<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
    
    <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
     <%@ taglib prefix="s" uri="/struts-tags"%> 
<html>
    
     <%@ page import="java.util.*" %>
    <%
    String message = (String)request.getAttribute("message");
    
    Map<String, String> map = new HashMap<String, String>();

    Enumeration <String> headerNames = request.getHeaderNames();
    
    while (headerNames.hasMoreElements()) {
        String key = (String) headerNames.nextElement();
        String value = request.getHeader(key);
        map.put(key, value);
    }
    //Android
    String ua = "";
  for(String key:map.keySet())
  {
	  if(key.equals("user-agent")){
		 ua = map.get(key);
	  }
	  
	 
  }
  if(ua.contains("Android"))
	{ 
    %>

<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EasyCrush - Login</title>
   <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

<!-- Include jQuery for Android -->
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 10px;
    margin: 0;
}

.login-container {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border-radius: 16px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    padding: 20px;
    width: 100%;
    max-width: 360px;
    animation: slideUp 0.6s ease-out;
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.logo-section {
    text-align: center;
    margin-bottom: 20px;
}

.logo-icon {
    width: 50px;
    height: 50px;
    margin: 0 auto 10px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
}

.logo-icon svg {
    width: 28px;
    height: 28px;
    fill: white;
}

.logo-section h1 {
    color: #333;
    font-size: 1.6rem;
    font-weight: 700;
    margin-bottom: 4px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.logo-section p {
    color: #666;
    font-size: 0.75rem;
    font-weight: 400;
    margin: 0;
}

.form-group {
    position: relative;
    margin-bottom: 15px;
}

.form-group i {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #667eea;
    font-size: 0.9rem;
    z-index: 2;
}

.form-input {
    width: 100%;
    padding: 10px 10px 10px 35px;
    border: 1.5px solid #e1e5e9;
    border-radius: 10px;
    font-size: 14px;
    font-family: 'Poppins', sans-serif;
    background: #fff;
    transition: all 0.3s ease;
    outline: none;
    box-sizing: border-box;
}

.form-input:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    transform: translateY(-1px);
    background: linear-gradient(to right, #fff 0%, #f8f9ff 100%);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Enhanced focus progression indicator */
.form-input.next-focus {
    border-color: #51cf66;
    animation: nextFieldPulse 0.6s ease-in-out;
}

@keyframes nextFieldPulse {
    0% { 
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    50% { 
        border-color: #51cf66;
        box-shadow: 0 0 0 6px rgba(81, 207, 102, 0.2);
        transform: translateY(-2px) scale(1.02);
    }
    100% { 
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-1px) scale(1);
    }
}

.form-input::placeholder {
    color: #a0a0a0;
    font-weight: 400;
}

.captcha-container {
    display: flex;
    gap: 8px;
    align-items: center;
    margin-bottom: 15px;
}

.captcha-image {
    border: 1.5px solid #e1e5e9;
    border-radius: 8px;
    height: 40px;
    flex: 1;
}

.refresh-btn {
    background: linear-gradient(135deg, #667eea, #764ba2);
    border: none;
    border-radius: 8px;
    width: 40px;
    height: 40px;
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.refresh-btn:hover {
    transform: rotate(90deg) scale(1.05);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.refresh-btn i {
    font-size: 0.9rem;
}

.login-btn {
    width: 100%;
    padding: 11px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    border: none;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    font-family: 'Poppins', sans-serif;
    cursor: pointer;
    transition: all 0.3s ease;
    margin-top: 5px;
    position: relative;
    overflow: hidden;
    box-sizing: border-box;
}

.login-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
}

.login-btn:active {
    transform: translateY(0);
}

.error-message {
    background: linear-gradient(135deg, #ff6b6b, #ff5252);
    color: white;
    padding: 8px 15px;
    border-radius: 8px;
    margin-bottom: 12px;
    text-align: center;
    font-weight: 500;
    font-size: 13px;
    animation: shake 0.5s ease-in-out;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

/* Loader Styles */
.loader-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.95);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    backdrop-filter: blur(5px);
}

.loader {
    width: 60px;
    height: 60px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid #667eea;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

.loader-text {
    margin-top: 20px;
    color: #667eea;
    font-weight: 600;
    font-size: 16px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Mobile Responsiveness */
@media (max-width: 480px) {
    body {
        padding: 5px;
    }
    
    .login-container {
        padding: 18px;
        margin: 5px;
        max-width: 320px;
        border-radius: 14px;
    }
    
    .logo-section {
        margin-bottom: 15px;
    }
    
    .logo-icon {
        width: 45px;
        height: 45px;
        margin-bottom: 8px;
    }
    
    .logo-icon svg {
        width: 24px;
        height: 24px;
    }
    
    .logo-section h1 {
        font-size: 1.4rem;
    }
    
    .logo-section p {
        font-size: 0.7rem;
    }
    
    .form-group {
        margin-bottom: 12px;
    }
    
    .form-input {
        padding: 9px 9px 9px 32px;
        font-size: 14px;
    }
    
    .captcha-container {
        flex-direction: column;
        gap: 8px;
        margin-bottom: 12px;
    }
    
    .refresh-btn {
        width: 100%;
        height: 35px;
    }
    
    .login-btn {
        padding: 10px;
        font-size: 14px;
    }
}

@media (max-width: 360px) {
    .login-container {
        padding: 15px;
        max-width: 300px;
    }
    
    .logo-section h1 {
        font-size: 1.3rem;
    }
    
    .form-input {
        padding: 8px 8px 8px 30px;
        font-size: 13px;
    }
}

/* Focus indicators for accessibility */
.form-input:focus,
.login-btn:focus,
.refresh-btn:focus {
    outline: 2px solid #667eea;
    outline-offset: 2px;
}

/* Input validation states */
.form-input.error {
    border-color: #ff6b6b;
    animation: shake 0.3s ease-in-out;
}

.form-input.success {
    border-color: #51cf66;
}
</style>

<script>
function showLoader() {
    // Simple loading message - no timeout
    console.log("Form submitting...");
}

$(document).ready(function(){
    // Simple Enter key navigation
    $('.form-input').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            
            var currentField = $(this);
            var formInputs = $('.form-input');
            var currentIndex = formInputs.index(currentField);
            
            // Move to next field if not the last one
            if (currentIndex < formInputs.length - 1) {
                var nextField = formInputs.eq(currentIndex + 1);
                nextField.focus();
            } else {
                // On last field (captcha), submit the form
                $('#loginSubmitBtn').click();
            }
            return false;
        }
    });

    // Simple form validation on submit
    $('form[action="login"]').on('submit', function(e) {
        if(!checkFormData()) {
            e.preventDefault();
            return false;
        }
        showLoader();
        return true;
    });
});

function validateField(field, isValid) {
    $(field).removeClass('error success');
    if ($(field).val().length > 0) {
        $(field).addClass(isValid ? 'success' : 'error');
    }
}

function showNotification(message, type = 'error') {
    alert(message); // Simple alert for now
}

function checkFormData() {
    var uname = $("#username").val();
    var pass = $("#password").val();
    var capt = $("#captcha").val();
    
    // Reset previous error states
    $('.form-input').removeClass('error');
    
    if(uname.length < 8) {
        $("#username").addClass('error');
        showNotification("Username must be at least 8 characters long");
        $("#username").focus();
        return false;
    }
    else if(pass.length < 8) {
        $("#password").addClass('error');
        showNotification("Password must be at least 8 characters long");
        $("#password").focus();
        return false;
    }
    else if(capt.length != 6) {
        $("#captcha").addClass('error');
        showNotification("Please enter the 6-digit captcha code");
        $("#captcha").focus();
        return false;
    }
    return true;
}

function generateNewCaptcha() {		
    document.getElementById("capImg").setAttribute("src", "");
    document.getElementById("capImg").setAttribute("src", "loadCaptcha?date="+new Date());
}

// Enhanced keyboard shortcuts for Android
document.addEventListener('keydown', function(e) {
    // Prevent F5 refresh
    if (e.key === 'F5' || (e.ctrlKey && e.key === 'r')) {
        e.preventDefault();
        return false;
    }
});
</script> 

<link rel="icon" type="image/jpg" href="jquery/favicon.ico">
</head>

<body>
<div class="login-container">
    <div class="logo-section">
        <div class="logo-icon">
            <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2C13.1 2 14 2.9 14 4V8L17 12V21C17 21.6 16.6 22 16 22H8C7.4 22 7 21.6 7 21V12L10 8V4C10 2.9 10.9 2 12 2M12 4V8H10V12H14V8H12M9 14V20H15V14H9Z"/>
                <circle cx="12" cy="16" r="1"/>
                <circle cx="10" cy="18" r="0.5"/>
                <circle cx="14" cy="18" r="0.5"/>
            </svg>
        </div>
        <h1>SAMARTH CONSTRUCTION COMPANY</h1>
        <p>Crusher Management System</p>
    </div>
    
    <s:if test="hasActionMessages()">
        <div class="error-message">
            <s:iterator var="error" value="%{actionMessages}">
                <i class="fas fa-exclamation-triangle"></i> <s:property value="%{error}"/>
            </s:iterator>
        </div>
    </s:if>

    <s:form action="login" theme="simple">
        <div class="form-group">
            <i class="fas fa-user"></i>
            <s:textfield id="username" name="username" placeholder="Enter your username" cssClass="form-input"/>
        </div>
        
        <div class="form-group">
            <i class="fas fa-lock"></i>
            <s:password id="password" name="password" placeholder="Enter your password" cssClass="form-input" autocomplete="off"/>
        </div>
        
        <div class="form-group">
            <i class="fas fa-shield-alt"></i>
            <s:textfield id="captcha" name="captcha" placeholder="Enter 6-digit captcha" cssClass="form-input" autocomplete="off"/>
        </div>
        
        <div class="captcha-container">
            <img id="capImg" src="loadCaptcha" class="captcha-image" alt="Captcha Image"/>
            <button type="button" class="refresh-btn" onclick="generateNewCaptcha()" title="Refresh Captcha">
                <i class="fas fa-sync-alt"></i>
            </button>
        </div>
        
        <s:submit cssClass="login-btn" value="Sign In Securely" id="loginSubmitBtn"/>
    </s:form>
</div>
</body>
</html>

<%
    }
  else{
    %>

<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>EasyCrush - Login</title>
   <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 10px;
    position: relative;
    overflow-x: hidden;
    margin: 0;
}

body::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('loginpage/crusherbg.jpg') center/cover;
    opacity: 0.1;
    z-index: -1;
}

.login-container {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(15px);
    border-radius: 16px;
    box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
    padding: 22px;
    width: 100%;
    max-width: 380px;
    animation: slideUp 0.8s ease-out;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(50px) scale(0.9);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.logo-section {
    text-align: center;
    margin-bottom: 22px;
}

.logo-icon {
    width: 55px;
    height: 55px;
    margin: 0 auto 12px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
}

.logo-icon svg {
    width: 32px;
    height: 32px;
    fill: white;
}

.logo-section h1 {
    color: #333;
    font-size: 1.7rem;
    font-weight: 700;
    margin-bottom: 6px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.logo-section p {
    color: #666;
    font-size: 0.8rem;
    font-weight: 400;
    letter-spacing: 0.2px;
    margin: 0;
}

.form-group {
    position: relative;
    margin-bottom: 16px;
}

.form-group i {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #667eea;
    font-size: 0.95rem;
    z-index: 2;
}

.form-input {
    width: 100%;
    padding: 11px 11px 11px 38px;
    border: 1.5px solid #e1e5e9;
    border-radius: 10px;
    font-size: 14px;
    font-family: 'Poppins', sans-serif;
    background: #fff;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    outline: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    box-sizing: border-box;
}

.form-input:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15), 0 4px 20px rgba(0, 0, 0, 0.1);
    transform: translateY(-3px);
    background: linear-gradient(to right, #fff 0%, #f8f9ff 100%);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Enhanced focus progression indicator for desktop */
.form-input.next-focus {
    border-color: #51cf66;
    animation: nextFieldPulseDesktop 0.6s ease-in-out;
}

@keyframes nextFieldPulseDesktop {
    0% { 
        border-color: #667eea;
        box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15), 0 4px 20px rgba(0, 0, 0, 0.1);
    }
    50% { 
        border-color: #51cf66;
        box-shadow: 0 0 0 6px rgba(81, 207, 102, 0.2), 0 6px 25px rgba(0, 0, 0, 0.15);
        transform: translateY(-4px) scale(1.02);
    }
    100% { 
        border-color: #667eea;
        box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15), 0 4px 20px rgba(0, 0, 0, 0.1);
        transform: translateY(-3px) scale(1);
    }
}

.form-input::placeholder {
    color: #a0a0a0;
    font-weight: 400;
    transition: all 0.3s ease;
}

.form-input:focus::placeholder {
    opacity: 0.7;
    transform: translateY(-2px);
}

.captcha-container {
    display: flex;
    gap: 8px;
    align-items: center;
    margin-bottom: 16px;
}

.captcha-image {
    border: 1.5px solid #e1e5e9;
    border-radius: 8px;
    height: 42px;
    flex: 1;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    transition: all 0.3s ease;
}

.captcha-image:hover {
    transform: scale(1.01);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
}

.refresh-btn {
    background: linear-gradient(135deg, #667eea, #764ba2);
    border: none;
    border-radius: 8px;
    width: 42px;
    height: 42px;
    color: white;
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    position: relative;
    overflow: hidden;
}

.refresh-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s ease;
}

.refresh-btn:hover::before {
    left: 100%;
}

.refresh-btn:hover {
    transform: rotate(180deg) scale(1.1);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

.refresh-btn i {
    font-size: 1.3rem;
    transition: all 0.3s ease;
}

.login-btn {
    width: 100%;
    padding: 12px;
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    border: none;
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    font-family: 'Poppins', sans-serif;
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    margin-top: 6px;
    position: relative;
    overflow: hidden;
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
    letter-spacing: 0.2px;
    box-sizing: border-box;
}

.login-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s ease;
}

.login-btn:hover::before {
    left: 100%;
}

.login-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 35px rgba(102, 126, 234, 0.4);
}

.login-btn:active {
    transform: translateY(-1px);
}

.error-message {
    background: linear-gradient(135deg, #ff6b6b, #ff5252);
    color: white;
    padding: 10px 16px;
    border-radius: 8px;
    margin-bottom: 14px;
    text-align: center;
    font-weight: 500;
    font-size: 13px;
    animation: shake 0.6s ease-in-out;
    box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    10%, 30%, 50%, 70%, 90% { transform: translateX(-8px); }
    20%, 40%, 60%, 80% { transform: translateX(8px); }
}

/* Enhanced Loader Styles */
.loader-container {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.95);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    backdrop-filter: blur(10px);
}

.loader {
    width: 80px;
    height: 80px;
    border: 6px solid #f3f3f3;
    border-top: 6px solid #667eea;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

.loader-text {
    margin-top: 25px;
    color: #667eea;
    font-weight: 600;
    font-size: 18px;
    text-align: center;
    animation: pulse 1.5s ease-in-out infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.7; }
}

/* Enhanced Mobile Responsiveness */
@media (max-width: 768px) {
    body {
        padding: 8px;
    }
    
    .login-container {
        padding: 20px 18px;
        margin: 8px;
        border-radius: 14px;
        max-width: 350px;
    }
    
    .logo-section {
        margin-bottom: 18px;
    }
    
    .logo-icon {
        width: 48px;
        height: 48px;
        margin-bottom: 10px;
    }
    
    .logo-icon svg {
        width: 28px;
        height: 28px;
    }
    
    .logo-section h1 {
        font-size: 1.5rem;
    }
    
    .logo-section p {
        font-size: 0.75rem;
    }
    
    .form-input {
        padding: 10px 10px 10px 35px;
        font-size: 14px;
    }
    
    .captcha-container {
        flex-direction: column;
        gap: 10px;
    }
    
    .refresh-btn {
        width: 100%;
        height: 38px;
    }
    
    .login-btn {
        padding: 11px;
        font-size: 14px;
    }
}

@media (max-width: 480px) {
    body {
        padding: 5px;
    }
    
    .login-container {
        padding: 18px 15px;
        margin: 5px;
        max-width: 320px;
    }
    
    .logo-section {
        margin-bottom: 15px;
    }
    
    .logo-icon {
        width: 45px;
        height: 45px;
        margin-bottom: 8px;
    }
    
    .logo-icon svg {
        width: 24px;
        height: 24px;
    }
    
    .logo-section h1 {
        font-size: 1.4rem;
    }
    
    .logo-section p {
        font-size: 0.7rem;
    }
    
    .form-group {
        margin-bottom: 14px;
    }
    
    .form-input {
        padding: 9px 9px 9px 32px;
        font-size: 14px;
    }
    
    .captcha-container {
        margin-bottom: 14px;
    }
    
    .refresh-btn {
        height: 35px;
    }
    
    .login-btn {
        padding: 10px;
    }
}

@media (max-width: 360px) {
    .login-container {
        padding: 15px 12px;
        max-width: 300px;
    }
    
    .logo-section h1 {
        font-size: 1.3rem;
    }
    
    .form-input {
        padding: 8px 8px 8px 30px;
        font-size: 13px;
    }
}

/* Accessibility improvements */
.form-input:focus,
.login-btn:focus,
.refresh-btn:focus {
    outline: 3px solid rgba(102, 126, 234, 0.5);
    outline-offset: 2px;
}

/* Input validation states */
.form-input.error {
    border-color: #ff6b6b;
    box-shadow: 0 0 0 4px rgba(255, 107, 107, 0.15);
    animation: shake 0.4s ease-in-out;
}

.form-input.success {
    border-color: #51cf66;
    box-shadow: 0 0 0 4px rgba(81, 207, 102, 0.15);
}

/* Notification styles */
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 15px 25px;
    border-radius: 12px;
    color: white;
    font-weight: 500;
    z-index: 10000;
    animation: slideInRight 0.3s ease-out;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
}

.notification.error {
    background: linear-gradient(135deg, #ff6b6b, #ff5252);
}

.notification.success {
    background: linear-gradient(135deg, #51cf66, #40c057);
}

@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(100%);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* Floating particles animation */
.login-container::after {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(102, 126, 234, 0.05) 1px, transparent 1px);
    background-size: 50px 50px;
    animation: float 20s linear infinite;
    pointer-events: none;
    z-index: -1;
}

@keyframes float {
    0% { transform: translate(0, 0) rotate(0deg); }
    100% { transform: translate(-50px, -50px) rotate(360deg); }
}
</style>

<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script>
function showLoader() {
    var loader = document.getElementById('pageLoader');
    if (!loader) {
        loader = document.createElement('div');
        loader.id = 'pageLoader';
        loader.className = 'loader-container';
        loader.innerHTML = '<div style="text-align: center;"><div class="loader"></div><div class="loader-text">Signing you in...</div></div>';
        document.body.appendChild(loader);
    }
    loader.style.display = 'flex';
}

function hideLoader() {
    var loader = document.getElementById('pageLoader');
    if (loader) {
        loader.style.display = 'none';
    }
}

$(document).ready(function(){
    // Simple Enter key navigation
    $('.form-input').on('keydown', function(e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            e.preventDefault();
            
            var currentField = $(this);
            var formInputs = $('.form-input');
            var currentIndex = formInputs.index(currentField);
            
            // Move to next field if not the last one
            if (currentIndex < formInputs.length - 1) {
                var nextField = formInputs.eq(currentIndex + 1);
                nextField.focus();
            } else {
                // On last field (captcha), submit the form
                $('#loginSubmitBtn').click();
            }
            return false;
        }
    });

    // Simple form validation on submit
    $('form[action="login"]').on('submit', function(e) {
        if(!checkFormData()) {
            e.preventDefault();
            return false;
        }
        showLoader();
        return true;
    });
});

function validateField(field, isValid) {
    $(field).removeClass('error success');
    if ($(field).val().length > 0) {
        $(field).addClass(isValid ? 'success' : 'error');
    }
}

function showNotification(message, type = 'error') {
    alert(message); // Simple alert for now
}

function checkFormData() {
    var uname = $("#username").val();
    var pass = $("#password").val();
    var capt = $("#captcha").val();
    
    // Reset previous error states
    $('.form-input').removeClass('error');
    
    if(uname.length < 8) {
        $("#username").addClass('error');
        showNotification("Username must be at least 8 characters long", 'error');
        $("#username").focus();
        return false;
    }
    else if(pass.length < 8) {
        $("#password").addClass('error');
        showNotification("Password must be at least 8 characters long", 'error');
        $("#password").focus();
        return false;
    }
    else if(capt.length != 6) {
        $("#captcha").addClass('error');
        showNotification("Please enter the 6-digit captcha code", 'error');
        $("#captcha").focus();
        return false;
    }
    
    return true;
}

function generateNewCaptcha() {
    // Add loading state to refresh button
    const refreshBtn = $('.refresh-btn i');
    refreshBtn.addClass('fa-spin');
    
    document.getElementById("capImg").setAttribute("src", "");
    document.getElementById("capImg").setAttribute("src", "loadCaptcha?date="+new Date());
    
    // Remove loading state after image loads
    $('#capImg').on('load', function() {
        setTimeout(() => {
            refreshBtn.removeClass('fa-spin');
        }, 500);
    });
}

// Enhanced keyboard navigation and shortcuts
document.addEventListener('keydown', function(e) {
    // Prevent F5 refresh
    if (e.key === 'F5' || (e.ctrlKey && e.key === 'r')) {
        e.preventDefault();
        return false;
    }
});

// Add smooth scroll and focus animations
function smoothFocus(element) {
    element.scrollIntoView({ behavior: 'smooth', block: 'center' });
    setTimeout(() => element.focus(), 300);
}
</script>

<link rel="icon" type="image/jpg" href="jquery/favicon.ico">
</head>

<body>
<div class="login-container">
    <div class="logo-section">
        <div class="logo-icon">
            <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2C13.1 2 14 2.9 14 4V8L17 12V21C17 21.6 16.6 22 16 22H8C7.4 22 7 21.6 7 21V12L10 8V4C10 2.9 10.9 2 12 2M12 4V8H10V12H14V8H12M9 14V20H15V14H9Z"/>
                <circle cx="12" cy="16" r="1"/>
                <circle cx="10" cy="18" r="0.5"/>
                <circle cx="14" cy="18" r="0.5"/>
            </svg>
        </div>
        <h1>SAMARTH CONSTRUCTION COMPANY</h1>
        <p>Professional Crusher Management System</p>
    </div>
    
    <s:if test="hasActionMessages()">
        <div class="error-message">
            <s:iterator var="error" value="%{actionMessages}">
                <i class="fas fa-exclamation-triangle"></i> <s:property value="%{error}"/>
            </s:iterator>
        </div>
    </s:if>

    <s:form action="login" theme="simple">
        <div class="form-group">
            <i class="fas fa-user"></i>
            <s:textfield id="username" name="username" placeholder="Enter your username" cssClass="form-input"/>
        </div>
        
        <div class="form-group">
            <i class="fas fa-lock"></i>
            <s:password id="password" name="password" placeholder="Enter your password" cssClass="form-input" autocomplete="off"/>
        </div>
        
        <div class="form-group">
            <i class="fas fa-shield-alt"></i>
            <s:textfield id="captcha" name="captcha" placeholder="Enter 6-digit captcha" cssClass="form-input" autocomplete="off"/>
        </div>
        
        <div class="captcha-container">
            <img id="capImg" src="loadCaptcha" class="captcha-image" alt="Captcha Image"/>
            <button type="button" class="refresh-btn" onclick="generateNewCaptcha()" title="Refresh Captcha">
                <i class="fas fa-sync-alt"></i>
            </button>
        </div>
        
        <s:submit cssClass="login-btn" value="Sign In Securely" id="loginSubmitBtn"/>
    </s:form>
</div>
</body>
</html>
<%}%>