<%@ taglib prefix="s" uri="/struts-tags" %>


<head>


    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

   

    <!-- Bootstrap CSS CDN -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/css/bootstrap.min.css" integrity="sha384-9gVQ4dYFwwWSjIDZnLEWnxCjeSWFphJiwGPXr1jddIhOegiu1FwO5qRGvFXOdJZ4" crossorigin="anonymous">
    <!-- Our Custom CSS -->
    <link rel="stylesheet" href="newsidebar/style3.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <style>
        /* Enhanced Sidebar Styles with Performance Optimizations */
        #sidebar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            /* Ultra-smooth scrolling optimizations */
            overflow-y: auto;
            overflow-x: hidden;
            -webkit-overflow-scrolling: touch; /* Smooth scrolling on iOS */
            scroll-behavior: smooth; /* Native smooth scrolling */
            scrollbar-width: thin; /* Firefox thin scrollbar */
            scrollbar-color: rgba(255, 255, 255, 0.3) transparent; /* Firefox scrollbar colors */
            
            /* Hardware acceleration and smoothness */
            transform: translateZ(0); /* Enable hardware acceleration */
            transform: translate3d(0, 0, 0); /* Force GPU layer */
            will-change: scroll-position; /* Optimize for scrolling */
            backface-visibility: hidden; /* Prevent flickering */
            perspective: 1000px; /* Enable 3D acceleration */
            
            /* Smooth momentum scrolling */
            -webkit-overflow-scrolling: touch;
            -ms-overflow-style: -ms-autohiding-scrollbar;
            
            /* Anti-aliasing for crisp rendering */
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            text-rendering: optimizeSpeed;
        }

        /* Ultra-Smooth Custom Webkit Scrollbar */
        #sidebar::-webkit-scrollbar {
            width: 6px;
            transition: all 0.3s ease;
        }

        #sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 3px;
            transition: background 0.3s ease;
        }

        #sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            /* Enhanced smoothness */
            transform: translateZ(0);
            will-change: background-color;
        }

        #sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.5);
            transform: scale(1.1) translateZ(0);
        }

        #sidebar::-webkit-scrollbar-thumb:active {
            background: rgba(255, 255, 255, 0.7);
        }

        #sidebar .sidebar-header {
            padding: 20px;
            background: rgba(255, 255, 255, 0.1);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        #sidebar ul li a {
            padding: 12px 20px;
            font-size: 0.9em;
            display: flex;
            align-items: center;
            gap: 10px;
            color: rgba(255, 255, 255, 0.9);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            /* Enhanced smoothness */
            transform: translateZ(0);
            backface-visibility: hidden;
            will-change: transform, background-color, padding-left;
        }

        #sidebar ul li a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            padding-left: 25px;
            transform: translateX(5px) translateZ(0);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        #sidebar ul li a i {
            width: 20px;
            text-align: center;
            font-size: 1em;
        }

        #sidebar ul li a i.fa-chevron-down {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 0.8em;
            opacity: 0.8;
        }

        #sidebar ul.components {
            padding: 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        #sidebar ul li.active > a {
            background: rgba(255, 255, 255, 0.2);
            color: #fff;
        }

        #sidebar ul li a[aria-expanded="true"] {
            background: rgba(255, 255, 255, 0.1);
        }

        #sidebar ul ul a {
            padding-left: 45px !important;
            background: rgba(0, 0, 0, 0.15);
            font-size: 0.85em;
        }

        #sidebar ul ul a:hover {
            background: rgba(0, 0, 0, 0.2);
        }

        #sidebar .components p {
            color: rgba(255, 255, 255, 0.7);
            padding: 10px 20px;
            margin: 0;
            font-size: 0.9em;
            font-weight: 500;
            letter-spacing: 0.5px;
        }

        #dismiss {
            width: 35px;
            height: 35px;
            line-height: 35px;
            text-align: center;
            background: rgba(255, 255, 255, 0.1);
            position: absolute;
            top: 10px;
            right: 10px;
            cursor: pointer;
            transition: all 0.3s;
            border-radius: 50%;
        }

        #dismiss:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: rotate(90deg);
        }

        .overlay {
            display: none;
            position: fixed;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.7);
            z-index: 998;
            opacity: 0;
            transition: all 0.5s ease-in-out;
        }

        .overlay.active {
            display: block;
            opacity: 1;
        }

        #sidebar.active {
            margin-left: 0;
            box-shadow: 5px 0px 20px rgba(0, 0, 0, 0.2);
        }

        /* Submenu Animation */
        .collapse {
            transition: all 0.3s ease;
        }

        /* Active Link Indicator */
        #sidebar ul li a::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 3px;
            background: #fff;
            opacity: 0;
            transition: all 0.3s;
        }

        #sidebar ul li a:hover::before {
            opacity: 1;
        }

        /* Additional Performance Optimizations */
        #sidebar ul {
            /* Enable GPU acceleration for lists */
            transform: translate3d(0, 0, 0);
            backface-visibility: hidden;
        }

        #sidebar ul li a {
            /* Optimize text rendering */
            text-rendering: optimizeSpeed;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            /* Enable GPU acceleration for links */
            transform: translateZ(0);
        }

        /* Ultra-smooth collapse animations */
        .collapse {
            transition: height 0.35s cubic-bezier(0.4, 0, 0.2, 1) !important;
            overflow: hidden;
            transform: translateZ(0);
            backface-visibility: hidden;
        }

        .collapse.show {
            animation: expandSmoothly 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        @keyframes expandSmoothly {
            0% {
                opacity: 0;
                transform: translateY(-10px) translateZ(0);
            }
            100% {
                opacity: 1;
                transform: translateY(0) translateZ(0);
            }
        }

        /* Reduce paint and layout thrashing */
        #sidebar .components {
            contain: layout style paint;
        }

        /* Optimize scrolling for long lists */
        #sidebar .list-unstyled {
            /* Virtual scrolling hint */
            overflow-anchor: auto;
        }
    </style>

</head>

<body>

    <div class="wrapper">
        <!-- Sidebar  -->
        <nav id="sidebar">
            <div id="dismiss">
                <i class="fas fa-arrow-left"></i>
            </div>

            <div class="sidebar-header">
            
           			 <s:if test="#session.lang=='mr'">
					<s:property value="getText('welcome.message')" />, <br><s:property value="#session.userFullNameMr"/>
					</s:if>
					
					<s:else>
					<s:property value="getText('welcome.message')" />, <br><s:property value="#session.userFullName"/>
					</s:else>
               
            </div>

            <ul class="list-unstyled components">
                <p><s:property value="#session.shopnameenglish"/></p>
                
               
                                 <li>
         		  <a href="home"><i class="fas fa-home"></i> <s:property value="getText('lable.home')" /></a>
         		  	</li>
         		  	
         		  	<!-- ADMIN -->
         		  	
         		  	  <s:if test="#session.role=='ADMIN'">
               		 <li >
                
                    <a href="#productSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-box"></i> <s:property value="getText('lable.product')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="productSubmenu">
                      	<li>
                            <a href="addNewProductJsp"><i class="fas fa-plus-circle"></i> <s:property value="getText('action.addNewProduct')" /></a>
                        </li>
                       	<li>
                            <a href="searchProductJsp"><i class="fas fa-search"></i> <s:property value="getText('action.searchProduct')" /></a>
                        </li>
                      
                    </ul>
                </li>
               
               
                <li >
                    <a href="#billingSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-file-invoice-dollar"></i> <s:property value="getText('lable.billing')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="billingSubmenu">
                    	<li>
                         	 <a href="addVehicleEntryDetailsJsp"><i class="fas fa-truck-loading"></i> <s:property value="getText('action.addVehicleEntryDetails')" /></a>
                        </li>
                        <li>
                         	 <a href="listVehicleEntryDetailsJsp"><i class="fas fa-list"></i> <s:property value="getText('action.listVehicleEntryDetails')" /></a>
                        </li>
                        <li>
                         	 <a href="addBillJsp"><i class="fas fa-plus"></i> <s:property value="getText('action.addNewBill')" /></a>
                        </li>
                        <li> <a href="addRmcBillJsp"><i class="fas fa-industry"></i> <s:property value="getText('action.addNewRMCBill')" /></a></li>                        	
                        	
                        	<li> <a href="addNewDCJsp"><i class="fas fa-file-alt"></i> <s:property value="getText('action.addNewDC')" /></a></li>                        	
                       <li> <a href="listDCJsp"><i class="fas fa-list-alt"></i> <s:property value="getText('action.listDC')" /></a></li>
		                  
		                 
                            
                    </ul>
                </li>
                
                <li>
                    <a href="#remindersSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-bell"></i> <s:property value="getText('lable.reminders')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="remindersSubmenu">
                       <li>
                            <a href="addNewPaymentReminder"><i class="fas fa-money-bill-wave"></i> <s:property value="getText('action.addPaymentReminder')" /></a>
                        </li>
                       
                    </ul>
                    
                </li>
                
                
                <li >
                    <a href="#taxSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-percent"></i> <s:property value="getText('lable.tax')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="taxSubmenu">
                    	
                 <li>
                            <a href="addNewTaxJsp"><i class="fas fa-plus"></i> <s:property value="getText('action.addNewTax')" /></a>
                        </li>
                        </ul>
                        </li>
                
                <li >
                    <a href="#quotationSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-file-signature"></i> <s:property value="getText('lable.quotation')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="quotationSubmenu">
                    	<li>
                         	 <a href="addnewQuotationJsp"><s:property value="getText('action.addNewQuotation')" /></a>
                        </li>
                        	<li> <a href="searchQuotationJsp"><s:property value="getText('action.searchQuotation')" /></a>
                        	</li>                        	
                           
                    </ul>
                </li>
                
                 <li >
                    <a href="#boulderSubmenu" data-toggle="collapse" aria-expanded="false">Boulder ></a>
                    <ul class="collapse list-unstyled" id="boulderSubmenu">
                      	  		<li>
                           			 <a href="addNewBoulderSupplierJsp">Add New Boulder Supplier</a>
		                        </li>
		                        <li>
                           			 <a href="searchBoulderSupplierJsp">Search Boulder Supplier</a>
		                        </li>
		                        <li>
                           			 <a href="addVehicleToBoulderSuppJsp">Add Vehicle</a>
		                        </li>
		                         <li>
                           			 <a href="addBoulderInwardJsp">Add Boulder Inward</a>
		                        </li>
		                         <li>
                           			 <a href="boulderInwardReportJsp">Boulder Inward Report</a>
		                        </li>
		                       <li>
                           			 <a href="searchBoulderSuppForAccJsp">Boulder Supplier Accounting</a>
		                        </li>
		                       
                    </ul>
                </li>
                  
                <li >
                    <a href="#custSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.customer')" /> ></a>
                    <ul class="collapse list-unstyled" id="custSubmenu">
                    	<li>
                         	 <a href="addNewCustomerJsp"><s:property value="getText('action.addNewCustomer')" /></a>
                        </li>
                        <li>
                         	 <a href="searchCutomerForUpdateJsp"><s:property value="getText('action.searchCustomer')" /></a>
                        </li>
                          <li>
                         	 <a href="searchCustomerJsp"><s:property value="getText('action.customerAccounting')" /></a>
                        </li>
		                      
                    </ul>
                </li>
                
                <li >
                    <a href="#vehicleSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-truck"></i> <s:property value="getText('lable.vehicle')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="vehicleSubmenu">
                    	<li>
                         	 <a href="addNewVehicle"><i class="fas fa-plus"></i> <s:property value="getText('action.addNewVehicle')" /></a>
                        </li>
                       <li>
                         	 <a href="listVehiclesJsp"><i class="fas fa-list"></i> <s:property value="getText('action.listVehicle')" /></a>
                        </li>
                        <li>
                         	 <a href="addVehicleTripEntryJsp"><i class="fas fa-route"></i> <s:property value="getText('action.addVehicleTripEntry')" /></a>
                        </li>
                        <li>
                         	 <a href="addVehicleConsumptionEntryJsp"><i class="fas fa-gas-pump"></i> <s:property value="getText('action.addVehicleConsumptionEntry')" /></a>
                        </li>
                        <li>
                         	 <a href="addVehicleMaintenanceEntryJsp"><i class="fas fa-wrench"></i> <s:property value="getText('action.addVehicleMaintenanceEntry')" /></a>
                        </li>
                          <li>
                         	 <a href="consumptionReportJsp"><i class="fas fa-chart-line"></i> <s:property value="getText('action.ConsumptionReport')" /></a>
                        </li>
                        <li>
                         	 <a href="maintenanceReportJsp"><i class="fas fa-tools"></i> <s:property value="getText('action.MaintenanceReport')" /></a>
                        </li>
		                      
                    </ul>
                </li>
               
               <li><a href="dieselReportJsp">Diesel Report</a></li>
               <li><a href="adblueReportJsp">Adblue/DEF Report</a></li>
                
                
                
               <li >
                    <a href="#supplierSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.supplier')" /> ></a>
                    <ul class="collapse list-unstyled" id="supplierSubmenu">
                      	<li>
                            <a href="addSupplierJsp"><s:property value="getText('action.addNewSupplier')" /></a>
                        </li>
                        <li>
                            <a href="searchSupplierJsp"><s:property value="getText('action.searchSupplier')" /></a>
                        </li>
                         <li>
		                       <a href="searchSupplierAccountingJsp"><s:property value="getText('action.accounts')" /></a>
		                   </li>
                      
                    </ul>
                </li>
                
                  <li>
                    <a href="#employeeSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.employee')" /> ></a>
                    <ul class="collapse list-unstyled" id="employeeSubmenu">
                      <li>
                            <a href="addNewLaborJsp"><s:property value="getText('action.addNewEmployee')" /></a>
                        </li>
                        <li>
                            <a href="searchLaborForUpdateJsp"><s:property value="getText('action.searchEmployee')" /></a>
                        </li>
                       
                         <li>
                            <a href="searchLaborForAddPaymentJsp"><s:property value="getText('action.addEmployeePayment/ViewAccount')" /></a>
                        </li>
                        
                         <li>
                            <a href="addLaborAbsentHalfDayOverTimeJsp"><s:property value="getText('action.addEmployeeAbsent/HalfDay/OverTimeEntry')" /></a>
                         </li>
                          <li>
                            <a href="calculateSalaryOfLabor"><s:property value="getText('action.calculateSalary')" /></a>
                         </li>
                     	 <li>
                            <a href="downloadListOfLabour" target="_blank"><s:property value="getText('action.listEmployeeDetails')" /></a>
                         </li>
                         <li>
                            <a href="employeeAbsentReportJsp"><s:property value="getText('action.emloyeeAbsentReport')" /></a>
                         </li>
                    </ul>
                </li>
                
                 <li >
                    <a href="#purchaseSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.purchase')" /> ></a>
                    <ul class="collapse list-unstyled" id="purchaseSubmenu">
                      	  		<li>
                           			 <a href="addNewPurchaseJsp"><s:property value="getText('action.addNewPurchase')" /></a>
		                        </li>
		                        <li>
                           			 <a href="addNewDieselAdbluePurchaseJsp">Add New Diesel/Adblue Purchase</a>
		                        </li>
		                        <li>
                           			 <a href="addDirectStockJsp"><s:property value="getText('action.addDirectStock')" /></a>
		                        </li>
		                      
		                       
                    </ul>
                </li>
                
                 <li >
                    <a href="#expensesSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.expense')" /> ></a>
                    <ul class="collapse list-unstyled" id="expensesSubmenu">
                    	 <li>
                            <a href="addNewSiteJsp"><s:property value="getText('action.addNewSite')" /></a>
                        </li>
                      	 <li>
                            <a href="addDailyExpenseJsp"><s:property value="getText('action.addDailyExpense')" /></a>
                        </li>
                         <li>
                            <a href="addNewCheckBookJsp"><s:property value="getText('action.addNewChequeBook')" /> </a>
                        </li>
                        <li>
                            <a href="addNewAddAccountHeadJsp"><s:property value="getText('action.addNewAccountHead')" /></a>
                        </li>
                    </ul>
                </li>
                  <li>
                    <a href="#bankingSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.banking')" /> ></a>
                    <ul class="collapse list-unstyled" id="bankingSubmenu">
                      	 <li>
                            <a href="addNewBankAccountJsp"><s:property value="getText('action.addNewAccount')" /></a>
                        </li>
                        <li>
                            <a href="listBankAccountJsp"><s:property value="getText('action.listAccountDetails')" /></a>
                        </li>
                         <li>
                            <a href="addAccountCreditEntryJsp"><s:property value="getText('action.addCreditEntry')" /></a>
                        </li>
                         <li>
                            <a href="addAccountDebitEntryJsp"><s:property value="getText('action.addDebitEntry')" /></a>
                        </li>
                    </ul>
                </li>
                
                 <li>
                    
                    
                    <a href="#gstReportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.gstReports')" /> ></a>
                    <ul class="collapse list-unstyled" id="gstReportSubmenu">
                        <li><a href="gstSaleReportJsp"><s:property value="getText('action.crusherSaleReport')" /></a></li>
                        <li><a href="gstRMCSaleReportJsp"><s:property value="getText('action.RMCSaleReport')" /></a></li>
                        <li><a href="GSTR-1ReportJsp"><s:property value="getText('action.GTR1Report')" /></a></li>
                     </ul>
              	  </li>	
              	  
              	  
              	  <li>
                    <a href="#productReportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.productReports')" /> ></a>
                    <ul class="collapse list-unstyled" id="productReportSubmenu">
                    
                      	<li><a href="itemWiseStockReportJsp"><s:property value="getText('action.itemWiseStockReport')" /></a></li>
                       	<li><a href="itemWiseSalesReportJsp"><s:property value="getText('action.itemWiseSaleReport')" /></a></li>
                       <li><a href="itemWisePurchaseReportJsp"><s:property value="getText('action.itemWisePurchaseReport')" /></a></li>
                       		
                       </ul>
                </li>
               
               
                <li>
                    <a href="#rmcReportSubmenu" data-toggle="collapse" aria-expanded="false">RMC Reports ></a>
                    <ul class="collapse list-unstyled" id="rmcReportSubmenu">
                      		 <li><a href="materialUsedReportJsp"><s:property value="getText('action.materialUsedReport')" /></a></li>
                        <li><a href="productWiseMaterialUsedReportJsp"><s:property value="getText('action.productWiseMaterialUsedReport')" /></a></li>
                       
                       </ul>
                </li>
               
               <li>
                    <a href="#reportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.reports')" /> ></a>
                    <ul class="collapse list-unstyled" id="reportSubmenu">
                    
                      	
                      	<li><a href="collectionReportJsp"><s:property value="getText('action.collectionReport')" /></a></li>
                        <li><a href="purchaseReportJsp"><s:property value="getText('action.purchaseReport')" /></a></li>
                        <li><a href="customerCreditReportJsp"><s:property value="getText('action.customerCreditReport')" /></a></li>
                        <li><a href="supplierDebitReportJsp"><s:property value="getText('action.supplierDebtReport')" /></a></li>
                        <li><a href="employeeBalanceReportJsp"><s:property value="getText('action.employeeBalanceReport')" /></a></li>
                        <li><a href="dailyExpenseReportJsp"><s:property value="getText('action.dailyExpenseReport')" /></a></li>
                        <li><a href="chequeReportJsp"><s:property value="getText('action.chequeReport')" /></a></li>
                        <li><a href="custPaymentReceivedReport"> <s:property value="getText('action.customerPaymentReport')" /></a></li>
                        <li><a href="vehicleTripReportJsp"><s:property value="getText('action.vehicleTripReport')" /></a></li>
                        <li><a href="bankAccReportJsp"><s:property value="getText('action.bankAccountReport')" /></a></li>
                        <li><a href="creditReportJsp"><s:property value="getText('action.creditReport')" /></a></li>
                        <li><a href="cashReportJsp"><s:property value="getText('action.cashReport')" /></a></li>
                        <li><a href="dailySalesReportJsp"><s:property value="getText('action.dailySalesReport')" /></a></li>
                        
                    </ul>
                </li>
               
                    <li>
                    <a href="#changeLaguageSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.changelanguage')" /> ></a>
                    <ul class="collapse list-unstyled" id="changeLaguageSubmenu">
                   
                    <li>
         		  	<s:a href="changelang?lang=en" ><s:property value="getText('language.english')"/></s:a>
         		  	</li>
         		  	<li>
	                 <s:a href="changelang?lang=mr" ><s:property value="getText('language.marathi')"/> </s:a>	
	                
	               </li>				
				</ul>
                  
               </li> 
               
                <li>
                    <a href="changePassJsp"><s:property value="getText('lable.changePassword')"/></a>
                </li>
                
                
                <li>
                    <a href="#settingsSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.settings')"/> ></a>
                    <ul class="collapse list-unstyled" id="settingsSubmenu">
                    
                      	
                      	<li><a href="updateSettingsJsp"><s:property value="getText('action.bankDetailsSetting')"/></a></li>
                        <li><a href="updateCompanySettingsJsp"><s:property value="getText('action.companyDetailsSetting')"/></a></li>
                        <s:if test="#session.online_weight_scale_allowed==true">
	           
	                
	                    <li><a  href="weightscaleupdateJsp"><s:property value="getText('action.weightScaleSetting')"/></a></li>
	                    
                    </s:if>
                    </ul>
                </li>
                
                
                
                
                <li>
                    <a href="logout"><s:property value="getText('lable.logOut')"/></a>
                </li>
                </s:if>
                
                <!-- ACCOUNT -->
                  <s:if test="#session.role=='ACCOUNT'">
               		 <li >
                
                    <a href="#productSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.product')"/> ></a>
                    <ul class="collapse list-unstyled" id="productSubmenu">
                      	<li>
                            <a href="addNewProductJsp"><s:property value="getText('action.addNewProduct')"/></a>
                        </li>
                       	<li>
                            <a href="searchProductJsp"><s:property value="getText('action.searchProduct')"/></a>
                        </li>
                      
                    </ul>
                </li>
               
               
                <li >
                    <a href="#billingSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.billing')"/> ></a>
                    <ul class="collapse list-unstyled" id="billingSubmenu">
                    	<li>
                         	 <a href="addBillJsp"><s:property value="getText('action.addNewBill')"/></a>
                        </li>
		                      
                    </ul>
                </li>
                
                <li>
                    <a href="#remindersSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.reminders')"/> ></a>
                     <ul class="collapse list-unstyled" id="remindersSubmenu">
                       <li>
                            <a href="addNewPaymentReminder"><s:property value="getText('action.addPaymentReminder')"/></a>
                        </li>
                       
                    </ul>
                    
                </li>
                
                <li >
                    <a href="#quotationSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.quotation')"/> ></a>
                    <ul class="collapse list-unstyled" id="quotationSubmenu">
                    	<li>
                         	 <a href="addnewQuotationJsp"><s:property value="getText('action.addNewQuotation')"/></a>
                        </li>
                        	<li> <a href="searchQuotationJsp"><s:property value="getText('action.searchQuotation')"/></a>
                        	</li>                        	
                           
                    </ul>
                </li>
                   <li >
                    <a href="#boulderSubmenu" data-toggle="collapse" aria-expanded="false">Boulder ></a>
                    <ul class="collapse list-unstyled" id="boulderSubmenu">
                      	  		<li>
                           			 <a href="addNewBoulderSupplierJsp">Add New Boulder Supplier</a>
		                        </li>
		                        <li>
                           			 <a href="searchBoulderSupplierJsp">Search Boulder Supplier</a>
		                        </li>
		                        <li>
                           			 <a href="addVehicleToBoulderSuppJsp">Add Vehicle</a>
		                        </li>
		                         <li>
                           			 <a href="addBoulderInwardJsp">Add Boulder Inward</a>
		                        </li>
		                         <li>
                           			 <a href="boulderInwardReportJsp">Boulder Inward Report</a>
		                        </li>
		                       <li>
                           			 <a href="searchBoulderSuppForAccJsp">Boulder Supplier Accounting</a>
		                        </li>
		                       
                    </ul>
                </li>
                <li >
                    <a href="#custSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-users"></i> <s:property value="getText('lable.customer')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="custSubmenu">
                    	<li>
                         	 <a href="addNewCustomerJsp"><i class="fas fa-user-plus"></i> <s:property value="getText('action.addNewCustomer')"/></a>
                        </li>
                        <li>
                         	 <a href="searchCutomerForUpdateJsp"><i class="fas fa-search"></i> <s:property value="getText('action.searchCustomer')"/></a>
                        </li>
                          <li>
                         	 <a href="searchCustomerJsp"><i class="fas fa-file-invoice-dollar"></i> <s:property value="getText('action.customerAccounting')"/></a>
                        </li>
		                      
                    </ul>
                </li>
                
                <li >
                    <a href="#vehicleSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.vehicle')"/> ></a>
                    <ul class="collapse list-unstyled" id="vehicleSubmenu">
                    	<li>
                         	 <a href="addNewVehicle"><s:property value="getText('action.addNewVehicle')"/></a>
                        </li>
                       <li>
                         	 <a href="listVehiclesJsp"><s:property value="getText('action.listVehicle')"/></a>
                        </li>
                        <li>
                         	 <a href="addVehicleTripEntryJsp"><s:property value="getText('action.addVehicleTripEntry')"/></a>
                        </li>
                        <li>
                         	 <a href="addVehicleConsumptionEntryJsp"><s:property value="getText('action.addVehicleConsumptionEntry')"/></a>
                        </li>
                        <li>
                         	 <a href="addVehicleMaintenanceEntryJsp"><s:property value="getText('action.addVehicleMaintenanceEntry')"/></a>
                        </li>
		                   <li>
                         	 <a href="consumptionReportJsp"><s:property value="getText('action.ConsumptionReport')"/></a>
                        </li>
                        <li>
                         	 <a href="maintenanceReportJsp"><s:property value="getText('action.MaintenanceReport')"/></a>
                        </li>   
                    </ul>
                </li>
               
                               <li >
                    <a href="#supplierSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-truck-field"></i> <s:property value="getText('lable.supplier')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="supplierSubmenu">
                      	<li>
                            <a href="addSupplierJsp"><i class="fas fa-plus-circle"></i> <s:property value="getText('action.addNewSupplier')"/></a>
                        </li>
                        <li>
                            <a href="searchSupplierJsp"><i class="fas fa-search"></i> <s:property value="getText('action.searchSupplier')"/></a>
                        </li>
                         <li>
		                       <a href="searchSupplierAccountingJsp"><i class="fas fa-file-invoice-dollar"></i> <s:property value="getText('action.accounts')"/></a>
		                   </li>
                      
                    </ul>
                </li>
                
                  <li>
                    <a href="#employeeSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-users-gear"></i> <s:property value="getText('lable.employee')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="employeeSubmenu">
                      <li>
                            <a href="addNewLaborJsp"><i class="fas fa-user-plus"></i> <s:property value="getText('action.addNewEmployee')"/></a>
                        </li>
                        <li>
                            <a href="searchLaborForUpdateJsp"><i class="fas fa-search"></i> <s:property value="getText('action.searchEmployee')"/></a>
                        </li>
                       
                         <li>
                            <a href="searchLaborForAddPaymentJsp"><i class="fas fa-money-bill-wave"></i> <s:property value="getText('action.addEmployeePayment/ViewAccount')"/></a>
                        </li>
                        
                         <li>
                            <a href="addLaborAbsentHalfDayOverTimeJsp"><i class="fas fa-clock"></i> <s:property value="getText('action.addEmployeeAbsent/HalfDay/OverTimeEntry')"/></a>
                         </li>
                          <li>
                            <a href="calculateSalaryOfLabor"><i class="fas fa-calculator"></i> <s:property value="getText('action.calculateSalary')"/></a>
                         </li>
                     	 <li>
                            <a href="downloadListOfLabour" target="_blank"><i class="fas fa-list-alt"></i> <s:property value="getText('action.listEmployeeDetails')"/></a>
                         </li>
                    </ul>
                </li>
                
                 <li >
                    <a href="#purchaseSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-shopping-cart"></i> <s:property value="getText('lable.purchase')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="purchaseSubmenu">
                      	  		<li>
                           			 <a href="addNewPurchaseJsp"><i class="fas fa-cart-plus"></i> <s:property value="getText('action.addNewPurchase')"/></a>
		                        </li>
		                      <li>
                           			 <a href="addNewDieselAdbluePurchaseJsp">Add New Diesel/Adblue Purchase</a>
		                        </li>
		                        <li>
                           			 <a href="addDirectStockJsp"><i class="fas fa-boxes-stacked"></i> <s:property value="getText('action.addDirectStock')"/></a>
		                        </li>
                    </ul>
                </li>
                
                 <li >
                    <a href="#expensesSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.expense')"/> ></a>
                    <ul class="collapse list-unstyled" id="expensesSubmenu">
                      	 
                      	  <li>
                            <a href="addNewSiteJsp"><s:property value="getText('action.addNewSite')"/></a>
                        </li>
                        <li>
                            <a href="addDailyExpenseJsp"><s:property value="getText('action.addDailyExpense')"/></a>
                        </li>
                         <li>
                            <a href="addNewCheckBookJsp"><s:property value="getText('action.addNewChequeBook')"/> </a>
                        </li>
                        <li>
                            <a href="addNewAddAccountHeadJsp"><s:property value="getText('action.addNewAccountHead')"/></a>
                        </li>
                    </ul>
                </li>
                
                
               
                
                
                
                  <li>
                    <a href="#bankingSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-university"></i> <s:property value="getText('lable.banking')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="bankingSubmenu">
                      	 <li>
                            <a href="addNewBankAccountJsp"><i class="fas fa-plus-circle"></i> <s:property value="getText('action.addNewAccount')"/></a>
                        </li>
                         <li>
                            <a href="addAccountCreditEntryJsp"><i class="fas fa-arrow-right"></i> <s:property value="getText('action.addCreditEntry')"/></a>
                        </li>
                         <li>
                            <a href="addAccountDebitEntryJsp"><i class="fas fa-arrow-left"></i> <s:property value="getText('action.addDebitEntry')"/></a>
                        </li>
                    </ul>
                </li>
                
                
                
                 <li>
                    <a href="#productReportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.productReports')"/> ></a>
                    <ul class="collapse list-unstyled" id="productReportSubmenu">
                    
                      	<li><a href="itemWiseStockReportJsp"><s:property value="getText('action.itemWiseStockReport')"/></a></li>
                       	<li><a href="itemWiseSalesReportJsp"><s:property value="getText('action.itemWiseSaleReport')"/></a></li>
                       <li><a href="itemWisePurchaseReportJsp"><s:property value="getText('action.itemWisePurchaseReport')"/></a></li>
                       		
                       </ul>
                </li>
                
                
                
                <li>
                    <a href="#reportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.reports')"/> ></a>
                    <ul class="collapse list-unstyled" id="reportSubmenu">
                      	<li><a href="vehicleTripReportJsp"><s:property value="getText('action.vehicleTripReport')"/></a></li>
                        <li><a href="dailySalesReportJsp"><s:property value="getText('action.dailySalesReport')"/></a></li>
                        <li><a href="purchaseReportJsp"><s:property value="getText('action.purchaseReport')"/></a></li>
                        <li><a href="dailyExpenseReportJsp"><s:property value="getText('action.dailyExpenseReport')"/></a></li>
                        <li><a href="custPaymentReceivedReport"> <s:property value="getText('action.customerPaymentReport')"/></a></li>
                        <li><a href="creditReportJsp"><s:property value="getText('action.creditReport')" /></a></li>
                        <li><a href="cashReportJsp"><s:property value="getText('action.cashReport')" /></a></li>
                        
                    </ul>
                </li>
                
                 <li>
                    <a href="#changeLaguageSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-language"></i> <s:property value="getText('lable.changelanguage')" /> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="changeLaguageSubmenu">
                   
                    <li>
         		  	<s:a href="changelang?lang=en"><i class="fas fa-flag-usa"></i> <s:property value="getText('language.english')"/></s:a>
         		  	</li>
         		  	<li>
	                 <s:a href="changelang?lang=mr"><i class="fas fa-om"></i> <s:property value="getText('language.marathi')"/> </s:a>	
	                
	               </li>				
				</ul>
                  
               </li> 
                
                <li>
                    <a href="changePassJsp"><i class="fas fa-key"></i> <s:property value="getText('lable.changePassword')"/></a>
                </li>
                 <li>
                    <a href="#settingsSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-cog"></i> <s:property value="getText('lable.settings')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="settingsSubmenu">
                    
                      	
                      	<li><a href="updateSettingsJsp"><i class="fas fa-university"></i> <s:property value="getText('action.bankDetailsSetting')"/></a></li>
                        <li><a href="updateCompanySettingsJsp"><i class="fas fa-building"></i> <s:property value="getText('action.companyDetailsSetting')"/></a></li>
                        <s:if test="#session.online_weight_scale_allowed==true">
	           
	                
	                    <li><a href="weightscaleupdateJsp"><i class="fas fa-weight-scale"></i> <s:property value="getText('action.weightScaleSetting')"/></a></li>
	                    
                    </s:if>
                    </ul>
                </li>
                
                <li>
                    <a href="logout"><i class="fas fa-sign-out-alt"></i> <s:property value="getText('lable.logOut')"/></a>
                </li>
                </s:if> 
                
                <!-- SALE  -->
                <s:if test="#session.role=='SALE'">
               		
               
                <li >
                    <a href="#billingSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.billing')"/> ></a>
                    <ul class="collapse list-unstyled" id="billingSubmenu">
                    	<li>
                         	 <a href="addBillJsp"><s:property value="getText('action.addNewBill')"/></a>
                        </li>
		                      
                    </ul>
                </li>
                
                <li>
                    <a href="#remindersSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.reminders')"/> ></a>
                     <ul class="collapse list-unstyled" id="remindersSubmenu">
                       <li>
                            <a href="addNewPaymentReminder"><s:property value="getText('action.addPaymentReminder')"/></a>
                        </li>
                       
                    </ul>
                    
                </li>
                
                <li >
                    <a href="#quotationSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.quotation')"/> ></a>
                    <ul class="collapse list-unstyled" id="quotationSubmenu">
                    	<li>
                         	 <a href="addnewQuotationJsp"><s:property value="getText('action.addNewQuotation')"/></a>
                        </li>
                        	<li> <a href="searchQuotationJsp"><s:property value="getText('action.searchQuotation')"/></a>
                        	</li>                        	
                           
                    </ul>
                </li>
                   <li >
                    <a href="#boulderSubmenu" data-toggle="collapse" aria-expanded="false">Boulder ></a>
                    <ul class="collapse list-unstyled" id="boulderSubmenu">
                      	  		<li>
                           			 <a href="addNewBoulderSupplierJsp">Add New Boulder Supplier</a>
		                        </li>
		                        <li>
                           			 <a href="searchBoulderSupplierJsp">Search Boulder Supplier</a>
		                        </li>
		                        <li>
                           			 <a href="addVehicleToBoulderSuppJsp">Add Vehicle</a>
		                        </li>
		                         <li>
                           			 <a href="addBoulderInwardJsp">Add Boulder Inward</a>
		                        </li>
		                         <li>
                           			 <a href="boulderInwardReportJsp">Boulder Inward Report</a>
		                        </li>
		                       <li>
                           			 <a href="searchBoulderSuppForAccJsp">Boulder Supplier Accounting</a>
		                        </li>
		                       
                    </ul>
                </li>
                <li >
                    <a href="#custSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.customer')"/> ></a>
                    <ul class="collapse list-unstyled" id="custSubmenu">
                    	<li>
                         	 <a href="addNewCustomerJsp"><s:property value="getText('action.addNewCustomer')"/></a>
                        </li>
                        <li>
                         	 <a href="searchCutomerForUpdateJsp"><s:property value="getText('action.searchCustomer')"/></a>
                        </li>
                        
		                      
                    </ul>
                </li>
                
                <li >
                    <a href="#vehicleSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.vehicle')"/> ></a>
                    <ul class="collapse list-unstyled" id="vehicleSubmenu">
                    	<li>
                         	 <a href="addNewVehicle"><s:property value="getText('action.addNewVehicle')"/></a>
                        </li>
                       <li>
                         	 <a href="listVehiclesJsp"><s:property value="getText('action.listVehicle')"/></a>
                        </li>
                        <li>
                         	 <a href="addVehicleTripEntryJsp"><s:property value="getText('action.addVehicleTripEntry')"/></a>
                        </li>
                        <li>
                         	 <a href="addVehicleConsumptionEntryJsp"><s:property value="getText('action.addVehicleConsumptionEntry')"/></a>
                        </li>
                        <li>
                         	 <a href="addVehicleMaintenanceEntryJsp"><s:property value="getText('action.addVehicleMaintenanceEntry')"/></a>
                        </li>
		                   <li>
                         	 <a href="consumptionReportJsp"><s:property value="getText('action.ConsumptionReport')"/></a>
                        </li>
                        <li>
                         	 <a href="maintenanceReportJsp"><s:property value="getText('action.MaintenanceReport')"/></a>
                        </li>   
                    </ul>
                </li>
                
                <li >
                    <a href="#purchaseSubmenu" data-toggle="collapse" aria-expanded="false"><i class="fas fa-shopping-cart"></i> <s:property value="getText('lable.purchase')"/> <i class="fas fa-chevron-down ml-auto"></i></a>
                    <ul class="collapse list-unstyled" id="purchaseSubmenu">
                      	  		<li>
                           			 <a href="addNewPurchaseJsp"><i class="fas fa-cart-plus"></i> <s:property value="getText('action.addNewPurchase')"/></a>
		                        </li>
		                      <li>
                           			 <a href="addNewDieselAdbluePurchaseJsp">Add New Diesel/Adblue Purchase</a>
		                        </li>
		                        <li>
                           			 <a href="addDirectStockJsp"><i class="fas fa-boxes-stacked"></i> <s:property value="getText('action.addDirectStock')"/></a>
		                        </li>
                    </ul>
                </li>
                 <li>
                    <a href="#productReportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.productReports')"/> ></a>
                    <ul class="collapse list-unstyled" id="productReportSubmenu">
                    
                      	<li><a href="itemWiseStockReportJsp"><s:property value="getText('action.itemWiseStockReport')"/></a></li>
                       	<li><a href="itemWiseSalesReportJsp"><s:property value="getText('action.itemWiseSaleReport')"/></a></li>
                       <li><a href="itemWisePurchaseReportJsp"><s:property value="getText('action.itemWisePurchaseReport')"/></a></li>
                       		
                       </ul>
                </li>
                 
                 	
               
               <li>
                    <a href="#reportSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.reports')"/> ></a>
                    <ul class="collapse list-unstyled" id="reportSubmenu">
                      	  <li><a href="vehicleTripReportJsp"><s:property value="getText('action.vehicleTripReport')"/></a></li>
                       <li><a href="dailySalesReportJsp"><s:property value="getText('action.dailySalesReport')"/></a></li>
                        <li><a href="creditReportJsp"><s:property value="getText('action.creditReport')" /></a></li>
                        <li><a href="cashReportJsp"><s:property value="getText('action.cashReport')" /></a></li>
                        
                    </ul>
                </li>
               
               <li>
                    <a href="#changeLaguageSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.changelanguage')" /> ></a>
                    <ul class="collapse list-unstyled" id="changeLaguageSubmenu">
                   
                    <li>
         		  	<s:a href="changelang?lang=en" ><s:property value="getText('language.english')"/></s:a>
         		  	</li>
         		  	<li>
	                 <s:a href="changelang?lang=mr" ><s:property value="getText('language.marathi')"/> </s:a>	
	                
	               </li>				
				</ul>
                  
               </li> 
               
                <li>
                    <a href="changePassJsp"><s:property value="getText('lable.changePassword')"/></a>
                </li>
                 <li>
                    <a href="#settingsSubmenu" data-toggle="collapse" aria-expanded="false"><s:property value="getText('lable.settings')"/> ></a>
                    <ul class="collapse list-unstyled" id="settingsSubmenu">
                    
                      	
                      	<li><a href="updateSettingsJsp"><s:property value="getText('action.bankDetailsSetting')"/></a></li>
                        <li><a href="updateCompanySettingsJsp"><s:property value="getText('action.companyDetailsSetting')"/></a></li>
                        <s:if test="#session.online_weight_scale_allowed==true">
	           
	                
	                    <li><a  href="weightscaleupdateJsp"><s:property value="getText('action.weightScaleSetting')"/></a></li>
	                    
                    </s:if>
                    </ul>
                </li>
                
                <li>
                    <a href="logout"><s:property value="getText('lable.logOut')"/></a>
                </li>
                </s:if> 
                  
                  
                
            </ul>

        </nav>

        <!-- Page Content  -->
       
    </div>

   
	<s:if test="addSideBarJs=='FALSE'">
 
	</s:if>
	<s:else>
		<script type="text/javascript" src="jquery/jQery3.5.js"  ></script>
	</s:else>
    <!-- jQuery CDN - Slim version (=without AJAX) -->
    <!-- Popper.JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
    <!-- Bootstrap JS -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
    <script type="text/javascript">
    var $j = jQuery.noConflict();
    $j(document).ready(function () {
        var sidebar = document.getElementById('sidebar');
        
        // Ultra-smooth scroll optimizations
        if (sidebar) {
            // Enable smooth scrolling with easing
            sidebar.style.scrollBehavior = 'smooth';
            
            // Optimize for high refresh rate displays
            sidebar.style.scrollSnapType = 'y proximity';
            
            // Enhanced momentum scrolling for iOS
            sidebar.style.webkitOverflowScrolling = 'touch';
            
            // Add scroll event throttling for performance
            let scrollTimeout;
            sidebar.addEventListener('scroll', function() {
                if (scrollTimeout) {
                    clearTimeout(scrollTimeout);
                }
                scrollTimeout = setTimeout(function() {
                    // Trigger repaint optimization
                    sidebar.style.transform = 'translateZ(0)';
                }, 16); // 60fps throttling
            }, { passive: true });
        }

        // Enhanced sidebar toggle with smooth animations
        $j('#dismiss, .overlay').on('click', function () {
            $j('#sidebar').removeClass('active');
            $j('.overlay').removeClass('active');
        });

        $j('#sidebarCollapse').on('click', function () {
            $j('#sidebar').addClass('active');
            $j('.overlay').addClass('active');
            $j('.collapse.in').toggleClass('in');
            $j('a[aria-expanded=true]').attr('aria-expanded', 'false');
        });
        
        // Ultra-smooth submenu animations
        $j('[data-toggle="collapse"]').on('click', function(e) {
            var target = $j(this).attr('href');
            var $target = $j(target);
            
            // Enhanced smooth transition for submenu expansion
            $target.css({
                'transition': 'height 0.35s cubic-bezier(0.4, 0, 0.2, 1)',
                'overflow': 'hidden'
            });
            
            // Smooth scroll to opened item
            setTimeout(function() {
                if ($target.hasClass('show')) {
                    $target[0].scrollIntoView({
                        behavior: 'smooth',
                        block: 'nearest'
                    });
                }
            }, 200);
        });
        
        // Enhanced touch device optimizations
        if ('ontouchstart' in window) {
            // Prevent overscroll bounce
            sidebar.addEventListener('touchmove', function(e) {
                var scrollTop = sidebar.scrollTop;
                var scrollHeight = sidebar.scrollHeight;
                var height = sidebar.clientHeight;
                var delta = e.touches[0].clientY - (e.touches[0].startY || 0);
                
                if ((scrollTop <= 0 && delta > 0) || 
                    (scrollTop >= scrollHeight - height && delta < 0)) {
                    e.preventDefault();
                }
            }, { passive: false });
        }
        
        // Smooth link hover effects
        $j('#sidebar a').on('mouseenter', function() {
            $j(this).css('transform', 'translateX(5px) translateZ(0)');
        }).on('mouseleave', function() {
            $j(this).css('transform', 'translateX(0) translateZ(0)');
        });
    });
    </script>
