<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib uri="/struts-dojo-tags" prefix="sx"%>  
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/smoothness/jquery-ui.css">

<style type="text/css">
/* Modern Dashboard Styles */
body {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 15px;
    min-height: 100vh;
    overflow-x: hidden;
}

.dashboard-container {
    max-width: 1300px;
    margin: 0 auto;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 16px;
    box-shadow: 0 15px 45px rgba(0, 0, 0, 0.08);
    padding: 25px;
    backdrop-filter: blur(10px);
}

.dashboard-header {
    text-align: center;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #e1e8ed;
}

.dashboard-title {
    font-size: 2.2rem;
    font-weight: 700;
    background: linear-gradient(135deg, #667eea, #764ba2);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin-bottom: 8px;
}

.dashboard-subtitle {
    font-size: 1rem;
    color: #6c757d;
    font-weight: 400;
}

/* Modern Statistics Cards */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 10px;
    margin-bottom: 20px;
}

.stat-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 10px;
    padding: 12px 16px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    cursor: pointer;
    min-height: 75px;
}

.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(43, 48, 68, 0.3);
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 45px;
    height: 45px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    transform: translate(15px, -15px);
}

.stat-card.card-customers {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stat-card.card-employees {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

.stat-card.card-vehicles {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
}

.stat-card.card-suppliers {
    background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
}

.stat-card.card-revenue {
    background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
}

.stat-card.card-debt {
    background: linear-gradient(135deg, #ff9a56 0%, #ff6b95 100%);
}

.stat-card.card-expense {
    background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
}

.stat-icon {
    font-size: 1.2rem;
    margin-bottom: 4px;
    opacity: 0.9;
}

.stat-value {
    font-size: 1.3rem;
    font-weight: 700;
    margin-bottom: 1px;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.stat-label {
    font-size: 0.65rem;
    opacity: 0.9;
    text-transform: uppercase;
    letter-spacing: 0.2px;
    font-weight: 500;
}

/* Search Section */
.search-section {
    background: white;
    border-radius: 8px;
    padding: 12px;
    margin-bottom: 15px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.04);
}

.search-title {
    font-size: 1rem;
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
}

.search-form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 8px;
    align-items: end;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.form-label {
    font-weight: 600;
    color: #495057;
    font-size: 0.7rem;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.form-input {
    padding: 8px 10px;
    border: 1px solid #e9ecef;
    border-radius: 6px;
    font-size: 0.85rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
    height: 32px;
}

.form-input:focus {
    outline: none;
    border-color: #667eea;
    background: white;
    box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.1);
}

.form-select {
    padding: 8px 10px;
    border: 1px solid #e9ecef;
    border-radius: 6px;
    background: #f8f9fa;
    font-size: 0.85rem;
    cursor: pointer;
    transition: all 0.3s ease;
    height: 32px;
}

.form-select:focus {
    outline: none;
    border-color: #667eea;
    background: white;
}

/* Data Tables */
.data-section {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
}

.section-title {
    font-size: 1.4rem;
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f1f3f4;
}

.modern-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.9rem;
    margin-top: 20px;
}

.modern-table th {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    padding: 15px 12px;
    text-align: left;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-size: 0.8rem;
    border: none;
}

.modern-table th:first-child {
    border-radius: 10px 0 0 0;
}

.modern-table th:last-child {
    border-radius: 0 10px 0 0;
}

.modern-table td {
    padding: 12px;
    border-bottom: 1px solid #e9ecef;
    color: #495057;
    vertical-align: middle;
}

.modern-table tr:hover {
    background: #f8f9fa;
}

.modern-table tr:last-child td {
    border-bottom: none;
}

/* Action Buttons */
.action-btn {
    padding: 8px 16px;
    border: none;
    border-radius: 8px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    margin: 2px;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
}

.btn-danger {
    background: linear-gradient(135deg, #ff6b6b, #ee5a24);
    color: white;
}

.btn-danger:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(255, 107, 107, 0.4);
}

.btn-success {
    background: linear-gradient(135deg, #00b894, #00cec9);
    color: white;
}

.btn-success:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(0, 184, 148, 0.4);
}

/* Alert Messages */
.alert {
    padding: 15px 20px;
    border-radius: 10px;
    margin-bottom: 20px;
    border: none;
    font-weight: 500;
}

.alert-success {
    background: linear-gradient(135deg, #00b894, #00cec9);
    color: white;
}

.alert-danger {
    background: linear-gradient(135deg, #ff6b6b, #ee5a24);
    color: white;
}

/* Quick Actions */
.quick-actions {
    display: grid;
    grid-template-columns: repeat(6, 1fr);
    grid-template-rows: repeat(2, 1fr);
    gap: 12px;
    margin-bottom: 20px;
    max-width: 100%;
}

.quick-action-card {
    background: white;
    border-radius: 10px;
    padding: 12px 8px;
    text-align: center;
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
    cursor: pointer;
    text-decoration: none;
    color: inherit;
    min-height: 70px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.quick-action-card:hover {
    border-color: #667eea;
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.12);
}

.quick-action-icon {
    font-size: 1.2rem;
    margin-bottom: 5px;
    color: #667eea;
}

.quick-action-label {
    font-weight: 600;
    color: #2c3e50;
    font-size: 0.75rem;
    line-height: 1.1;
    text-align: center;
}

/* Table Wrapper for Horizontal Scroll */
.table-wrapper {
    width: 100%;
    overflow-x: auto;
    margin: 10px 0;
    border-radius: 8px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.05);
    -webkit-overflow-scrolling: touch;
}

.table-wrapper .mytable {
    margin: 0 !important;
    min-width: 1000px;
}

/* Responsive Design */
@media (max-width: 768px) {
    body {
        padding: 5px;
    }
    
    .dashboard-container {
        padding: 10px;
        margin: 2px;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 6px;
        margin-bottom: 15px;
    }
    
    .stat-card {
        min-height: 50px;
        padding: 8px 6px;
        border-radius: 6px;
    }
    
    .stat-icon {
        font-size: 0.9rem;
        margin-bottom: 2px;
    }
    
    .stat-value {
        font-size: 1rem;
        margin-bottom: 1px;
    }
    
    .stat-label {
        font-size: 0.55rem;
        line-height: 1;
    }
    
    .search-form {
        grid-template-columns: 1fr;
        gap: 6px;
    }
    
    .search-section {
        padding: 8px;
        margin-bottom: 10px;
    }
    
    .search-title {
        font-size: 0.9rem;
        margin-bottom: 6px;
    }
    
    .dashboard-title {
        font-size: 1.6rem;
        margin-bottom: 8px;
    }
    
    .dashboard-subtitle {
        font-size: 0.75rem;
        margin-bottom: 15px;
    }
    
    .quick-actions {
        grid-template-columns: repeat(3, 1fr);
        grid-template-rows: repeat(4, 1fr);
        gap: 6px;
    }
    
    .quick-action-card {
        min-height: 55px;
        padding: 8px 4px;
    }
    
    .quick-action-icon {
        font-size: 0.9rem;
        margin-bottom: 3px;
    }
    
    .quick-action-label {
        font-size: 0.65rem;
    }
    
    .additional-actions {
        grid-template-columns: 1fr;
        gap: 8px;
    }
    
    .mytable {
        font-size: 0.7rem !important;
    }
    
    .mytable th {
        padding: 4px 2px !important;
        font-size: 0.65rem !important;
    }
    
    .mytable td {
        padding: 4px 2px !important;
        font-size: 0.7rem !important;
    }
}

/* Extra small mobile devices */
@media (max-width: 480px) {
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 4px;
    }
    
    .stat-card {
        min-height: 45px;
        padding: 6px 4px;
    }
    
    .stat-icon {
        font-size: 0.8rem;
        margin-bottom: 1px;
    }
    
    .stat-value {
        font-size: 0.9rem;
        margin-bottom: 0px;
    }
    
    .stat-label {
        font-size: 0.5rem;
        line-height: 0.9;
    }
    
    .dashboard-title {
        font-size: 1.4rem;
    }
    
    .quick-actions {
        grid-template-columns: repeat(4, 1fr);
        gap: 4px;
    }
    
    .quick-action-card {
        min-height: 50px;
        padding: 6px 2px;
    }
    
    .quick-action-icon {
        font-size: 0.8rem;
        margin-bottom: 2px;
    }
    
    .quick-action-label {
        font-size: 0.6rem;
    }
}

/* Search Results */
.search-results {
    margin-top: 20px;
}

.search-results .data-section {
    margin-bottom: 20px;
}

/* Additional Button Styles */
.additional-actions {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 6px;
    margin: 15px 0;
}

.additional-action-btn {
    display: flex;
    align-items: center;
    gap: 4px;
    padding: 6px 8px;
    background: white;
    border: 1px solid #e9ecef;
    border-radius: 4px;
    text-decoration: none;
    color: #495057;
    font-weight: 600;
    font-size: 0.65rem;
    transition: all 0.3s ease;
    min-height: 30px;
}

.additional-action-btn:hover {
    border-color: #667eea;
    background: #f8f9fa;
    color: #667eea;
    transform: translateY(-1px);
}

.additional-action-btn img {
    width: 24px;
    height: 24px;
}

/* Enhanced Statistics Cards */
.stylish-box {
    background: white;
    border-radius: 15px;
    padding: 25px;
    margin: 10px;
    text-align: center;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    border: 2px solid transparent;
    position: relative;
    overflow: hidden;
    display: inline-block;
    min-width: 200px;
}

.stylish-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
    border-color: #667eea;
}

.stylish-box .label {
    display: block;
    font-size: 0.9rem;
    color: #6c757d;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 10px;
}

.stylish-box .value {
    display: block;
    font-size: 2rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 10px;
}

.stylish-box .symbol {
    position: absolute;
    top: 15px;
    right: 15px;
    font-size: 1.5rem;
    color: #667eea;
    opacity: 0.7;
}

.box-1 { border-left: 4px solid #667eea; }
.box-2 { border-left: 4px solid #f093fb; }
.box-3 { border-left: 4px solid #4facfe; }
.box-4 { border-left: 4px solid #43e97b; }
.box-5 { border-left: 4px solid #fa709a; }

/* Enhanced Table Styles for Data Tables */
.mytable {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.05);
    margin: 10px auto !important;
    width: 100% !important;
    max-width: 100% !important;
    font-size: 0.8rem !important;
    table-layout: auto !important;
    border-collapse: separate !important;
    border-spacing: 0 !important;
}

.mytable th {
    background: linear-gradient(135deg, #667eea, #764ba2) !important;
    color: white !important;
    padding: 8px 6px !important;
    font-weight: 600 !important;
    text-transform: uppercase;
    letter-spacing: 0.3px;
    font-size: 0.75rem !important;
    border: none !important;
    white-space: nowrap !important;
    overflow: hidden !important;
    text-overflow: ellipsis !important;
    min-width: 80px !important;
}

.mytable td {
    padding: 8px 6px !important;
    border-bottom: 1px solid #e9ecef !important;
    color: #495057 !important;
    vertical-align: middle !important;
    font-size: 0.8rem !important;
    white-space: nowrap !important;
    overflow: hidden !important;
    text-overflow: ellipsis !important;
    min-width: 80px !important;
}

.mytable tr:hover {
    background: #f8f9fa !important;
}

.mytable tr:last-child td {
    border-bottom: none !important;
}

/* Loading Animation Enhancement */
.blinking {
    animation: blinkingText 2s infinite;
}

@keyframes blinkingText {
    0% { color: #667eea; }
    49% { color: #667eea; }
    60% { color: transparent; }
    99% { color: transparent; }
    100% { color: #667eea; }
}
</style>

<div class="dashboard-container">
    <!-- Alert Messages -->
    <s:if test="hasActionErrors()">
        <div class="alert alert-danger">
            <strong><i class="fas fa-exclamation-triangle"></i> Error!</strong>
            <s:iterator var="error" value="%{errorMessages}">
                <s:property value="%{error}"/>
            </s:iterator>
        </div>
    </s:if>

    <s:if test="hasActionMessages()">
        <div class="alert alert-success">
            <strong><i class="fas fa-check-circle"></i> Success!</strong>
            <s:iterator var="message" value="%{actionMessages}">
                <s:property value="%{message}"/>
            </s:iterator>
        </div>
    </s:if>

    <!-- Statistics Cards -->
    <s:if test="#session.role == 'ADMIN' || #session.role == 'ACCOUNT'">
    <div class="stats-grid">
        <a target="blank" href="<s:url action='downloadListOfCustomer'  />" style="text-decoration: none; color: inherit;">
            <div class="stat-card card-customers">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-value"><s:property value="#session.totalNoOfCustomer" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.customerCount')" /></div>
            </div>
        </a>
        
        <a target="blank" href="<s:url action='downloadListOfLabour'  />" style="text-decoration: none; color: inherit;">
            <div class="stat-card card-employees">
                <div class="stat-icon">
                    <i class="fas fa-user-tie"></i>
                </div>
                <div class="stat-value"><s:property value="#session.totalNoOfEmployee" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.employeeCount')" /></div>
            </div>
        </a>
        
        <a href="<s:url action='listVehiclesJsp' />" style="text-decoration: none; color: inherit;">
            <div class="stat-card card-vehicles">
                <div class="stat-icon">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="stat-value"><s:property value="#session.totalNoOfVehicle" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.vehicleCount')" /></div>
            </div>
        </a>
        
        <a target="blank" href="<s:url action='downloadListOfSupplier'  />" style="text-decoration: none; color: inherit;">
            <div class="stat-card card-suppliers">
                <div class="stat-icon">
                    <i class="fas fa-handshake"></i>
                </div>
                <div class="stat-value"><s:property value="#session.totalNoOfSupplier" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.supplierCount')" /></div>
            </div>
        </a>
        
        <a href="<s:url action='getCustCreditReport' >
           <s:param name="minAmount"><s:property value="minAmount"/></s:param>
           <s:param name="maxAmount"><s:property value="maxAmount"/></s:param>
           <s:param name="fromDate"><s:property value="fromDate"/></s:param>
           <s:param name="toDate"><s:property value="toDate"/></s:param>
           <s:param name="downloadFileType"><s:property value="downloadFileType"/></s:param>
           <s:param name="downloadFileLanguage"><s:property value="downloadFileLanguage"/></s:param>
           </s:url>" style="text-decoration: none; color: inherit;">
            <div class="stat-card card-revenue">
                <div class="stat-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stat-value"><s:property value="#session.allCustomerCreditAmt" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.customerCreditAmt')" /></div>
            </div>
        </a>
        
        <a href="<s:url action='getSupplierDebtReport' >
        
         <s:param name="fromDate"><s:property value="fromDate"/></s:param>
           <s:param name="toDate"><s:property value="toDate"/></s:param>
           </s:url>     
        " style="text-decoration: none; color: inherit;">
            <div class="stat-card card-debt">
                <div class="stat-icon">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="stat-value"><s:property value="#session.allSupplierDebtAmt" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.supplierDebtAmt')" /></div>
            </div>
        </a>
        
        <a href="<s:url action='dailyExpenseReportJsp' />" style="text-decoration: none; color: inherit;">
            <div class="stat-card card-expense">
                <div class="stat-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
                <div class="stat-value">₹ <s:property value="#session.allTotalExpenseAmt" /></div>
                <div class="stat-label"><s:property value="getText('text.lable.totalExpenseAmt')" /></div>
            </div>
        </a>
    </div>
    </s:if>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <a href="addNewProductJsp" class="quick-action-card" accesskey="e">
            <div class="quick-action-icon">
                <i class="fas fa-plus-circle"></i>
            </div>
            <div class="quick-action-label">Add Product</div>
        </a>
        
        <a href="addNewCustomerJsp" class="quick-action-card" accesskey="c">
            <div class="quick-action-icon">
                <i class="fas fa-user-plus"></i>
            </div>
            <div class="quick-action-label">Add Customer</div>
        </a>
        
        <a href="addBillJsp" class="quick-action-card" accesskey="b">
            <div class="quick-action-icon">
                <i class="fas fa-file-invoice-dollar"></i>
            </div>
            <div class="quick-action-label">New Bill</div>
        </a>
        
        <a href="addSupplierJsp" class="quick-action-card" accesskey="g">
            <div class="quick-action-icon">
                <i class="fas fa-truck-loading"></i>
            </div>
            <div class="quick-action-label">Add Supplier</div>
        </a>
        
        <a href="addDailyExpenseJsp" class="quick-action-card" accesskey="x">
            <div class="quick-action-icon">
                <i class="fas fa-receipt"></i>
            </div>
            <div class="quick-action-label">Add Expense</div>
        </a>
        
        <a href="addNewLaborJsp" class="quick-action-card" accesskey="l">
            <div class="quick-action-icon">
                <i class="fas fa-hard-hat"></i>
            </div>
            <div class="quick-action-label">Add Employee</div>
        </a>

        <a href="addNewVehicle" class="quick-action-card" accesskey="v">
            <div class="quick-action-icon">
                <i class="fas fa-truck"></i>
            </div>
            <div class="quick-action-label">Add Vehicle</div>
        </a>
        
        <a href="addNewPurchaseJsp" class="quick-action-card" accesskey="u">
            <div class="quick-action-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="quick-action-label">Add Purchase</div>
        </a>

        <a href="searchSupplierAccountingJsp" class="quick-action-card" accesskey="s">
            <div class="quick-action-icon">
                <i class="fas fa-credit-card"></i>
            </div>
            <div class="quick-action-label">Supplier Payment</div>
        </a>

        <a href="searchCustomerJsp" class="quick-action-card" accesskey="m">
            <div class="quick-action-icon">
                <i class="fas fa-money-bill-wave"></i>
            </div>
            <div class="quick-action-label">Customer Payment</div>
        </a>

        <a href="addNewPaymentReminder" class="quick-action-card" accesskey="d">
            <div class="quick-action-icon">
                <i class="fas fa-bell"></i>
            </div>
            <div class="quick-action-label">Payment Reminder</div>
        </a>

        <a href="addRmcBillJsp" class="quick-action-card" accesskey="r">
            <div class="quick-action-icon">
                <i class="fas fa-file-contract"></i>
            </div>
            <div class="quick-action-label">RMC Bill</div>
        </a>
    </div>

    <!-- Search Section -->
    <div class="search-section">
        <h2 class="search-title">
            <i class="fas fa-search"></i>
            Search Center
        </h2>
        <div class="search-form">
            <div class="form-group">
                <label class="form-label">Product Search</label>
                <s:textfield id="searchValue" name="searchValue" placeholder="Enter product name..." onkeyup="getProductData(this.value)" theme="simple" cssClass="form-input"/>
            </div>
            <div class="form-group">
                <label class="form-label">Supplier Search</label>
                <s:select theme="simple" list="customerSearchOptionList" name="customerSearchOption" id="supplierSearchOption" headerKey="" headerValue="Search by..." cssClass="form-select"/>
                <s:textfield onkeyup="getSupplierData(this.value, 'supplierSearchOption')" placeholder="Enter supplier name..." theme="simple" cssClass="form-input"/>
            </div>
            <div class="form-group">
                <label class="form-label">Employee Search</label>
                <s:select theme="simple" list="customerSearchOptionList" name="customerSearchOption" id="laborSearchOption" headerKey="" headerValue="Search by..." cssClass="form-select"/>
                <s:textfield onkeyup="getLaborData(this.value, 'laborSearchOption')" placeholder="Enter employee name..." theme="simple" cssClass="form-input"/>
            </div>
            <div class="form-group">
                <label class="form-label">Customer Search</label>
                <s:select theme="simple" list="customerSearchOptionList" name="customerSearchOption" id="customerSearchOption" headerKey="" headerValue="Search by..." cssClass="form-select"/>
                <s:textfield onkeyup="getCustomerData(this.value, 'customerSearchOption')" placeholder="Enter customer name..." theme="simple" cssClass="form-input"/>
            </div>
        </div>
    </div>

    <!-- Search Results Container -->
    <div class="search-results">
        <div id="productData"></div>
        <div id="supplierData"></div>
        <div id="laborData"></div>
        <div id="custData"></div>
    </div>
</div>

 <script lang="javascript" type="text/javascript"> 

 		
 	
 window.onload = function() {
	  document.getElementById("searchValue").focus();
	};
	
	

	function getProductData(str)
	{
		 
		 var strlength = str.length;
		
		 if(strlength >1 && str.includes(" "))
		{
		 var url = "productInfoJSON?key="+str;
		// alert(url);
		 var text = "<div class='data-section'><h3 class='section-title'><i class='fas fa-box'></i> Product Search Results</h3>";
		 text = text + "<table class='modern-table'>";
		 text = text + "<thead><tr>";
		 text = text + "<th><s:property value="getText('text.lable.date(productAdded)')" /></th>";
		 text = text + "<th><s:property value="getText('text.lable.productName')" /></th>";
		 text = text + "<th><s:property value="getText('text.lable.marathiName')" /></th>";
		 text = text + "<th><s:property value="getText('text.lable.purchaseRate')" /></th>";
		 text = text + "<th><s:property value="getText('text.lable.salesRate')" /></th>";
		 text = text + "<th><s:property value="getText('text.lable.alias')" /></th>";
		 text = text + "<th><s:property value="getText('text.lable.tax')" />(%)</th>";
		 text = text + "<th><s:property value="getText('text.lable.action')" /></th>";
		 text = text + "</tr></thead><tbody>";
		
		 $.getJSON(url, function(data)
		{
			
			 var d;
			 var name;
			 var mname;			
			 var prate;
			 var srate;
			 var a;
			 var t;
			 var proId;
			 var i = 1;
			 
			 $.each(data.searchProductInfo, function()
			{
				  var me = this;//save `this` reference
				 
				
				  d = me.addDate;
				  name = me.productName;
				  mname  = me.marathiName;
				  prate = me.purchaseRate;
				  srate = me.salesRate;
				   a = me.alias;
				   t = me.tax
				   proId =me.productId;
				  
				 
				   text = text+"<tr>";
				   text = text+'<td>'+d+'</td>';
				   text = text+'<td>'+name+'</td>';
				   text = text+'<td>'+mname+'</td>';
				   text = text+'<td>'+prate+'</td>';
				   text = text+'<td>'+srate+'</td>';
				   text = text+'<td>'+a+'</td>';
				   text = text+'<td>'+t+'</td>';
				  
				   text = text+"<td align='center'><a href='editProductJsp?id="+proId+"' class='action-btn btn-primary'><i class='fas fa-edit'></i> <s:property value="getText('action.edit')" /></a></td>";
				 					   
				 		
				 
				   text = text+'</tr>';
				  
			 });
			 
			 
			 text = text+'</tbody></table></div>';
			
			
			
			
			 document.getElementById("productData").innerHTML = text;	
				document.getElementById("supplierData").innerHTML = "";
				document.getElementById("custData").innerHTML = "";	
				document.getElementById("laborData").innerHTML = "";
				
			
         
	});
	}
	} 
		 

	function getSupplierData(str, selectId)
	{
		 var supplierSearchOption = document.getElementById(selectId).value;
	
		
		 
		 var strlength = str.length;
		
		 if(strlength >4 && str.includes(" "))
		{
			 var url = "supplierInfoJSON?key="+str+"&searchOption="+supplierSearchOption;
				
		
		 var text = "<div style='display: flex; justify-content: center; width: 100%; margin: 20px 0;'>";
		 text = text + "<table class='table table-bordered' style='width: 1000px; font-size: 14px; margin: 0 auto;'>";
		 text = text + "<tr  style='font-weight: bold; background-color: rgb(234,234,234);'>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.id')" /></td>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.supplierName')" /></td>";		
		 text = text + "<td class='td'><s:property value="getText('text.lable.mobile')" /></td>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.address')" /></td>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.debtAmount')" /></td>";		
		 text = text + "<td colspan='2' class='td' align='center'><s:property value="getText('text.lable.action')" /></td>";
		 text = text + "</tr>";
		 
		 $.getJSON(url, function(data)
		{
			 var id;
			 var sname;
			 var mobile;			
			 var address;			
			 var debt;
			 var key;
			
			 var i = 1;
			 
			 $.each(data.supplierInfoList, function()
			{
				  var me = this;//save `this` reference
				 
				
				  id = me.supplierId;
				  sname = me.supplierName;
				  mobile  = me.supplierMobile;
				  address = me.supplierAddress;				  
				  debt = me.debtAmount;
				  key = me.key;
				  
				 
				   text = text+"<tr>";
				   text = text+'<td>'+id+'</td>';
				   text = text+'<td>'+sname+'</td>';
				   text = text+'<td>'+mobile+'</td>';
				   text = text+'<td>'+address+'</td>';
				   text = text+'<td>'+debt+'</td>';				
				  
				  
				 		text = text+"<td align='center'><a href='addSuppPaymentDetailsJsp?key="+key+"'><button type='button' class='btn btn-primary btn-sm'><s:property value="getText('button.addPaymentDetails')" /></button></td>";
				 					   
				 	
				 		text = text+"<td align='center'><a href='viewSupplierAccDetailsJsp?key="+key+"'><button type='button' class='btn btn-danger btn-sm'><s:property value="getText('button.viewAccountDetails')" /></button></td>";
				 		
				 
				   text = text+'</tr>';
				  
			 });
			 
			 
			 text = text+'</table></div>';
			
			 document.getElementById("supplierData").innerHTML = text;	
				
				
				document.getElementById("custData").innerHTML = "";
				document.getElementById("productData").innerHTML = "";	
				document.getElementById("laborData").innerHTML = "";
				
				
			
			
         
	});
	}


}

	
	
	function getLaborData(str, selectId)
	{
		 
		 var supplierSearchOption = document.getElementById(selectId).value;
		 
		 var strlength = str.length;
		
		 if(strlength >4 && str.includes(" "))
		{
			 
		 var url = "laborInfoJSON?key="+str+"&searchOption="+supplierSearchOption;
		
		 var text = "<div style='display: flex; justify-content: center; width: 100%; margin: 20px 0;'>";
		 text = text + "<table class='table table-bordered' style='width: 1000px; font-size: 14px; margin: 0 auto;'>";
		 text = text + "<tr  style='font-weight: bold; background-color: rgb(234,234,234);'>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.id')" /></td>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.laborName')" /></td>";
		 text = text + "<td class='td'><s:property value="getText('text.lable.laborMobile')" /></td>";				
		 text = text + "<td class='td' align='center' colspan='2'><s:property value="getText('text.lable.action')" /></td>";
		 text = text + "</tr>";
		 
		 $.getJSON(url, function(data)
		{
			 var id;
			 var bname;
			 var mobile;				
			 var key;
			
			 var i = 1;
			 
			 $.each(data.laborInfoList, function()
			{
				  var me = this;//save `this` reference
				 
				
				  id = me.laborId;
				  bname = me.laborName;
				  mobile  = me.laborMobile;
				
				  key = me.key;
				  
				 
				   text = text+"<tr>";
				   text = text+'<td>'+id+'</td>';
				   text = text+'<td>'+bname+'</td>';
				   text = text+'<td>'+mobile+'</td>';
				 
				  
				  
				   text = text+"<td align='center'><a href='addLaborPaymentJsp?key="+key+"'><button type='button' class='btn btn-primary'><s:property value="getText('button.addLaborPayment')" /></button></td>";
				   text = text+"<td align='center'><a href='viewLabourAccountDetailsJsp?key="+key+"'><button type='button' class='btn btn-primary'><s:property value="getText('button.viewAccountDetails')" /></button></td>";
				  		
				   text = text+'</tr>';
				  
			 });
			 
			 
			 text = text+'</table></div>';
			
			document.getElementById("laborData").innerHTML = text;
			
			document.getElementById("custData").innerHTML = "";	
			
			document.getElementById("supplierData").innerHTML = "";
			document.getElementById("productData").innerHTML = "";	
			
			
	});
	}
}
	
	
			function getCustomerData(str, selectId)
			{
				 //alert(str);
				 var customerSearchOption = document.getElementById(selectId).value;
				 
				 var strlength = str.length;
				
				 if(strlength >4 && str.includes(" "))
				{
				 var url = "customerInfoJSON?key="+str+"&searchOption="+customerSearchOption;
				
				 var text = "<div style='display: flex; justify-content: center; width: 100%; margin: 20px 0;'>";
				 text = text + "<table class='table table-bordered' style='width: 1000px; font-size: 14px; margin: 0 auto;' >";
				 text = text + "<tr  style='font-weight: bold; background-color: rgb(234,234,234);'>";
				 text = text + "<td class='td'><s:property value="getText('text.lable.id')" /></td>";
				 text = text + "<td class='td'><s:property value="getText('text.lable.customerName')" /></td>";
				 text = text + "<td class='td'><s:property value="getText('text.lable.image')" /></td>";
				
				 text = text + "<td class='td'><s:property value="getText('text.lable.mobile')" /></td>";
				 text = text + "<td class='td'><s:property value="getText('text.lable.address')" /></td>";
				 text = text + "<td class='td'><s:property value="getText('text.lable.mobileVerified')" />?</td>";
				 text = text + "<td class='td'><s:property value="getText('text.lable.outstandingAmount')" /></td>";		
				 text = text + "<td colspan='2' class='td' align='center'><s:property value="getText('text.lable.action')" /></td>";
				 text = text + "</tr>";
				 
				 $.getJSON(url, function(data)
				{
					 var id;
					 var cname;
					 var mobile;			
					 var address;
					 var mverified;
					 var outstanding;
					 var key;
					
					 var i = 1;
					 
					 $.each(data.custInfoList, function()
					{
						  var me = this;//save `this` reference
						 
						
						  id = me.customerId;
						  cname = me.custName;
						  mobile  = me.mobileNumber;
						  address = me.billingaddress;
						  mverified = me.mobileVerified;
						  outstanding = me.totalOutStandingAmount;
						  key = me.key;
						  
						 
						   text = text+"<tr>";
						   text = text+'<td>'+id+'</td>';
						   text = text+'<td>'+cname+'</td>';
						   text = text+'<td><img width="90" height="100" src=customerImage.action?custId='+id+'></td>';
						   text = text+'<td>'+mobile+'</td>';
						   text = text+'<td>'+address+'</td>';
						   text = text+'<td>'+mverified+'</td>';
						   text = text+'<td>'+outstanding+'</td>';
						  
						  
						 		text = text+"<td align='center'><a href='addPaymentDetailsJsp?key="+key+"'><button type='button' class='btn btn-primary btn-sm'><s:property value="getText('button.addPaymentDetails')" /></button></td>";
						 					   
						 	
						 		text = text+"<td align='center'><a href='viewAccountDetailsJsp?key="+key+"'><button type='button' class='btn btn-danger btn-sm'><s:property value="getText('button.viewAccountDetails')" /></button></td>";
						 		
						 
						   text = text+'</tr>';
						  
					 });
					 
					 
					 text = text+'</table></div>';
					
					 document.getElementById("custData").innerHTML = text;	
						
						document.getElementById("supplierData").innerHTML = "";
						document.getElementById("productData").innerHTML = "";	
						document.getElementById("laborData").innerHTML = "";
						
			});
			}
}
			
			
			function stateChange(req){   
				 if (req.readyState==4 || req.readyState=="complete"){   
				 document.getElementById("dataRes").innerHTML=req.responseText;  
				 }   
				 }  
			
			

</script>


<!-- Alert messages are now handled in the header section above -->
<script type="text/javascript">
$(function() {
	$('#successMessage').delay(5000).fadeOut('slow');
});

$('#billDate').change(function(){ 
	var a = $('#billDate').val();
	
	$('#billDateHidden').val(a);
	
	 $('#home').submit();
    });


</script>
<!-- Modern search section is now above in the dashboard container -->


<!-- Duplicate stylish-box sections removed - now using modern stat cards above -->

<!-- Additional Actions section removed to eliminate duplicate buttons -->


<!-- Search results are now handled in the modern search section above -->




<s:if test="todayBillingList.size()>0">

<div class="table-wrapper">
<table class="table table-bordered mytable">
<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="19" align="center"> <s:property value="getText('text.lable.todaysBillDetails')" /></td>
</tr><tr  style="font-weight: bold; background-color: rgb(234,234,234);">
<th><s:property value="getText('text.lable.date')" /></th>
<th><s:property value="getText('text.lable.time')" /></th>
<th><s:property value="getText('text.lable.billNo')" /></th>
<th><s:property value="getText('text.lable.chalanNo')" /></th>
<th><s:property value="getText('text.lable.billType')" /></th>
<th><s:property value="getText('text.lable.name')" /></th>
<th><s:property value="getText('text.lable.address')" /></th>
<th><s:property value="getText('text.lable.vehicle')" /></th>
<th><s:property value="getText('text.lable.item')" /></th>
<th><s:property value="getText('text.lable.quantity')" /></th>
<th><s:property value="getText('text.lable.rate')" /></th>
<th><s:property value="getText('text.lable.materialCost')" /></th>
<th><s:property value="getText('text.lable.taxableAmount')" /></th>
<th>cgst</th>
<th>sgst</th>
<s:if test="#session.royaltyAllowed == 1">
 <th><s:property value="getText('text.lable.royalty')" /></th>
 
 </s:if>
<th><s:property value="getText('text.lable.transportationCharges')" /></th>
 <th>Pump Amount</th>
<th>Labor Amount</th>
<th><s:property value="getText('text.lable.totalAmount')" /></th>
<th>Cash Amt</th>
<th>Online Amt</th>
<th><s:property value="getText('text.lable.amountReceived')" /></th>
<th><s:property value="getText('text.lable.balanceAmount')" /></th>
<th><s:property value="getText('text.lable.address')" /></th>
<th><s:property value="getText('text.lable.billedBy')" /></th>
<th><s:property value="getText('text.lable.comments')" /></th>
</tr>
<s:iterator value="todayBillingList">
<tr>
<td><s:property value="billDate"/></td>
<td><s:property value="billTime"/></td>
<td>
<s:if test="originateSource=='CRUSHER'">
<a href="viewBillJsp?billNumber=<s:property value="billNumber"/>&billType=<s:property value="billType"/>" >
<span class="glyphicon glyphicon-eye-open"></span>&nbsp;&nbsp;&nbsp;&nbsp;<s:property value="billNumber"/></a>
</s:if>


<s:if test="originateSource=='RMC'">

<a  href="viewRMCBillJsp?billNumber=<s:property value="billNumber"/>&billType=<s:property value="billType"/>" >
  <span class="glyphicon glyphicon-eye-open"></span>&nbsp;&nbsp;&nbsp;&nbsp;<s:property value="billNumber"/>
</a>
</s:if>

</td>

<td><s:property value="chalanNumber"/></td>
<td><s:property value="billType"/></td>

<td><s:property value="custName"/></td>
<td><s:property value="custAddress"/></td>
<td><s:property value="vehicleNumber"/>-<s:property value="vehicleMake"/> </td>
<td><s:property value="itemNameAll"/></td>
<td><s:property value="itemQuantityAll"/></td>
<td><s:property value="itemRate"/></td>
<td><s:property value="materialAmount"/></td>
<td><s:property value="taxableAmt"/></td>
<td><s:property value="cgst"/></td>
<td><s:property value="sgst"/></td>
<s:if test="#session.royaltyAllowed == 1">
<td><s:property value="royalty"/></td>
</s:if>

<td><s:property value="transportCharges"/></td>
<td><s:property value="pumpAmount"/></td>
<td><s:property value="laborAmount"/></td>
<td><s:property value="billTotalAmount"/></td>
<td><s:property value="CashAmt"/></td>
<td><s:property value="OnlineAmt"/></td>
<td><s:property value="billAmountRecieved"/></td>
<td><s:property value="balanceAmount"/></td>
<td><s:property value="custAddress"/></td>
<td><s:property value="billedBy"/></td>
<td><s:property value="comments"/></td>
</tr>
</s:iterator>
<tr  style="font-weight: bold;">
<td colspan="9" align="right"> <s:property value="getText('text.lable.total')" /></td>
<td><s:property value="materialTotal"/></td>

<td ></td>
<td><s:property value="allBillMatrialCostTotal"/></td>
<td><s:property value="totalTaxableAmtAllTheTime"/></td>
<td><s:property value="totalCgstAllTheTime"/></td>
<td><s:property value="totalSgstAllTheTime"/></td>
<s:if test="#session.royaltyAllowed == 1">

<td><s:property value="totalRoyalty"/></td>

</s:if>
<td><s:property value="transportTotal"/></td>
<td><s:property value="totalPumpAmtAllTheTime"/></td>
<td><s:property value="totalLaborAmtAllTheTime"/></td>
<td><s:property value="totalBillAmount"/></td>
<td><s:property value="totalCashAmt"/></td>
<td><s:property value="totalOnlineAmt"/></td>
<td><s:property value="totalReceivedAmount"/></td>
<td><s:property value="totalBalanceAmount"/></td>
<td></td>
<td></td>
<td></td>
</tr>

</table>
</div>

</s:if>

<s:if test="purchaseDetailsList.size()>0">

<div class="table-wrapper">
<table class="table table-bordered mytable">
<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="13" align="center"> <s:property value="getText('text.lable.todaysPurchaseDetails')" /></td>
</tr>
<tr  style="font-weight: bold; background-color: rgb(234,234,234); ">
<th><s:property value="getText('text.lable.date')" /></th>
<s:if test="#session.role=='ADMIN'">

<th><s:property value="getText('text.lable.action')" />?</th>
</s:if>
<th><s:property value="getText('text.lable.invoiceNo')" /></th>
<th><s:property value="getText('text.lable.productName')" /></th>
<th><s:property value="getText('text.lable.quantity')" />.</th>
<th><s:property value="getText('text.lable.rate')" /></th>
<th><s:property value="getText('text.lable.purchaseAmount')" /></th>
<th><s:property value="getText('text.lable.amountPaid')" /></th>
<th><s:property value="getText('text.lable.balanceAmount')" /></th>
<th><s:property value="getText('text.lable.debtAmount')" /></th>
<th><s:property value="getText('text.lable.purchaseBy')" /></th>
<th><s:property value="getText('text.lable.entryBy')" /></th>
<th><s:property value="getText('text.lable.comments')" /></th>
</tr>

<s:iterator  value="purchaseDetailsList" > 

<tbody>
<tr>
<td><s:property value="dateAsString"/></td>
<s:if test="#session.role=='ADMIN'">
<s:if test="entryType=='PURCHASE'">
<s:if test="entryAddedBy=='REGULAR'">

<td>
<a  href="viewPurchaseJsp?purchaseNumber=<s:property value="paymentPurchaseId"/> " target="_blank" title="View Purchase Invoice">
  <button style="padding: 0px;" type="button" class="btn btn-primary"><s:property value="getText('button.view')" /></button>
</a>

<s:url var="deleteSupplierPurchaseEntry" action="deleteSupplierPurchaseEntry">
<s:param name="fromDate"><s:property value="fromDate"/></s:param>
<s:param name="toDate"><s:property value="toDate"/></s:param>   
<s:param name="key"><s:property value="key"/></s:param>  
<s:param name="paymentPurchaseId"><s:property value="paymentPurchaseId"/></s:param>  
</s:url>

<a href="${deleteSupplierPurchaseEntry}" title="Delete Supplier Purchase Entry" onclick="return confirm('Are you sure, you want to delete purchase entry?')"><button style="padding: 0px;" type="button" class="btn btn-danger"><s:property value="getText('button.delete')" /></button></a>



</td>

</s:if>

<s:else>
<td>
<s:url var="deleteSupplierDieselAdbluePurchaseEntry" action="deleteSupplierDieselAdbluePurchaseEntry">
<s:param name="fromDate"><s:property value="fromDate"/></s:param>
<s:param name="toDate"><s:property value="toDate"/></s:param>   
<s:param name="key"><s:property value="key"/></s:param>  
<s:param name="paymentPurchaseId"><s:property value="paymentPurchaseId"/></s:param>  
</s:url>

<a href="${deleteSupplierDieselAdbluePurchaseEntry}" title="Delete Supplier Purchase Entry" onclick="return confirm('Are you sure, you want to delete purchase entry?')"><button style="padding: 0px;" type="button" class="btn btn-danger"><s:property value="getText('button.delete')" /></button></a>

</td>

</s:else>

</s:if>
</s:if>
<td><s:property value="invoiceNumber"/></td>
<td><s:property value="itemNameAll"/></td>
<td><s:property value="itemQuantityAll"/></td>
<td><s:property value="itemRate"/></td>
<td><s:property value="purchaseAmount"/></td>
<td><s:property value="amountPaid"/></td>
<td><s:property value="balanceAmount"/></td>
<td><s:property value="debtAmount"/></td>
<td><s:property value="purchaseBy"/></td>
<td><s:property value="entryBy"/></td>
<td><s:property value="comments"/></td>
</tr>
</tbody>
</s:iterator>


</table>


</s:if>

<s:if test="custPaymentDetailsDAOList.size()>0">
<div class="table-wrapper">
<table class="table table-bordered mytable">
<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="7" align="center"> <s:property value="getText('text.lable.todaysCustomerPaymentDetails')" /></td>
</tr>
<tr  style="font-weight: bold; background-color: rgb(234,234,234);">

<th><s:property value="getText('text.lable.paymentId')" /></th>
<th><s:property value="getText('text.lable.paymentDate')" /></th>
<th><s:property value="getText('text.lable.customerId')" /></th>
<th><s:property value="getText('text.lable.customerName')" /></th>
<th><s:property value="getText('text.lable.address')" /></th>
<th><s:property value="getText('text.lable.amount')" /></th>
<th><s:property value="getText('text.lable.details')" /></th>

</tr>
<s:iterator  value="custPaymentDetailsDAOList">
<tr>

<td>

<a href="updateCustPaymentEntryJsp?paymentId=<s:property value='paymentId'/>">
  <span class="glyphicon glyphicon-eye-open"></span>
</a>



 <s:url var="downloadCustomerPaymentSlip" action="downloadCustomerPaymentSlip">
<s:param name="key"><s:property value="key"/></s:param>
<s:param name="paymentId"><s:property value="paymentId"/></s:param>
<s:param name="size">A4</s:param>
<s:param name="lang">eng</s:param>
</s:url>
<a href="${downloadCustomerPaymentSlip}" target="_blank" style="font-weight: bold;" ><s:property value="paymentId"/></a>
 
 </td>
<td><s:property value="paymentDate"/> </td>
<td><s:property value="custId"/> </td>
<td><s:property value="custName"/> </td>
<td><s:property value="custAddess"/> </td>

<td><s:property value="amount"/></td>
<td><s:property value="details"/> </td>

</tr>
</s:iterator>

</table>
</div>
</s:if>


<s:if test="reportList.size()>0">
<div class="table-wrapper">	
<table class="table table-bordered mytable">

<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="9" align="center" >
<s:property value="getText('text.lable.accountWisedebitReportStatement')" />
</td>
</tr>
<tr  style="font-weight: bold; background-color: rgb(234,234,234);">
<th><s:property value="getText('text.lable.accountName')" /></th>
<th><s:property value="getText('text.lable.accountNumber')" /></th>
<th><s:property value="getText('text.lable.date')" /></th>
<th><s:property value="getText('text.lable.paymentType')" /></th>
<th><s:property value="getText('text.lable.amount')" /></th>
<th><s:property value="getText('text.lable.details')" /></th>
<th><s:property value="getText('text.lable.entryBy')" /></th>


</tr>


<s:iterator  value="reportList">
<tr>
<td><s:property value="accountName"/> </td>
<td><s:property value="accountNumber"/> </td>
<td><s:property value="dateAsString"/> </td>
<td><s:property value="paymentType"/> </td>
<td><s:property value="amount"/> </td>
<td><s:property value="entryDetails"/> </td>
<td><s:property value="entryBy"/> </td>


</tr>
</s:iterator>

</table>
</div>
</s:if>




<s:if test="bankCreditList.size()>0">
<div class="table-wrapper">	
<table class="table table-bordered mytable">
<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="10" align="center" >
<s:property value="getText('text.lable.accountWiseTodaysCreditReportStatement')" />
</td>
</tr>

<tr  style="font-weight: bold; background-color: rgb(234,234,234);">

<td><s:property value="getText('text.lable.accountName')" /></td>
<th><s:property value="getText('text.lable.totalCreditAmount')" /></th>

</tr>

<s:iterator  value="bankCreditList">
<tr  >
<td><s:property value="accountNumber"/>-<s:property value="accountName"/> </td>
<td><s:property value="amount"/> </td>


</tr>
</s:iterator>

</table>
</div>
</s:if>







<s:if test="bankAccountReportDAOList.size()>0">
<div class="table-wrapper">	
<table class="table table-bordered mytable">

<tr  style="font-weight: bold; background-color: rgb(234,234,234);">
<td colspan="10" align="center" >
Account Statement
</td>
</tr>
<tr>
<td>Acc Name</td>
<td>Date</td>
<th>Payment Type</th>
<th>Details</th>
<th>CREDIT</th>
<th>DEBIT</th>
<th>Balance</th>
<th>Entry By</th>
<s:if test="#session.role=='ADMIN'">
<th colspan="2">Action?</th>
</s:if>
</tr>
<tr style="font-weight: bold;">
<td colspan="4" align="right">Total:</td>
<td><s:property value="totalCredit"/> </td>
<td><s:property value="totalDebit"/> </td>
<td><s:property value="balance"/> </td>
<td colspan="3"></td>
</tr>

<s:iterator  value="bankAccountReportDAOList">
<tr>
<td><s:property value="accountName"/> </td>
<td><s:property value="dateAsString"/> </td>
<td><s:property value="paymentType"/> </td>
<td><s:property value="entryDetails"/> </td>
<s:if test="entryType=='CREDIT'">
<td><s:property value="amount"/> </td>
<td></td>
</s:if>
<s:if test="entryType=='DEBIT'">
<td></td>

<td><s:property value="amount"/> </td>
</s:if>
<td><s:property value="balance"/> </td>
<td><s:property value="entryBy"/> </td>
<s:if test="#session.role=='ADMIN'">
<td  align="center">
<s:url var="updateBankAccEntry" action="updateBankAccEntryJsp">
  <s:param name="key"><s:property value="key"/></s:param> 
</s:url>
<a href="${updateBankAccEntry}">
<button type='button' class='btn btn-primary'>UPDATE</button></a>
</td>
<td  align="center">
<s:url var="deleteBankAccEntry" action="deleteBankAccEntry">
  <s:param name="key"><s:property value="key"/></s:param> 
</s:url>
<a href="${deleteBankAccEntry}" onclick="return confirm('Are you sure, you want to delete this entry?')">
<button type='button' class='btn btn-danger'>DELETE</button></a>
</td>
</s:if>
</tr>
</s:iterator>

</table>
</div>
</s:if>


<s:if test="rmcUsedIngreDAOList.size()>0">
<div class="table-wrapper">
<table class="table table-bordered mytable">
<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="14" align="center"> RMC Used Material Details</td>
</tr>
<tr  style="font-weight: bold; background-color: rgb(234,234,234);">

<th>Bill Date</th>
<th>Bill Number</th>
<th>Bill Type</th>
<th>Chalan No</th>
<th>Customer Name</th>
<th>Product Name</th>
<th>10 MM</th>
<th>20 MM</th>
<th>CRUSH SAND</th>
<th>WASH SAND</th>
<th>WATER</th>
<th>ADD MIXTURE</th>
<th>CEMENT OPC</th>
<th>CEMENT PPC</th>

</tr>
<s:iterator  value="rmcUsedIngreDAOList">
<tr>
<td align="center"><s:property value="billDate"/> </td>
<td align="center"><s:property value="rmBillNumber"/> </td>
<td align="center"><s:property value="billType"/> </td>
<td align="center"><s:property value="chalanNo"/> </td>
<td align="center"><s:property value="cutomerName"/> </td>
<td align="center"><s:property value="productName"/> </td>
<td align="center"><s:property value="tenmm"/> </td>
<td align="center"><s:property value="twentymm"/> </td>
<td align="center"><s:property value="crushsand"/> </td>
<td align="center"><s:property value="washsand"/></td>
<td align="center"><s:property value="water"/> </td>
<td align="center"><s:property value="addmixture"/> </td>
<td align="center"><s:property value="cementOPC"/></td>
<td align="center"><s:property value="cementPPC"/> </td>

</tr>
</s:iterator>
<tr  style="font-weight: bold; background-color: rgb(234,234,234);">
<td colspan="6" align="right">
Total
</td>
<td align="center">
<s:property value="totalTenMMUsed"/>

</td>
<td align="center">
<s:property value="totalTwentyMMUsed"/>

</td>
<td align="center">
<s:property value="totalCrushSandUsed"/>

</td>
<td align="center">
<s:property value="totalWashSandUsed"/>

</td>
<td align="center">
<s:property value="totalWaterUsed"/>

</td>
<td align="center">
<s:property value="totalAddMixtureUsed"/>

</td>
<td align="center">
<s:property value="totalOPCUsed"/>

</td>
<td align="center">
<s:property value="totalPPCUsed"/>

</td>
</tr>
</table>
</div>
</s:if>


<s:if test="dailyExpenseList.size()>0">
<div class="table-wrapper">
<table class="table table-bordered mytable">
<tr  style="font-weight: bold; background-color: #D6EAF8; color: #2C3E50;">
<td colspan="7" align="center"> <s:property value="getText('text.lable.todaysExpenseDetails')" /></td>
</tr>
<tr  style="font-weight: bold; background-color: rgb(234,234,234);">

<th><s:property value="getText('text.lable.id')" /></th>
<th><s:property value="getText('text.lable.expenseDate')" /></th>
<th><s:property value="getText('text.lable.reason')" /></th>
<th><s:property value="getText('text.lable.paymentType')" /></th>
<th><s:property value="getText('text.lable.entryBy')" /></th>
<th><s:property value="getText('text.lable.amount')" /></th>
<s:if test="#session.role=='ADMIN'">
<th><s:property value="getText('text.lable.action')" />?</th>
</s:if>
</tr>
<s:iterator  value="dailyExpenseList">
<tr>
<s:if test="expenseImage==null">
<td><s:property value="id"/> </td>
</s:if>
<s:else>
<td><a href="expenseImage.action?id=<s:property value='id'/>" target="_blank"><s:property value="id"/></a>
</td>
</s:else>
<td><s:property value="expenseDate"/> </td>
<td><s:property value="expenseReason"/> </td>
<td align="right"><s:property value="typeOfPayment"/> </td>
<td align="right"><s:property value="description"/></td>
<td align="right"><s:property value="amount"/> </td>
<s:if test="#session.role=='ADMIN'">
<td>
<s:url var="deleteExpenseEntry" action="deleteExpenseEntry">
<s:param name="key"><s:property value="key"/></s:param>  
<s:param name="fromDate"><s:property value="fromDate"/></s:param>  
<s:param name="toDate"><s:property value="toDate"/></s:param>  
</s:url>
<a href="${deleteExpenseEntry}" onclick="return confirm('Are you sure, you want to delete expense entry?')"><button type='button' class='btn btn-danger'><s:property value="getText('button.delete')" /></button></a>
 </td>

</s:if>
</tr>
</s:iterator>
<tr  style="font-weight: bold; background-color: rgb(234,234,234);">
<td colspan="5" align="right">
<s:property value="getText('text.lable.totalExpenseAmount')" />
</td>
<td align="right">
<s:property value="totalExpenseAmount"/>
</td>
</tr>
</table>
</div>
</s:if>


<s:form id="home" action="home" name="home" theme="simple" enctype="multipart/form-data" acceptcharset="UTF-8">
<s:hidden id="billDateHidden" name="billDateHidden"/>

</s:form>











