<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Page Not Found | Samarth Stone Crusher</title>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
        }

        /* Animated Background Particles */
        .particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: 1;
        }

        .particle {
            position: absolute;
            width: 4px;
            height: 4px;
            background: rgba(255, 255, 255, 0.6);
            border-radius: 50%;
            animation: float 6s infinite ease-in-out;
        }

        .particle:nth-child(1) { left: 10%; animation-delay: 0s; }
        .particle:nth-child(2) { left: 20%; animation-delay: 1s; }
        .particle:nth-child(3) { left: 30%; animation-delay: 2s; }
        .particle:nth-child(4) { left: 40%; animation-delay: 3s; }
        .particle:nth-child(5) { left: 50%; animation-delay: 4s; }
        .particle:nth-child(6) { left: 60%; animation-delay: 5s; }
        .particle:nth-child(7) { left: 70%; animation-delay: 0.5s; }
        .particle:nth-child(8) { left: 80%; animation-delay: 1.5s; }
        .particle:nth-child(9) { left: 90%; animation-delay: 2.5s; }
        .particle:nth-child(10) { left: 15%; animation-delay: 3.5s; }

        @keyframes float {
            0%, 100% {
                transform: translateY(100vh) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100px) rotate(360deg);
                opacity: 0;
            }
        }

        /* Main Container */
        .error-container {
            position: relative;
            z-index: 2;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .error-content {
            text-align: center;
            color: white;
            max-width: 600px;
            animation: slideUp 1s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* 404 Number Animation */
        .error-number {
            font-size: 200px;
            font-weight: 800;
            margin-bottom: 20px;
            position: relative;
            background: linear-gradient(45deg, #fff, #f0f0ff, #fff);
            background-size: 200% 200%;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: shimmer 3s ease-in-out infinite, bounce 2s ease-in-out infinite;
            text-shadow: 0 0 50px rgba(255, 255, 255, 0.5);
        }

        @keyframes shimmer {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-20px);
            }
            60% {
                transform: translateY(-10px);
            }
        }

        /* Floating Icons */
        .floating-icon {
            position: absolute;
            font-size: 60px;
            color: rgba(255, 255, 255, 0.3);
            animation: floatIcon 4s ease-in-out infinite;
        }

        .floating-icon.icon-1 {
            top: 20%;
            left: 15%;
            animation-delay: 0s;
        }

        .floating-icon.icon-2 {
            top: 30%;
            right: 20%;
            animation-delay: 1s;
        }

        .floating-icon.icon-3 {
            bottom: 30%;
            left: 10%;
            animation-delay: 2s;
        }

        .floating-icon.icon-4 {
            bottom: 20%;
            right: 15%;
            animation-delay: 3s;
        }

        @keyframes floatIcon {
            0%, 100% {
                transform: translateY(0px) rotate(0deg);
            }
            50% {
                transform: translateY(-20px) rotate(10deg);
            }
        }

        /* Error Message */
        .error-title {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 20px;
            animation: slideInLeft 1s ease-out 0.3s both;
        }

        .error-subtitle {
            font-size: 24px;
            font-weight: 400;
            margin-bottom: 30px;
            opacity: 0.9;
            animation: slideInRight 1s ease-out 0.6s both;
        }

        .error-description {
            font-size: 18px;
            font-weight: 300;
            margin-bottom: 40px;
            opacity: 0.8;
            line-height: 1.6;
            animation: fadeIn 1s ease-out 0.9s both;
        }

        @keyframes slideInLeft {
            from {
                opacity: 0;
                transform: translateX(-50px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(50px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 0.8;
            }
        }

        /* Action Buttons */
        .action-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            animation: slideUp 1s ease-out 1.2s both;
        }

        .btn {
            padding: 15px 30px;
            border: none;
            border-radius: 50px;
            font-family: 'Poppins', sans-serif;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .btn-primary {
            background: linear-gradient(45deg, #ff6b6b, #ff8e53);
            color: white;
            box-shadow: 0 8px 25px rgba(255, 107, 107, 0.3);
        }

        .btn-secondary {
            background: transparent;
            color: white;
            border: 2px solid white;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .btn:hover::before {
            left: 100%;
        }

        .btn:hover {
            transform: translateY(-5px) scale(1.05);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        }

        .btn-secondary:hover {
            background: white;
            color: #667eea;
        }

        /* Glitch Effect for 404 */
        .glitch {
            position: relative;
            animation: glitch 2s infinite;
        }

        .glitch::before,
        .glitch::after {
            content: '404';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }

        .glitch::before {
            animation: glitch-1 0.5s infinite;
            color: #ff00ff;
            z-index: -1;
        }

        .glitch::after {
            animation: glitch-2 0.5s infinite;
            color: #00ffff;
            z-index: -2;
        }

        @keyframes glitch {
            0%, 74%, 76%, 100% {
                transform: translate(0);
            }
            75% {
                transform: translate(-2px, 2px);
            }
        }

        @keyframes glitch-1 {
            0%, 100% {
                transform: translate(0);
            }
            20% {
                transform: translate(-2px, 2px);
            }
            40% {
                transform: translate(-2px, -2px);
            }
            60% {
                transform: translate(2px, 2px);
            }
            80% {
                transform: translate(2px, -2px);
            }
        }

        @keyframes glitch-2 {
            0%, 100% {
                transform: translate(0);
            }
            20% {
                transform: translate(2px, -2px);
            }
            40% {
                transform: translate(2px, 2px);
            }
            60% {
                transform: translate(-2px, -2px);
            }
            80% {
                transform: translate(-2px, 2px);
            }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .error-number {
                font-size: 120px;
            }
            
            .error-title {
                font-size: 32px;
            }
            
            .error-subtitle {
                font-size: 20px;
            }
            
            .error-description {
                font-size: 16px;
            }
            
            .floating-icon {
                font-size: 40px;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .btn {
                width: 250px;
            }
        }

        @media (max-width: 480px) {
            .error-number {
                font-size: 80px;
            }
            
            .error-title {
                font-size: 24px;
            }
            
            .error-subtitle {
                font-size: 18px;
            }
            
            .floating-icon {
                display: none;
            }
        }

        /* Mouse Trail Effect */
        .mouse-trail {
            position: fixed;
            width: 20px;
            height: 20px;
            background: radial-gradient(circle, rgba(255,255,255,0.8) 0%, rgba(255,255,255,0) 70%);
            border-radius: 50%;
            pointer-events: none;
            z-index: 9999;
            transition: transform 0.1s ease-out;
        }
    </style>
</head>
<body>
    <!-- Animated Background Particles -->
    <div class="particles">
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
    </div>

    <!-- Floating Icons -->
    <div class="floating-icon icon-1">
        <i class="fas fa-cog"></i>
    </div>
    <div class="floating-icon icon-2">
        <i class="fas fa-search"></i>
    </div>
    <div class="floating-icon icon-3">
        <i class="fas fa-exclamation-triangle"></i>
    </div>
    <div class="floating-icon icon-4">
        <i class="fas fa-home"></i>
    </div>

    <!-- Main Error Container -->
    <div class="error-container">
        <div class="error-content">
            <div class="error-number glitch">404</div>
            <h1 class="error-title">Oops! Page Not Found</h1>
            <h2 class="error-subtitle">Houston, we have a problem!</h2>
            <p class="error-description">
                The page you're looking for seems to have taken a coffee break. 
                Don't worry, our stone crushing business is still running smoothly!
            </p>
            
            <div class="action-buttons">
                <a href="login.jsp" class="btn btn-primary">
                    <i class="fas fa-home"></i> Back to Login
                </a>
                <a href="javascript:history.back()" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Go Back
                </a>
            </div>
        </div>
    </div>

    <!-- Mouse Trail -->
    <div class="mouse-trail"></div>

    <script>
        // Mouse Trail Effect
        document.addEventListener('mousemove', function(e) {
            const trail = document.querySelector('.mouse-trail');
            trail.style.left = e.clientX - 10 + 'px';
            trail.style.top = e.clientY - 10 + 'px';
        });

        // Add random particles
        function createParticle() {
            const particle = document.createElement('div');
            particle.className = 'particle';
            particle.style.left = Math.random() * 100 + '%';
            particle.style.animationDuration = (Math.random() * 3 + 2) + 's';
            particle.style.animationDelay = Math.random() * 2 + 's';
            document.querySelector('.particles').appendChild(particle);
            
            setTimeout(() => {
                particle.remove();
            }, 5000);
        }

        // Create particles periodically
        setInterval(createParticle, 300);

        // Add click ripple effect to buttons
        document.querySelectorAll('.btn').forEach(button => {
            button.addEventListener('click', function(e) {
                const ripple = document.createElement('span');
                const rect = this.getBoundingClientRect();
                const size = Math.max(rect.width, rect.height);
                const x = e.clientX - rect.left - size / 2;
                const y = e.clientY - rect.top - size / 2;
                
                ripple.style.width = ripple.style.height = size + 'px';
                ripple.style.left = x + 'px';
                ripple.style.top = y + 'px';
                ripple.style.position = 'absolute';
                ripple.style.borderRadius = '50%';
                ripple.style.background = 'rgba(255, 255, 255, 0.6)';
                ripple.style.transform = 'scale(0)';
                ripple.style.animation = 'ripple 0.6s linear';
                ripple.style.pointerEvents = 'none';
                
                this.appendChild(ripple);
                
                setTimeout(() => {
                    ripple.remove();
                }, 600);
            });
        });

        // Ripple animation keyframes
        const style = document.createElement('style');
        style.textContent = `
            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>