<%@ page language="java" pageEncoding="UTF-8"%>
<%@ page contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib uri="/struts-dojo-tags" prefix="sx"%>  
<%@ taglib prefix="sj" uri="/struts-jquery-tags"  %>

<style>
/* Conservative UI/UX Enhancements */
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background-color: #f8f9fa;
}

/* Clean Table Styling */
.table.mytable {
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    margin-bottom: 15px;
}

.table.mytable td {
    border: 1px solid #dee2e6;
    padding: 8px;
    vertical-align: middle;
    font-size: 13px;
}

.table.mytable tr:first-child td {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
    font-weight: 600;
    text-align: center;
    border-color: #0056b3;
}

.table.mytable tr:nth-child(even) {
    background-color: #f8f9fa;
}

.table.mytable tr:hover {
    background-color: #e9ecef;
    transition: background-color 0.2s ease;
}

/* Clean Form Elements */
input[type="text"], input[type="password"], select, textarea {
    border: 1px solid #ced4da;
    border-radius: 4px;
    padding: 6px 10px;
    font-size: 13px;
    font-family: 'Segoe UI', sans-serif;
    transition: border-color 0.2s ease;
}

input[type="text"]:focus, input[type="password"]:focus, select:focus, textarea:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25);
    outline: none;
}

input[readonly] {
    background-color: #e9ecef;
    cursor: not-allowed;
}

/* Clean Button Styling */
.btn {
    border-radius: 4px;
    font-weight: 500;
    padding: 8px 16px;
    border: 1px solid transparent;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 13px;
}

.btn-primary {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.btn-primary:hover {
    background-color: #0056b3;
    border-color: #004085;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.btn-danger {
    background-color: #dc3545;
    border-color: #dc3545;
    color: white;
}

.btn-danger:hover {
    background-color: #c82333;
    border-color: #bd2130;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
    color: white;
}

.btn-success:hover {
    background-color: #218838;
    border-color: #1e7e34;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Clean Alert Messages */
.alert {
    border-radius: 6px;
    border: 1px solid transparent;
    margin: 10px 0;
    padding: 12px 16px;
    font-weight: 500;
}

.alert-danger {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

.alert-success {
    background-color: #d4edda;
    border-color: #c3e6cb;
    color: #155724;
}

/* Loading Overlay */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.9);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

.loading-spinner {
    background: white;
    padding: 20px 30px;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    text-align: center;
    font-weight: 500;
    color: #007bff;
}

.loading-spinner::before {
    content: '';
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 2px solid #f3f3f3;
    border-top: 2px solid #007bff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-bottom: 10px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Status Indicators */
.status-indicator {
    display: inline-block;
    width: 8px;
    height: 8px;
    border-radius: 50%;
    margin-right: 6px;
    animation: pulse 2s infinite;
}

.status-connected {
    background: #28a745;
}

.status-disconnected {
    background: #dc3545;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.6; }
    100% { opacity: 1; }
}

/* Notification System */
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 12px 20px;
    border-radius: 6px;
    color: white;
    font-weight: 500;
    z-index: 10000;
    animation: slideInRight 0.3s ease-out;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    max-width: 350px;
}

.notification.success {
    background-color: #28a745;
}

.notification.error {
    background-color: #dc3545;
}

@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(100%);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* Field Validation States */
.field-valid {
    border-color: #28a745;
    box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.25);
}

.field-invalid {
    border-color: #dc3545;
    box-shadow: 0 0 0 2px rgba(220, 53, 69, 0.25);
    animation: shake 0.3s ease-in-out;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-3px); }
    75% { transform: translateX(3px); }
}

/* Clean Focus States */
input:focus, select:focus, textarea:focus, button:focus {
    outline: none;
    box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25);
}

/* Radio and Checkbox Enhancement */
input[type="radio"], input[type="checkbox"] {
    margin-right: 6px;
    accent-color: #007bff;
}

/* Responsive Improvements */
@media (max-width: 768px) {
    .table.mytable td {
        padding: 6px 4px;
        font-size: 12px;
    }
    
    .btn {
        padding: 6px 12px;
        font-size: 12px;
    }
}
</style>

<style>
/* Enhanced CSS for Better UI/UX */
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    margin: 0;
    padding: 20px;
    min-height: 100vh;
}

/* Main Container */
.main-container {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border-radius: 15px;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    padding: 20px;
    margin: 0 auto;
    max-width: 1250px;
}

/* Enhanced Table Styling */
.table.mytable {
    background: white;
    border-radius: 12px !important;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08) !important;
    border: none !important;
    margin-bottom: 20px !important;
}

.table.mytable td {
    border: 1px solid #e8ecef !important;
    padding: 8px 6px !important;
    vertical-align: middle !important;
    font-size: 13px !important;
    color: #2c3e50 !important;
    font-weight: 500 !important;
}

.table.mytable tr:first-child td {
    background: #f8f9fa !important;
    color: #333 !important;
    font-weight: 600 !important;
    text-align: center !important;
    font-size: 14px !important;
    padding: 8px 6px !important;
    border: 1px solid #dee2e6 !important;
}

.table.mytable tr:nth-child(even) {
    background-color: #f8f9fa !important;
}

.table.mytable tr:hover {
    background-color: #e3f2fd !important;
    transition: all 0.3s ease !important;
}

/* Enhanced Form Elements */
input[type="text"], input[type="password"], select, textarea {
    border: 1px solid #ddd !important;
    border-radius: 4px !important;
    padding: 6px 10px !important;
    font-size: 14px !important;
    font-family: 'Segoe UI', sans-serif !important;
    transition: all 0.3s ease !important;
    background: white !important;
    color: #333 !important;
    height: auto !important;
    line-height: normal !important;
    font-weight: 500 !important;
}

/* Ensure dropdown options are visible */
select option {
    background: white !important;
    color: #333 !important;
    padding: 6px 10px !important;
    font-size: 14px !important;
    font-weight: 500 !important;
}

select:focus option {
    background: white !important;
    color: #333 !important;
}

input[type="text"]:focus, input[type="password"]:focus, select:focus, textarea:focus {
    border-color: #80bdff !important;
    box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.05) !important;
    outline: none !important;
    background: white !important;
}

input[type="text"]:hover, select:hover, textarea:hover {
    border-color: #b3c6ff !important;
}

input[readonly] {
    background-color: #f8f9fa !important;
    cursor: not-allowed !important;
}

/* Enhanced Buttons */
.btn {
    border-radius: 8px !important;
    font-weight: 600 !important;
    padding: 10px 20px !important;
    border: none !important;
    cursor: pointer !important;
    transition: all 0.3s ease !important;
    font-size: 13px !important;
    margin: 2px !important;
    text-transform: uppercase !important;
    letter-spacing: 0.5px !important;
}

.btn-primary {
    background: #e9ecef !important;
    color: #495057 !important;
    border: 1px solid #ced4da !important;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
}

.btn-primary:hover {
    transform: translateY(-2px) !important;
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4) !important;
}

.btn-danger {
    background: linear-gradient(135deg, #ff6b6b 0%, #ee5a52 100%) !important;
    color: white !important;
    box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3) !important;
}

.btn-danger:hover {
    transform: translateY(-2px) !important;
    box-shadow: 0 8px 25px rgba(255, 107, 107, 0.4) !important;
}

.btn-success {
    background: linear-gradient(135deg, #51cf66 0%, #40c057 100%) !important;
    color: white !important;
    box-shadow: 0 4px 15px rgba(81, 207, 102, 0.3) !important;
}

.btn:active {
    transform: translateY(1px) !important;
}

/* Enhanced Alert Messages */
.alert {
    border-radius: 10px !important;
    border: none !important;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
    margin: 10px 0 !important;
    padding: 15px 20px !important;
    font-weight: 500 !important;
}

.alert-danger {
    background: linear-gradient(135deg, #ff6b6b 0%, #ee5a52 100%) !important;
    color: white !important;
    animation: shake 0.5s ease-in-out !important;
}

.alert-success {
    background: linear-gradient(135deg, #51cf66 0%, #40c057 100%) !important;
    color: white !important;
    animation: slideInDown 0.5s ease-out !important;
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
}

@keyframes slideInDown {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Radio Button Enhancement */
input[type="radio"] {
    margin-right: 6px !important;
    transform: scale(1.0) !important;
}

/* Checkbox Enhancement */
input[type="checkbox"] {
    transform: scale(1.1) !important;
    margin-right: 6px !important;
}

/* Loading Overlay */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.9);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    backdrop-filter: blur(5px);
}

.loading-spinner {
    background: white;
    padding: 15px 25px;
    border-radius: 4px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    text-align: center;
    font-weight: 500;
    color: #495057;
    font-size: 14px;
    border: 1px solid #dee2e6;
}

.loading-spinner::before {
    content: '';
    display: inline-block;
    width: 16px;
    height: 16px;
    border: 2px solid #e9ecef;
    border-top: 2px solid #495057;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-bottom: 8px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Enhanced Table Data Display */
.table .table-striped td {
    border: 1px solid #dee2e6 !important;
    padding: 10px 8px !important;
    font-size: 12px !important;
}

.table .table-striped tr:first-child {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    color: white !important;
    font-weight: 600 !important;
}

.table .table-striped tr:first-child td {
    color: white !important;
    border-color: rgba(255, 255, 255, 0.2) !important;
}

.table .table-striped tr:nth-child(even) {
    background-color: #f8f9fa !important;
}

.table .table-striped tr:hover {
    background-color: #e3f2fd !important;
    transform: scale(1.002) !important;
    transition: all 0.3s ease !important;
}

/* Form Section Headers */
.form-section-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    color: white !important;
    padding: 15px !important;
    margin: 20px 0 0 0 !important;
    border-radius: 10px 10px 0 0 !important;
    font-weight: 600 !important;
    text-align: center !important;
}

/* Enhanced Serial Port Controls */
.serial-controls {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
    border-radius: 10px !important;
    padding: 15px !important;
    margin: 15px 0 !important;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05) !important;
}

/* Image Enhancement */
img {
    border-radius: 8px !important;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
    transition: all 0.3s ease !important;
}

img:hover {
    transform: scale(1.05) !important;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2) !important;
}

/* Status Indicators */
.status-indicator {
    display: inline-block;
    width: 10px;
    height: 10px;
    border-radius: 50%;
    margin-right: 8px;
    animation: pulse 2s infinite;
}

.status-connected {
    background: #51cf66;
}

.status-disconnected {
    background: #ff6b6b;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

/* Tooltip Enhancement */
[title] {
    position: relative;
    cursor: help;
}

/* Focus Ring Enhancement */
*:focus {
    outline: 1px solid #80bdff !important;
    outline-offset: 1px !important;
}

/* Print Button Group */
.print-button-group {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    justify-content: center;
    margin: 20px 0;
}

.print-button-group .btn {
    flex: 1;
    min-width: 120px;
}

/* Responsive Enhancements */
@media (max-width: 1250px) {
    .main-container {
        margin: 0 10px;
        padding: 15px;
    }
    
    .table.mytable {
        font-size: 12px !important;
    }
    
    .table.mytable td {
        padding: 8px 6px !important;
    }
}

@media (max-width: 768px) {
    .main-container {
        margin: 0 5px;
        padding: 10px;
    }
    
    .table.mytable {
        font-size: 11px !important;
    }
    
    .btn {
        padding: 8px 15px !important;
        font-size: 12px !important;
    }
	 	 
    .print-button-group {
        flex-direction: column;
    }
    
    .print-button-group .btn {
        width: 100%;
        margin: 5px 0;
    }
}

/* Notification System */
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 15px 25px;
    border-radius: 10px;
    color: white;
    font-weight: 600;
    z-index: 10000;
    animation: slideInRight 0.3s ease-out;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
    max-width: 400px;
}

.notification.success {
    background: linear-gradient(135deg, #51cf66, #40c057);
}

.notification.error {
    background: linear-gradient(135deg, #ff6b6b, #ee5a52);
}

.notification.info {
    background: linear-gradient(135deg, #339af0, #228be6);
}

@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(100%);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* Field Validation States */
.field-valid {
    border-color: #51cf66 !important;
    box-shadow: 0 0 0 3px rgba(81, 207, 102, 0.1) !important;
}

.field-invalid {
    border-color: #ff6b6b !important;
    box-shadow: 0 0 0 3px rgba(255, 107, 107, 0.1) !important;
    animation: shake 0.3s ease-in-out !important;
}

/* Progress Indicator */
.progress-indicator {
    background: #e9ecef;
    border-radius: 10px;
    height: 6px;
    margin: 15px 0;
    overflow: hidden;
}

.progress-bar {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    height: 100%;
    border-radius: 10px;
    transition: width 0.3s ease;
}

/* Enhanced UI Labels */
.ui-widget {
    font-family: 'Segoe UI', sans-serif !important;
}

/* Better Visual Hierarchy */
.section-title {
    color: #495057;
    font-weight: 500;
    font-size: 13px;
    margin-bottom: 8px;
    border-left: 2px solid #dee2e6;
    padding-left: 8px;
}

/* Enhanced Hover Effects */
.table.mytable tr {
    transition: all 0.2s ease !important;
}

/* Clean focus styles */
#addProductToBill {
    outline: none !important;
    cursor: pointer !important;
}

#addProductToBill:focus {
    outline: 2px solid #007bff !important;
    outline-offset: 2px !important;
    background: #0056b3 !important;
    transform: scale(1.05) !important;
}

.btn {
    position: relative;
    overflow: hidden;
}

.btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.btn:hover::before {
    left: 100%;
}
</style>

<s:if test="productInfoList.size()>0">
<script lang="javascript" type="text/javascript"> 

 window.onload = function() {
	 
	  document.getElementById("amountPaid").focus();
	  
	};

</script>

</s:if>

<s:else>
<script lang="javascript" type="text/javascript"> 

 window.onload = function() {
	 <s:if test="#session.weight_scale_online =='TRUE'">
	 document.getElementById("start").focus();
	 </s:if>
	 <s:else>
	  document.getElementById("billDateTime").focus();
	</s:else>
	 	 
	};

</script>
</s:else>








<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.min.js"></script>



<s:if test="#session.online_weight_scale_allowed==true">

<s:if test="#session.weight_scale_online =='TRUE'">

<script lang="javascript" type="text/javascript">

window.onload = function() {
    checkAndOpenPort();
}

let serialPort;
let reader;
let writer;
let readableStreamClosed;
let writableStreamClosed;
let keepReading = false;
let currentLine = "";

// Function to check and open the port
async function checkAndOpenPort() {
    try {
        const ports = await navigator.serial.getPorts();
        
        if (ports.length > 0) {
            // If a port has been granted access before, use it
            serialPort = ports[0];
            await openPort();
        } else {
            // If no port has been granted access, ask the user to select one
            await startReading();
        }
    } catch (error) {
        alert("There was an error accessing the serial port: " + error.message);
        console.error("Error accessing the serial port: ", error);
    }
}

async function openPort() {
    // Retrieve session values as strings
    const baudRate = '<s:property value="#session.bits_per_second"/>'; // Baud rate
    const dataBits = '<s:property value="#session.data_bits"/>'; // Data bits
    const parity = '<s:property value="#session.parity"/>'.toLowerCase(); // Parity
    const stopBits = '<s:property value="#session.stop_bits"/>'; // Stop bits
    const flowControl = '<s:property value="#session.flow_control"/>'.toLowerCase(); // Flow control

    await serialPort.open({
        baudRate: parseInt(baudRate),
        dataBits: parseInt(dataBits),
        
        parity: parity.toLowerCase(),
        stopBits: parseInt(stopBits),
        flowControl: flowControl.toLowerCase()
    });

    const textDecoder = new TextDecoderStream();
    readableStreamClosed = serialPort.readable.pipeTo(textDecoder.writable);
    reader = textDecoder.readable.getReader();

    const textEncoder = new TextEncoderStream();
    writableStreamClosed = textEncoder.readable.pipeTo(serialPort.writable);
    writer = textEncoder.writable.getWriter();

    <s:if test="#session.auto_zero_mode == 'TRUE'">
        sendTareZeroCommand();
        showNotification("Weight Scale Connected Successfully & Current Weight = 0.0", "success");
        addStatusIndicator('start', true);
    </s:if>
}

async function startReading() {
    try {
        if (!("serial" in navigator)) {
            alert("Your browser does not support the Web Serial API");
            return;
        }

        // User selects the port
        serialPort = await navigator.serial.requestPort();
        await openPort();

    } catch (error) {
        alert("There was an error opening the serial port: " + error.message);
        console.error("Error opening the serial port: ", error);
    }
}

async function readLoop() {
    try {
        while (keepReading) {
            const { value, done } = await reader.read();

            if (done) {
                console.log("Stream closed");
                break;
            }

            if (value) {
                currentLine += value;
                
                if (value.includes('\n')) {
                    appendData(currentLine.trim());
                    currentLine = "";
                }
            }
        }
    } catch (error) {
        console.error("Error reading from the serial port: ", error);
        appendData("Error reading data");
    }
}

<s:if test="isFromVehicleEntryDetails || viewBill">
<s:if test="!generateBillForDc">

function appendData(data) {
    const milkInLiterElement = document.getElementById("grossWeight");
    let numericData = data.replace(/[^\d.-]/g, '');  // Remove non-numeric characters except dot and minus
    numericData = numericData.replace(/^0+(?=\d)/, '');  // Remove leading zeros
    milkInLiterElement.value = numericData;  // Set the value of the text field
}
</s:if>
</s:if>

<s:else>

function appendData(data) {
    const milkInLiterElement = document.getElementById("quantity");
    let numericData = data.replace(/[^\d.-]/g, '');  // Remove non-numeric characters except dot and minus
    numericData = numericData.replace(/^0+(?=\d)/, '');  // Remove leading zeros
    milkInLiterElement.value = numericData;  // Set the value of the text field
}

</s:else>


async function sendTareZeroCommand() {
    if (!serialPort) {
        alert("Serial port not open");
        return;
    }

    try {
        const command = ["Z"];
        await writer.write(command + "\n"); // Append newline if required by your device
        console.log("Sent TARE/ZERO command:", command);
    } catch (error) {
        alert("Error sending TARE/ZERO command: " + error.message);
        console.error("Error sending TARE/ZERO command:", error);
    }
}

async function stopReading() {
    keepReading = false;  // Stop the reading loop
    try {
        if (reader) {
            await reader.cancel();
            reader.releaseLock();
        }
        if (writer) {
            await writer.close();
            writer.releaseLock();
        }
        if (readableStreamClosed) {
            await readableStreamClosed.catch(() => {});
        }
        if (writableStreamClosed) {
            await writableStreamClosed.catch(() => {});
        }
        if (serialPort) {
            await serialPort.close();
            alert("Serial port closed");
        } else {
            alert("Serial port already closed");
        }
    } catch (error) {
        alert("Error closing the serial port: " + error.message);
        console.error("Error closing the serial port: ", error);
    }
}

function startReadLoop() {
    keepReading = true;
    currentLine = "";  // Reset currentLine to avoid partial data from previous reads
    readLoop();
}

function stopReadLoop() {
    keepReading = false;
}

</script>

</s:if>
</s:if>





<div class="main-container">
<div align="center" style="margin-top: 0px;font-size: 14px; font-weight: bold;">
		<div class="ui-widget">
		

<table class="table table-bordered mytable" style="height: 50px; width: 1200px; font-size: 14px; margin-top: 5px;">


<tr  style="font-weight: bold; background-color: rgb(234,234,234);">

<s:hidden name="viewBill" id="viewBill"/>
<td colspan="12" align="center" style="padding: 0px;">
<s:if test="viewBill=='true'">

<s:property value="getText('header.view/updateBill')" />
</s:if>
<s:else>
<s:property value="getText('header.addNewBill')" />
</s:else>
</td>
</tr>
<s:if test="hasActionErrors()" >


<tr style="height:50px; ">

<td colspan="12" align="center" style="padding: 5px;"> 

 
     
    <div class="alert alert-danger">
 	 <strong><s:property value="getText('header.error')" />! </strong>
     
      <s:iterator var="error" value="%{errorMessages}">
        <s:property value="%{error}"/>
    </s:iterator>
	</div>
      


</td>
</tr>
</s:if>
<s:if test="hasActionMessages()" >
<tr>
<td colspan="12" style="font-size: medium; color: green; padding: 5px;" align="center" >  
    
    <div class="alert alert-success">
  	<strong><s:property value="getText('header.success')" />! </strong>
   	<s:iterator var="message" value="%{actionMessages}">
        <s:property value="%{message}"/>
    </s:iterator>
    </div>
  
 


</td>
</tr>
</s:if>
</table>





    <s:if test="#session.online_weight_scale_allowed==true">
	           
<s:if test="#session.weight_scale_online =='TRUE'">

<table class="table table-bordered mytable" style="height: 50px; width: 1200px; font-size: 14px; margin-top: 5px;">



<tr align="center">

<tr align="center">


<td  colspan="4" >
                    <button onclick="startReading()" id="start" name="start" class="btn btn-danger btn-sm"><s:property value="getText('button.connectToWeightScale')" /></button>
                 
                    <button onclick="sendTareZeroCommand()" id="tareZeroButton" class="btn btn-danger btn-sm"><s:property value="getText('button.tareZero')" /></button>
                
                 <button onclick="stopReading()" id="stop" name="stop" class="btn btn-danger btn-sm"><s:property value="getText('button.disconnect')" /></button>
                
                </td>

</tr>
</table>
</s:if>
</s:if>






<s:form method="post" name="addProductToBill" action="addProductToBill" theme="simple" enctype="multipart/form-data" acceptcharset="UTF-8" >


<table class="table table-bordered mytable" style="height: 50px; width: 1200px; font-size: 14px; margin-top: 5px;">



<tr>

<td colspan="3" align="left" style="padding: 2px;"><s:property value="getText('text.lable.billDate')" /> *</td>
<td  align="left"  colspan="3" style="padding: 2px;">
<sj:datepicker displayFormat="dd-mm-yy" 
               timepicker="true" 
               name="billDateTime"
			   id="billDateTime"
			   maxDate="1"
			   changeMonth="true"
			   changeYear="true" 
			   readonly="true"
			   placeholder="Bill Date" cssClass="textBoxDate" tabindex="1" />
			   <s:hidden id="keyVehicle" name="keyVehicle" value="%{keyVehicle}"/>
			   <s:hidden id="isFromVehicleEntryDetails" name="isFromVehicleEntryDetails" value="%{isFromVehicleEntryDetails}"/>
			   <s:hidden id="viewBill" name="viewBill" value="%{viewBill}"/>
			   
 
</td>
<td style="padding: 2px;"><s:property value="getText('text.lable.billNo')" />.</td><td align="left" style="padding: 2px;"><s:textfield name="billNumber" id="billNumber" readonly="true" cssClass="textBoxSmallSmall"/> </td>
<s:if test="viewBill=='true' || productInfoList.size()>0" >
<td style="padding: 2px;"><s:property value="getText('text.lable.chalanNo')" />.*</td><td align="left" style="padding: 2px;"><s:textfield name="chalanNumber" id="chalanNumber" tabindex="2" cssClass="textBoxSmallSmall" readonly="true"/> </td>
</s:if>
<s:else>
<td style="padding: 2px;"><s:property value="getText('text.lable.chalanNo')" />.*</td><td align="left" style="padding: 2px;"><s:textfield name="chalanNumber" id="chalanNumber" tabindex="2" cssClass="textBoxSmallSmall" onselect="this.select();"  onfocus="this.select();"/> </td>
</s:else>
<td style="padding: 2px;" >
<s:property value="getText('text.lable.paymentType')" /> * 
</td>
<td style="width: 200px; font-size: 16px; padding: 2px;">
<s:radio list="paymentTypeList" name="paymentType" id="paymentType" theme="simple" value="defaultValue" tabindex="3"/>
</td>
</tr>
<tr>
</table>
<table class="table table-bordered mytable" style="height: 10px; width: 1200px; font-size: 14px; margin-top: -15px;">


<tr>
<td style="padding: 2px;">
<s:property value="getText('text.lable.billType')" /> *
</td>
<td colspan="3" style="padding: 2px;">
  <s:select list="billTypeList"  name="billType" id="billType" headerKey=""  headerValue="Select Bill Type" cssClass="selectSmall" tabindex="4"/>
</td>
<td  style="padding: 0px;">
<s:property value="getText('text.lable.rateType')" />*&nbsp;&nbsp;&nbsp;&nbsp;
<s:radio list="rateTypeList" name="rateType" id="rateType" theme="simple" value="rateTyprDefaultValue" tabindex="2"/>
</td>

<s:if test="viewBill=='true' || productInfoList.size()>0" >
<td align="right" style="padding: 2px;"><s:property value="getText('text.lable.customerName')" /> *</td><td style="padding: 2px;">
<s:textfield name="customerName" id="customerName" cssClass="textBox" readonly="true"/>

</td>
</s:if>

<s:else>

 
<td align="right" style="padding: 2px;"><s:property value="getText('text.lable.customerName')" />*</td><td style="padding: 2px;">
<s:url id="customerList" action="databaseCustomerJSON" />
<sj:autocompleter 				href="%{customerList}" 
								name="customerName" list="customerList" 
								id="customerName" 
								loadMinimumCount="1"								
								placeholder="Customer Name"		
								cssClass="textBox"					 
								tabindex="5" 
								onfocus="this.select();"/>

</td>
 </s:else>
</tr>
</table>

<table class="table table-bordered mytable" style="height: 0px; width: 1200px; margin-top: -15px;">
<tr>
<td style="padding: 2px;"><s:property value="getText('text.lable.selectVehicle')" />*</td>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td style="padding: 2px;"><s:url id="vehicleList1" action="databaseVehicleJSON" />
<sj:autocompleter 				href="%{vehicleList1}" 
								name="vehicleId" list="vehicleList" 
								id="vehicleId" 
								loadMinimumCount="1"								
								placeholder="Vehicle Details"							 
								tabindex="6" 
								cssClass="textBoxMedium"		
								onfocus="this.select();" 
								readonly="true"/>
								</td>
								</s:if>
								<s:else>
								<td style="padding: 2px;"><s:url id="vehicleList1" action="databaseVehicleJSON" />
<sj:autocompleter 				href="%{vehicleList1}" 
								name="vehicleId" list="vehicleList" 
								id="vehicleId" 
								loadMinimumCount="1"								
								placeholder="Vehicle Details"							 
								tabindex="6" 
								cssClass="textBoxMedium"		
								onfocus="this.select();"/>
								</td>
								
								</s:else>
<td style="padding: 2px;"><s:property value="getText('text.lable.kmStart')" />*

<s:textfield id="kmStart" name="kmStart" cssClass="textBox100" tabindex="7" onselect="this.select();"  onfocus="this.select();"/>
</td>
<td style="padding: 2px;"><s:property value="getText('text.lable.kmEnd')" />*
<s:textfield id="kmEnd" name="kmEnd" cssClass="textBox100" tabindex="8" onselect="this.select();"  onfocus="this.select();"/>
</td>
<td style="padding: 2px;">
<s:property value="getText('text.lable.totalKm')" />*

<s:textfield id="totalKm" name="totalKm" cssClass="textBox100" readonly="true" tabindex="9" onselect="this.select();"  onfocus="this.select();"/>
</td>
</tr>
<tr>
<td style="padding: 2px;"><s:property value="getText('text.lable.tripFrom')" />*</td>
<td style="padding: 2px;"><s:textfield id="tripFrom" name="tripFrom" cssClass="textBoxMedium" tabindex="10" onselect="this.select();"  onfocus="this.select();"/> </td>
<td style="padding: 2px;"><s:property value="getText('text.lable.tripTo')" />*</td>
<td style="padding: 2px;"><s:textfield id="tripTo" name="tripTo" cssClass="textBoxMedium" tabindex="11" onselect="this.select();"  onfocus="this.select();"/> </td>
<td style="padding: 2px;"><s:property value="getText('text.lable.totalTrips')" />*<s:textfield id="totalTrips" name="totalTrips" cssClass="textBox100" tabindex="12" onselect="this.select();"  onfocus="this.select();"/> </td>
</tr>
</table>

<table class="table table-bordered mytable" style="height: 0px; width: 1200px; margin-top: -15px;">
<tr>

<td style="padding: 2px;"><s:property value="getText('text.lable.productName')" />*</td>

<s:if test="isFromVehicleEntryDetails || viewBill">

<td style="padding: 2px;"><s:property value="getText('text.lable.vehicleEmptyWeight')" />*</td>


<td style="padding: 2px;"><s:property value="getText('text.lable.grossWeight')" />*</td>
</s:if>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td style="padding: 2px;"><s:property value="getText('text.lable.netWeight')" /><br>/<s:property value="getText('text.lable.quantity')" />*</td>
</s:if>
<s:else>

<td style="padding: 2px;"><s:property value="getText('text.lable.quantity')" />*</td>

</s:else>


<td style="padding: 2px;"><s:property value="getText('text.lable.salesRate')" />*</td>
<td style="padding: 2px;"><s:property value="getText('text.lable.amount')" /> *</td>
<td style="padding: 2px;"><s:property value="getText('text.lable.discountType')" /> *</td>
<td style="padding: 2px;"><s:property value="getText('text.lable.disAmount')" /></td>

<td style="padding: 2px;"><s:property value="getText('text.lable.amt.aft.dis')" /> *</td>
<s:if test="#session.royaltyAllowed == 1">
 
<td style="padding: 2px;"><s:property value="getText('text.lable.royalty')" /> </td>
</s:if>
<td style="padding: 2px;"><s:property value="getText('text.lable.transportationCharges')" /></td>

<td rowspan="2" align="center" style="padding: 8px; vertical-align: middle;">
 <button  type='submit' name='addProductToBill' class='btn btn-primary btn-sm' id="addProductToBill"  name="addProductToBill" tabindex="20" style="margin: 0; white-space: nowrap;">+ <s:property value="getText('button.addProductToBill')" /></button>
</td>

</tr>
<tr>

<s:if test="isFromVehicleEntryDetails || viewBill">

 <s:if test="generateBillForDc">
  
<td style="padding: 2px;">
<s:url id="productList" action="databaseProductJSON" />
<sj:autocompleter 				href="%{productList}" 
								name="productName" list="productList" 
								id="productName" 
								loadMinimumCount="2"	 readonly="true"							
								placeholder="Product Name" cssClass="textBoxSmall" tabindex="13"  onfocus="this.select();"/>
</td>
</s:if>

<s:else>

<td style="padding: 2px;">
<s:url id="productList" action="databaseProductJSON" />
<sj:autocompleter 				href="%{productList}" 
								name="productName" list="productList" 
								id="productName" 
								loadMinimumCount="2"	 							
								placeholder="Product Name" cssClass="textBoxSmall" tabindex="13"  onfocus="this.select();"/>
</td>

</s:else>


</s:if>
<s:else>


<td style="padding: 2px;">
<s:url id="productList" action="databaseProductJSON" />
<sj:autocompleter 				href="%{productList}" 
								name="productName" list="productList" 
								id="productName" 
								loadMinimumCount="2"								
								placeholder="Product Name" cssClass="textBoxSmall" tabindex="13"  onfocus="this.select();"/>
</td>


</s:else>

<s:if test="isFromVehicleEntryDetails || viewBill">

<td style="padding: 2px;">

<s:textfield name="vehicleEmptyWeight" id="vehicleEmptyWeight" cssClass="textBoxSmallSmall" tabindex="14"  readonly="true"/>
</td> 
 




<td style="padding: 2px;">



<s:if test="#session.online_weight_scale_allowed==true">
<s:if test="#session.weight_scale_online =='TRUE'">

<s:if test="generateBillForDc">
  
<s:textfield name="grossWeight" id="grossWeight" cssClass="textBoxSmallSmall" tabindex="14"  readonly="true" />
 </s:if>
 <s:else>
 
 <s:textfield name="grossWeight" id="grossWeight" cssClass="textBoxSmallSmall" tabindex="14"  readonly="true" oninput="calculateNetWeight()"/>
 
 </s:else>
 
 
 
</s:if>
<s:else>


<s:if test="generateBillForDc">
  
<s:textfield name="grossWeight" id="grossWeight" cssClass="textBoxSmallSmall" tabindex="14"  readonly="true" />
 </s:if>
 <s:else>
<s:textfield name="grossWeight" id="grossWeight" cssClass="textBoxSmallSmall" tabindex="14" oninput="calculateNetWeight()"/>
</s:else>



</s:else>
</s:if>
<s:else>
<s:textfield name="grossWeight" id="grossWeight" cssClass="textBoxSmallSmall" tabindex="14" oninput="calculateNetWeight()"/>

</s:else>	



</td>
</s:if>



<s:if test="isFromVehicleEntryDetails || viewBill">

<td style="padding: 2px;">

<s:textfield name="quantity" id="quantity" cssClass="textBoxSmallSmall" tabindex="14" />
</td> 
</s:if>
<s:else>

<td style="padding: 2px;">
<s:if test="#session.online_weight_scale_allowed==true">
<s:if test="#session.weight_scale_online =='TRUE'">
<s:textfield name="quantity" id="quantity" cssClass="textBoxSmallSmall" tabindex="14"  readonly="true" />
 
</s:if>
<s:else>
<s:textfield name="quantity" id="quantity" cssClass="textBoxSmallSmall" tabindex="14" />

</s:else>
</s:if>
<s:else>
<s:textfield name="quantity" id="quantity" cssClass="textBoxSmallSmall" tabindex="14" />

</s:else>	

</td>
</s:else>

 
 
<td style="padding: 2px;">
<s:textfield name="salesRate" id="salesRate" cssClass="textBoxSmallSmall" tabindex="15"/>
</td>
<td style="padding: 2px;">
<s:textfield name="amount" id="amount" readonly="true" cssClass="textBoxSmallSmall" />
</td>
<td style="padding: 2px;">
<s:select list="discountTypeList" name= "discountType" id="discountType" headerKey="" cssClass="selectSmall" tabindex="16"/>
</td>

<td style="padding: 2px;">
<s:textfield name="discountRupees"  id="discountRupees" value="0" tabindex="17" cssClass="textBoxSmallSmall"/>
</td>


<td style="padding: 2px;">
<s:textfield name="amountAfterDiscount" id="amountAfterDiscount" readonly="true" cssClass="textBoxSmallSmall" />
</td>
<s:if test="#session.royaltyAllowed == 1">
 
<td style="padding: 2px;">
<s:textfield name="royalty"  id="royalty" tabindex="17" cssClass="textBoxSmallSmall"/>
</td>
</s:if>
<td style="padding: 2px;">
<s:if test="viewBill=='true' || productInfoList.size()>0" >

<s:textfield name="transportCharge" id = "transportCharge" cssClass="textBoxSmall" 
tabindex="10" onfocus="this.select();" onclick="this.select();"/> 
</s:if>
<s:else>
<s:textfield name="transportCharge" id = "transportCharge" value="0" cssClass="textBoxSmallSmall" tabindex="18"/> 
</s:else>
</td>
</tr>

</table>
<table class="table table-bordered mytable" style="height: 50px; width: 1200px; margin-top: -15px;">
<tr>
<td style="padding: 2px;"><s:property value="getText('text.lable.salesUnit')" /> *</td>
<td align="left" style="padding: 2px;"><s:property value="getText('text.lable.selectTax')" /> % *</td>
<s:if test="productInfoList.size()>0">
<td  style="padding: 2px;"><s:property value="getText('text.lable.alternateMobileNo')" />&nbsp;&nbsp;</td><td><s:textfield name="alternateMobileNumber" id="alternateMobileNumber" readonly="true" cssClass="textBoxSize10"/> </td>
</s:if>
<s:else>
<td style="padding: 2px;"><s:property value="getText('text.lable.alternateMobileNo')" />&nbsp;&nbsp;</<td><s:textfield name="alternateMobileNumber" id="alternateMobileNumber" cssClass="textBoxSize10"/> </td>
</s:else>

<td style="padding: 2px;"><s:checkbox name="sendSMS" id="sendSMS" tabindex="18"><s:property value="getText('text.lable.sendSms')" /> &nbsp;&nbsp;</s:checkbox> </td>

</tr>

<tr>
<td style="padding: 2px;">
  <s:select list="unitList"  name="salesUnit" id="salesUnit" headerKey=""  headerValue="Select Sales Unit" cssClass="selectSmall" />
</td>
<td style="padding: 2px;">

<s:select list="taxList" name= "taxPercentage" id="taxPercentage" headerKey="" headerValue="TAX Percentage" cssClass="selectSmall"/>
</td>


<!-- 
<td>


Product Alias *
</td>
<td>
<s:textfield name="alias" id="alias" tabindex="3" cssClass="textBoxSmallSmall" onfocus="this.select();"/>
</td>
 -->
<!-- 
<td>
Marathi Name * 
</td>
<td>
<s:textfield name="productMarathiName" 
			id="productMarathiName" 
			readonly="true" 
			placeholder="Marathi Name" 
			tabindex="5"
			cssClass="textBoxSmall"/>
</td>
 -->
 <s:hidden name="productMarathiName" id="productMarathiName"/>

<td colspan="2"><s:property value="getText('text.lable.comments')" /> &nbsp;&nbsp;&nbsp;<s:textarea cols="20" rows="1" id="comments" name="comments" value="NA"  tabindex="19" onfocus="this.select();" onselect="this.select();"/></td>

</tr>
<tr>


</tr>
</table>

<table class="table table-bordered" style="height: 50px; width: 1200px; margin-top: -15px;">

<tr>

<!-- RealLinkBillingPrintHandler -->
</tr>
</table>

<s:hidden id="discountPercentage" name="discountPercentage"/>
<!--
<table class="table table-bordered" style="height: 50px; width: 1100px; margin-top: -20px;">
<tr>
 
<td>
Discount %
</td>
<td>
<s:textfield name="discountPercentage"  id="discountPercentage" value="0" tabindex="10" cssClass="textBoxSmallSmall"/>
</td>


</tr>  
</table>
-->
</s:form>


<s:if test="productInfoList.size()>0">

<s:if test="billType=='CASH-MEMO'">

<table class="table .table-striped mytable" style="height: 50px; width: 1200px;">

<tr>
<td colspan="16" align="center" style="font-weight: bold; font-size: 16px;"><s:property value="getText('text.lable.totalItems')" />:<s:property value="%{productInfoList.size()}"/> </td>
</tr>
<tr style="font-weight: bold; font-size: 14px;">
<td><s:property value="getText('text.lable.date')" /></td>
<td><s:property value="getText('text.lable.chalanNo')" /></td>
<td><s:property value="getText('text.lable.paymentType')" /></td>
<td><s:property value="getText('text.lable.productName')" /></td>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td><s:property value="getText('text.lable.vehicleEmptyWeight')" /></td>


<td><s:property value="getText('text.lable.grossWeight')" />.</td>
</s:if>

<td><s:property value="getText('text.lable.quantity')" /></td>

<td><s:property value="getText('text.lable.rate')" /></td>
<td><s:property value="getText('text.lable.salesUnit')" /></td>
<td ><s:property value="getText('text.lable.discountType')" /> *</td>
<td><s:property value="getText('text.lable.totatlDisRs')" /></td>
<s:if test="#session.royaltyAllowed == 1">
 
<td><s:property value="getText('text.lable.royalty')" /></td>
</s:if>

<td><s:property value="getText('text.lable.amount')" /></td>
<td><s:property value="getText('text.lable.amt.aft.dis')" /></td>
<td align="center"><s:property value="getText('button.delete/edit')" /></td>
</tr>
<s:iterator  value="productInfoList" > 


<tr>
<td><s:property value="billDateTime"/></td>
<td><s:property value="chalanNumber"/></td>
<td><s:property value="paymentType"/></td>
<td><s:property value="productName"/></td>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td><s:property value="vehicleEmptyWeight"/></td>


<td><s:property value="grossWeight"/></td>
</s:if>
<td><s:property value="quantity"/></td>

<td><s:property value="salesRate"/></td>
<td><s:property value="salesUnit"/></td>
<td><s:property value="discountType"/></td>
<td><s:property value="productTotalDiscount"/></td>
<s:if test="#session.royaltyAllowed == 1">
 
<td><s:property value="royalty"/></td>
</s:if>


<td><s:property value="amount"/></td>
<td><s:property value="amountAfterDiscount"/></td>
<td align="center">
<s:url var="deleteEditProduct" action="deleteEditProductFromList">
  <s:param name="productNameForDelete"><s:property value="productName"/></s:param>
  <s:param name="keyVehicle"><s:property value="keyVehicle"/></s:param>
  <s:param name="isFromVehicleEntryDetails"><s:property value="isFromVehicleEntryDetails"/></s:param>
  <s:param name="viewBill"><s:property value="viewBill"/></s:param>
  <s:param name="generateBillForDc"><s:property value="generateBillForDc"/></s:param>
 	
</s:url>
<a href="${deleteEditProduct}"><button type="button" class="btn btn-danger"><s:property value="getText('button.delete/edit')" /></button></a> 
</td>

</tr>
</s:iterator>
</table>

</s:if>

<s:if test="billType=='BILL-OF-SUPPLY'">

<table class="table .table-striped mytable" style="height: 50px; width: 1200px;">

<tr>
<td colspan="16" align="center" style="font-weight: bold; font-size: 14px;"><s:property value="getText('text.lable.totalItems')" />:<s:property value="%{productInfoList.size()}"/> </td>
</tr>
<tr style="font-weight: bold; font-size: 14px;">
<td><s:property value="getText('text.lable.date')" /></td>
<td><s:property value="getText('text.lable.chalanNo')" /></td>
<td><s:property value="getText('text.lable.paymentType')" /></td>
<td><s:property value="getText('text.lable.productName')" /></td>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td><s:property value="getText('text.lable.vehicleEmptyWeight')" /></td>


<td><s:property value="getText('text.lable.grossWeight')" /></td>
</s:if>
<td><s:property value="getText('text.lable.quantity')" /></td>

<td><s:property value="getText('text.lable.rate')" /></td>
<td><s:property value="getText('text.lable.salesUnit')" /></td>
<td ><s:property value="getText('text.lable.discountType')" /> *</td>
<td><s:property value="getText('text.lable.totatlDisRs')" /></td>

<td><s:property value="getText('text.lable.amount')" /></td>
<td><s:property value="getText('text.lable.amt.aft.dis')" /></td>

<s:if test="#session.royaltyAllowed == 1">
 
<td><s:property value="getText('text.lable.royalty')" /></td>
</s:if>


<td align="center"><s:property value="getText('button.delete/edit')" /></td>
</tr>
<s:iterator  value="productInfoList" > 


<tr>
<td><s:property value="billDateTime"/></td>
<td><s:property value="chalanNumber"/></td>
<td><s:property value="paymentType"/></td>
<td><s:property value="productName"/></td>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td><s:property value="vehicleEmptyWeight"/></td>


<td><s:property value="grossWeight"/></td>
</s:if>
<td><s:property value="quantity"/></td>

<td><s:property value="salesRate"/></td>
<td><s:property value="salesUnit"/></td>
<td ><s:property value="discountType"/></td>
<td><s:property value="productTotalDiscount"/></td>


<!-- <td><s:property value="sgst"/></td>
<td><s:property value="cgst"/></td>
<td><s:property value="igst"/></td>-->
<td><s:property value="grossAmount"/></td> 

<td><s:property value="amountAfterDiscount"/></td>
<s:if test="#session.royaltyAllowed == 1">
 
 <td><s:property value="royalty"/></td>
 
 </s:if>
<td align="center">
<s:url var="deleteEditProduct" action="deleteEditProductFromList">
  <s:param name="productNameForDelete"><s:property value="productName"/></s:param>
  <s:param name="keyVehicle"><s:property value="keyVehicle"/></s:param>
  <s:param name="isFromVehicleEntryDetails"><s:property value="isFromVehicleEntryDetails"/></s:param>
  <s:param name="viewBill"><s:property value="viewBill"/></s:param>
 	<s:param name="generateBillForDc"><s:property value="generateBillForDc"/></s:param>
 	
</s:url>
<a href="${deleteEditProduct}"><button type="button" class="btn btn-danger"><s:property value="getText('button.delete/edit')" /></button></a> 
</td>

</tr>
</s:iterator>
</table>

</s:if>

<s:if test="billType=='TAX-INVOICE'">

<table class="table .table-striped mytable" style="height: 50px; width: 1200px;">

<tr>
<td colspan="16" align="center" style="font-weight: bold; font-size: 14px;"><s:property value="getText('text.lable.totalItems')" />:<s:property value="%{productInfoList.size()}"/> </td>
</tr>
<tr style="font-weight: bold; font-size: 14px;">

<td><s:property value="getText('text.lable.date')" /></td>
<td><s:property value="getText('text.lable.chalanNo')" /></td>
<td><s:property value="getText('text.lable.paymentType')" /></td>
<td><s:property value="getText('text.lable.productName')" /></td>
<s:if test="isFromVehicleEntryDetails || viewBill">

<td><s:property value="getText('text.lable.vehicleEmptyWeight')" /></td>




<td><s:property value="getText('text.lable.grossWeight')" /></td>
</s:if>


<td><s:property value="getText('text.lable.quantity')" /></td>

<td><s:property value="getText('text.lable.salesUnit')" /></td>
<td><s:property value="getText('text.lable.rate')" /></td>
<td><s:property value="getText('text.lable.tax')" />%</td>
<td>SGST</td>
<td>CGST</td>
<td>IGST</td>
<td><s:property value="getText('text.lable.netAmount')" /></td>
<td><s:property value="getText('text.lable.grossAmount')" /></td>
<td align="center"><s:property value="getText('button.delete/edit')" /></td>
</tr>
<s:iterator  value="productInfoList" > 


<tr>
<td><s:property value="billDateTime"/></td>
<td><s:property value="chalanNumber"/></td>
<td><s:property value="paymentType"/></td>
<td><s:property value="productName"/></td>
<s:if test="isFromVehicleEntryDetails || viewBill">


<td><s:property value="vehicleEmptyWeight"/></td>

<td><s:property value="grossWeight"/></td>
</s:if>
<td><s:property value="quantity"/></td>


<td><s:property value="salesUnit"/></td>
<td><s:property value="salesRate"/></td>
<td><s:property value="taxPercentage"/></td>
<td><s:property value="sgst"/></td>
<td><s:property value="cgst"/></td>
<td><s:property value="igst"/></td>
<td><s:property value="grossAmount"/></td>
<td><s:property value="amountAfterDiscount"/></td>
<td align="center">
<s:url var="deleteEditProduct" action="deleteEditProductFromList">
  <s:param name="productNameForDelete"><s:property value="productName"/></s:param>
  <s:param name="viewBill"><s:property value="viewBill"/></s:param>
  <s:param name="keyVehicle"><s:property value="keyVehicle"/></s:param>
  <s:param name="isFromVehicleEntryDetails"><s:property value="isFromVehicleEntryDetails"/></s:param>
  <s:param name="generateBillForDc"><s:property value="generateBillForDc"/></s:param>
 	
</s:url>
<a href="${deleteEditProduct}"><button type="button" class="btn btn-danger"><s:property value="getText('button.delete/edit')" /></button></a> 
</td>
</tr>
</s:iterator>
</table>

</s:if>

<s:form method="post" name="saveAndPrint" action="saveAndPrint" theme="simple" enctype="multipart/form-data" acceptcharset="UTF-8" >

<table class="table .table-striped mytable"  style="height: 50px; width: 1200px; font-size: 16px; font-weight: bold;">

<tr>
<td align="left" style="font-size: 14px;">
<s:hidden name="totalAmount" id="totalAmount"/>
<s:hidden id="keyVehicle" name="keyVehicle" value="%{keyVehicle}"/>
 <s:hidden id="isFromVehicleEntryDetails" name="isFromVehicleEntryDetails" value="%{isFromVehicleEntryDetails}"/>
 <s:hidden id="viewBill" name="viewBill" value="%{viewBill}"/>
			  
<s:property value="getText('text.lable.totalBillAmount')" /> : <s:property value="totalAmount"/>
</td>
<td style="font-size: 14px;">
<s:property value="getText('text.lable.totalPayableAmount')" />:
</td>
<td style="font-size: 14px;"><s:textfield name="totalPaybleAmount" id="totalPaybleAmount" cssClass="textBoxSmall" readonly="true"/> </td>
<td style="font-size: 14px;">
<s:property value="getText('text.lable.totalAmountPaid')" />:
</td>
<td style="font-size: 14px;"><s:textfield name="amountPaid" id="amountPaid" cssClass="textBoxSmall" tabindex="21"/> </td>

</tr>


<tr >

<td style="font-size: 14px;"><s:property value="getText('text.lable.selectAccountForEntry')" />1*
</td>
<td style="font-size: 14px;">
<s:select list="accountList" name="accountId1" id="accountId1" cssClass="select"></s:select>
</td>

<td style="font-size: 14px;"><s:property value="getText('text.lable.modeOfPayment')" />1*<s:select list="paymentTypeList2" id="modeOfPayment1" name="modeOfPayment1" cssClass="select"/> 
</td>
<td style="font-size: 14px;">
<s:property value="getText('text.lable.totalAmountPaid')" />1:
</td>
<td style="font-size: 14px;"><s:textfield name="amountPaid1" id="amountPaid1" cssClass="textBoxSmall" tabindex="21"/> </td>
</tr>


<tr>

<td style="font-size: 14px;"><s:property value="getText('text.lable.selectAccountForEntry')" />2*
</td>
<td style="font-size: 14px;">
<s:select list="accountList" name="accountId2" id="accountId2" cssClass="select"></s:select>
</td>

<td style="font-size: 14px;"><s:property value="getText('text.lable.modeOfPayment')" />2*<s:select list="paymentTypeList2" id="modeOfPayment2" name="modeOfPayment2" cssClass="select"/> </td>

<td style="font-size: 14px;">
<s:property value="getText('text.lable.totalAmountPaid')" />2:
</td>
<td style="font-size: 14px;"><s:textfield name="amountPaid2" id="amountPaid2" cssClass="textBoxSmall" tabindex="22" /> </td>
</tr>

<tr>
<td ></td>
<td ></td>
<td ></td>
<td style="font-size: 14px;">
<s:property value="getText('text.lable.amountReturn')" />:
</td>
<td><s:textfield name="returnAmount" id="returnAmount" cssClass="textBoxSmall" readonly="true"/> </td>




 
 </tr>
</table>


 
 
 <s:if test="displayDCPhotos">
 
 <table class="table table-striped" style="height: 10px; width:1200px; margin-top: 0px; font-size: 14px;">
<tr>
<td><s:property value="getText('text.lable.vehicleImage1')" /></td>
<td><s:property value="getText('text.lable.vehicleImage2')" /></td>
<td><s:property value="getText('text.lable.vehicleImage3')" /></td>
</tr>
<tr>

<td><div ><img width="150" height="100" alt="IMAGE NOT AVAILABLE" src="vehicleImage1PDF.action?id=<s:property value="chalanNumber"/>"></div></td>
 <td><div ><img width="150" height="100" alt="IMAGE NOT AVAILABLE" src="vehicleImage2PDF.action?id=<s:property value="chalanNumber"/>"></div></td>
<td><div ><img width="150" height="100" alt="IMAGE NOT AVAILABLE" src="vehicleImage3PDF.action?id=<s:property value="chalanNumber"/>"></div></td>


</tr>
</table>
</s:if>





<table class="table .table-striped mytable" style="height: 50px; width: 1100px; font-size: 20px; font-weight: bold;">

<tr>

<td align="center">


<%-- <s:if test="viewBill=='true'">

</s:if>
<s:else>
<button type="submit" class="btn btn-primary sm" tabindex="22">SAVE</button>

</s:else> --%>


<s:if test="billSaved">

</s:if>

<s:else>

<td align="center">

<button type="submit" class="btn btn-primary sm" tabindex="23"><s:property value="getText('button.save')" /></button>
</td>
</s:else>


</td> 
<td align="center">

<s:if test="billSaved">
<s:url var="printBill" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A4</s:param>
<s:param name="lang">eng</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>
</s:url>

<s:url var="printBilla5" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A5</s:param>
<s:param name="lang">eng</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>

</s:url>
<!-- 
<s:url var="printBilla5Mar" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A5</s:param>
<s:param name="lang">mar</s:param>
</s:url>
 -->
 
 <s:url var="printBilla5Mar" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A5</s:param>
<s:param name="lang">mar</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>
</s:url>

<s:url var="printBillThermal" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">tharmal</s:param>
<s:param name="lang">eng</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>
</s:url>


<a href="${printBilla5Mar}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="24"><s:property value="getText('button.printA5Marathi')" /></button></a>
<a href="${printBill}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="25"><s:property value="getText('button.printA4English')" /></button></a>
<a href="${printBilla5}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="26"><s:property value="getText('button.printA5English')" /></button></a>
<a href="${printBillThermal}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="27"><s:property value="getText('button.printThermal')" /></button></a>

</s:if>
<%-- <s:if test="viewBill=='true'">
<s:url var="printBill" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A4</s:param>
<s:param name="lang">eng</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>
</s:url>

<s:url var="printBilla5" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A5</s:param>
<s:param name="lang">eng</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>
</s:url>

<s:url var="printBilla5Mar" action="printBill">
<s:param name="billNumber"><s:property value="billNumber"/></s:param>
<s:param name="size">A5</s:param>
<s:param name="lang">mar</s:param>
<s:param name="billType"><s:property value="billType"/></s:param>
</s:url>

<a href="${printBilla5Mar}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="23">PRINT A5 MARATHI</button></a>

<a href="${printBill}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="24">PRINT A4</button></a>
<a href="${printBilla5}" target="_blank" ><button type='button' class='btn btn-primary' tabindex="25">PRINT A5 ENGLISH</button></a>

</s:if> --%>
</td>

<td  style="padding: 2px;">
<s:if test="billSaved">
<a href="addBillJsp"><img alt="" height="30px" width="30px" src="buttons/add.png"/><button type='button' class='btn btn-primary' accesskey="b">Add New <u>B</u>ill</button></a>
</s:if>
</td>

</tr>




 
</table>
</s:form>
</s:if>

</div>
</div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" class="loading-overlay" style="display: none;">
    <div class="loading-spinner">
        Processing your request...
    </div>
</div>

<!-- Enhanced JavaScript for Better UX -->
<script>
// Enhanced UI/UX JavaScript Functions
function showLoading(message = 'Processing...') {
    const overlay = document.getElementById('loadingOverlay');
    const spinner = overlay.querySelector('.loading-spinner');
    spinner.textContent = message;
    overlay.style.display = 'flex';
}

function hideLoading() {
    const overlay = document.getElementById('loadingOverlay');
    overlay.style.display = 'none';
}

function showNotification(message, type = 'info') {
    // Remove existing notifications
    const existingNotifications = document.querySelectorAll('.notification');
    existingNotifications.forEach(notification => notification.remove());
    
    const notification = document.createElement('div');
    notification.className = `notification ${type}`;
    notification.textContent = message;
    document.body.appendChild(notification);
    
    // Auto remove after 4 seconds
    setTimeout(() => {
        if (notification.parentNode) {
            notification.style.animation = 'slideOutRight 0.3s ease-in';
            setTimeout(() => notification.remove(), 300);
        }
    }, 4000);
}

function validateField(field, isValid) {
    field.classList.remove('field-valid', 'field-invalid');
    if (field.value.trim() !== '') {
        field.classList.add(isValid ? 'field-valid' : 'field-invalid');
    }
}

function addStatusIndicator(buttonId, connected = false) {
    const button = document.getElementById(buttonId);
    if (button) {
        const indicator = document.createElement('span');
        indicator.className = `status-indicator ${connected ? 'status-connected' : 'status-disconnected'}`;
        button.insertBefore(indicator, button.firstChild);
    }
}

// AJAX functionality preserved from original code

// Basic initialization - no conflicts with existing AJAX
$(document).ready(function() {
    console.log('UI enhancements loaded');
});

// Keep original AJAX functionality intact - no overrides

// Original functionality preserved - no additional event handlers
</script>

<style>
@keyframes slideOutRight {
    from {
        opacity: 1;
        transform: translateX(0);
    }
    to {
        opacity: 0;
        transform: translateX(100%);
    }
}
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
var $j = jQuery.noConflict(true); // Ensure jQuery doesn't conflict

$j(document).ready(function(){
    var defaultTaxOptions = $j("#taxPercentage").html();

    $j("#billType").change(function(){
        var selectedBillType = $j(this).val();
        $j("#taxPercentage").empty();

        if (selectedBillType === "TAX-INVOICE") {
            $j("#taxPercentage").append('<option value="5">GST-5</option>');
        }

        $j("#taxPercentage").append(defaultTaxOptions);
    });
});
</script>


<s:if test="%{isFromVehicleEntryDetails || viewBill}">

<script>
function calculateNetWeight() {
    var quantity = parseFloat(document.getElementById("grossWeight").value.replace(',', '.')) || 0;
    var vehicleEmptyWeight = parseFloat(document.getElementById("vehicleEmptyWeight").value.replace(',', '.')) || 0;
    
    var netWeight = quantity - vehicleEmptyWeight;
    
    document.getElementById("quantity").value = netWeight.toFixed(2); 
}


function updateNetWeightContinuously() {
    calculateNetWeight();
    requestAnimationFrame(updateNetWeightContinuously);
}


requestAnimationFrame(updateNetWeightContinuously);
</script>
</s:if>


<script type="text/javascript">


$(document).ready(function () 
{
	
	jQuery.noConflict();(function( $ ) {
		
		
		

		

	<s:if test="#session.weight_scale_online =='TRUE'">
	    <s:if test="isFromVehicleEntryDetails || viewBill">
	        $('#grossWeight').focus(function () {
	            startReadLoop();
	        });

	        $('#grossWeight').focusout(function () {
	            stopReadLoop();
	        });
	    </s:if>
	    <s:else>
	        $('#quantity').focus(function () {
	            startReadLoop();
	        });

	        $('#quantity').focusout(function () {
	            stopReadLoop();
	        });
	    </s:else>
	</s:if>


	
	$('#billDateTime').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#customerName').focus();
			    }
			});
	$('#customerName').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#vehicleId').focus();
			    }
			});
	$('#vehicleId').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#kmStart').focus();
			    }
			});
	$('#kmStart').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#kmEnd').focus();
			    }
			});
	$('#kmEnd').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#totalKm').focus();
			    }
			});
	$('#totalKm').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#tripFrom').focus();
			    }
			});
	$('#tripFrom').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#tripTo').focus();
			    }
			});
	$('#tripTo').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#totalTrips').focus();
			    }
			});
	$('#totalTrips').keypress(function (e) 
			{
			    if (e.which == 13) {
			        e.preventDefault();            
			        $('#productName').focus();
			    }
			});


	

	<s:if test="#session.weight_scale_online =='TRUE'">
    $('#start').keypress(function (e) {
        if (e.which == 13) {
            e.preventDefault();            
            $('#billDateTime').focus();
        }
    });

    $('#productName').keypress(function (e) {
        if (e.which == 13) {
            e.preventDefault();            
            <s:if test="isFromVehicleEntryDetails || viewBill">
                $('#grossWeight').focus();
            </s:if>
            <s:else>
                $('#quantity').focus();
            </s:else>
        }
    });
</s:if>

<s:else>								
    $('#productName').keypress(function (e) {
        if (e.which == 13) {
            e.preventDefault();            
            <s:if test="isFromVehicleEntryDetails || viewBill">
                $('#grossWeight').focus();
            </s:if>
            <s:else>
                $('#quantity').focus();
            </s:else>
        }
    });
</s:else>
	
	
		
$('#quantity').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#salesRate').focus();
		    }
		});
$('#salesRate').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#discountType').focus();
		    }
		});
		
$('#discountType').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#discountRupees').focus();
		    }
		});
		
$('#discountRupees').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        // Check if royalty field exists and is visible
		        if ($('#royalty').length && $('#royalty').is(':visible')) {
		            $('#royalty').focus();
		        } else {
		            $('#transportCharge').focus();
		        }
		    }
		});
$('#transportCharge').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#comments').focus();
		    }
		});
$('#comments').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#addProductToBill').focus();
		    }
		});

// Add navigation from Royalty to Transport Charges
$('#royalty').keypress(function (e) 
		{
		    if (e.which == 13) {
		        e.preventDefault();            
		        $('#transportCharge').focus();
		    }
		});

$('#productName').focusout(function(){
    // Make the ajax request
    $.ajax({
        url: 'getAliasFullName',
        data: "aliasValue=" + $(this).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object            
            $('#productName').val(data.fullName);
            $('#productMarathiName').val(data.fullNameMarathi);
            $('#salesUnit').val(data.salesUnit);
            $('#taxPercentage').val(data.tax);
            $('#salesRate').val(data.salesRate);
        }
		
    });
});

/*
$('#productName').change(function(){
    // Make the ajax request
    $.ajax({
        url: 'getMarathiName',
        data: "productName=" + $(this).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object            
           
            $('#productMarathiName').val(data.fullNameMarathi);
            $('#alias').val(data.alias);
            $('#salesUnit').val(data.salesUnit);
            $('#taxPercentage').val(data.tax);
            $('#salesRate').val(data.salesRate);
            
        }
   
   		
    });
});*/

$('#salesRate').focusout(function(){
    // Make the ajax request
    $.ajax({
        url: 'getAmount',
        data: "salesRate=" + $(salesRate).val()+"&quantity=" + $(quantity).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object           
            $('#amount').val(data.amount);         
        }
    });
});
/*
$('#discountPercentage').focusout(function(){
    // Make the ajax request
    $.ajax({
        url: 'getAmount',
        data: "salesRate=" + $(salesRate).val()+"&quantity=" + $(quantity).val()+"&discountPercentage=" + $(discountPercentage).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object           
            $('#amountAfterDiscount').val(data.amount);         
        }  ,
  		 error:  function(){ 
  			 alert("Please provide correct value!");
  			$('#salesRate').focus();
  		 
  		 }
    });
});
*/


	$('#discountRupees').focusout(function () {


    // Fetch input values
    var salesRate = $('#salesRate').val();
    var quantity = $('#quantity').val();
    var discountRupees = $('#discountRupees').val();
    var discountType = $('#discountType').val();
   
    // Check session value for royaltyAllowed
    if ('<s:property value="#session.royaltyAllowed" />' == '1') {
        // Make the AJAX request including royalty
        $.ajax({
            url: 'getAmountAfterRsDiscount',
            data: {
                salesRate: salesRate,
                quantity: quantity,
                discountRupees: discountRupees,
                discountType: discountType,
            },
            dataType: 'json',
            success: function (data) {
                // Set the inputs from the JSON object
                $('#amountAfterDiscount').val(data.amount);
                $('#discountPercentage').val('0');
            },
            error: function () {
                alert('Please provide correct values!');
            },
        });
    } else {
        // Make the AJAX request excluding royalty
        $.ajax({
            url: 'getAmountAfterRsDiscount',
            data: {
                salesRate: salesRate,
                quantity: quantity,
                discountRupees: discountRupees,
                discountType: discountType,
            },
            dataType: 'json',
            success: function (data) {
                // Set the inputs from the JSON object
                $('#amountAfterDiscount').val(data.amount);
                $('#discountPercentage').val('0');
            },
            error: function () {
                alert('Please provide correct values!');
            },
        });
    }
});





$('#amountPaid').focusout(function(){
    // Make the ajax request
    $.ajax({
        url: 'getAmountReturn',
        data: "totalPaybleAmount=" + $(totalPaybleAmount).val()+"&amountPaid=" + $(amountPaid).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object            
           
        	 $('#returnAmount').val(data.returnAmount); 
        	
            
        } 
    });
});

$('#vehicleId').focusout(function(){
    // Make the ajax request
    $.ajax({
        url: 'getVehicleBrassCapacity',
        data: "vehicleId=" + $(vehicleId).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object            
           
        	 $('#quantity').val(data.quantity); 
        	
            
        } 
    });
});
/*
$('#chalanNumber').focusout(function(){
    // Make the ajax request
    $.ajax({
        url: 'checkDuplicateChalanNumber',
        data: "chalanNumber=" + $(chalanNumber).val(),
        dataType: "json",
        success: function(data) {    
            // Set the inputs from the json object   
        
         	  if(data.alreadyAdded)
        	   {
        	 	  alert("This chalan number is already added!");
        	 	 $('#chalanNumber').val("");
        	 	 $('#chalanNumber').focus();
        	   }
        	
            
        } 
    });
});
*/
$( function() {
    $( "#taxPercentage" ).selectmenu();  
  } );
  
$( function() {
    $( "#salsUnit" ).selectmenu();   
  } );
  
  


$('#kmEnd').focusout(function(){
	
	var kmS = $('#kmStart').val();
	var kmE = $('#kmEnd').val();
	
	var kmT = kmE - kmS;
	$('#totalKm').val(kmT);
	
});













	})( jQuery );

	
	  
});
  
</script>
