package com.stonecrusher.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.struts2.dispatcher.SessionMap;

public class MaintainCloseingBalUtil {

	
	public static boolean maintainCloseingBal(String accountId, String entryType, String entryDate, Float amount,String entryBy, Connection connection, SessionMap<String, Object> sessionMap)
	{
		boolean entryAddedUpdated = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
		
		
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
	
		java.util.Date date = new java.util.Date();
	      long t = date.getTime();	        	     
	      java.sql.Time time = new java.sql.Time(t);
		try
		{
			boolean isEntryAddedForDate = false;
			float thatDateClosingBal = 0.0F;
			
			sql = "SELECT "
					+ "closeing_bal_amount "
					+ "FROM "
					+ "datewise_closing_balance "
					+ "WHERE "
					+ "closeing_bal_date = STR_TO_DATE(?,'%d-%m-%Y') "
					+ "AND "
					+ "account_id = ? "
					+ "AND "
    				+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
			
			preparedStatement = connection.prepareStatement(sql);
			
			preparedStatement.setString(1, entryDate);
			preparedStatement.setString(2, accountId);
			preparedStatement.setString(3, crusherId);
			preparedStatement.setString(4, crusherCode);
			
			
			resultSet = preparedStatement.executeQuery();
			if(resultSet.next())
			{
				thatDateClosingBal = resultSet.getFloat(1);
				isEntryAddedForDate = true;
			}
			
			
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(preparedStatement != null)
			{
				preparedStatement.close();
				preparedStatement = null;
			}
			
			int rowUpdated = 0;
			
			if(isEntryAddedForDate)
			{	
				
				float newClosingBalForThatDate = 0.0f;
				
				if(entryType.equals("CREDIT"))
				{					
					newClosingBalForThatDate = thatDateClosingBal + amount;			
					
				}				
				
				if(entryType.equals("DEBIT"))
				{
					newClosingBalForThatDate = thatDateClosingBal - amount;		
				}
				
				
				sql = "UPDATE "
						+ "datewise_closing_balance "
						+ "SET "
						+ "closeing_bal_amount = ?,"
						+ "last_entry_updated_by = ?,"
						+ "last_enty_updated_time = ? "
						+ "WHERE "
						+ "closeing_bal_date = STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND "
						+ "account_id = ? "
						+ "AND "
	    				+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?";
				preparedStatement = connection.prepareStatement(sql);					
				preparedStatement.setFloat(1, newClosingBalForThatDate);
				preparedStatement.setString(2, entryBy);
				preparedStatement.setTime(3, time);
				preparedStatement.setString(4, entryDate);
				preparedStatement.setString(5, accountId);
				preparedStatement.setString(6, crusherId);
				preparedStatement.setString(7, crusherCode);
				
				rowUpdated = preparedStatement.executeUpdate();
		
				
					
			}
			else
			{
				float lastDateClosingBal = 0.0F;
				
				/*SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
				Calendar cal = Calendar.getInstance();
				cal = Calendar.getInstance();
				cal.add(Calendar.DATE, -1);
				String lastDate = dateFormat.format(cal.getTime());*/
				
				sql = "SELECT "
						+ "closeing_bal_amount "
						+ "FROM "
						+ "datewise_closing_balance "
						+ "WHERE "
        				+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "AND "
						+ "account_id = ? "
						+ "ORDER BY "
						+ "closeing_bal_date DESC LIMIT 1";
				
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				preparedStatement.setString(3, accountId);
				
				
				
				
				resultSet = preparedStatement.executeQuery();
				
				if(resultSet.next())
				{
					lastDateClosingBal = resultSet.getFloat(1);
				}
				
				float newClosingBalForThatDate = 0.0f;
				
				if(entryType.equals("CREDIT"))
				{					
					newClosingBalForThatDate = lastDateClosingBal + amount;			
					
				}				
				
				if(entryType.equals("DEBIT"))
				{
					newClosingBalForThatDate = lastDateClosingBal - amount;		
				}
				
				
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
				sql = "INSERT "
						+ "INTO "
						+ "datewise_closing_balance "
						+ "(account_id,"
						+ "crusher_id,"
						+ "crusher_code,"
						+ "closeing_bal_date,"
						+ "closeing_bal_time,"
						+ "last_enty_updated_time,"
						+ "closeing_bal_amount,"
						+ "last_entry_updated_by) "
						+ "VALUES "
						+ "(?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?)";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, accountId);
				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				preparedStatement.setString(4, entryDate);
				preparedStatement.setTime(5, time);
				preparedStatement.setTime(6, time);
				preparedStatement.setFloat(7, newClosingBalForThatDate);
				preparedStatement.setString(8, entryBy);
				
				rowUpdated = preparedStatement.executeUpdate();
			}
			
			if(rowUpdated > 0)
			{
				entryAddedUpdated = true;
			}
			else
			{
				entryAddedUpdated = false;
			}
			
			
		}
		catch (SQLException e) {
			entryAddedUpdated = false;
			e.printStackTrace();
		}
		catch (Exception e) {
			entryAddedUpdated = false;
		}finally {
			if(resultSet != null)
			{
				try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			
			
		}
		
		return entryAddedUpdated;
	}
	
	
	
	public static boolean maintainCloseingBalDiesel(String productId, String productName, String entryType, String entryDate, Float quantity ,String entryBy, Connection connection, SessionMap<String, Object> sessionMap)
	{
		boolean entryAddedUpdated = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
		
		
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
	
		java.util.Date date = new java.util.Date();
	      long t = date.getTime();	        	     
	      java.sql.Time time = new java.sql.Time(t);
		try
		{
			
			
			
			boolean isEntryAddedForDate = false;
			float thatDateClosingBal = 0.0F;
			
			sql = "SELECT "
					+ "closeing_bal_quantity "
					+ "FROM "
					+ "diesel_datewise_closing_balance "
					+ "WHERE "
					+ "closeing_bal_date = STR_TO_DATE(?,'%d-%m-%Y') "
					+ "AND "
					+ "product_id = ? "
					+ "AND "
    				+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
			
			preparedStatement = connection.prepareStatement(sql);
			
			preparedStatement.setString(1, entryDate);
			preparedStatement.setString(2, productId);
			preparedStatement.setString(3, crusherId);
			preparedStatement.setString(4, crusherCode);
			
			
			resultSet = preparedStatement.executeQuery();
			if(resultSet.next())
			{
				thatDateClosingBal = resultSet.getFloat(1);
				isEntryAddedForDate = true;
			}
			
			
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(preparedStatement != null)
			{
				preparedStatement.close();
				preparedStatement = null;
			}
			
			int rowUpdated = 0;
			
			if(isEntryAddedForDate)
			{	
				
				float newClosingBalForThatDate = 0.0f;
				
				if(entryType.equals("CREDIT"))
				{					
					newClosingBalForThatDate = thatDateClosingBal + quantity;			
					
				}				
				
				if(entryType.equals("DEBIT"))
				{
					newClosingBalForThatDate = thatDateClosingBal - quantity;		
				}
				
				
				sql = "UPDATE "
						+ "diesel_datewise_closing_balance "
						+ "SET "
						+ "closeing_bal_quantity = ?,"
						+ "last_entry_updated_by = ?,"
						+ "last_enty_updated_time = ? "
						+ "WHERE "
						+ "closeing_bal_date = STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND "
						+ "product_id = ? "
						+ "AND "
	    				+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?";
				preparedStatement = connection.prepareStatement(sql);					
				preparedStatement.setFloat(1, newClosingBalForThatDate);
				preparedStatement.setString(2, entryBy);
				preparedStatement.setTime(3, time);
				preparedStatement.setString(4, entryDate);
				preparedStatement.setString(5, productId);
				preparedStatement.setString(6, crusherId);
				preparedStatement.setString(7, crusherCode);
				
				rowUpdated = preparedStatement.executeUpdate();
		
				
					
			}
			else
			{
				float lastDateClosingBal = 0.0F;
				
				/*SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
				Calendar cal = Calendar.getInstance();
				cal = Calendar.getInstance();
				cal.add(Calendar.DATE, -1);
				String lastDate = dateFormat.format(cal.getTime());*/
				
				sql = "SELECT "
						+ "closeing_bal_quantity "
						+ "FROM "
						+ "diesel_datewise_closing_balance "
						+ "WHERE "
        				+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "AND "
						+ "product_id = ? "
						+ "ORDER BY "
						+ "closeing_bal_date DESC LIMIT 1";
				
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				preparedStatement.setString(3, productId);
				
				
				
				
				resultSet = preparedStatement.executeQuery();
				
				if(resultSet.next())
				{
					lastDateClosingBal = resultSet.getFloat(1);
				}
				
				float newClosingBalForThatDate = 0.0f;
				
				if(entryType.equals("CREDIT"))
				{					
					newClosingBalForThatDate = lastDateClosingBal + quantity;			
					
				}				
				
				if(entryType.equals("DEBIT"))
				{
					newClosingBalForThatDate = lastDateClosingBal - quantity;		
				}
				
				
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
				sql = "INSERT "
						+ "INTO "
						+ "diesel_datewise_closing_balance "
						+ "(product_id,"
						+ "product_name,"
						+ "crusher_id,"
						+ "crusher_code,"
						+ "closeing_bal_date,"
						+ "closeing_bal_time,"
						+ "last_enty_updated_time,"
						+ "closeing_bal_quantity,"
						+ "last_entry_updated_by) "
						+ "VALUES "
						+ "(?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?)";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, productId);
				preparedStatement.setString(2, productName);
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, entryDate);
				preparedStatement.setTime(6, time);
				preparedStatement.setTime(7, time);
				preparedStatement.setFloat(8, newClosingBalForThatDate);
				preparedStatement.setString(9, entryBy);
				
				rowUpdated = preparedStatement.executeUpdate();
			}
			
			if(rowUpdated > 0)
			{
				entryAddedUpdated = true;
			}
			else
			{
				entryAddedUpdated = false;
			}
			
			
		}
		catch (SQLException e) {
			entryAddedUpdated = false;
			e.printStackTrace();
		}
		catch (Exception e) {
			entryAddedUpdated = false;
		}finally {
			if(resultSet != null)
			{
				try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			
			
		}
		
		return entryAddedUpdated;
	}
	
	
	
	
	
	public static boolean maintainCloseingBalAdblue(String productId, String productName, String entryType, String entryDate, Float quantity ,String entryBy, Connection connection, SessionMap<String, Object> sessionMap)
	{
		boolean entryAddedUpdated = false;
		
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");
		
		
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
	
		java.util.Date date = new java.util.Date();
	      long t = date.getTime();	        	     
	      java.sql.Time time = new java.sql.Time(t);
		try
		{
			
			
			
			boolean isEntryAddedForDate = false;
			float thatDateClosingBal = 0.0F;
			
			sql = "SELECT "
					+ "closeing_bal_quantity "
					+ "FROM "
					+ "adblue_datewise_closing_balance "
					+ "WHERE "
					+ "closeing_bal_date = STR_TO_DATE(?,'%d-%m-%Y') "
					+ "AND "
					+ "product_id = ? "
					+ "AND "
    				+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
			
			preparedStatement = connection.prepareStatement(sql);
			
			preparedStatement.setString(1, entryDate);
			preparedStatement.setString(2, productId);
			preparedStatement.setString(3, crusherId);
			preparedStatement.setString(4, crusherCode);
			
			
			resultSet = preparedStatement.executeQuery();
			if(resultSet.next())
			{
				thatDateClosingBal = resultSet.getFloat(1);
				isEntryAddedForDate = true;
			}
			
			
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(preparedStatement != null)
			{
				preparedStatement.close();
				preparedStatement = null;
			}
			
			int rowUpdated = 0;
			
			if(isEntryAddedForDate)
			{	
				
				float newClosingBalForThatDate = 0.0f;
				
				if(entryType.equals("CREDIT"))
				{					
					newClosingBalForThatDate = thatDateClosingBal + quantity;			
					
				}				
				
				if(entryType.equals("DEBIT"))
				{
					newClosingBalForThatDate = thatDateClosingBal - quantity;		
				}
				
				
				sql = "UPDATE "
						+ "adblue_datewise_closing_balance "
						+ "SET "
						+ "closeing_bal_quantity = ?,"
						+ "last_entry_updated_by = ?,"
						+ "last_enty_updated_time = ? "
						+ "WHERE "
						+ "closeing_bal_date = STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND "
						+ "product_id = ? "
						+ "AND "
	    				+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?";
				preparedStatement = connection.prepareStatement(sql);					
				preparedStatement.setFloat(1, newClosingBalForThatDate);
				preparedStatement.setString(2, entryBy);
				preparedStatement.setTime(3, time);
				preparedStatement.setString(4, entryDate);
				preparedStatement.setString(5, productId);
				preparedStatement.setString(6, crusherId);
				preparedStatement.setString(7, crusherCode);
				
				rowUpdated = preparedStatement.executeUpdate();
		
				
					
			}
			else
			{
				float lastDateClosingBal = 0.0F;
				
				/*SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
				Calendar cal = Calendar.getInstance();
				cal = Calendar.getInstance();
				cal.add(Calendar.DATE, -1);
				String lastDate = dateFormat.format(cal.getTime());*/
				
				sql = "SELECT "
						+ "closeing_bal_quantity "
						+ "FROM "
						+ "adblue_datewise_closing_balance "
						+ "WHERE "
        				+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "AND "
						+ "product_id = ? "
						+ "ORDER BY "
						+ "closeing_bal_date DESC LIMIT 1";
				
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				preparedStatement.setString(3, productId);
				
				
				
				
				resultSet = preparedStatement.executeQuery();
				
				if(resultSet.next())
				{
					lastDateClosingBal = resultSet.getFloat(1);
				}
				
				float newClosingBalForThatDate = 0.0f;
				
				if(entryType.equals("CREDIT"))
				{					
					newClosingBalForThatDate = lastDateClosingBal + quantity;			
					
				}				
				
				if(entryType.equals("DEBIT"))
				{
					newClosingBalForThatDate = lastDateClosingBal - quantity;		
				}
				
				
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(preparedStatement != null)
				{
					preparedStatement.close();
					preparedStatement = null;
				}
				
				sql = "INSERT "
						+ "INTO "
						+ "adblue_datewise_closing_balance "
						+ "(product_id,"
						+ "product_name,"
						+ "crusher_id,"
						+ "crusher_code,"
						+ "closeing_bal_date,"
						+ "closeing_bal_time,"
						+ "last_enty_updated_time,"
						+ "closeing_bal_quantity,"
						+ "last_entry_updated_by) "
						+ "VALUES "
						+ "(?,?,?,?,STR_TO_DATE(?,'%d-%m-%Y'),?,?,?,?)";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, productId);
				preparedStatement.setString(2, productName);
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, entryDate);
				preparedStatement.setTime(6, time);
				preparedStatement.setTime(7, time);
				preparedStatement.setFloat(8, newClosingBalForThatDate);
				preparedStatement.setString(9, entryBy);
				
				rowUpdated = preparedStatement.executeUpdate();
			}
			
			if(rowUpdated > 0)
			{
				entryAddedUpdated = true;
			}
			else
			{
				entryAddedUpdated = false;
			}
			
			
		}
		catch (SQLException e) {
			entryAddedUpdated = false;
			e.printStackTrace();
		}
		catch (Exception e) {
			entryAddedUpdated = false;
			e.printStackTrace();
		}finally {
			if(resultSet != null)
			{
				try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			
			
		}
		
		return entryAddedUpdated;
	}
	
	
}
