package com.stonecrusher.utils;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import com.stonecrusher.db.GetDBConnection;

public class GetVehicleList {
	
	public static LinkedHashMap<String,String> getVehicleList(HttpSession session)
	{
		LinkedHashMap<String,String> vehicleMap = new LinkedHashMap<String,String>();

    	Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");

		String sql = "";
		String db = (String) session.getAttribute("db");
	
			try
			{
			
				connection = GetDBConnection.getDBConnection(db);
				
				
				sql = "SELECT "
						+ "vehicle_id,"
						+ "vehicle_registration_number "
						+ "FROM "
						+ "crusher_vehicle_details_master "
						+ "WHERE "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";

				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);

				resultSet = preparedStatement.executeQuery();
				
				while(resultSet.next())
				{
					vehicleMap.put(resultSet.getString(1), resultSet.getString(2));
				}
				
			}catch (SQLException e) {
				
			} catch (IOException e) {
				
			}finally {
				if(resultSet != null)
   				{
   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
			
		
		
		return vehicleMap;
	}

}
