package com.stonecrusher.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.struts2.dispatcher.SessionMap;

public class GetHeadNameByHeadId {
	
	public static String getTaxPercentageById(String taxId, Connection connection, SessionMap<String, Object> sessionMap)
	{
	PreparedStatement preparedStatement= null;
	ResultSet resultSet = null;
	
	String crusherId = (String) sessionMap.get("crusherId");
	String crusherCode = (String) sessionMap.get("crusherCode");

	String headName = "";
	
	String sql = "";
	
	try
	{
		sql = "SELECT "
				+ "head_name "
				+ "FROM "
				+ "crusher_daily_expenses_head_master "
				+ "WHERE "
				+ "head_entry_id = ? "
				+ "AND "
				+ "crusher_id = ? "
				+ "AND "
				+ "crusher_code = ? ";
		
		
		preparedStatement = connection.prepareStatement(sql);
		preparedStatement.setString(1, taxId);
		preparedStatement.setString(2, crusherId);
		preparedStatement.setString(3, crusherCode);

		resultSet = preparedStatement.executeQuery();
		
		while(resultSet.next())
		{
			headName = resultSet.getString(1);
		}
		
	}
	catch (SQLException e) 
	{
		headName = "";
		
	}
	catch (Exception e) 
	{
		headName = "";
	}
	finally 
	{
		if(resultSet != null)
		{
			try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		}
		
		
	}
	
	return headName;
	}

}
