package com.stonecrusher.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class UpdateVehicleDetails  extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8319399134111952661L;
	private HttpSession session;
	private String key;
	private String vehicleMake;
	private String vehicleRegistrationNumber;
	private String vehicleOwnerName;
	private String ownerMobileNumber;
	private String vehicleDriverName;
	private String driverMobileNumber;
	private String insuranceCompanyName;
	private String insuranceContactNumber;
	private String insuranceStartDate;
	private String insuranceEndDate;
	private String taxReceiptStartDate;
	private String taxReceiptEndDate;
	private String rtoPassingStartDate;
	private String rtoPassingEndDate;
	private String pucPassingStartDate;
	private String pucPassingEndDate;
	private File insurancePDF;
	private File taxReceiptPDF;
	private File rtoPassingPDF;
	private File pucPassingPDF;
	private File gpsCertificatePDF;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private Float carryingCapacityBrass;
	private String addSideBarJs;
	private SessionMap<String,Object> sessionMap;  
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
				
				String sql = "";
				
				String db = (String) session.getAttribute("db");
				
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						int rowUpdated = 0;
					
						String vehicleId = EncryptionDecryption.decrypt(this.getKey());
						
						FileInputStream insuranceFileFis  = null;
						FileInputStream taxReceiptFileFis  = null;
						FileInputStream rtoPassingFileFis = null;
						FileInputStream pucPassingFileFis = null;
						FileInputStream gpsCertificateFileFis = null;
						
						if(this.getInsurancePDF() != null)
						{
							insuranceFileFis =  new FileInputStream(this.getInsurancePDF());
						}
						if(this.getTaxReceiptPDF() != null)
						{
							taxReceiptFileFis =  new FileInputStream(this.getTaxReceiptPDF());
						}
						
						if(this.getRtoPassingPDF() != null)
						{
							rtoPassingFileFis =  new FileInputStream(this.getRtoPassingPDF());
						}
						if(this.getPucPassingPDF() != null)
						{
							pucPassingFileFis = new FileInputStream(this.getPucPassingPDF());
						}
						if(this.getGpsCertificatePDF() != null)
						{
							gpsCertificateFileFis = new FileInputStream(this.getGpsCertificatePDF());
						}
					
							sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "vehicle_make = ?,"
									+ "vehicle_registration_number = ?,"
									+ "owner_name = ?,"
									+ "owner_mobile_number = ?,"
									+ "driver_name = ?,"
									+ "driver_mobile_number = ?,"
									+ "vehicle_insurance_name = ?,"
									+ "vehicle_insurance_company_contact = ?,"
									+ "insurance_start_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "insurance_end_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "tax_receipt_start_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "tax_receipt_end_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "rto_passing_start_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "rto_passing_end_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "puc_passing_start_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "puc_passing_end_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "brass_quantity=? "
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, this.getVehicleMake().trim().toUpperCase());
						preparedStatement.setString(2, this.getVehicleRegistrationNumber().trim().toUpperCase());
						preparedStatement.setString(3, this.getVehicleOwnerName());
						preparedStatement.setString(4, this.getOwnerMobileNumber());
						preparedStatement.setString(5, this.getVehicleDriverName());
						preparedStatement.setString(6, this.getDriverMobileNumber());
						
						if (this.getInsuranceCompanyName() == null || this.getInsuranceCompanyName().trim().isEmpty()) {
						    preparedStatement.setNull(7, java.sql.Types.VARCHAR);
						} else {
						    preparedStatement.setString(7, this.getInsuranceCompanyName().trim().toUpperCase());
						}

					
						if (this.getInsuranceContactNumber() == null || this.getInsuranceContactNumber().trim().isEmpty()) {
						    preparedStatement.setNull(8, java.sql.Types.VARCHAR);
						} else {
						    preparedStatement.setString(8, this.getInsuranceContactNumber());
						}
						
						if (this.getInsuranceStartDate() == null || this.getInsuranceStartDate().isEmpty()) {
						    preparedStatement.setNull(9, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(9, this.getInsuranceStartDate());
						}

						if (this.getInsuranceEndDate() == null || this.getInsuranceEndDate().isEmpty()) {
						    preparedStatement.setNull(10, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(10, this.getInsuranceEndDate());
						}
						
						
						if (this.getTaxReceiptStartDate() == null || this.getTaxReceiptStartDate().isEmpty()) {
						    preparedStatement.setNull(11, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(11, this.getTaxReceiptStartDate());
						}

						if (this.getTaxReceiptEndDate() == null || this.getTaxReceiptEndDate().isEmpty()) {
						    preparedStatement.setNull(12, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(12, this.getTaxReceiptEndDate());
						}

						
						// Handling null for RTO passing start and end dates
						if (this.getRtoPassingStartDate() == null || this.getRtoPassingStartDate().isEmpty()) {
						    preparedStatement.setNull(13, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(13, this.getRtoPassingStartDate());
						}

						if (this.getRtoPassingEndDate() == null || this.getRtoPassingEndDate().isEmpty()) {
						    preparedStatement.setNull(14, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(14, this.getRtoPassingEndDate());
						}
						
						
						if (this.getPucPassingStartDate() == null || this.getPucPassingStartDate().isEmpty()) {
						    preparedStatement.setNull(15, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(15, this.getPucPassingStartDate());
						}

						if (this.getPucPassingEndDate() == null || this.getPucPassingEndDate().isEmpty()) {
						    preparedStatement.setNull(16, java.sql.Types.DATE);
						} else {
						    preparedStatement.setString(16, this.getPucPassingEndDate());
						}
						
						
						preparedStatement.setFloat(17, this.getCarryingCapacityBrass());
						preparedStatement.setString(18,vehicleId);
						preparedStatement.setString(19,crusherId);
						preparedStatement.setString(20,crusherCode);
						
						
						
						rowUpdated = preparedStatement.executeUpdate();

						
						if(rowUpdated > 0)
						{
							
							
							if(this.getInsurancePDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "insurance_image_file = ? "								
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
								
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, insuranceFileFis,(int)this.getInsurancePDF().length() );
							preparedStatement.setString(2,vehicleId);
							preparedStatement.setString(3,crusherId);
							preparedStatement.setString(4,crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							if(this.getTaxReceiptPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "tax_receipt_image_file = ? "
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, taxReceiptFileFis,(int)this.getTaxReceiptPDF().length() );
							preparedStatement.setString(2,vehicleId);
							preparedStatement.setString(3,crusherId);
							preparedStatement.setString(4,crusherCode);
							
							
							preparedStatement.executeUpdate();
							}
							
							if(this.getRtoPassingPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "rto_passing_image_file = ? "
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, rtoPassingFileFis,(int)this.getRtoPassingPDF().length() );
							preparedStatement.setString(2,vehicleId);
							preparedStatement.setString(3,crusherId);
							preparedStatement.setString(4,crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							
							
							
							if(this.getPucPassingPDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "puc_passing_image_file = ? "
									+ "WHERE "
									+ "vehicle_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, pucPassingFileFis,(int)this.getPucPassingPDF().length() );
							preparedStatement.setString(2,vehicleId);
							preparedStatement.setString(3,crusherId);
							preparedStatement.setString(4,crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							
							
							
							if(this.getGpsCertificatePDF() != null)
							{
								if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
							
								sql = "UPDATE "
									+ "crusher_vehicle_details_master "
									+ "SET "
									+ "gps_certificate_image_file = ? "
									+ "WHERE "
									+ "vehicle_make = ? "
									+ "AND "
									+ "vehicle_registration_number = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setBinaryStream(1, gpsCertificateFileFis,(int)this.getGpsCertificatePDF().length() );
							preparedStatement.setString(2, this.getVehicleMake().trim().toUpperCase());
							preparedStatement.setString(3, this.getVehicleRegistrationNumber().trim().toUpperCase());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
							 preparedStatement.executeUpdate();
							}
							
							
							
							result = "success";
							addActionMessage(this.getText("message.success.vehicleDetailsUpdatedsuccessfully"));
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.unableToAddVehicleDetailsPlzTryAgain"));
						}
						
						if(insuranceFileFis != null)
			        	{
							insuranceFileFis.close();
							insuranceFileFis = null;
			        	}
						
						if(taxReceiptFileFis != null)
			        	{
							taxReceiptFileFis.close();
							taxReceiptFileFis = null;
			        	}
						
						if(rtoPassingFileFis != null)
			        	{
							rtoPassingFileFis.close();
							rtoPassingFileFis = null;
			        	}
						
					}catch (SQLException e) {
						result = "error";
						e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.vehicleDetailsNotUpdated"));
					} catch (Exception e) {
						e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.vehicleDetailsNotUpdated"));
					}finally {
						
						if(preparedStatement != null)
						{
							try {preparedStatement.close();preparedStatement=null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close();connection=null;}catch (SQLException e) {}
						}
						
					}
	        	
					
	        	
	        }
	        
	        customerSearchOptionList.put("BYNAME", "BY NAME");
        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
			setCustomerSearchOption("BYNAME");
			setDefaultValue("BYNAME");
	        
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		this.setAddSideBarJs("FALSE");
		
		if(this.getVehicleMake().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideVehicleMake"));
		}
		if(!hasActionErrors())
		{
			if(this.getVehicleRegistrationNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideVehicleRegistrationNumber"));
			}
		}
		
		/*
		 * if(!hasActionErrors()) { if(this.getInsuranceCompanyName().equals("")) {
		 * addActionError("Please provide insurance company name!"); } }
		 * 
		 * if(!hasActionErrors()) { if(this.getInsuranceContactNumber().equals("")) {
		 * addActionError("Please provide insurance comapny contact number!"); } }
		 * 
		 * if(!hasActionErrors()){ if(this.getInsuranceStartDate().equals("") ||
		 * this.getInsuranceEndDate().equals("")) {
		 * addActionError("Please provide insurance start and end date!"); } }
		 * 
		 * if(!hasActionErrors()) { if(this.getTaxReceiptStartDate().equals("") ||
		 * this.getTaxReceiptEndDate().equals("")) {
		 * addActionError("Please provide tax receipt start and end date!"); } }
		 */
		
		if(!hasActionErrors())
		{
			String isVehicleAdded = "false";
			
			String [] result = new String[2];
			String condition  = "AND vehicle_registration_number <> '"+this.getVehicleRegistrationNumber()+"'";
			result = new CheckAlreadyAvailable().checkAvaibility("crusher_vehicle_details_master", "vehicle_registration_number", condition, this.getVehicleRegistrationNumber().trim().toUpperCase());
			
			isVehicleAdded = result[0];
			
			if(isVehicleAdded.equals("true"))
			{
				addActionError(this.getText("message.error.vehiclewithThisRegistrationNumberIsAlreadyAdded"));
			}		
		}
		
		/*
		 * if(!hasActionErrors()) { if(this.getInsurancePDF() != null) { int sizeOfImage
		 * =(int)this.getInsurancePDF().length();
		 * 
		 * if(sizeOfImage > 1000000) {
		 * addActionError("Size of insurance file is large than 1000Kb!"); } } }
		 */
		
		/*
		 * if(!hasActionErrors()) { if(this.getTaxReceiptPDF() != null) { int
		 * sizeOfImage =(int)this.getTaxReceiptPDF().length();
		 * 
		 * if(sizeOfImage > 1000000) {
		 * addActionError("Size of tax receipt file is large than 1000Kb!"); } } }
		 */
		
		/*
		 * if(!hasActionErrors()) { if(this.getRtoPassingPDF() != null) { int
		 * sizeOfImage =(int)this.getRtoPassingPDF().length();
		 * 
		 * if(sizeOfImage > 1000000) {
		 * addActionError("Size of RTO passing file is large than 1000Kb!"); } } }
		 */
		
		if(!hasActionErrors())
		{
			if(this.getCarryingCapacityBrass() == null || this.getCarryingCapacityBrass().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectCarryingBrassCapacity"));
			}
		}
	
	} 
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getVehicleMake() {
		return vehicleMake;
	}
	public void setVehicleMake(String vehicleMake) {
		this.vehicleMake = vehicleMake;
	}
	public String getVehicleRegistrationNumber() {
		return vehicleRegistrationNumber;
	}
	public void setVehicleRegistrationNumber(String vehicleRegistrationNumber) {
		this.vehicleRegistrationNumber = vehicleRegistrationNumber;
	}
	public String getInsuranceCompanyName() {
		return insuranceCompanyName;
	}
	public void setInsuranceCompanyName(String insuranceCompanyName) {
		this.insuranceCompanyName = insuranceCompanyName;
	}
	public String getInsuranceContactNumber() {
		return insuranceContactNumber;
	}
	public void setInsuranceContactNumber(String insuranceContactNumber) {
		this.insuranceContactNumber = insuranceContactNumber;
	}
	public String getInsuranceStartDate() {
		return insuranceStartDate;
	}
	public void setInsuranceStartDate(String insuranceStartDate) {
		this.insuranceStartDate = insuranceStartDate;
	}
	public String getInsuranceEndDate() {
		return insuranceEndDate;
	}
	public void setInsuranceEndDate(String insuranceEndDate) {
		this.insuranceEndDate = insuranceEndDate;
	}
	public String getTaxReceiptStartDate() {
		return taxReceiptStartDate;
	}
	public void setTaxReceiptStartDate(String taxReceiptStartDate) {
		this.taxReceiptStartDate = taxReceiptStartDate;
	}
	public String getTaxReceiptEndDate() {
		return taxReceiptEndDate;
	}
	public void setTaxReceiptEndDate(String taxReceiptEndDate) {
		this.taxReceiptEndDate = taxReceiptEndDate;
	}
	public File getInsurancePDF() {
		return insurancePDF;
	}
	public void setInsurancePDF(File insurancePDF) {
		this.insurancePDF = insurancePDF;
	}
	public File getTaxReceiptPDF() {
		return taxReceiptPDF;
	}
	public void setTaxReceiptPDF(File taxReceiptPDF) {
		this.taxReceiptPDF = taxReceiptPDF;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getRtoPassingStartDate() {
		return rtoPassingStartDate;
	}

	public void setRtoPassingStartDate(String rtoPassingStartDate) {
		this.rtoPassingStartDate = rtoPassingStartDate;
	}

	public String getRtoPassingEndDate() {
		return rtoPassingEndDate;
	}

	public void setRtoPassingEndDate(String rtoPassingEndDate) {
		this.rtoPassingEndDate = rtoPassingEndDate;
	}

	public File getRtoPassingPDF() {
		return rtoPassingPDF;
	}

	public void setRtoPassingPDF(File rtoPassingPDF) {
		this.rtoPassingPDF = rtoPassingPDF;
	}

	public String getVehicleOwnerName() {
		return vehicleOwnerName;
	}

	public void setVehicleOwnerName(String vehicleOwnerName) {
		this.vehicleOwnerName = vehicleOwnerName;
	}

	public String getOwnerMobileNumber() {
		return ownerMobileNumber;
	}

	public void setOwnerMobileNumber(String ownerMobileNumber) {
		this.ownerMobileNumber = ownerMobileNumber;
	}

	public String getVehicleDriverName() {
		return vehicleDriverName;
	}

	public void setVehicleDriverName(String vehicleDriverName) {
		this.vehicleDriverName = vehicleDriverName;
	}

	public String getDriverMobileNumber() {
		return driverMobileNumber;
	}

	public void setDriverMobileNumber(String driverMobileNumber) {
		this.driverMobileNumber = driverMobileNumber;
	}

	public Float getCarryingCapacityBrass() {
		return carryingCapacityBrass;
	}

	public void setCarryingCapacityBrass(Float carryingCapacityBrass) {
		this.carryingCapacityBrass = carryingCapacityBrass;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getPucPassingStartDate() {
		return pucPassingStartDate;
	}

	public void setPucPassingStartDate(String pucPassingStartDate) {
		this.pucPassingStartDate = pucPassingStartDate;
	}

	public String getPucPassingEndDate() {
		return pucPassingEndDate;
	}

	public void setPucPassingEndDate(String pucPassingEndDate) {
		this.pucPassingEndDate = pucPassingEndDate;
	}

	public File getPucPassingPDF() {
		return pucPassingPDF;
	}

	public void setPucPassingPDF(File pucPassingPDF) {
		this.pucPassingPDF = pucPassingPDF;
	}

	public File getGpsCertificatePDF() {
		return gpsCertificatePDF;
	}

	public void setGpsCertificatePDF(File gpsCertificatePDF) {
		this.gpsCertificatePDF = gpsCertificatePDF;
	}
	
	
	
	
}