package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class UpdateSupplier extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6424268643743578099L;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private HttpSession session;
	
	private String supplierId;
	private String supplierName;
	private String personName;
	private String mobileNumber;
	private String email;
	private String GSTINumber;
	private String TINumber;
	private String PANumber;
	private String address;

	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				
				String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");
				

				
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
				customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
				customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				
				setDefaultValue("BYNAME");
				setCustomerSearchOption("BYNAME");
				
	        
				
				String sql = "";
				String db = (String) session.getAttribute("db");
	        
				try
				{
			
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "UPDATE "
							+ "crusher_supplier_master "
							+ "SET "
							+ "supplier_name = ?,"
							+ "contact_person_name = ?,"
							+ "contact_number = ?,"
							+ "supplier_email = ?,"
							+ "supplier_gstin = ?,"
							+ "supplier_pan = ?,"
							+ "supplier_address = ? "
							+ "WHERE "
							+ "supplier_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, this.getSupplierName().trim().toUpperCase());
					preparedStatement.setString(2, this.getPersonName().trim().toUpperCase());
					preparedStatement.setString(3, this.getMobileNumber().trim());
					preparedStatement.setString(4, this.getEmail());
					preparedStatement.setString(5, this.getGSTINumber().trim().toUpperCase());
					preparedStatement.setString(6, this.getPANumber().trim().toUpperCase());
					preparedStatement.setString(7, this.getAddress().trim().toUpperCase());
					preparedStatement.setString(8, this.getSupplierId());
					preparedStatement.setString(9, crusherId);
					preparedStatement.setString(10, crusherCode);
					

					int rowCountUpdated = preparedStatement.executeUpdate();
					
					if(rowCountUpdated > 0)
					{
						result = "success";
						addActionMessage(this.getText("message.success.supplierDetailsUpdatedSuccessfully"));
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.errorSupplierDetailsNotAddedPlzTryAgain"));
					}
					
					
				}catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.supplierDetailsNotUpdated"));
				} catch (IOException e) {
					//e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.supplierDetailsNotUpdated"));
				}finally {
				
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();}catch (SQLException e) {}
				}
		
	}



}
return result;
}
@Override
public void validate() 
{
		// TODO Auto-generated method stub
	
	
	if(getSupplierName().equals("") || getPersonName().equals("") || getMobileNumber().equals("") || getAddress().equals(""))
	{
		addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
	}

	if(!hasActionErrors())
	{
		if(!getMobileNumber().equals(""))
		{
			if(getMobileNumber().length() >10)
			{
				addActionError(this.getText("message.error.plzProvideCorrectMobileNumber(10digit)"));
			}
		}
	}
	
	if(!hasActionErrors())
	{
		String isCustomerAdded = "false";
		
		String [] result = new String[2];
		String condition = "AND supplier_id !="+this.getSupplierId();
		
		result = new CheckAlreadyAvailable().checkAvaibility("crusher_supplier_master", "supplier_name", condition, getSupplierName().trim());
		
		isCustomerAdded = result[0];
		
		if(isCustomerAdded.equals("true"))
		{
			addActionError(this.getText("message.error.supplierIsAlreadyAddedWithSameName"));
		}				
		
	}
	
	if(!hasActionErrors())
	{
		String isCustomerAdded = "false";
		
		String [] result = new String[2];
		
		String condition = "AND supplier_id !="+this.getSupplierId();
		
		result = new CheckAlreadyAvailable().checkAvaibility("crusher_supplier_master", "contact_number", condition, getMobileNumber());
		
		isCustomerAdded = result[0];
		
		if(isCustomerAdded.equals("true"))
		{
			addActionError(this.getText("message.error.supplierIsAlreadyAddedWithSameContactNumber"));
		}				
		
	}
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(String supplierId) {
		this.supplierId = supplierId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getPersonName() {
		return personName;
	}

	public void setPersonName(String personName) {
		this.personName = personName;
	}

	public String getMobileNumber() {
		return mobileNumber;
	}

	public void setMobileNumber(String mobileNumber) {
		this.mobileNumber = mobileNumber;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getGSTINumber() {
		return GSTINumber;
	}

	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}

	public String getTINumber() {
		return TINumber;
	}

	public void setTINumber(String tINumber) {
		TINumber = tINumber;
	}

	public String getPANumber() {
		return PANumber;
	}

	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}


}
