package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class UpdateSettings extends ActionSupport implements SessionAware, ServletResponseAware, ServletRequestAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8595377243671444313L;
	
	private HttpSession session;
	
	
	private String bankingName;
	private String nameOfBank;
	private String nameOfBranch;
	private String accountNumber;
	private String ifscCode;
	private String micrCode;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	private SessionMap<String,Object> sessionMap; 
	
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
				
		      String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

  				Connection connection = null;
  		   		PreparedStatement preparedStatement= null;	
  		   		ResultSet resultSet = null;
  		   		
  		   		String sql = "";
  		   		String db = (String) session.getAttribute("db");
      		   	
				
  		   	 try {
  	            connection = GetDBConnection.getDBConnection(db);
  	            connection.setAutoCommit(false);

  	            
  	            String checkSql = "SELECT COUNT(*) FROM crusher_settings_master WHERE name = ? AND crusher_id = ? AND crusher_code = ?";
  	            String updateSql = "UPDATE crusher_settings_master SET value = ? WHERE name = ? AND crusher_id = ? AND crusher_code = ?";
  	            String insertSql = "INSERT INTO crusher_settings_master (name, value, crusher_id, crusher_code) VALUES (?, ?, ?, ?)";

  	            Map<String, String> updateNameValueMap = new HashMap<>();
  	            updateNameValueMap.put("banking_name", this.getBankingName().trim().toUpperCase());
  	            updateNameValueMap.put("name_of_bank", this.getNameOfBank().trim().toUpperCase());
  	            updateNameValueMap.put("name_of_branch", this.getNameOfBranch().trim().toUpperCase());
  	            updateNameValueMap.put("account_number", this.getAccountNumber().trim());
  	            updateNameValueMap.put("ifsc_code", this.getIfscCode().trim());
  	            updateNameValueMap.put("micr_code", this.getMicrCode().trim());

  	            preparedStatement = connection.prepareStatement(checkSql);

  	            for (String name : updateNameValueMap.keySet()) {
  	                
  	                preparedStatement.setString(1, name);
  	                preparedStatement.setString(2, crusherId);
  	                preparedStatement.setString(3, crusherCode);

  	                resultSet = preparedStatement.executeQuery();
  	                boolean exists = false;
  	                if (resultSet.next()) {
  	                    exists = resultSet.getInt(1) > 0;
  	                }

  	                if (resultSet != null) {
  	                    try {
  	                        resultSet.close();
  	                    } catch (SQLException e) {
  	                        e.printStackTrace();
  	                    }
  	                    resultSet = null;
  	                }

  	               
  	                if (exists) {
  	                    try (PreparedStatement updateStmt = connection.prepareStatement(updateSql)) {
  	                        updateStmt.setString(1, updateNameValueMap.get(name));
  	                        updateStmt.setString(2, name);
  	                        updateStmt.setString(3, crusherId);
  	                        updateStmt.setString(4, crusherCode);
  	                        updateStmt.executeUpdate();
  	                    }
  	                } else {
  	                    try (PreparedStatement insertStmt = connection.prepareStatement(insertSql)) {
  	                        insertStmt.setString(1, name);
  	                        insertStmt.setString(2, updateNameValueMap.get(name));
  	                        insertStmt.setString(3, crusherId);
  	                        insertStmt.setString(4, crusherCode);
  	                        insertStmt.executeUpdate();
  	                    }
  	                }
  	            }
					
					
					
					
						connection.commit();

			            this.getSessionMap().replace("banking_name", this.getBankingName());
			            this.getSessionMap().replace("name_of_bank", this.getNameOfBank());
			            this.getSessionMap().replace("name_of_branch", this.getNameOfBranch());
			            this.getSessionMap().replace("account_number", this.getAccountNumber());
			            this.getSessionMap().replace("ifsc_code", this.getIfscCode());
			            this.getSessionMap().replace("micr_code", this.getMicrCode());

						result = "success";
						addActionMessage(this.getText("message.success.settingsUpdatedSuccessfully"));
					
					
					
				}catch (SQLException e) {
					try {
						connection.rollback();
					} catch (SQLException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
					
						result = "error";
					
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||1 "+this.getText("message.error.cannotLoadPage"));
				}finally {
					if(resultSet !=null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();
						 connection = null;
						}catch (SQLException e) {}
					}
				}
		    	
	        }
	        
	       
	        return result;
	}

	@Override
	public void validate() {
		
     
		
		if(!this.hasActionErrors())
		{
			if(this.getBankingName() == null || this.getBankingName().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectBankingName"));
				
			}
		}
		
		if(!this.hasActionErrors())
		{
			if(this.getNameOfBank() == null || this.getNameOfBank().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectNameOfBank"));
				
			}
		}
		
		
		
		if(!this.hasActionErrors())
		{
			if(this.getNameOfBranch() == null || this.getNameOfBranch().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectNameOfBranch"));
				
			}
		}
		
		if(!this.hasActionErrors())
		{
			if(this.getAccountNumber() == null || this.getAccountNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAccountNumber"));
				
			}
		}
		
		if(!this.hasActionErrors())
		{
			if(this.getIfscCode() == null || this.getIfscCode().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectIfscCode"));
				
			}
		}
		
		if(!this.hasActionErrors())
		{
			if(this.getMicrCode() == null || this.getMicrCode().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectMicrCode"));
				
			}
		}
		
		
		
		
	}
	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getBankingName() {
		return bankingName;
	}

	public void setBankingName(String bankingName) {
		this.bankingName = bankingName;
	}

	public String getAccountNumber() {
		return accountNumber;
	}

	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	@Override
	public void setServletRequest(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		this.request = arg0;
	}

	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		this.response = arg0;
	}

	public String getNameOfBank() {
		return nameOfBank;
	}

	public void setNameOfBank(String nameOfBank) {
		this.nameOfBank = nameOfBank;
	}

	public String getNameOfBranch() {
		return nameOfBranch;
	}

	public void setNameOfBranch(String nameOfBranch) {
		this.nameOfBranch = nameOfBranch;
	}

	public String getIfscCode() {
		return ifscCode;
	}

	public void setIfscCode(String ifscCode) {
		this.ifscCode = ifscCode;
	}

	public String getMicrCode() {
		return micrCode;
	}

	public void setMicrCode(String micrCode) {
		this.micrCode = micrCode;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	

	
	
	
	
}
