package com.stonecrusher.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;

public class UpdateLaborDetails extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1722314200818603120L;

	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private HttpSession session;
	private String key;
	private String laborName;
	private String laborMobileNumber;
	private String address;
	private String birthDate;
	private String laborId;
	private File laborImage;
	private String joiningDate;
	private String addSideBarJs;
	private String adharNumber;
	
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
				customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
				customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setDefaultValue("BYNAME");
				setCustomerSearchOption("BYNAME");
				
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
				String laborId = EncryptionDecryption.decrypt(this.getKey());
				String sql = "";
				String db = (String) session.getAttribute("db");
				FileInputStream fis = null;
				
			
				if(this.getLaborImage() != null)
				{
				 fis =  new FileInputStream(this.getLaborImage());
				}
			
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);
						
						if(this.getLaborImage() != null)
						{
							sql = "UPDATE "
									+ "crusher_employee_master "
									+ "SET "
									+ "employee_name = ?,"
									+ "employee_mobile_number = ?,"
									+ "employee_address = ?,"
									+ "employee_birth_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "employee_image = ?,"
									+ "joining_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "adhar_number = ? "
									+ "WHERE "
									+ "employee_name = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, this.getLaborName());
							preparedStatement.setString(2, this.getLaborMobileNumber());
							preparedStatement.setString(3, this.getAddress());
							preparedStatement.setString(4, this.getBirthDate());
							preparedStatement.setBinaryStream(5, fis,(int)this.getLaborImage().length() );
							if(this.getJoiningDate() == null || this.getJoiningDate().equals("")) {
								preparedStatement.setString(6, null);
									
							}else {
								preparedStatement.setString(6, this.getJoiningDate());
								   
							}
							preparedStatement.setString(7, this.getAdharNumber().trim());
							preparedStatement.setString(8, laborId);
							preparedStatement.setString(9, crusherId);
							preparedStatement.setString(10, crusherCode);
							
							
						}
						else if(this.getLaborImage() == null)
						{
							sql = "UPDATE "
									+ "crusher_employee_master "
									+ "SET "
									+ "employee_name = ?,"
									+ "employee_mobile_number = ?,"
									+ "employee_address = ?,"
									+ "employee_birth_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "joining_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "adhar_number = ? "
									+ "WHERE "
									+ "employee_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, this.getLaborName());
							preparedStatement.setString(2, this.getLaborMobileNumber());
							preparedStatement.setString(3, this.getAddress());
							preparedStatement.setString(4, this.getBirthDate());
							if(this.getJoiningDate() == null || this.getJoiningDate().equals("")) {
								preparedStatement.setString(5, null);
							}else {
								preparedStatement.setString(5, this.getJoiningDate());
								
							}
							preparedStatement.setString(6, this.getAdharNumber().trim());
							preparedStatement.setString(7, laborId);
							preparedStatement.setString(8, crusherId);
							preparedStatement.setString(9, crusherCode);
							
						}
						
						
						int k = preparedStatement.executeUpdate();
						
						if(k>0)
						{
							result = SUCCESS;
							addActionMessage(this.getText("message.success.emploeeDetailsUpdatedSuccessfully"));
						}
						else
						{
							result = ERROR;
							addActionError(this.getText("message.error.employeeDetailsNotUpdatedPlzTryAgain"));
						}
					}catch (SQLException e) {
						//e.printStackTrace();
						result =ERROR;				
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.employeeDetailsNotUpdated"));
					
					} catch (IOException e) {
						//e.printStackTrace();
						result =ERROR;			
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.employeeDetailsNotUpdated"));
					
					}finally {
					
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        	
	        	
	        	if(fis != null)
	        	{
	        		fis.close();
	        		fis = null;
	        	}
				
				
				
	        }
	        
	        return result;
	}
	
public void validate() {
	this.setAddSideBarJs("FALSE");
	
		String laborId = EncryptionDecryption.decrypt(this.getKey());
		
		if(this.getLaborName() == null || this.getLaborName().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideLaborName"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getLaborMobileNumber() == null || this.getLaborMobileNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideLaborMobileNumber"));
			}else if(this.getLaborMobileNumber().length() != 10)
			{
				addActionError(this.getText("message.error.plzProvideLaborMobileNumber"));
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getAddress() == null || this.getAddress().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCorrectAddress"));
			}
				
		}
		
		if(!hasActionErrors())
		{
			if(this.getAdharNumber() == null || this.getAdharNumber().equals(""))
			{
				addActionError("Please Provide Adhar Number !");
			}
		}
		
		if(!hasActionErrors())
		{
			if(this.getBirthDate() == null || this.getBirthDate().equals(""))
			{
				addActionError(this.getText("message.error.plzSelectLaborBirthDate"));
			}
		}
		
		
		/*
		 * if(!hasActionErrors()) { String isCustomerAdded = "false";
		 * 
		 * String [] result = new String[2]; String condition =
		 * "AND employee_id <> "+laborId;
		 * 
		 * result = new
		 * CheckAlreadyAvailable().checkAvaibility("crusher_employee_master",
		 * "employee_mobile_number", condition ,this.getLaborMobileNumber().trim());
		 * 
		 * isCustomerAdded = result[0];
		 * 
		 * if(isCustomerAdded.equals("true")) { addActionError(this.getText(
		 * "message.error.employeeIsAlreadyAddedWithSameNameOrMobileNumber")); }
		 * 
		 * }
		 */
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getLaborMobileNumber() {
		return laborMobileNumber;
	}

	public void setLaborMobileNumber(String laborMobileNumber) {
		this.laborMobileNumber = laborMobileNumber;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}

	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	public File getLaborImage() {
		return laborImage;
	}

	public void setLaborImage(File laborImage) {
		this.laborImage = laborImage;
	}

	public String getJoiningDate() {
		return joiningDate;
	}

	public void setJoiningDate(String joiningDate) {
		this.joiningDate = joiningDate;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getAdharNumber() {
		return adharNumber;
	}

	public void setAdharNumber(String adharNumber) {
		this.adharNumber = adharNumber;
	}
	
	
	
}
