package com.stonecrusher.update;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetHeadNameByHeadId;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class UpdateExpenseEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	
	private String key;
	private String fromDate;
	private String toDate;
	private String accountHeadId;
	
	private String expenseDate;
	private String expenseReason;
	private Float amount;
	private String typeOfPayment;
	private String description;
	private File expenseImage;
	private List<String> paymentTypeList = new ArrayList<String>();
	private HttpSession session;
	private String addSideBarJs;
	private String accountId;
	
	private String chequeNumber;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String accountHeadCode;
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();

	private Map<String,String> accountHeadList = new LinkedHashMap<String,String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private Map<String,String> siteList = new LinkedHashMap<String,String>();
	private String siteCode;
	
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					
					String crusherId = (String) this.getSessionMap().get("crusherId");
		    		String crusherCode = (String) this.getSessionMap().get("crusherCode");

					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
					
					String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					
					String entryId = keyDetails[0];
					String entryDate = keyDetails[1];
					FileInputStream fis  = null;
					
					  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
					if(this.getExpenseImage() != null)
					{
					 fis =  new FileInputStream(this.getExpenseImage());
					}
					
					String user = (String) this.getSessionMap().get("userFullName");
					String shortName = "";
					
					try
					{
						shortName = user.split(" ")[0];
					}catch(Exception e)
					{
						shortName = user;
					}
					
					
					
					sql = "SELECT "
  							+ "credit_debit_id "
  							+ "FROM "
  							+ "crusher_daily_expenses "
  							+ "WHERE "
    						+ "entry_id = ? "
    						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
    				preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
					resultSet = preparedStatement.executeQuery();
					
					
					if(resultSet.next()){
						String crditDebitId = resultSet.getString(1);
						
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						
						
						sql = "SELECT "
								+ "entry_id,"
								+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crditDebitId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);

						
						resultSet = preparedStatement.executeQuery();
						
						int m = 0;
						if(resultSet.next())
						{
							
							PreparedStatement  insertIntoDeletedPSMT = null;
							
							String inertDeletedSQL = "INSERT "
									+ "INTO "
									+ "bank_account_credit_debit_updated_entry_master "
									+ "("
									+ "entry_id,"
									+ "crusher_id,"
									+ "crusher_code,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details,"
									+ "old_amount,"
									+ "updated_date,"
									+ "updated_time) "
									+ "VALUES "
									+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,STR_TO_DATE(?, '%d-%m-%Y'),?)";
							
							insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
							
							insertIntoDeletedPSMT.setString(1, crditDebitId);
							insertIntoDeletedPSMT.setString(2, crusherId);
							insertIntoDeletedPSMT.setString(3, crusherCode);
							insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
							insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
							insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
							insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
							insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
							insertIntoDeletedPSMT.setFloat(9, this.getAmount());
							insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
							insertIntoDeletedPSMT.setString(11, shortName);
							insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
							insertIntoDeletedPSMT.setFloat(13, resultSet.getFloat(7));
							insertIntoDeletedPSMT.setString(14, this.getExpenseDate());
							insertIntoDeletedPSMT.setTime(15,time);
							
							
							  m = insertIntoDeletedPSMT.executeUpdate();
							  
							  String paymentType = resultSet.getString(6);
							  
							  
							  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
					
								    
							 
							    
							    
							  boolean isCloseingBalMaintained = false;
							  
							  if (paymentType.equals("CREDIT")) {
							   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), shortName, connection, this.getSessionMap());
							  }else {
								   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), shortName, connection, this.getSessionMap());
								  
							  }
								}
							  
							if(insertIntoDeletedPSMT != null)
							{
								insertIntoDeletedPSMT.close();
								insertIntoDeletedPSMT = null;
							}
							
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
					int rowCount = 0;
					if(this.getExpenseImage() != null)
					{
						
					
							sql = "UPDATE "
									+ "crusher_daily_expenses "
									+ "SET "
									+ "head_id = ?,"
									+ "head_name = ?,"
									+ "expense_date = STR_TO_DATE(?,'%d-%m-%Y'),"
									+ "expense_time = ?,"
									+ "expense_reason = ?,"
									+ "expense_amount = ?,"
									+ "type_of_payment = ?,"
									+ "account_id = ?,"
									+ "expense_details = ?,"									
									+ "expense_image = ?,"
									+ "expense_entry_by = ?,"
									+ "site_code = ? "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";

							
							
							
							preparedStatement = connection.prepareStatement(sql);
							
						
							preparedStatement.setString(1, this.getAccountHeadCode());
							preparedStatement.setString(2, GetHeadNameByHeadId.getTaxPercentageById(this.getAccountHeadCode(), connection, this.getSessionMap()));
							preparedStatement.setString(3, this.getExpenseDate());
							preparedStatement.setTime(4, time);
							preparedStatement.setString(5, this.getExpenseReason().trim().toUpperCase());
							preparedStatement.setFloat(6, this.getAmount());
							preparedStatement.setString(7, this.getTypeOfPayment());
							preparedStatement.setString(8, this.getAccountId());
							preparedStatement.setString(9, this.getDescription().trim().toUpperCase());							
							preparedStatement.setBinaryStream(10, fis,(int)this.getExpenseImage().length() );
							preparedStatement.setString(11, shortName);
							preparedStatement.setString(12, this.getSiteCode());
							preparedStatement.setString(13, entryId);
							preparedStatement.setString(14, crusherId);
							preparedStatement.setString(15, crusherCode);
							

							rowCount = preparedStatement.executeUpdate();
							
					}
					else
					{
						sql = "UPDATE "
								+ "crusher_daily_expenses "
								+ "SET "
								+ "head_id = ?,"
								+ "head_name = ?,"
								+ "expense_date =  STR_TO_DATE(?,'%d-%m-%Y'),"
								+ "expense_time = ?,"
								+ "expense_reason = ?,"
								+ "expense_amount = ?,"
								+ "type_of_payment = ?,"
								+ "account_id = ?,"
								+ "expense_details = ?,"
								+ "expense_entry_by = ?,"
								+ "site_code = ? "
								+ "WHERE "
								+ "entry_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						
						
						preparedStatement = connection.prepareStatement(sql);
						
					
						preparedStatement.setString(1, this.getAccountHeadCode());
						preparedStatement.setString(2, GetHeadNameByHeadId.getTaxPercentageById(this.getAccountHeadCode(), connection, this.getSessionMap()));
						preparedStatement.setString(3, this.getExpenseDate());
						preparedStatement.setTime(4, time);
						preparedStatement.setString(5, this.getExpenseReason().trim().toUpperCase());
						preparedStatement.setFloat(6, this.getAmount());
						preparedStatement.setString(7, this.getTypeOfPayment());
						preparedStatement.setString(8, this.getAccountId());
						preparedStatement.setString(9, this.getDescription().trim().toUpperCase());							
						preparedStatement.setString(10, shortName);
						preparedStatement.setString(11, this.getSiteCode());
						preparedStatement.setString(12, entryId);
						preparedStatement.setString(13, crusherId);
						preparedStatement.setString(14, crusherCode);
						

						rowCount = preparedStatement.executeUpdate();
						
						
					}
					
					
					
					if(!this.getTypeOfPayment().equals("CHEQUE") && m > 0)
        			{
					String accountNumber = "";
	        		sql = "SELECT "
	        				+ "account_number "
	        				+ "FROM "
	        				+ "crusher_bank_account "
	        				+ "WHERE "
	        				+ "account_id  = ?"
	        				+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	        			
	        		preparedStatement = connection.prepareStatement(sql);
	        		
	        		preparedStatement.setString(1, this.getAccountId());
	        		preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
	        		resultSet = preparedStatement.executeQuery();
	        		if(resultSet.next())
	        		{
	        			accountNumber = resultSet.getString(1);
	        		}
	        		

					
					sql = "UPDATE "
							+ "bank_account_credit_debit_master "
							+ "SET "
							+ "entry_date = STR_TO_DATE(?,'%d-%m-%Y'),"
							+ "entry_time = ?,"
							+ "account_id = ?,"
							+ "account_number = ?,"
							+ "entry_type = ?,"
							+ "amount = ?,"
							+ "payment_type = ?,"
							+ "entry_by = ?,"
							+ "entry_details = ? "
							+ "WHERE "
							+ "entry_id = ?"
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
				
					
					
					
					preparedStatement = connection.prepareStatement(sql);
					
				
					preparedStatement.setString(1, this.getExpenseDate());
					preparedStatement.setTime(2, time);
					preparedStatement.setString(3, this.getAccountId());
					preparedStatement.setString(4, accountNumber);
					preparedStatement.setString(5, "DEBIT");
					preparedStatement.setFloat(6, this.getAmount());
					preparedStatement.setString(7, this.getTypeOfPayment());							
					preparedStatement.setString(8, shortName);
					preparedStatement.setString(9, "UPDATED DAILY EXPENSE TO ");
					preparedStatement.setString(10, crditDebitId);
					preparedStatement.setString(11, crusherId);
					preparedStatement.setString(12, crusherCode);
					
					int	count = preparedStatement.executeUpdate();
					
					boolean isCloseingBalMaintained1 = MaintainCloseingBalUtil.maintainCloseingBal(this.getAccountId(),"DEBIT", this.getExpenseDate(), this.getAmount(), shortName, connection, this.getSessionMap());
						
					if(count > 0 && isCloseingBalMaintained1)
					{
						connection.commit();
						result = "success";
						addActionMessage(this.getText("message.error.expenseEntryDetailsUpdatedSuccessfully"));
						
					}
        			}else {
        				
        				
        				
        				
    					connection.commit();
						result = SUCCESS;
						addActionMessage(this.getText("message.error.expenseEntryDetailsUpdatedSuccessfully"));
						
        				 
					}
					
					
        		}
				else
				{
					connection.rollback();
					result = "error";
					addActionError(this.getText("message.error.expenseDetailsCouldNotBeAddedPlzTryAgain"));
				}
				
			
			     
						
					
					
				this.setExpenseReason("");
    			this.setExpenseImage(null);
    			this.setDescription("");
    			this.setAmount(0.0F);
    			this.setTypeOfPayment("CASH");
				
					
				
			}catch (SQLException e) {
				result = "error";
				e.printStackTrace();
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.expenseDetailsNotAdded"));
			} catch (Exception e) {
				e.printStackTrace();
				result = "error";						
				addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.expenseDetailsNotAdded"));
			}finally {
				if(resultSet != null)
   				{
   					try {resultSet.close();}catch(SQLException sqe){}   					
   				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();}catch (SQLException e) {}
				}
				
			}
    	
    	
    	
    	
    }
    return result;
}


	
	public void validate() {
		this.setAddSideBarJs("FALSE");
		
		if(this.getAccountHeadId() == null || this.getAccountHeadId().equals("ALL"))
		{
			addActionError(this.getText("message.error.plzSelectAccountHead"));
		}
		if(this.getExpenseDate().equals("") || this.getExpenseReason().equals("") || this.getAmount() == null  
				|| this.getTypeOfPayment().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getExpenseReason().length() > 99)
			{
				addActionError(this.getText("message.error.lenghtOfExpenseReasnIsMoreThan100Characters"));
			}
		}
		if(!hasActionErrors())
		{
					
			if(this.getDescription().length() > 199)
			{
				addActionError(this.getText("message.error.lenghtOfDescriptionIsMoreThan200Characters"));
			}
		}
		if(!hasActionErrors())
		{
			if(this.getExpenseImage() != null)
				{
					int sizeOfImage =(int)this.getExpenseImage().length();
					
					if(sizeOfImage >  300000)
					{
						addActionError(this.getText("message.error.sizeOfImagelargeThan300kbPlzReduceSizeOfImage"));
					}
				}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getTypeOfPayment().equals("CHEQUE"))
			{
				if(this.getChequePayDate().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideChequePayDate"));
				}
				if(this.getChequePayee().equals(""))
				{
					addActionError(this.getText("message.error.plzProvideChequePayeeName"));
				}
				if(this.getBankName().equals(""))
				{
					addActionError(this.getText("message.error.plzSelectBank"));
				}
				else if(this.getBranchName().equals(""))
				{
					addActionError(this.getText("message.error.plzSelectBranch"));
				}
				else if(this.getChequeNumber().equals(""))
				{
					addActionError(this.getText("message.error.plzSelectCheque"));
				}
			}
			
		}
		paymentTypeList.add("CASH");
    	paymentTypeList.add("UPI");
    	paymentTypeList.add("RTGS");
    	paymentTypeList.add("NEFT");
    	paymentTypeList.add("CHEQUE");
    	

    	
    	
		this.setAccountHeadList(GetListResource.getAccountHeadList());
	
    	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));  
    	this.setSiteList(GetListResource.getSiteList());
        
	}
	
	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getAccountHeadId() {
		return accountHeadId;
	}



	public void setAccountHeadId(String accountHeadId) {
		this.accountHeadId = accountHeadId;
	}



	public String getExpenseDate() {
		return expenseDate;
	}



	public void setExpenseDate(String expenseDate) {
		this.expenseDate = expenseDate;
	}



	public String getExpenseReason() {
		return expenseReason;
	}



	public void setExpenseReason(String expenseReason) {
		this.expenseReason = expenseReason;
	}



	public Float getAmount() {
		return amount;
	}



	public void setAmount(Float amount) {
		this.amount = amount;
	}



	public String getTypeOfPayment() {
		return typeOfPayment;
	}



	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}



	public String getDescription() {
		return description;
	}



	public void setDescription(String description) {
		this.description = description;
	}



	public File getExpenseImage() {
		return expenseImage;
	}



	public void setExpenseImage(File expenseImage) {
		this.expenseImage = expenseImage;
	}



	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}



	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}



	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public String getAccountId() {
		return accountId;
	}



	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}



	public String getChequeNumber() {
		return chequeNumber;
	}



	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}



	public String getChequePayDate() {
		return chequePayDate;
	}



	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}



	public String getChequePayee() {
		return chequePayee;
	}



	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}



	public String getBankName() {
		return bankName;
	}



	public void setBankName(String bankName) {
		this.bankName = bankName;
	}



	public String getBranchName() {
		return branchName;
	}



	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}



	public String getAccountHeadCode() {
		return accountHeadCode;
	}



	public void setAccountHeadCode(String accountHeadCode) {
		this.accountHeadCode = accountHeadCode;
	}



	public List<String> getBankList() {
		return bankList;
	}



	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}



	public List<String> getBranchList() {
		return branchList;
	}



	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}



	public List<String> getChequeList() {
		return chequeList;
	}



	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}



	public Map<String, String> getAccountHeadList() {
		return accountHeadList;
	}



	public void setAccountHeadList(Map<String, String> accountHeadList) {
		this.accountHeadList = accountHeadList;
	}



	public Map<String, String> getAccountList() {
		return accountList;
	}



	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public Map<String, String> getSiteList() {
		return siteList;
	}



	public void setSiteList(Map<String, String> siteList) {
		this.siteList = siteList;
	}



	public String getSiteCode() {
		return siteCode;
	}



	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}
	

}



