package com.stonecrusher.update;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerPaymentReminderDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetNotificationList;

public class UpdateCustomerPaymentReminder extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	
	private String paymentReminderAddDate;
	private String customerName;
	private Float outstandingAmount;
	private String paymentPromiseDate;
	private String comments;
	private ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList;
	private String key;
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "error";
	        }  
	        else{
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
				 String crusherId = (String) this.getSessionMap().get("crusherId");
				 String crusherCode = (String) this.getSessionMap().get("crusherCode");
	
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					String keyData [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					String entryId = keyData[0];
					String custId = keyData[1];
					String keyPromiseDate = keyData[2];
					
					connection = GetDBConnection.getDBConnection(db);
					
					
					sql = "UPDATE "
							+ "crusher_customer_payment_reminder_master "
							+ "SET "
							+ "outsatnding_amount = ?,"						
							+ "payment_promise_date = STR_TO_DATE(?,'%d-%m-%Y'),"
							+ "comments = ?,"
							+ "status = 'NOTIFY' "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "AND "
							+ "entry_id = ? "
							+ "AND "
							+ "customer_id = ? "
							+ "AND "
							+ "payment_promise_date = STR_TO_DATE(?,'%d-%M-%Y')";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setFloat(1, this.getOutstandingAmount());
					preparedStatement.setString(2, this.getPaymentPromiseDate());
					preparedStatement.setString(3, this.getComments());
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					preparedStatement.setString(6, entryId);
					preparedStatement.setString(7, custId);
					preparedStatement.setString(8, keyPromiseDate);
					
					int k = preparedStatement.executeUpdate();
					
					
					if(k>0)
					{
						addActionMessage("Reminder details updated Successfully!");
						
						result = SUCCESS;
						
						this.setCustomerPaymentReminderList(GetNotificationList.getCustPaymentReminderList(this.getSessionMap()));
		        		
		        		this.getSessionMap().replace("customerpaymentnotificationlist",this.getCustomerPaymentReminderList());
		        
					}
					else
					{
						
						addActionError("Reminder details not updated! Please try again!");
						result = ERROR;
					}
					
					
				}
				catch (SQLException e) {
					result = ERROR;
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Reminder details not updated !");
				}
				catch (Exception e) {
					result = ERROR;
					
					addActionError(e.getMessage() +" || Reminder details not updated !");
				}
				finally {
					
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	public String getPaymentReminderAddDate() {
		return paymentReminderAddDate;
	}


	public void setPaymentReminderAddDate(String paymentReminderAddDate) {
		this.paymentReminderAddDate = paymentReminderAddDate;
	}


	public String getCustomerName() {
		return customerName;
	}


	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	public Float getOutstandingAmount() {
		return outstandingAmount;
	}


	public void setOutstandingAmount(Float outstandingAmount) {
		this.outstandingAmount = outstandingAmount;
	}


	public String getPaymentPromiseDate() {
		return paymentPromiseDate;
	}


	public void setPaymentPromiseDate(String paymentPromiseDate) {
		this.paymentPromiseDate = paymentPromiseDate;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public ArrayList<CustomerPaymentReminderDetailsDAO> getCustomerPaymentReminderList() {
		return customerPaymentReminderList;
	}


	public void setCustomerPaymentReminderList(ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList) {
		this.customerPaymentReminderList = customerPaymentReminderList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}