package com.stonecrusher.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.CheckAlreadyAvailable;


public class UpdateCustomer  extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -5130010812118775769L;
	
	private HttpSession session;
	private String custAddDate;
	private String custName;
	private String custMobileNumber;
	private String GSTINumber;
	private String TINumber;
	private String PANumber;
	private String billingAddress;
	private String birthDate;
	private String creditLimit;
	private String key;
	private String custSecondaryMobileNumber;
	private File customerImage;
	private String custNameMarathi;
	private String billingAddressMrathi;
	private String pinCode;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

	        	customerSearchOptionList.put("BYNAME", "BY NAME");
				customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
				customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setDefaultValue("BYNAME");
				setCustomerSearchOption("BYNAME");
				
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
			
			
				String custId = EncryptionDecryption.decrypt(key);
				String sql = "";
				String db = (String) session.getAttribute("db");
				FileInputStream fis = null;
				if(this.getCustomerImage() != null)
				{
				  fis =  new FileInputStream(this.getCustomerImage());
				}
					try
					{
						
						this.setTINumber("NA");
						
						connection = GetDBConnection.getDBConnection(db);
						
						if(getGSTINumber().equals(""))
						{
							setGSTINumber("NA");
						}
						if(getTINumber().equals(""))
						{
							setTINumber("NA");
						}
						if(getPANumber().equals(""))
						{
							setPANumber("NA");
						}
						if(getCreditLimit().equals(""))
						{
							setCreditLimit("0");
						}
						if(this.getCustomerImage() != null)
						{
							sql = "UPDATE crusher_customer_master "
									+ "set "
									+ "customer_name=?,"
									+ "cust_name_marathi=?,"
									+ "mobile_number=?,"
									+ "cust_secondary_mobile=?,"
									+ "gst_number=?,"
									+ "pan_number=?,"
									+ "tin_number=?,"
									+ "billing_address=?,"
									+ "billing_address_marathi=?,"
									+ "birth_date=STR_TO_DATE(?, '%d-%m-%Y'),"
									+ "credit_limit=?,"
									+ "customer_image=?,"
									+ "pincode_number=?,"
									+ "customer_status=?"
									+ "WHERE "
									+ "customer_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";

									
							
							preparedStatement = connection.prepareStatement(sql);						
						
							preparedStatement.setString(1, this.getCustName().trim().toUpperCase());
							preparedStatement.setString(2, this.getCustNameMarathi());
							preparedStatement.setString(3, this.getCustMobileNumber().trim());
							preparedStatement.setString(4, this.getCustSecondaryMobileNumber().trim());
							preparedStatement.setString(5, this.getGSTINumber().trim());
							preparedStatement.setString(6, this.getPANumber().trim());
							preparedStatement.setString(7, this.getTINumber().trim());
							preparedStatement.setString(8, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(9, this.getBillingAddressMrathi());
							preparedStatement.setString(10, this.getBirthDate());
							preparedStatement.setString(11, this.getCreditLimit());
							preparedStatement.setBinaryStream(12, fis,(int)getCustomerImage().length() );
							preparedStatement.setString(13, this.getPinCode().trim());
							preparedStatement.setString(14, "ACTIVE");
							preparedStatement.setString(15, custId);
							preparedStatement.setString(16, crusherId);
							preparedStatement.setString(17, crusherCode);

						}
						else
						{
							sql = "UPDATE crusher_customer_master "
									+ "set "
									+ "customer_name=?,"
									+ "cust_name_marathi=?,"
									+ "mobile_number=?,"
									+ "cust_secondary_mobile=?,"
									+ "gst_number=?,"
									+ "pan_number=?,"
									+ "tin_number=?,"
									+ "billing_address=?,"
									+ "billing_address_marathi=?,"
									+ "birth_date=STR_TO_DATE(?, '%d-%m-%Y'),"
									+ "credit_limit=?,"
									+ "pincode_number=?,"
									+ "customer_status=? "
									+ "WHERE "
									+ "customer_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";

									
							
							preparedStatement = connection.prepareStatement(sql);						
						
							preparedStatement.setString(1, this.getCustName().trim().toUpperCase());
							preparedStatement.setString(2, this.getCustNameMarathi());
							preparedStatement.setString(3, this.getCustMobileNumber().trim());
							preparedStatement.setString(4, this.getCustSecondaryMobileNumber().trim());
							preparedStatement.setString(5, this.getGSTINumber().trim());
							preparedStatement.setString(6, this.getPANumber().trim());
							preparedStatement.setString(7, this.getTINumber().trim());
							preparedStatement.setString(8, this.getBillingAddress().trim().toUpperCase());
							preparedStatement.setString(9, this.getBillingAddressMrathi());
							preparedStatement.setString(10, this.getBirthDate());
							preparedStatement.setString(11, this.getCreditLimit());
							preparedStatement.setString(12, this.getPinCode().trim());
							preparedStatement.setString(13, "ACTIVE");
							preparedStatement.setString(14, custId);
							preparedStatement.setString(15, crusherId);
							preparedStatement.setString(16, crusherCode);

						}
						
						
						int i = preparedStatement.executeUpdate();
						
						
						if(i>0)
						{
							result = "success";
							addActionMessage(this.getText("message.success.customerDetailsUpdatedSuccessfully"));
						}
						else
						{
							result = "error";
							addActionError(this.getText("message.error.errorCustomerDetailsNotUpdatedPlzTryAgain"));
						}
						
						
						
					}catch (SQLException e) {
						result = "error";
						//e.printStackTrace();
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.customerDetailsNotUpdated"));
					} catch (IOException e) {
						//e.printStackTrace();
						result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.customerDetailsNotUpdated"));
					}finally {
						
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        	
	        	if(fis != null)
	        	{
	        		try
	        		{
	        			fis.close();
	        			fis = null;
	        		}
	        		catch(IOException ioe)
	        		{
	        			
	        		}
	        	}
	        	
	        	
	        }
	        return result;
	}

	
	public void validate() {
		
		if(getCustName().equals("") || getCustMobileNumber().equals("") || getBillingAddress().equals(""))
		{
			addActionError(this.getText("message.error.PlzProvideDetailsForFields*Astrick"));
		}
		
		if(!hasActionErrors())
		{
			if(!getCustMobileNumber().equals(""))
			{
				if(getCustMobileNumber().length() >10)
				{
					addActionError(this.getText("message.error.plzProvideCorrectMobileNumber(10digit)"));
				}
			}
		}
		
		if(!hasActionErrors())
		{
			if(!getCreditLimit().equals(""))
			{
				try
				{
					Integer.parseInt(getCreditLimit());
					
				}catch(NumberFormatException nfe)
				{
					addActionError(this.getText("message.error.plzProvideCorrectCreditLimit"));
				}
			}
		}
		
		String custId = EncryptionDecryption.decrypt(key);
		String condition = "AND customer_id <> '"+custId+"'";
		
		if(!hasActionErrors())
		{
			if(!this.getCustMobileNumber().equals("9999999999"))
			{
				String isAliasAdded = "false";
				
				String [] result = new String[2];
				
				
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "mobile_number", condition , this.getCustMobileNumber());
				
				isAliasAdded = result[0];
				
				if(isAliasAdded.equals("true"))
				{
					addActionError(this.getText("message.error.customerIsAlreadyAddedWithSameMobile"));
				}	
			}
			
		}
		
		if(!hasActionErrors())
		{
			if(!this.getGSTINumber().equals("NA"))
			{
				String isAliasAdded = "false";
				
				String [] result = new String[2];
				
				result = new CheckAlreadyAvailable().checkAvaibility("crusher_customer_master", "gst_number", condition , this.getGSTINumber().trim().toUpperCase());
				
				isAliasAdded = result[0];
				
				if(isAliasAdded.equals("true"))
				{
					addActionError(this.getText("message.error.customerIsAlreadyAddedWithSameGstNumber"));
				}				
			}
		}
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getCustAddDate() {
		return custAddDate;
	}


	public void setCustAddDate(String custAddDate) {
		this.custAddDate = custAddDate;
	}


	public String getCustName() {
		return custName;
	}


	public void setCustName(String custName) {
		this.custName = custName;
	}


	public String getCustMobileNumber() {
		return custMobileNumber;
	}


	public void setCustMobileNumber(String custMobileNumber) {
		this.custMobileNumber = custMobileNumber;
	}




	public String getCreditLimit() {
		return creditLimit;
	}


	public void setCreditLimit(String creditLimit) {
		this.creditLimit = creditLimit;
	}


	public String getGSTINumber() {
		return GSTINumber;
	}


	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}


	public String getTINumber() {
		return TINumber;
	}


	public void setTINumber(String tINumber) {
		TINumber = tINumber;
	}


	public String getPANumber() {
		return PANumber;
	}


	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}




	public String getBillingAddress() {
		return billingAddress;
	}


	public void setBillingAddress(String billingAddress) {
		this.billingAddress = billingAddress;
	}


	public String getBirthDate() {
		return birthDate;
	}


	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}


	public File getCustomerImage() {
		return customerImage;
	}


	public void setCustomerImage(File customerImage) {
		this.customerImage = customerImage;
	}


	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}


	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}


	public String getCustomerSearchOption() {
		return customerSearchOption;
	}


	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public String getCustSecondaryMobileNumber() {
		return custSecondaryMobileNumber;
	}


	public void setCustSecondaryMobileNumber(String custSecondaryMobileNumber) {
		this.custSecondaryMobileNumber = custSecondaryMobileNumber;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getCustNameMarathi() {
		return custNameMarathi;
	}


	public void setCustNameMarathi(String custNameMarathi) {
		this.custNameMarathi = custNameMarathi;
	}


	public String getBillingAddressMrathi() {
		return billingAddressMrathi;
	}


	public void setBillingAddressMrathi(String billingAddressMrathi) {
		this.billingAddressMrathi = billingAddressMrathi;
	}


	public String getPinCode() {
		return pinCode;
	}


	public void setPinCode(String pinCode) {
		this.pinCode = pinCode;
	}
	
	
	
	

}
