package com.stonecrusher.update;


import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class UpdateCompanySettings extends ActionSupport implements SessionAware, ServletResponseAware, ServletRequestAware{

	

	/**
	 * 
	 */
	private static final long serialVersionUID = 7890027431045939241L;

	private SessionMap<String,Object> sessionMap;
	
	private String addSideBarJs;
	private String customerCareNumber;
	private String GSTNumber;
	private File leftLogoPDF;
	private File rightLogoPDF;
	private File ownerSignImagePDF;
	private File companyStampImagePDF;
	
    private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	private Map<String,String> CompanyDetailsDisplayList = new HashMap<String,String>();
	private String companyDetailsDisplay;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		      
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    		  
		    	  }
		      }
		     
		      

				 this.setAddSideBarJs("FALSE");
				 	
			  
		    	  
				
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				
				 String crusherId = (String) this.getSessionMap().get("crusherId");
					String crusherCode = (String) this.getSessionMap().get("crusherCode");

				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "UPDATE "
							+ "crusher_info_master "
							+ "SET "
							+ "customer_care_number = ? ,"
							+ "crusher_gst_number = ?,"
							+ "discount_type = ?,"
							+ "company_details_display_in_thermal_bill_print = ? "
							+ "WHERE "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ?";
					
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getCustomerCareNumber().trim());
					preparedStatement.setString(2, this.getGSTNumber().trim());
					preparedStatement.setString(3, this.getDiscountType().trim());
					preparedStatement.setString(4, this.getCompanyDetailsDisplay());
					preparedStatement.setString(5, crusherId);
					preparedStatement.setString(6, crusherCode);
					
					int rowCount = preparedStatement.executeUpdate();
					
					if(rowCount > 0)
					{
						
						FileInputStream leftLogoFileFis  = null;
						FileInputStream rightLogoFileFis  = null;
						FileInputStream ownerSignFileFis = null;
						FileInputStream companyStampFileFis = null;
						
						
						if(this.getLeftLogoPDF() != null)
						{
							leftLogoFileFis =  new FileInputStream(this.getLeftLogoPDF());
						}
						if(this.getRightLogoPDF() != null)
						{
							rightLogoFileFis =  new FileInputStream(this.getRightLogoPDF());
						}
						
						if(this.getOwnerSignImagePDF() != null)
						{
							ownerSignFileFis =  new FileInputStream(this.getOwnerSignImagePDF());
						}
						if(this.getCompanyStampImagePDF() != null)
						{
							companyStampFileFis =  new FileInputStream(this.getCompanyStampImagePDF());
						}
						
						
						
						
						if(this.getLeftLogoPDF() != null)
						{
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
								
							
							sql = "UPDATE "
								+ "crusher_info_master "
								+ "SET "
								+ "left_logo_file = ? "
								+ "WHERE "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setBinaryStream(1, leftLogoFileFis,(int)this.getLeftLogoPDF().length() );
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						 preparedStatement.executeUpdate();
						 
						
						 
						 byte[] leftLogoBytes = IOUtils.toByteArray(leftLogoFileFis);
						 
						  this.getSessionMap().put("left_logo_image_array",leftLogoBytes); 
						  
						
							
						}
						
						if(this.getRightLogoPDF() != null)
						{
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
						
							
							
								
							
							sql = "UPDATE "
								+ "crusher_info_master "
								+ "SET "
								+ "right_logo_file = ? "
								+ "WHERE "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setBinaryStream(1, rightLogoFileFis,(int)this.getRightLogoPDF().length() );
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						 preparedStatement.executeUpdate();
						 
						 
						 byte[] rightLogoBytes = IOUtils.toByteArray(rightLogoFileFis);
						  this.getSessionMap().put("right_logo_image_array",rightLogoBytes); 
						  
						  
						}
						
						
						
						if(this.getOwnerSignImagePDF() != null)
						{
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
						
							
							
								
							
							sql = "UPDATE "
								+ "crusher_info_master "
								+ "SET "
								+ "owner_sign_image_file = ? "
								+ "WHERE "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setBinaryStream(1, ownerSignFileFis,(int)this.getOwnerSignImagePDF().length() );
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						 preparedStatement.executeUpdate();
						 
						  byte[] ownerSignImageBytes = IOUtils.toByteArray(ownerSignFileFis);
						  this.getSessionMap().put("owner_sign_image_array",ownerSignImageBytes); 
						  
						  
						  
						}
						
						if(this.getCompanyStampImagePDF() != null)
						{
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
						
							
							
								
							
							sql = "UPDATE "
								+ "crusher_info_master "
								+ "SET "
								+ "comany_stamp_image_file = ? "
								+ "WHERE "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setBinaryStream(1, companyStampFileFis,(int)this.getCompanyStampImagePDF().length() );
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						 preparedStatement.executeUpdate();
						 
						 byte[] companyStampImageBytes = IOUtils.toByteArray(companyStampFileFis);
						  this.getSessionMap().put("company_stamp_image_array",companyStampImageBytes); 
						  
						  
						  
						}
						
						    this.getSessionMap().put("crushercustcarenumber", this.getCustomerCareNumber());
						    this.getSessionMap().put("crushergstnumber", this.getGSTNumber());
						    this.getSessionMap().put("discountTypeForBilling", this.getDiscountType());
						    this.getSessionMap().put("companyDetailsDisplayInThermalBillPrint", this.getCompanyDetailsDisplay());
						    if(requestFromAndroid)
				    		{
				    			result = "android-success";
				    		}
				    		else
				    		{
				    			result = "success";
				    		}  
					
						addActionMessage(this.getText("message.success.settingsUpdatedSuccessfully"));
					}
					else
					{
						if(requestFromAndroid)
			    		{
			    			result = "android-error";
			    		}
			    		else
			    		{
			    			result = "error";
			    		}
						addActionError(this.getText("message.error.settingsNotUpdatedPlzTryAgain"));
					}
					
					
				}
				catch (SQLException e) {
					if(requestFromAndroid)
		    		{
		    			result = "android-error";
		    		}
		    		else
		    		{
		    			result = "error";
		    		}
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					if(requestFromAndroid)
		    		{
		    			result = "android-error";
		    		}
		    		else
		    		{
		    			result = "error";
		    		}
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
				
	        	
	        }
	        
	        return result;
	}
	
	

	public void validate() {
		
	

		 this.setAddSideBarJs("FALSE");
			
		 discountTypeList.put("", "Select Discount Type");
	      discountTypeList.put("By Quantity", "By Quantity");
	      discountTypeList.put("By Percentage", "By Percentage");
	      discountTypeList.put("By Direct Amount", "By Direct Amount");
		
	      CompanyDetailsDisplayList.put("", "Select");
			CompanyDetailsDisplayList.put("YES", "YES");
			CompanyDetailsDisplayList.put("NO", "NO");
		    
			
			
		if(this.getCustomerCareNumber() == null || this.getCustomerCareNumber().equals(""))
		{
			addActionError(this.getText("message.error.plzProvideCustomerCareNumber"));
		}
		
		if(!hasActionErrors())
		{
			if(this.getGSTNumber() == null || this.getGSTNumber().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideCompanyGstNumber"));
				
			}
		}
		
		
		if(!hasActionErrors())
		{
			if(this.getDiscountType() == null || this.getDiscountType().equals(""))
			{
				addActionError(this.getText("message.error.plzProvideDiscountType"));
				
			}
		}
		
		
		
	}
	
	


	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	@Override
	public void setServletRequest(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		this.request = arg0;
	}



	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		this.response = arg0;
	}



	public HttpServletRequest getRequest() {
		return request;
	}



	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}



	public HttpServletResponse getResponse() {
		return response;
	}



	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public String getCustomerCareNumber() {
		return customerCareNumber;
	}



	public void setCustomerCareNumber(String customerCareNumber) {
		this.customerCareNumber = customerCareNumber;
	}





	public File getLeftLogoPDF() {
		return leftLogoPDF;
	}



	public void setLeftLogoPDF(File leftLogoPDF) {
		this.leftLogoPDF = leftLogoPDF;
	}



	public File getRightLogoPDF() {
		return rightLogoPDF;
	}



	public void setRightLogoPDF(File rightLogoPDF) {
		this.rightLogoPDF = rightLogoPDF;
	}



	public File getOwnerSignImagePDF() {
		return ownerSignImagePDF;
	}



	public void setOwnerSignImagePDF(File ownerSignImagePDF) {
		this.ownerSignImagePDF = ownerSignImagePDF;
	}



	public File getCompanyStampImagePDF() {
		return companyStampImagePDF;
	}



	public void setCompanyStampImagePDF(File companyStampImagePDF) {
		this.companyStampImagePDF = companyStampImagePDF;
	}



	public String getGSTNumber() {
		return GSTNumber;
	}



	public void setGSTNumber(String gSTNumber) {
		GSTNumber = gSTNumber;
	}



	public String getDiscountType() {
		return discountType;
	}



	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}



	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}



	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}



	public Map<String, String> getCompanyDetailsDisplayList() {
		return CompanyDetailsDisplayList;
	}



	public void setCompanyDetailsDisplayList(Map<String, String> companyDetailsDisplayList) {
		CompanyDetailsDisplayList = companyDetailsDisplayList;
	}



	public String getCompanyDetailsDisplay() {
		return companyDetailsDisplay;
	}



	public void setCompanyDetailsDisplay(String companyDetailsDisplay) {
		this.companyDetailsDisplay = companyDetailsDisplay;
	}

   

}



