package com.stonecrusher.update;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class BillUpdateAndPrint extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3432314472279303591L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private BillInformationDAO billInfoDAO = null;
	private List<BillProductInfoDAO> productInfoList = null;	
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String billNumber;
	private String billDateTime;
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private String chalanNumber;
	private String totalPaybleAmount;
	private Float amountPaid;
	private Float transportCharge;
	private String returnAmount;
	private String alternateMobileNumber;
	private boolean sendSMS;
	
	private boolean billSaved;
	
	@SuppressWarnings("unchecked")
	public String execute() {
		
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

        		String fullUserName = (String) session.getAttribute("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	
	        	String billedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		billedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		billedBy =fullUserName;
	        	}
	        	
	        	
	        	if((getAmountPaid() == null || getAmountPaid().equals("")) && (getReturnAmount() == null || getReturnAmount().equals("")))
	        	{
	        		
	        		
	        		productInfoList = (List<BillProductInfoDAO>) sessionMap.get("productList");		        	
		        	billInfoDAO = (BillInformationDAO) sessionMap.get("billInformation");
		        	
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : productInfoList)
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	setCustomerName(billInfoDAO.getCustomerName());
	        		setBillNumber(billInfoDAO.getBillNumber());
	        		setBillType(billInfoDAO.getBillType());
	        		
		        	setTotalAmount(""+floatTotalAmount);	        	
		        	setTotalDiscount(""+floatTotalDiscount);
		        	setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	setDefaultValue(billInfoDAO.getPaymentType());
		        	

		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	billTypeList = GetListResource.GetBillTypeList();
		        	
		        	
		        	addActionError("Please Provide Amount Paid and Amount Return !");
	        		
	        		sessionMap.put("billInformation", billInfoDAO);
	        		sessionMap.put("productList", productInfoList);
	        		result = "error";
		        	
	        	}
	        	else
	        	{
	        		
	        		Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
		        	String billDateTime = dateFormat.format(d);
	        	
		        	
		        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				productInfoList = (List<BillProductInfoDAO>) sessionMap.get("productList");
	        	
	        	billInfoDAO = (BillInformationDAO) sessionMap.get("billInformation");
	        	
	        	//System.out.print("Is Bill Saved : "+billInfoDAO.isBillSaved());
	        	
	        	if(!billInfoDAO.isBillSaved())	        	
	        	{
	        		/*System.out.println("In Save Bill");
	        		
		        	Date d = new Date();
		        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");*/
		        	//String billDateTime = dateFormat.format(d);	        	
		        	
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : productInfoList)
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
	        	try
	        	{
	        		
	        		  java.util.Date date = new java.util.Date();
	        	      long t = date.getTime();	        	     
	        	      java.sql.Time time = new java.sql.Time(t);
	        	      
	        	connection = new GetDBConnection().getDBConnection(db);
	        	connection.setAutoCommit(false);
	        	
	        	String [] custData = new String [5];
        		
        		String custId = "NA";
        		
        		
        		try
        		{
        			custData = billInfoDAO.getCustomerName().split("-");
        			custId = custData[0];
        		}
        		catch(Exception e)
        		{
        			//e.printStackTrace();
        			custId = "NA";
        		}
        		
        		
        		
        		
	        	if(getReturnAmount() == null || getReturnAmount().equals(""))
	        	{
	        		
	        		float amountPaid = 0.0F;
	        		try
	        		{
	        			amountPaid =this.getAmountPaid();
	        			
	        			this.setReturnAmount(""+(floatTotalAmtAfterDiscount-amountPaid));
	        		}
	        		catch(Exception e)
	        		{}
	        		
	        	}
	        	int countBillInfoInserted = 0;
	        	int countBillInfoUpdated = 0;
	        	if(!billInfoDAO.isBillInformationInserted())
	        	{
	        		
	        		float transportChargeFloat = 0.0F;
	        		
	        		try{
	        			transportChargeFloat = billInfoDAO.getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		
	        	sql = "UPDATE "
	        			+ "billinfo"
	        			+ "SET "	        		    			
	        			+ "billtime=?,"
	        			+ "billdate=?,"
	        			+ "paymenttype=?,"
	        			+ "billtype=?,"	        			
	        			+ "transportcharges=?,"
	        			+ "comments=?,"
	        			+ "billtotalamount=?,"
	        			+ "billamountreceived=?,"
	        			+ "amountreturn=?,"	        		
	        			+ "billedby=? "
	        			+ "WHERE "
	        			+ "billnumber = ? "
	        			+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";

	        			
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	
	        
	           	preparedStatement.setTime(1, time);
	        	preparedStatement.setString(2,billInfoDAO.getBillDate());
	        	preparedStatement.setString(3,billInfoDAO.getPaymentType());
	        	preparedStatement.setString(4,billInfoDAO.getBillType());	        	
	        	preparedStatement.setFloat(5,billInfoDAO.getTransportCharge());
	        	preparedStatement.setString(6,billInfoDAO.getComments());
	        	preparedStatement.setString(7,""+(floatTotalAmtAfterDiscount+transportChargeFloat));
	        	preparedStatement.setFloat(8,this.getAmountPaid());
	        	preparedStatement.setString(9,this.getReturnAmount());	        	
	        	preparedStatement.setString(10,billedBy);
	        	preparedStatement.setString(11, billInfoDAO.getBillNumber());
	        	preparedStatement.setString(12, crusherId);
				preparedStatement.setString(13, crusherCode);

	        	countBillInfoInserted = preparedStatement.executeUpdate();
	        	
	        	}
	        	else
	        	{

	        		float transportChargeFloat = 0.0F;
	        		
	        		try{
	        			transportChargeFloat = billInfoDAO.getTransportCharge();
	        		}catch(NumberFormatException nfe)
	        		{}
	        		sql = "UPDATE "
	        				+ "billinfo "
	        				+ "SET "
	        				+ "billtime=?,"
		        			+ "billdate=STR_TO_DATE(?,'%d-%m-%Y'),"
		        			+ "paymenttype=?,"
		        			+ "billtype=?,"
		        			+ "customername=?,"
		        			+ "transportcharges=?,"
		        			+ "comments=?,"
		        			+ "billtotalamount=?,"
		        			+ "billamountreceived=?,"
		        			+ "amountreturn=? "		        			        			
		        			+ "WHERE "
		        			+ "billnumber = ? "
		        			+ "AND "
		        			+ "custid = ? "
		        			+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	        		
	        		preparedStatement = connection.prepareStatement(sql);
		        	
		        	
		        	
		        	
		           	preparedStatement.setTime(1, time);
		        	preparedStatement.setString(2, billDateTime);
		        	preparedStatement.setString(3,billInfoDAO.getPaymentType());
		        	preparedStatement.setString(4,billInfoDAO.getBillType());
		        	preparedStatement.setString(5,billInfoDAO.getCustomerName());
		        	preparedStatement.setFloat(6,billInfoDAO.getTransportCharge());
		        	preparedStatement.setString(7,billInfoDAO.getComments());
		        	preparedStatement.setString(8,""+(floatTotalAmtAfterDiscount+transportChargeFloat));
		        	preparedStatement.setFloat(9,this.getAmountPaid());
		        	preparedStatement.setString(10,this.getReturnAmount());
		        	preparedStatement.setString(11,billInfoDAO.getBillNumber());
		        	preparedStatement.setString(12,custId);   
		        	preparedStatement.setString(13, crusherId);
					preparedStatement.setString(14, crusherCode);

		        	
		        	countBillInfoUpdated = preparedStatement.executeUpdate();
	        		
	        	}
	        	
	        	
	        	
	        	if(countBillInfoInserted>0 || countBillInfoUpdated > 0)
	        	{
	        		
	        		
	        		if(preparedStatement != null)
	        		{
	        			preparedStatement.close();
	        		}
	        		
	        		
	        		sql = "select "
	        				+ "productname "
	        				+ "from "
	        				+ "productbillinfo "
	        				+ "where "
	        				+ "billnumber = '"+billInfoDAO.getBillNumber()+"' "
	        				+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? ";
	        		
	        		
	        		preparedStatement = connection.prepareStatement(sql);
	        		preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);

					resultSet = preparedStatement.executeQuery();
	        		
	        		resultSet.last();
	        		int rowCount = resultSet.getRow();
	        		resultSet.beforeFirst();
	        		
	        		
	        		if(rowCount > 0)
	        		{
	        			if(preparedStatement != null)
		        		{
		        			preparedStatement.close();
		        		}
	        			
	        			sql = "delete from productbillinfo where billnumber = '"+billInfoDAO.getBillNumber()+"' "
	        					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);

	        			preparedStatement.executeUpdate(); 	        			
	        			
	        		}
	        			int productInserted = 0;
	        			for(BillProductInfoDAO productInfoDAO : productInfoList)
	        			{
	        				if(preparedStatement != null)
	    	        		{
	    	        			preparedStatement.close();
	    	        		}
	        			
	        			sql = "insert into productbillinfo "
	        					+ "("
	        					+ "billnumber,"
	        					+ "crusher_id,"
	        					+ "crusher_code,"
	        					+ "productname,"
	        					+ "salesunit,"
	        					+ "taxpercentage,"
	        					+ "salesrate,"
	        					+ "quanity,"
	        					+ "discountpercentage,"
	        					+ "discountrupees,"
	        					+ "productamount,"
	        					+ "productamtafterdiscount,"
	        					+ "grossamount,"
	        					+ "igst,"
	        					+ "cgst,"
	        					+ "sgst,"
	        					+ "productnamemarathi) "
	        					+ "values "
	        					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	        			
	        			preparedStatement = connection.prepareStatement(sql);
	        			
	        			preparedStatement.setString(1, billInfoDAO.getBillNumber());
	        			preparedStatement.setString(2, crusherId);
	        			preparedStatement.setString(3, crusherCode);
	        			preparedStatement.setString(4, productInfoDAO.getProductName());
	        			preparedStatement.setString(5, productInfoDAO.getSalesUnit());
	        			preparedStatement.setString(6, productInfoDAO.getTaxId());
	        			preparedStatement.setFloat(7, productInfoDAO.getSalesRate());
	        			preparedStatement.setFloat(8, productInfoDAO.getQuantity());
	        			preparedStatement.setFloat(9, productInfoDAO.getDiscountPecentage());
	        			preparedStatement.setFloat(10, productInfoDAO.getDiscountRupees());
	        			preparedStatement.setFloat(11, productInfoDAO.getAmount());
	        			preparedStatement.setFloat(12, productInfoDAO.getAmountAfterDiscount());
	        			preparedStatement.setFloat(13, productInfoDAO.getGrossAmount());
	        			preparedStatement.setFloat(14, productInfoDAO.getIgst());
	        			preparedStatement.setFloat(15, productInfoDAO.getCgst());
	        			preparedStatement.setFloat(16, productInfoDAO.getSgst());
	        			preparedStatement.setString(17, productInfoDAO.getProductNameMarathi());
	        			
	        			productInserted = productInserted +  preparedStatement.executeUpdate();
	        			
	        			}
	        			
	        			if(productInserted == productInfoList.size())
	        			{
	        				if(countBillInfoInserted > 0)
	        				{
	        					billInfoDAO.setBillInformationInserted(true);
	        				}
	        				
	        				
	    	        		billInfoDAO.setBillSaved(true);
	    	        		this.setBillSaved(true);
	    	        		this.setBillDateTime(billInfoDAO.getBillDate());
	    	        		this.setCustomerName(billInfoDAO.getCustomerName());
	    	        		this.setBillNumber(billInfoDAO.getBillNumber());
	    	        		this.setBillType(billInfoDAO.getBillType());
	    	        		this.setAlternateMobileNumber(billInfoDAO.getCustomerMobile());
	    	        		this.setSendSMS(billInfoDAO.isSendSMS());
	    	        		this.setTotalAmount(""+floatTotalAmount);	        	
	    	        		this.setTotalDiscount(""+floatTotalDiscount);
	    	        		this.setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
	    		        	
	    	        		paymentTypeList.put("CASH","CASH");
	    		        	paymentTypeList.put("CREDIT","CREDIT");
	    		        	
	    		        	setDefaultValue(billInfoDAO.getPaymentType());
	    		        	

	    		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
	    		        	
	    		        	unitList = GetListResource.GetUnitList();
	    		        	billTypeList = GetListResource.GetBillTypeList();
	    		        	
	    		        	
	    	        		addActionMessage("Bill details Saved Successfully !");
	    	        		connection.commit();
	    	        		sessionMap.put("billInformation", billInfoDAO);
	    	        		sessionMap.put("productList", productInfoList);
	    	        		result = "success";
	    	        		
	    	        		
	    		        	
	        			}
	        			else
	        			{
	        				result = "error";
	        				addActionError("Bill Not Saved Properly !");
	        			}
	        			
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError("Sorry! Bill details not saved!");
	        	}
	        		
	        	}
	        	catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||1 Bill details not Saved Successfully !");
				} catch (IOException e) {
					//e.printStackTrace();
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" ||2 Bill details not Saved Successfully !");
				}finally {
					if(resultSet != null)
	   				{
	   					try {resultSet.close();}catch(SQLException sqe){}   					
	   				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
					}
	        	}
	        	else
	        	{
	        		
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	for(BillProductInfoDAO infoDAO : productInfoList)
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount +infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	
		        	
	        		sessionMap.put("productList", productInfoList);
	        		
	        		setCustomerName(billInfoDAO.getCustomerName());
	        		setBillNumber(billInfoDAO.getBillNumber());
	        		setBillType(billInfoDAO.getBillType());
	        		setTransportCharge(billInfoDAO.getTransportCharge());
	        		//System.out.println(getAlternateMobileNumber());
	        		
	        		setAlternateMobileNumber(billInfoDAO.getCustomerMobile());
	        		setSendSMS(billInfoDAO.isSendSMS());
	        		float transportCharge = 0.0F;
	        		
		        	if(!billInfoDAO.getTransportCharge().equals("")){
		        		
		        		try
		        		{
		        			transportCharge = this.billInfoDAO.getTransportCharge();
		        		}catch(NumberFormatException nfe)
		        		{
		        			addActionError("Please provide correct transportaion amount!");
		        		}
		        	}
		        	
		        	if(!hasActionErrors())
		        	{
			        	setTotalAmount(""+(floatTotalAmount+transportCharge));	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+transportCharge));
			        	addActionMessage("Product added successfully to list !");
		        	}
		        	else
		        	{
		        		setTotalAmount(""+floatTotalAmount);	        	
			        	setTotalDiscount(""+floatTotalDiscount);
			        	setTotalAmouAfterDisount(""+floatTotalAmtAfterDiscount);
			        	addActionMessage("Product added successfully to list !");
		        	}
		        	
	        		paymentTypeList.put("CASH","CASH");
		        	paymentTypeList.put("CREDIT","CREDIT");
		        	
		        	setDefaultValue(billInfoDAO.getPaymentType());
		        	

		        	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
		        	
		        	unitList = GetListResource.GetUnitList();
		        	billTypeList = GetListResource.GetBillTypeList();
		        	sessionMap.put("billInformation", billInfoDAO);
	        		sessionMap.put("productList", productInfoList);
	        		result = "success";
	        		addActionError("Bill Already Saved !");
	        	}
	        	}	
	        }
	       // System.out.print(result);
	        return result;
		
	}
	@SuppressWarnings("unchecked")
	@Override
	public void validate() {
		
		
    	
		if(this.getAmountPaid() == null || this.getAmountPaid().equals(""))
		{
			addActionError("Amount Paid Null ! Bill Cannot be Saved !");
		}
		
		if(!hasActionErrors())
		{
			if(this.getReturnAmount() == null || getReturnAmount().equals(""))
			{
				addActionError("Return amount Null ! Bill Cannot be Saved !");
			}
		}
		

		productInfoList = (List<BillProductInfoDAO>) sessionMap.get("productList");		        	
    	billInfoDAO = (BillInformationDAO) sessionMap.get("billInformation");
    	
    	float floatTotalAmount = 0.0F;
    	float floatTotalDiscount = 0.0F;
    	float floatTotalAmtAfterDiscount = 0.0F;
    	
    	for(BillProductInfoDAO infoDAO : productInfoList)
    	{
    		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
    		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
    		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
    		
    	}
    	
    	setTransportCharge(billInfoDAO.getTransportCharge());
    	setCustomerName(billInfoDAO.getCustomerName());
		setBillNumber(billInfoDAO.getBillNumber());
		setBillType(billInfoDAO.getBillType());
		setBillDateTime(billInfoDAO.getBillDate());
		setChalanNumber(billInfoDAO.getChalanNumber());
		float transportCharge = 0.0F;
		if(!billInfoDAO.getTransportCharge().equals("")){
    		
    		try
    		{
    			transportCharge = this.billInfoDAO.getTransportCharge();
    		}catch(NumberFormatException nfe)
    		{
    			addActionError("Please provide correct transportaion amount!");
    		}
    	}
    	
    	if(!hasActionErrors())
    	{
        	setTotalAmount(""+(floatTotalAmount+transportCharge));	        	
        	setTotalDiscount(""+floatTotalDiscount);
        	setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+transportCharge));
        	addActionMessage("Product added successfully to list !");
    	}
    	
		paymentTypeList.put("CASH","CASH");
    	paymentTypeList.put("CREDIT","CREDIT");
    	
    	setDefaultValue(billInfoDAO.getPaymentType());
    	

    	try {taxList = GetListResource.GetTaxList();}catch (IOException e) {}
    	
    	unitList = GetListResource.GetUnitList();
    	billTypeList = GetListResource.GetBillTypeList();
    	
    	if(!hasActionErrors())
    	{
    		if(this.getBillInfoDAO().getPaymentType().equals("CASH"))
    		{
    			if(this.getAmountPaid() <  floatTotalAmtAfterDiscount)
    			{
    				addActionError("Bill type is cash! Paid amount cannot be less than amount payble!");
    			}
    				
    		}
    		else if(this.getBillInfoDAO().getPaymentType().equals("CREDIT"))
    		{
    			if(this.getAmountPaid() > 0)
    			{
    				addActionError("Bill type is credit! Paid amount cannot be more than 0!");
    			}
    		}
    	}
    	
		
		sessionMap.put("billInformation", billInfoDAO);
		sessionMap.put("productList", productInfoList);
	}
	
	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}

	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}

	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}
	
	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}

	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getTotalDiscount() {
		return totalDiscount;
	}

	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}

	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}

	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}

	public String getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public void setTotalPaybleAmount(String totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	
	


	public Float getAmountPaid() {
		return amountPaid;
	}
	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}
	public String getReturnAmount() {
		return returnAmount;
	}

	public void setReturnAmount(String returnAmount) {
		this.returnAmount = returnAmount;
	}



	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}



	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}



	public boolean isSendSMS() {
		return sendSMS;
	}



	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}
	public boolean isBillSaved() {
		return billSaved;
	}
	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}
	public String getBillDateTime() {
		return billDateTime;
	}
	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getChalanNumber() {
		return chalanNumber;
	}
	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}
	public Float getTransportCharge() {
		return transportCharge;
	}
	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}
	
	
}
