package com.stonecrusher.resource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;

import com.stonecrusher.db.GetDBConnection;

public class GetListResource {
	
	private static HttpSession session;
	private static HttpServletResponse response;
	
	public static HashMap<String,String> getVehicleList(boolean withAll, SessionMap<String, Object> sessionMap)
	{
		HashMap<String,String> vehicleList = new HashMap<String,String>();
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		String sql = "";
		
		String db = (String) sessionMap.get("db");
		try
		{
			
			connection = GetDBConnection.getDBConnection(db);					
			
			
			sql = "SELECT "
					+ "vehicle_id,"
					+ "vehicle_make,"
					+ "vehicle_registration_number "
					+ "FROM "
					+ "crusher_vehicle_details_master " 
					+ "WHERE "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ? ";

			
			preparedStatement = connection.prepareStatement(sql);
			preparedStatement.setString(1, crusherId);
			preparedStatement.setString(2, crusherCode);

			
			resultSet = preparedStatement.executeQuery();
			if(withAll)
			{
				vehicleList.put("ALL", "ALL");
			}
			while(resultSet.next())
			{
				vehicleList.put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
			}
		
    } catch (SQLException e) {
		
	} catch (IOException e) {
	
	}finally {

		if(resultSet != null)
		{
			try {
				resultSet.close(); resultSet = null;
			} catch (SQLException e) {
				
			}
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		}
		if(connection != null)
		{
			
			try {connection.close(); connection = null;}catch (SQLException e) {}
		}
		
	}
		
		return vehicleList;
	}
	
	
	
	
	public static HashMap<String,String> getRMCIngreProductMappList(SessionMap<String, Object> sessionMap, Connection connection)
	{
		HashMap<String,String> productMapList = new HashMap<String,String>();
	
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		String crusherId = (String) sessionMap.get("crusherId");
		String crusherCode = (String) sessionMap.get("crusherCode");

		String sql = "";
		try
		{
			
			
			
			sql = "SELECT "
					+ "product_name_used_in_billing,"
					+ "product_id,"
					+ "product_name_as_per_master "
					+ "FROM "
					+ "crusher_rmc_product_name_id_mapping_master " 
					+ "WHERE "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ? ";

			
			preparedStatement = connection.prepareStatement(sql);
			preparedStatement.setString(1, crusherId);
			preparedStatement.setString(2, crusherCode);

			resultSet = preparedStatement.executeQuery();
		
			while(resultSet.next())
			{
				productMapList.put(resultSet.getString(1), resultSet.getString(2)+"#"+resultSet.getString(3));
			}
		
    } catch (SQLException e) {
    	e.printStackTrace();
		
	} finally {

		if(resultSet != null)
		{
			try {
				resultSet.close(); resultSet = null;
			} catch (SQLException e) {
				
			}
		}
		if(preparedStatement != null)
		{
			try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		}
	
		
	}
		
		return productMapList;
	}
	
	
	public static HashMap<String,String> getAccountHeadList()
	{
		HashMap<String,String> accountHeadList = new LinkedHashMap<String,String>();
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		if(session != null)
		{
					String db = (String) session.getAttribute("db");
					String crusherId = (String) session.getAttribute("crusherId");
					String crusherCode = (String) session.getAttribute("crusherCode");

					try
					{
						
						connection = GetDBConnection.getDBConnection(db);					
						
						sql = "SELECT "
								+ "head_entry_id,"
								+ "head_name "
								+ "FROM "
								+ "crusher_daily_expenses_head_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "head_name";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
             
						resultSet = preparedStatement.executeQuery();
						
						accountHeadList.put("ALL","ALL");
						
						while(resultSet.next())
						{
							accountHeadList.put(resultSet.getString(1),resultSet.getString(2));
						}
					
			    } catch (SQLException e) {
					
				} catch (IOException e) {
				
				}finally {

					if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
			}
			
		return accountHeadList;
	}

	public static HashMap<String,String> getSiteList()
	{
		HashMap<String,String> siteList = new LinkedHashMap<String,String>();
		
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");

		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		if(session != null)
		{
					String db = (String) session.getAttribute("db");
					
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);					
						
						sql = "SELECT "
								+ "site_code,"
								+ "site_name "
								+ "FROM "
								+ "side_details_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY "
								+ "site_name";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						
						resultSet = preparedStatement.executeQuery();
						
						siteList.put("ALL","ALL");
						
						while(resultSet.next())
						{
							siteList.put(resultSet.getString(1),resultSet.getString(2));
						}
					
			    } catch (SQLException e) {
					
				} catch (IOException e) {
				
				}finally {

					if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
			}
			
		return siteList;
	}
	
	public static final Map<String,String> GetTaxList() throws IOException
	{
		Map<String,String> taxList = new LinkedHashMap<String,String>();
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");
		
		
		
		if(session != null)
		{
					String db = (String) session.getAttribute("db");
					
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);					
						
						sql = "SELECT "
								+ "tax_id,"
								+ "tax_name "
								+ "FROM "
								+ "crusher_tax_table "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY tax_name";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						while(resultSet.next())
						{
							taxList.put(resultSet.getString(1),resultSet.getString(2));
						}
					
			    } catch (SQLException e) {
					
				} catch (IOException e) {
				
				}finally {

					if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet= null;
						} catch (SQLException e) {
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection= null;}catch (SQLException e) {}
					}
					
				}
			}
			else
			{
				response.sendRedirect("login.jsp");
			}
		return taxList;
	}
	
	public static final HashMap<String,String> GetTaxNamePercentage(String taxId)
	{
		HashMap<String,String> taxInfo = new HashMap<String,String>();
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");
		
		
		
		if(session != null)
		{
					String db = (String) session.getAttribute("db");
					
					try
					{
						connection = GetDBConnection.getDBConnection(db);		
						
						sql = "SELECT tax_percentage,tax_name "
								+ "FROM crusher_tax_table "
								+ "WHERE tax_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
						
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, taxId);
						preparedStatement.setString(2, crusherId);
						preparedStatement.setString(3, crusherCode);
						
						
						resultSet = preparedStatement.executeQuery();
						
						while(resultSet.next())
						{
							taxInfo.put("TAX-NAME", resultSet.getString(2));
							taxInfo.put("TAX-PERCENTAGE", resultSet.getString(1));
							
						}
					
			} catch (SQLException e) {
				
			} catch (IOException e) {
			
			}finally {

				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet= null;
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
		}
		
		return taxInfo;
		
	}
	public static final Map<String,String> GetSupplierList() throws IOException
	{
		Map<String,String> supplierList = new LinkedHashMap<String,String>();
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");

		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		if(session != null)
		{
					String db = (String) session.getAttribute("db");
					
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);					
						
						sql = "SELECT "
								+ "supplier_id,"
								+ "supplier_name "
								+ "FROM "
								+ "crusher_supplier_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY supplier_name";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
                        resultSet = preparedStatement.executeQuery();
						
						while(resultSet.next())
						{
							supplierList.put(resultSet.getString(1),resultSet.getString(2));
						}
					
			    } catch (SQLException e) {
					
				} catch (IOException e) {
				
				}finally {

					if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
			}
			else
			{
				response.sendRedirect("login.jsp");
			}
		return supplierList;
	}
	public static final String getTaxDetailsByTaxId(String taxId)
	{
		String taxDetails="";
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");

		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		if(session != null)
		{

			String db = (String) session.getAttribute("db");
			
			try
			{
			
				connection = GetDBConnection.getDBConnection(db);					
				
				sql = "SELECT "
						+ "tax_name,"
						+ "tax_percentage "
						+ "FROM "
						+ "crusher_tax_table "
						+ "WHERE tax_id = ? "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? ";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, taxId);
				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				

				resultSet = preparedStatement.executeQuery();
				
				if(resultSet.next())
				{
					taxDetails = resultSet.getString(1)+":"+resultSet.getString(2);
					
				}
			
	    } catch (SQLException e) {
			
		} catch (IOException e) {
		
		}finally {

			if(resultSet != null)
			{
				try {
					resultSet.close(); resultSet = null;
				} catch (SQLException e) {
					
				}
			}
			if(preparedStatement != null)
			{
				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
			}
			if(connection != null)
			{
				
				try {connection.close(); connection = null;}catch (SQLException e) {}
			}
			
		}
	}
	else
	{
		try {
			response.sendRedirect("login.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
		
		
		return taxDetails;
	}
	public static final Map<String,String> GetUnitList()
	{
		Map<String,String> unitList = new LinkedHashMap<String,String>();
		
		unitList.put("Brass", "Brass");
		unitList.put("Boxes", "Boxes");
		unitList.put("Bags", "Bags");
		unitList.put("Bottles", "Bottles");
		unitList.put("Bunches", "Bunches");
		unitList.put("Dozen", "Dozen");
		unitList.put("Feet", "Feet");
		unitList.put("Grams", "Grams");
		unitList.put("Kilograms", "Kilograms");
		unitList.put("Liters", "Liters");
		unitList.put("Numbers", "Numbers");
		unitList.put("Quintal", "Quintal");
		unitList.put("Rolls", "Rolls");
		unitList.put("Sets", "Sets");
		unitList.put("Sheets", "Sheets");
		unitList.put("Units", "Units");	
		unitList.put("Bunches", "Bunches");
		unitList.put("Cubic Meter", "Cubic Meter");
		unitList.put("Cubic Centimeter", "Cubic Centimeter");
		unitList.put("Cubic Inches", "Cubic Inches");
		unitList.put("Centimeter", "Centimeter");
		unitList.put("Carton", "Carton");
		unitList.put("Milli Grams", "Milli Grams");
		unitList.put("Metric TON", "Metric TON");
		unitList.put("Packs", "Packs");
		unitList.put("Pieces", "Pieces");
		unitList.put("Square Feet", "Square Feet");
		unitList.put("Square Inches", "Square Inches");
		unitList.put("Square Meter", "Square Meter");
		unitList.put("Tola", "Tola");
		unitList.put("Thousand", "Thousand");
		unitList.put("Tubes", "Tubes");	
		unitList.put("Cans", "Cans");	
		
		return unitList;
	}
	
	public static final Map<String,String> GetUnitShortEnglishName()
	{
		Map<String,String> unitList = new LinkedHashMap<String,String>();
		
		unitList.put("Brass", "Br");
		unitList.put("Boxes", "Bx");
		unitList.put("Bags", "Bgs");
		unitList.put("Bottles", "Btls");
		unitList.put("Bunches", "Bnc");
		unitList.put("Dozen", "Dz");
		unitList.put("Feet", "Ft");
		unitList.put("Grams", "gms");
		unitList.put("Kilograms", "kg");
		unitList.put("Liters", "ltr");
		unitList.put("Numbers", "Nos");
		unitList.put("Quintal", "Qtl");
		unitList.put("Rolls", "Rls");
		unitList.put("Sets", "Sets");
		unitList.put("Sheets", "Sheets");
		unitList.put("Units", "Nos");	
		unitList.put("Bunches", "Bunches");
		unitList.put("Cubic Meter", "CubMtr");
		unitList.put("Cubic Centimeter", "CubCM");
		unitList.put("Cubic Inches", "CubInch");
		unitList.put("Centimeter", "CM");
		unitList.put("Carton", "CTON");
		unitList.put("Milli Grams", "ml");
		unitList.put("Metric TON", "TON");
		unitList.put("Packs", "Pks");
		unitList.put("Pieces", "Pcs");
		unitList.put("Square Feet", "SqFt");
		unitList.put("Square Inches", "SqInch");
		unitList.put("Square Meter", "SqM");
		unitList.put("Tola", "Tola");
		unitList.put("Thousand", "Thns");
		unitList.put("Tubes", "Tubes");	
		unitList.put("Cans", "Cans");	
		
		return unitList;
	}
	public static final Map<String,String> GetBillTypeList()
	{
		Map<String,String> billTypeList = new LinkedHashMap<String,String>();
		
		billTypeList.put("CASH-MEMO", "CASH-MEMO");
		billTypeList.put("BILL-OF-SUPPLY", "BILL-OF-SUPPLY");
		billTypeList.put("TAX-INVOICE", "TAX-INVOICE");
		/*
		 * billTypeList.put("ESTIMATE", "ESTIMATE"); billTypeList.put("QUOTATION",
		 * "QUOTATION");
		 */
		
		
		return billTypeList;
	}
	

	public static final HashMap<String,String> GetBoulderInwardUnitList()
	{
		HashMap<String,String> inwardUnitList = new HashMap<String,String>();
		
		inwardUnitList.put("BRASS", "BRASS");
		inwardUnitList.put("MTON", "METRIC TON");
	
		
		return inwardUnitList;
	}
	
	public static final HashMap<String,String> GetBoulderInwardFromList()
	{
		HashMap<String,String> inwardFromList = new HashMap<String,String>();
		
		inwardFromList.put("QUARRY", "QUARRY");
		inwardFromList.put("STOCK", "STOCK");
	
		
		return inwardFromList;
	}
	
	public static final HashMap<String,String> GetBoulderInwardToList()
	{
		HashMap<String,String> inwardToList = new HashMap<String,String>();
		
		inwardToList.put("HOPPER", "HOPPER");
		inwardToList.put("STOCK", "STOCK");
	
		
		return inwardToList;
	}
	
	
	
	public static HashMap<String,String> getBoulderSupplierList(SessionMap<String, Object> sessionMap)
	{
		HashMap<String,String> boulderSuppList = new LinkedHashMap<String,String>();
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		
					String db = (String) sessionMap.get("db");
					String crusherId = (String) sessionMap.get("crusherId");
					String crusherCode = (String) sessionMap.get("crusherCode");

					try
					{
						
						connection = GetDBConnection.getDBConnection(db);					
						
						sql = "SELECT "
								+ "boulder_supplier_id,"
								+ "boulder_supplier_firm_name "
								+ "FROM "
								+ "crusher_boulder_supplier_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
             
						resultSet = preparedStatement.executeQuery();
						
						while(resultSet.next())
						{
							boulderSuppList.put(resultSet.getString(1),resultSet.getString(2));
						}
					
			    } catch (SQLException e) {
					
				} catch (IOException e) {
				
				}finally {

					if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
			
			
		return boulderSuppList;
	}
	
	
	
	public static List<String> getDieselAdblueProductList()
	{
		List<String> dieselAdblueProductList = new ArrayList<String>();

		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");

		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		session=ServletActionContext.getRequest().getSession(false); 
		response = ServletActionContext.getResponse();
		if(session != null)
		{
					String db = (String) session.getAttribute("db");
					
					try
					{
						
						connection = GetDBConnection.getDBConnection(db);					
						
						sql = "SELECT "
							     + "product_id, "
							     + "product_name_eng "
							     + "FROM "
							     + "crusher_product_master "
							     + "WHERE "
							     + "crusher_id = ? "
							     + "AND "
							     + "crusher_code = ? "
							     + "AND ("
							     + "UPPER(product_name_eng) LIKE '%DIESEL%' "
							     + "OR "
							     + "UPPER(product_name_eng) LIKE '%ADBLUE%'"
							     + ") "
							     + "ORDER BY "
							     + "product_id";

						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						
						resultSet = preparedStatement.executeQuery();
						
						while(resultSet.next()) {
						    String id = resultSet.getString(1);
						    String name = resultSet.getString(2);
						    dieselAdblueProductList.add(id + "-" + name);
						}
   
					
			    } catch (SQLException e) {
					
				} catch (IOException e) {
				
				}finally {

					if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
			}  
			
		return dieselAdblueProductList;
	}
	
	
	
	
}
