package com.stonecrusher.resource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class DataBaseResourceFactory extends ActionSupport implements SessionAware{
	/**
	 * 
	 */
	private static final long serialVersionUID = -7848084714189823301L;
	private String login;
	private String db;
	private Connection connection = null;
	private PreparedStatement  preparedStatement = null;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap; 
	
	
	
	public DataBaseResourceFactory() {
		
		
	}
	
	
	public int getRowCount(String sql)
	{
		try
		{
		session=ServletActionContext.getRequest().getSession(false);
		db = (String) session.getAttribute("db");
		login = (String) session.getAttribute("login");
		setConnection(new GetDBConnection().getDBConnection(db));		
		}catch(Exception e)
		{}		
		
		ResultSet resultSet = null;
		int rowCount = 0;
		
		try
		{
			preparedStatement = getConnection().prepareStatement(sql);
			resultSet = preparedStatement.executeQuery();			
			while(resultSet.next())
			{
			rowCount = resultSet.getInt(1);
			}
			
			
			resultSet.close();
		}
		catch(Exception e)
		{//e.printStackTrace();
		
		}
		finally
		{
			if(resultSet != null)
			{
				try {
					resultSet.close();
				} catch (SQLException e) {
					
				}
			}
			closeConnection();}
		
		
		
		return rowCount;
	}
	
	public ResultSet getResultSet(String sql)
	{
		ResultSet resultSet = null;
		

		try
		{
			preparedStatement = getConnection().prepareStatement(sql);
			resultSet = preparedStatement.executeQuery();			
			
		}
		catch(Exception e)
		{}
		finally
		{closeConnection();}
		
		return resultSet;
	}
	
	public void closeConnection()
	{
		
		if(getPreparedStatement() != null)
		{
			try
			{
				this.preparedStatement.close();
			}
			catch(SQLException sqle)
			{
				
			}
			
		}
		
		if(getConnection() != null)
		{
			try
			{
				this.connection.close();
				
				
			}
			catch(SQLException sqle)
			{
				
			}
		}
	}
	
	
	
	

	


	public String getLogin() {
		return login;
	}



	public void setLogin(String login) {
		this.login = login;
	}



	public String getDb() {
		return db;
	}



	public void setDb(String db) {
		this.db = db;
	}



	


	public Connection getConnection() {
		return connection;
	}


	public void setConnection(Connection connection) {
		this.connection = connection;
	}


	public PreparedStatement getPreparedStatement() {
		return preparedStatement;
	}


	public void setPreparedStatement(PreparedStatement preparedStatement) {
		this.preparedStatement = preparedStatement;
	}


	public HttpSession getSession() {
		return session;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}
