package com.stonecrusher.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemwisePurchaseReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class ItemWisePurchaseReport extends ActionSupport implements SessionAware, ServletResponseAware, ServletRequestAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -835363253445318549L;

	private SessionMap<String,Object> sessionMap; 
	private HttpSession session;
	private String fromDate;
	private String toDate;
	private List<ItemwisePurchaseReportDAO> itemWisePurchaseList = new  ArrayList<ItemwisePurchaseReportDAO>();
	
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	private String addSideBarJs;
	
	public String execute(){
		 
		String result = "login";
		this.setSession(ServletActionContext.getRequest().getSession(false)); 
		
	        if(this.getSession()==null || this.getSession().getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		      
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    		  
		    	  }
		      }
		      
		      this.setAddSideBarJs("FALSE");
		      
		      if(this.getFromDate().equals("") || this.getToDate().equals(""))
				{
		    	  addActionError("Please Select dates");
				}
		      
		      
		      
		      if(!hasActionErrors())
		    	{
					
		    	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet  resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					String crusherId = (String) this.getSessionMap().get("crusherId");
		    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
		    	
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "DATE_FORMAT(cpi.purchase_date,'%d-%m-%Y'),"					
							+ "cpp.purchase_id,"
							+ "cpp.product_name,"
							+ "cpp.purchase_unit,"
							+ "SUM(cpp.purchase_quantity),"
							+ "SUM(cpp.purchase_total_amount_after_discount),"							
							+ "SUM(cpp.purchase_gross_amount),"
							+ "SUM(cpp.purchase_igst_amount),"
							+ "SUM(cpp.purchase_cgst_amount),"
							+ "SUM(cpp.purchase_sgst_amount),"
							+ "cpp.purchase_rate "
							+ "FROM "
							+ "crusher_purchase_master AS cpi "
							+ "INNER JOIN "
							+ "crusher_purchase_product_info_master AS cpp "
							+ "ON "
							+ "cpi.purchase_id = cpp.purchase_id "
							+ "AND "
							+ "cpp.crusher_id = ? "
							+ "AND "
							+ "cpp.crusher_code = ? "
							+ "AND "
							+ "cpi.crusher_id = ? "
							+ "AND "
							+ "cpi.crusher_code = ? "
							+ "AND "						
							+ "(cpi.purchase_date "
							+ "BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
							+ "AND "
							+ "STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "GROUP BY "
							+ "cpp.product_name";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					preparedStatement.setString(5, this.getFromDate());
					preparedStatement.setString(6, this.getToDate());
					
					//System.out.println(preparedStatement.toString());
					resultSet = preparedStatement.executeQuery();
					DecimalFormat df = new DecimalFormat();
					df.setMaximumFractionDigits(2);
					while(resultSet.next())
					{
						ItemwisePurchaseReportDAO purchaseReportDAO =  new ItemwisePurchaseReportDAO();
						purchaseReportDAO.setProductName(resultSet.getString(3));
						purchaseReportDAO.setUnits(resultSet.getString(4));
						purchaseReportDAO.setQuantity(df.format(resultSet.getFloat(5)));
						purchaseReportDAO.setTotalAmount(df.format(resultSet.getFloat(6)));
						purchaseReportDAO.setRate(resultSet.getString(11));
						
						
						this.getItemWisePurchaseList().add(purchaseReportDAO);
						
						
					}
					
					if(requestFromAndroid)
					{
						result = "android-success";
						
					}else
					{
						result = "success";
					}
					
			}catch (SQLException e) 
			{		
				e.printStackTrace();
				if(requestFromAndroid)
				{
					result = "android-error";
					
				}else
				{
					result = "error";
				}
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.purchasedetailscouldnotfound"));
			
			}catch (Exception e) 
			{		
				e.printStackTrace();
				if(requestFromAndroid)
				{
					result = "android-error";
					
				}else
				{
					result = "error";
				}
					
			}
			finally 
			{
				
		    	
				if(resultSet !=null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();
					 connection = null;
					}catch (SQLException e) {}
				}
				
			}
		    	}else {
		    		if(requestFromAndroid)
		    		{
		    			result = "input-android";
		    		}
		    		else
		    		{
		    			result = INPUT;
		    		}
		    	}
        }
        
        
        return result;
}

	@Override
	public void validate() {
		boolean requestFromAndroid = false;
        Map<String, String> map = new HashMap<String, String>();

        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
        
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = this.getRequest().getHeader(key);
            map.put(key, value);
        }
        //Android
      
        String ua = "";
      for(String key:map.keySet())
      {
    	  if(key.equals("user-agent")){
    		  
    		  ua = map.get(key);	    		  
    		
    		  if(ua.contains("Android")){
    			  requestFromAndroid = true;
    		  }
    		  
    	  }
      }
      
      this.setAddSideBarJs("FALSE");
      
      if(!requestFromAndroid)
      	
  	{
		if(this.getFromDate().equals("") || this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzselectdates"));
		}
  	}
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public List<ItemwisePurchaseReportDAO> getItemWisePurchaseList() {
		return itemWisePurchaseList;
	}

	public void setItemWisePurchaseList(List<ItemwisePurchaseReportDAO> itemWisePurchaseList) {
		this.itemWisePurchaseList = itemWisePurchaseList;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	@Override
	public void setServletRequest(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		this.request = arg0;
	}

	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		this.response = arg0;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	
}
