package com.stonecrusher.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemWiseStockDetailsDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetStockReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 873615081827050453L;
	private SessionMap<String,Object> sessionMap;  
	private HttpSession session;
	private List<ItemWiseStockDetailsDAO> productStockList = new ArrayList<ItemWiseStockDetailsDAO>();
	private String totalPurchaseValue;
	private String totalCustSaleValue;
	private String totalDealerSaleValue;
	private String totalRetailSaleValue;
	private boolean addQuantity2;
	
	public String execute() {
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        
	        	DecimalFormat df = new DecimalFormat("##.##");
	        	float totalCustSaleVal = 0.0F;
	        	float totalPurchaseVal = 0.0F;
	        	float totalDealerSaleVal = 0.0F;
	        	float totalRetailSaleVal = 0.0F;
	     
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);
					sql = "SELECT "
							+ "product_name_eng,"
							+ "product_name_mar,"
							+ "product_alias,"
							+ "low_stock_count,"
							+ "in_stock_quantity,"
							+ "(purchase_rate*in_stock_quantity) AS purchase_value,"
							+ "(customer_sales_price*in_stock_quantity) AS cust_sales_alue,"
							+ "(dealer_sales_price*in_stock_quantity) AS dealer_sales_value,"
							+ "(retailer_sales_price*in_stock_quantity) AS retailer_sales_value "
							+ "FROM "
							+ "crusher_product_master "
							+ "WHERE "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
					resultSet = preparedStatement.executeQuery();
					
					while(resultSet.next())
					{
						ItemWiseStockDetailsDAO detailsDAO = new ItemWiseStockDetailsDAO();
						
						detailsDAO.setProductNameEn(resultSet.getString(1));
						detailsDAO.setProductNameMr(resultSet.getString(2));
						detailsDAO.setAlias(resultSet.getString(3));
						detailsDAO.setLowStockCount(resultSet.getString(4));
						detailsDAO.setStock(df.format(resultSet.getFloat(5)));
						detailsDAO.setPurchaseValue(df.format(resultSet.getFloat(6)));
						detailsDAO.setCustSaleValue(df.format(resultSet.getFloat(7)));
						detailsDAO.setDealerSaleValue(df.format(resultSet.getFloat(8)));
						detailsDAO.setRetailerSaleValue(df.format(resultSet.getFloat(9)));
						
							totalPurchaseVal = totalPurchaseVal + resultSet.getFloat(6);
							totalCustSaleVal = totalCustSaleVal + resultSet.getFloat(7);
							totalDealerSaleVal = totalDealerSaleVal + resultSet.getFloat(8);
							totalRetailSaleVal = totalRetailSaleVal + resultSet.getFloat(9);
							this.getProductStockList().add(detailsDAO);
						
						
						
						 
					}
					
					
					this.setTotalCustSaleValue(df.format(totalCustSaleVal));
					this.setTotalPurchaseValue(df.format(totalPurchaseVal));
					this.setTotalDealerSaleValue(df.format(totalDealerSaleVal));
					this.setTotalRetailSaleValue(df.format(totalRetailSaleVal));
					
					result = SUCCESS;
					
				}
				catch (SQLException e) {
					
					e.printStackTrace();
						result = ERROR;
						addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.cannotLoadPage"));

					
				} catch (Exception e) {
					result = ERROR;
					
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.cannotLoadPage"));
				}finally {
					
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;}catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();
						 connection = null;
						}catch (SQLException e) {}
					}
					
				}
	        	
	        		        	
	        }
	        
	        return result;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}


	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public List<ItemWiseStockDetailsDAO> getProductStockList() {
		return productStockList;
	}


	public void setProductStockList(List<ItemWiseStockDetailsDAO> productStockList) {
		this.productStockList = productStockList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getTotalPurchaseValue() {
		return totalPurchaseValue;
	}


	public void setTotalPurchaseValue(String totalPurchaseValue) {
		this.totalPurchaseValue = totalPurchaseValue;
	}


	public String getTotalCustSaleValue() {
		return totalCustSaleValue;
	}


	public void setTotalCustSaleValue(String totalCustSaleValue) {
		this.totalCustSaleValue = totalCustSaleValue;
	}


	public String getTotalDealerSaleValue() {
		return totalDealerSaleValue;
	}


	public void setTotalDealerSaleValue(String totalDealerSaleValue) {
		this.totalDealerSaleValue = totalDealerSaleValue;
	}


	public String getTotalRetailSaleValue() {
		return totalRetailSaleValue;
	}


	public void setTotalRetailSaleValue(String totalRetailSaleValue) {
		this.totalRetailSaleValue = totalRetailSaleValue;
	}


	public boolean isAddQuantity2() {
		return addQuantity2;
	}


	public void setAddQuantity2(boolean addQuantity2) {
		this.addQuantity2 = addQuantity2;
	}


	
	
}
