package com.stonecrusher.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.PurchaseDateWiseReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetPurchaseReport extends ActionSupport implements SessionAware{
	

	/**
	 * 
	 */
	private static final long serialVersionUID = -8510696889700245213L;

	private String fromDate;
	private String toDate;
	private HttpSession session;
	private String supplierName;
	private String addSideBarJs;
	private List<PurchaseDateWiseReportDAO> purchaseList = new ArrayList<PurchaseDateWiseReportDAO>();
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	private float totalBillingAmt;
	private float totalPaidAmt;
	

	private SessionMap<String,Object> sessionMap;  
	
	public String execute(){
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
	        	
	        	
	        	downloadTypeList.add("pdf");
	        	downloadTypeList.add("xl");
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	        	
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			
	    			if(this.getSupplierName().equals(""))
	    			{
	    			
	    			sql = "SELECT "
	    					+ "purchase_id,"
	    					+ "purchase_invoice_number,"
	    					+ "DATE_FORMAT(purchase_date,'%d-%m-%Y'),"
	    					+ "purchase_time,"
	    					+ "payemnt_type,"
	    					+ "purchase_type,"
	    					+ "supplier_id,"
	    					+ "supplier_name,"
	    					+ "tarnsportation_charges,"
	    					+ "other_expenses,"
	    					+ "comments,"
	    					+ "purchase_total_amount,"
	    					+ "purchase_amount_paid,"
	    					+ "purchase_total_igst_amount,"
	    					+ "purchase_total_cgst_amount,"
	    					+ "purchase_total_sgst_amount,"
	    					+ "purchase_total_nett_amount,"
	    					+ "purcahsed_by,"
	    					+ "purchase_invoice_pic,"
	    					+ "purchase_entry_by "
	    					+ "FROM "
	    					+ "crusher_purchase_master "
	    					+ "WHERE "
	    					+ "(purchase_date "
	    					+ "BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') "
	    					+ "AND "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
	    					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? ";
		    			
		    			preparedStatement = connection.prepareStatement(sql);	    			
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, crusherId);
		    			preparedStatement.setString(4, crusherCode);
	    			
	    			}else
	    			{
	    				sql = "SELECT "
	    						+ "purchase_id,"
		    					+ "purchase_invoice_number,"
		    					+ "DATE_FORMAT(purchase_date,'%d-%m-%Y'),"
		    					+ "purchase_time,"
		    					+ "payemnt_type,"
		    					+ "purchase_type,"
		    					+ "supplier_id,"
		    					+ "supplier_name,"
		    					+ "tarnsportation_charges,"
		    					+ "other_expenses,"
		    					+ "comments,"
		    					+ "purchase_total_amount,"
		    					+ "purchase_amount_paid,"
		    					+ "purchase_total_igst_amount,"
		    					+ "purchase_total_cgst_amount,"
		    					+ "purchase_total_sgst_amount,"
		    					+ "purchase_total_nett_amount,"
		    					+ "purcahsed_by,"
		    					+ "purchase_invoice_pic,"
		    					+ "purchase_entry_by "
		    					+ "FROM "
		    					+ "crusher_purchase_master "
		    					+ "WHERE "
		    					+ "supplier_name LIKE '%"+this.getSupplierName().trim()+"%' "
		    					+ "AND "
		    					+ "(purchase_date "
		    					+ "BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') "
		    					+ "AND "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
	    				
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, crusherId);
		    			preparedStatement.setString(4, crusherCode);
		    			
		    			
	    			}
	    			
	    			
	    		
	    			
	    			resultSet = preparedStatement.executeQuery();
	    			
	    			int rowCount = 0;
	    			
	    			resultSet.last();
	    			rowCount = resultSet.getRow();
	    			resultSet.beforeFirst();
	    	
	    			if(rowCount > 0 )
	    			{
	    				while(resultSet.next())
	    				{
	    					PurchaseDateWiseReportDAO dao = new PurchaseDateWiseReportDAO();
	    					dao.setPurchaseNumber(resultSet.getString(1));
	    					dao.setInvoiceNumber(resultSet.getString(2));
	    					dao.setPurchaseDate(resultSet.getString(3));
	    					dao.setPaymentType(resultSet.getString(5));
	    					dao.setPurchaseType(resultSet.getString(6));
	    					dao.setSupplierId(resultSet.getString(7));
	    					dao.setSupplierName(resultSet.getString(8));
	    					dao.setTransportChages(resultSet.getString(9));
	    					dao.setOtherExpenses(resultSet.getString(10));
	    					dao.setComments(resultSet.getString(11));
	    					dao.setTotalPurchaseAmount(resultSet.getString(12));
	    					dao.setTotalPurchaseAmountPaid(resultSet.getString(13));
	    					dao.setTotalCGST(resultSet.getString(14));
	    					dao.setTotalSGST(resultSet.getString(15));
	    					dao.setTotalIGST(resultSet.getString(16));
	    					dao.setTotalNettAmount(resultSet.getString(17));
	    					dao.setPurchaseBy(resultSet.getString(18));
	    					
	    					
	    					if(resultSet.getBlob(19) == null)
	    					{
	    						dao.setInvoiceBillAvailable(false);
	    					}
	    					else
	    					{
	    						dao.setInvoiceBillAvailable(true);
	    					}
	    					
	    					dao.setEntryBy(resultSet.getString(20));
	    					
	    					
	    				this.setTotalBillingAmt(this.getTotalBillingAmt() + resultSet.getFloat(12));
	    				this.setTotalPaidAmt(this.getTotalPaidAmt() + resultSet.getFloat(13));
	    				
	    				
	    					this.getPurchaseList().add(dao);
	    					
	    					
	    					
	    				}
	    				result = "success";
	    			}
	    			else
	    			{
	    				result = "error";
	    				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
	    			}
	    			
	    			
	    		} catch (SQLException e) {
	    			//e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
	    		} catch (Exception e) {
	    			result = "error";
	    			//e.printStackTrace();
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		} finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close();resultSet = null;
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close();preparedStatement= null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        }
	        
	        return result;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getSupplierName() {
		return supplierName;
	}


	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public List<PurchaseDateWiseReportDAO> getPurchaseList() {
		return purchaseList;
	}


	public void setPurchaseList(List<PurchaseDateWiseReportDAO> purchaseList) {
		this.purchaseList = purchaseList;
	}


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}
	
	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public float getTotalBillingAmt() {
		return totalBillingAmt;
	}


	public void setTotalBillingAmt(float totalBillingAmt) {
		this.totalBillingAmt = totalBillingAmt;
	}


	public float getTotalPaidAmt() {
		return totalPaidAmt;
	}


	public void setTotalPaidAmt(float totalPaidAmt) {
		this.totalPaidAmt = totalPaidAmt;
	}


	        
}
