package com.stonecrusher.report;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.VehicleConsumptionInfoDAO;
import com.stonecrusher.DAO.VehicleMaintenanceInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.opensymphony.xwork2.ActionSupport;

public class GetMaintenanceReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	private String fromDate;
	private String toDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private String addSideBarJs;
	private String vehicleId;
	
	private ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList = new ArrayList<VehicleMaintenanceInfoDAO>();
	private Float totalMaintenanceAmount = 0.0F;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					if(!this.getVehicleId().equals("ALL"))
					{
						sql = "SELECT "
								+ "maininfo.vehicle_expense_entry_id,"
								+ "maininfo.vehicle_id,"
								+ "vinfo.vehicle_make,"
								+ "vinfo.vehicle_registration_number,"
								+ "maininfo.exepense_date,"
								+ "maininfo.exepense_time,"
								+ "maininfo.exepense_amount,"
								+ "maininfo.entry_by,"
								+ "maininfo.consupmtion_details,"
								+ "maininfo.expence_image "
								+ "FROM "
								+ "crusher_vehicle_expense_master AS maininfo "
								+ "INNER JOIN "
								+ "crusher_vehicle_details_master AS vinfo "
								+ "ON maininfo.vehicle_id = vinfo.vehicle_id "
								+ "WHERE "
								+ "maininfo.vehicle_id = ? "
								+ "AND "
								+ "(maininfo.exepense_date "
								+ "BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "maininfo.crusher_id = ? "
								+ "AND "
								+ "maininfo.crusher_code = ? "
								+ "AND "
								+ "vinfo.crusher_id = ? "
								+ "AND "
								+ "vinfo.crusher_code = ? ";
						
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, this.getVehicleId());
							preparedStatement.setString(2, this.getFromDate());
							preparedStatement.setString(3, this.getToDate());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							preparedStatement.setString(6, crusherId);
							preparedStatement.setString(7, crusherCode);
					
					}
					else
					{

						sql = "SELECT "
								+ "maininfo.vehicle_expense_entry_id,"
								+ "maininfo.vehicle_id,"
								+ "vinfo.vehicle_make,"
								+ "vinfo.vehicle_registration_number,"
								+ "DATE_FORMAT(maininfo.exepense_date,'%d-%m-%Y'),"
								+ "maininfo.exepense_time,"
								+ "maininfo.exepense_amount,"
								+ "maininfo.entry_by,"
								+ "maininfo.consupmtion_details,"
								+ "maininfo.expence_image "
								+ "FROM "
								+ "crusher_vehicle_expense_master AS maininfo "
								+ "INNER JOIN "
								+ "crusher_vehicle_details_master AS vinfo "
								+ "ON maininfo.vehicle_id = vinfo.vehicle_id "
								+ "WHERE "
								+ "(maininfo.exepense_date "
								+ "BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "maininfo.crusher_id = ? "
								+ "AND "
								+ "maininfo.crusher_code = ? "
								+ "AND "
								+ "vinfo.crusher_id = ? "
								+ "AND "
								+ "vinfo.crusher_code = ? ";
						
							preparedStatement = connection.prepareStatement(sql);
						
							preparedStatement.setString(1, this.getFromDate());
							preparedStatement.setString(2, this.getToDate());
							preparedStatement.setString(3, crusherId);
							preparedStatement.setString(4, crusherCode);
							preparedStatement.setString(5, crusherId);
							preparedStatement.setString(6, crusherCode);
					
					}
					
					
					resultSet = preparedStatement.executeQuery();
					
					while(resultSet.next())
					{
						VehicleMaintenanceInfoDAO infoDAO = new VehicleMaintenanceInfoDAO();
						infoDAO.setEntryId(resultSet.getString(1));
						infoDAO.setVehicleId(resultSet.getString(2));
						infoDAO.setVehicleMake(resultSet.getString(3));
						infoDAO.setVehicleRegNumber(resultSet.getString(4));
						infoDAO.setEntryDate(resultSet.getString(5));
						infoDAO.setEntryTime(resultSet.getString(6));
						infoDAO.setAmount(resultSet.getFloat(7));
						infoDAO.setEntryBy(resultSet.getString(8));
						infoDAO.setComments(resultSet.getString(9));
						if(resultSet.getBlob(10) != null)
						{
							infoDAO.setImageAvailable(true);
						}
						else
						{
							infoDAO.setImageAvailable(false);
						}
						
						infoDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(5)));
						
						this.setTotalMaintenanceAmount(this.getTotalMaintenanceAmount() + resultSet.getFloat(7));
						
						this.getVehicleMainInfoList().add(infoDAO);
						
						
					}
					
					if(this.getVehicleMainInfoList().size() == 0)
					{
						
						result = ERROR;
						addActionError(this.getText("message.error.noDetailsFoundForProvidedInputs"));
						
					}else {
					   
					    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
					    Collections.sort(this.getVehicleMainInfoList(), new Comparator<VehicleMaintenanceInfoDAO>() {
					        @Override
					        public int compare(VehicleMaintenanceInfoDAO o1, VehicleMaintenanceInfoDAO o2) {
					            try {
					                Date date1 = dateFormat.parse(o1.getEntryDate());
					                Date date2 = dateFormat.parse(o2.getEntryDate());
					                return date1.compareTo(date2); 
					            } catch (ParseException e) {
					                e.printStackTrace();
					                return 0; 
					            }
					        }
					    });
					}
						result = SUCCESS;
					
				
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	@Override
	public void validate() 
	{
		this.setAddSideBarJs("FALSE");
		downloadTypeList.add("pdf");
    	downloadTypeList.add("xl");
    	
			
		if(this.getVehicleId().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectVehicle"));
		}
		
		this.setVehicleList(GetListResource.getVehicleList(true, this.getSessionMap()));
	}
	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public Map<String, String> getVehicleList() {
		return vehicleList;
	}



	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public ArrayList<VehicleMaintenanceInfoDAO> getVehicleMainInfoList() {
		return vehicleMainInfoList;
	}



	public void setVehicleMainInfoList(ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList) {
		this.vehicleMainInfoList = vehicleMainInfoList;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getVehicleId() {
		return vehicleId;
	}



	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}



	public Float getTotalMaintenanceAmount() {
		return totalMaintenanceAmount;
	}



	public void setTotalMaintenanceAmount(Float totalMaintenanceAmount) {
		this.totalMaintenanceAmount = totalMaintenanceAmount;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}
	

}



