package com.stonecrusher.report;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.EmployeeAbsentHalfOvertimeInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class GetEmployeeAbsentReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2228171855579030504L;
	private SessionMap<String,Object> sessionMap; 
	private String fromDate;
	private String toDate;
	private ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> employeeAbsentHalfOvertimeList = new ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> ();
	private String addSideBarJs;
	private String LaborIdName;
	private String type;
	private String markingType;
	private List<String> typeList = new ArrayList<String>();
	private List<String> markingTypeList = new ArrayList<String>();

	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					
					
					if(this.getType().equals("Type 1"))
					{
						if(this.getMarkingType().equals("ALL") || this.getMarkingType().equals("ABSENT"))
						{
							
						
				 
					if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
					{
		    		

		    		sql = "SELECT "
							+ "entry_id,"
							+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
							+ "employee_id,"
							+ "employee_name,"
							+ "details,"
							+ "type_of_marking "
							+ "FROM "
							+ "crusher_employee_presenty_details "
							+ "WHERE "
							+ "type_of_marking = ? "
							+ "AND "
                            + "(marking_date BETWEEN "
							+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY marking_date ";

					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, "ABSENT");
					preparedStatement.setString(2, this.getFromDate());
					preparedStatement.setString(3, this.getToDate());
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					
		    		
		    	}else {
		    		
					sql = "SELECT "
							+ "entry_id,"
							+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
							+ "employee_id,"
							+ "employee_name,"
							+ "details,"
							+ "type_of_marking "
							+ "FROM "
							+ "crusher_employee_presenty_details "
							+ "WHERE "
							+ "type_of_marking = ? "
							+ "AND "
                            + "(marking_date BETWEEN "
							+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "AND "
							+ "employee_id = ? "
							+ "ORDER BY marking_date ";

					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, "ABSENT");
					preparedStatement.setString(2, this.getFromDate());
					preparedStatement.setString(3, this.getToDate());
					preparedStatement.setString(4, crusherId);
					preparedStatement.setString(5, crusherCode);
					preparedStatement.setString(6, this.getLaborIdName().split("-")[0]);

		    	}
		    		
					
					

					resultSet = preparedStatement.executeQuery();
					
					resultSet.last();
					int rowCount = resultSet.getRow();
					resultSet.beforeFirst();
					if(rowCount > 0)
					{
						while(resultSet.next())
						{
							EmployeeAbsentHalfOvertimeInfoDAO dao = new EmployeeAbsentHalfOvertimeInfoDAO();
							
							dao.setEntryId(EncryptionDecryption.encrypt(resultSet.getString(1)));
							dao.setMarkingDate(resultSet.getString(2));
							dao.setEmployeeId(resultSet.getString(3));
							dao.setEmployeeName(resultSet.getString(4));
							dao.setDetails(resultSet.getString(5));
							dao.setMarkingType(resultSet.getString(6));
							
							this.getEmployeeAbsentHalfOvertimeList().add(dao);
									
						}
					}
					
					
						}
						
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
					
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						
						
						if(this.getMarkingType().equals("ALL") || this.getMarkingType().equals("HALFDAY"))
						{
							
							

							if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
							{
				    		

				    		sql = "SELECT "
									+ "entry_id,"
									+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
									+ "employee_id,"
									+ "employee_name,"
									+ "details,"
									+ "type_of_marking "
									+ "FROM "
									+ "crusher_employee_presenty_details "
									+ "WHERE "
									+ "type_of_marking = ? "
									+ "AND "
		                            + "(marking_date BETWEEN "
									+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY marking_date ";

							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, "HALFDAY");
							preparedStatement.setString(2, this.getFromDate());
							preparedStatement.setString(3, this.getToDate());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
				    		
				    	}else {
				    		
							sql = "SELECT "
									+ "entry_id,"
									+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
									+ "employee_id,"
									+ "employee_name,"
									+ "details,"
									+ "type_of_marking "
									+ "FROM "
									+ "crusher_employee_presenty_details "
									+ "WHERE "
									+ "type_of_marking = ? "
									+ "AND "
		                            + "(marking_date BETWEEN "
									+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "AND "
									+ "employee_id = ? "
									+ "ORDER BY marking_date ";

							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, "HALFDAY");
							preparedStatement.setString(2, this.getFromDate());
							preparedStatement.setString(3, this.getToDate());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							preparedStatement.setString(6, this.getLaborIdName().split("-")[0]);

				    	}
							resultSet = preparedStatement.executeQuery();
							
							resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							if(rowCount > 0)
							{
								while(resultSet.next())
								{
									
									EmployeeAbsentHalfOvertimeInfoDAO dao = new EmployeeAbsentHalfOvertimeInfoDAO();
									
									dao.setEntryId(EncryptionDecryption.encrypt(resultSet.getString(1)));
									dao.setMarkingDate(resultSet.getString(2));
									dao.setEmployeeId(resultSet.getString(3));
									dao.setEmployeeName(resultSet.getString(4));
									dao.setDetails(resultSet.getString(5));
									dao.setMarkingType(resultSet.getString(6));
									
									this.getEmployeeAbsentHalfOvertimeList().add(dao);
												
								}
							}
							
						}
						
						
						if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						
						
						if(this.getMarkingType().equals("ALL") || this.getMarkingType().equals("OVERTIME"))
						{
							
							

							if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
							{
				    		

				    		sql = "SELECT "
									+ "entry_id,"
									+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
									+ "employee_id,"
									+ "employee_name,"
									+ "details,"
									+ "type_of_marking "
									+ "FROM "
									+ "crusher_employee_presenty_details "
									+ "WHERE "
									+ "type_of_marking = ? "
									+ "AND "
		                            + "(marking_date BETWEEN "
									+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY marking_date ";

							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, "OVERTIME");
							preparedStatement.setString(2, this.getFromDate());
							preparedStatement.setString(3, this.getToDate());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							
				    		
				    	}else {
				    		
							sql = "SELECT "
									+ "entry_id,"
									+ "DATE_FORMAT(marking_date,'%d-%m-%Y'),"
									+ "employee_id,"
									+ "employee_name,"
									+ "details,"
									+ "type_of_marking "
									+ "FROM "
									+ "crusher_employee_presenty_details "
									+ "WHERE "
									+ "type_of_marking = ? "
									+ "AND "
		                            + "(marking_date BETWEEN "
									+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "							
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "AND "
									+ "employee_id = ? "
									+ "ORDER BY marking_date ";

							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, "OVERTIME");
							preparedStatement.setString(2, this.getFromDate());
							preparedStatement.setString(3, this.getToDate());
							preparedStatement.setString(4, crusherId);
							preparedStatement.setString(5, crusherCode);
							preparedStatement.setString(6, this.getLaborIdName().split("-")[0]);

				    	}
							resultSet = preparedStatement.executeQuery();
							
							resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							if(rowCount > 0)
							{
								while(resultSet.next())
								{
									
									EmployeeAbsentHalfOvertimeInfoDAO dao = new EmployeeAbsentHalfOvertimeInfoDAO();
									
									dao.setEntryId(EncryptionDecryption.encrypt(resultSet.getString(1)));
									dao.setMarkingDate(resultSet.getString(2));
									dao.setEmployeeId(resultSet.getString(3));
									dao.setEmployeeName(resultSet.getString(4));
									dao.setDetails(resultSet.getString(5));
									dao.setMarkingType(resultSet.getString(6));
									
									this.getEmployeeAbsentHalfOvertimeList().add(dao);
									
												
								}
							}
							
						}
						
					}
					
					
					
					
					
					if(this.getType().equals("Type 2"))
					{
						
						
						SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
						

						int noOfDays = 0;
						try {
						    Date date1 = myFormat.parse(this.getFromDate());
						    Date date2 = myFormat.parse(this.getToDate());
						    long diff = date2.getTime() - date1.getTime();
						    noOfDays = (int) TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS) +1;
						} catch (ParseException e) {}
					
						
						
						if(this.getLaborIdName() == null || this.getLaborIdName().equals(""))
						{
			    		

							sql = "SELECT "
									+ "employee_id,"
									+ "employee_name,"
									+ "type_of_marking "
									+ "FROM "
									+ "crusher_employee_presenty_details "
									+ "WHERE "
									+ "(marking_date BETWEEN "
									+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y'))"
									+ "AND "
								    + "crusher_id = ? "
								    + "AND "
								    + "crusher_code = ?";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, this.getFromDate());
							preparedStatement.setString(2, this.getToDate());
							preparedStatement.setString(3, crusherId);
							preparedStatement.setString(4, crusherCode);
							
						
			    		
			    	}else {
			    		
			    		sql = "SELECT "
			    				+ "employee_id,"
								+ "employee_name,"
								+ "type_of_marking "
								+ "FROM "
								+ "crusher_employee_presenty_details "
								+ "WHERE "
								+ "employee_id = ? "
								+ "AND "
								+ "(marking_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y'))"
								+ "AND "
							    + "crusher_id = ? "
							    + "AND "
							    + "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, this.getLaborIdName().split("-")[0]);
						preparedStatement.setString(2, this.getFromDate());
						preparedStatement.setString(3, this.getToDate());
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
						
						
							}
						
						
						
						 resultSet = preparedStatement.executeQuery();
							
							resultSet.last();
							int rowCount = resultSet.getRow();
							resultSet.beforeFirst();
							if(rowCount > 0)
							{
								Map<String, EmployeeAbsentHalfOvertimeInfoDAO> employeeMap = new LinkedHashMap<>();

								while (resultSet.next()) {
								    String empId = resultSet.getString(1);
								    String empName = resultSet.getString(2);
								    String typeOfMarking = resultSet.getString(3);

								    EmployeeAbsentHalfOvertimeInfoDAO dao = employeeMap.get(empId);

								    if (dao == null) {
								        dao = new EmployeeAbsentHalfOvertimeInfoDAO();
								        dao.setEmployeeId(empId);
								        dao.setEmployeeName(empName);
								        dao.setNoOfDaysInMonth(noOfDays);
								        dao.setNoOfDaysAbsentDays(0);
								        dao.setNoOfHalfDays(0);
								        dao.setNoOfOverTime(0);
								        employeeMap.put(empId, dao);
								    }

								    if ("ABSENT".equalsIgnoreCase(typeOfMarking)) {
								        dao.setNoOfDaysAbsentDays(dao.getNoOfDaysAbsentDays() + 1);
								    } else if ("HALFDAY".equalsIgnoreCase(typeOfMarking)) {
								        dao.setNoOfHalfDays(dao.getNoOfHalfDays() + 1);
								    } else if ("OVERTIME".equalsIgnoreCase(typeOfMarking)) {
								        dao.setNoOfOverTime(dao.getNoOfOverTime() + 1);
								    }
								}

								
								for (EmployeeAbsentHalfOvertimeInfoDAO dao : employeeMap.values()) {
								    dao.setNoOfFullDays(dao.getNoOfDaysInMonth() - (dao.getNoOfDaysAbsentDays() + dao.getNoOfHalfDays()));
								    this.getEmployeeAbsentHalfOvertimeList().add(dao);
								}

							}
								
								
						
					
					
						
						
					}
					
					
					
					
					
					if(this.getEmployeeAbsentHalfOvertimeList().size() > 0)
					{
						
					}else {
						addActionError(this.getText("message.error.noEmployeeAbsentDetailsForThisDate"));
						
					}
					
					result = SUCCESS;
				}
				catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
						e.printStackTrace();
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
    	
		typeList.add("Type 1");
   		typeList.add("Type 2");
   		
   		
    	
   		markingTypeList.add("ALL");
   		markingTypeList.add("ABSENT");
   		markingTypeList.add("HALFDAY");
   		markingTypeList.add("OVERTIME");
   		
		if(this.getFromDate() == null || this.getFromDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectFromDate"));
		}
		
		if(this.getToDate() == null || this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectToDate"));
		}
	}
	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	

	

	public ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> getEmployeeAbsentHalfOvertimeList() {
		return employeeAbsentHalfOvertimeList;
	}

	public void setEmployeeAbsentHalfOvertimeList(
			ArrayList<EmployeeAbsentHalfOvertimeInfoDAO> employeeAbsentHalfOvertimeList) {
		this.employeeAbsentHalfOvertimeList = employeeAbsentHalfOvertimeList;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getLaborIdName() {
		return LaborIdName;
	}

	public void setLaborIdName(String laborIdName) {
		LaborIdName = laborIdName;
	}

	public List<String> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}

	

	public List<String> getMarkingTypeList() {
		return markingTypeList;
	}

	public void setMarkingTypeList(List<String> markingTypeList) {
		this.markingTypeList = markingTypeList;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getMarkingType() {
		return markingType;
	}

	public void setMarkingType(String markingType) {
		this.markingType = markingType;
	}

	

}



