package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.DieselStatementDAO;
import com.stonecrusher.db.GetDBConnection;

public class GetDieselReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4897790099069628703L;
	
	private HttpSession session; 

	
	private String fromDate;
	private String toDate;
	private List<DieselStatementDAO> dieselReportList = new ArrayList<DieselStatementDAO>();
	
	private Float totalCreditAmount;
	private Float totalDebitAmount;
	private Float balanceAmount;
	private SessionMap<String,Object> sessionMap;  
	
	
	
	private Float yesterdayBallanceQty = 0.0f ;
	
	
	
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	
	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	        	float ttlCrAmt = 0.0F;
	        	float ttlDrAmt = 0.0F;
	        	float balAmt = 0.0F;
	        	
	        	
	        	
	        	this.setAddSideBarJs("FALSE");

	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSession().getAttribute("db");
	        	
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
		            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		            
		            LocalDate fromDateLocal = LocalDate.parse(fromDate, inputFormatter);
		            LocalDate yesterdayDate = fromDateLocal.minusDays(1);

		            String yesterdayDateFormatted = yesterdayDate.format(outputFormatter);

		            
		            
		            
		            sql = "SELECT "
		                    + "closeing_bal_quantity "
		                    + "FROM "
		                    + "diesel_datewise_closing_balance "
		                    + "WHERE "
		                    + "crusher_id = ? "
		                    + "AND "
		                    + "crusher_code = ? "
		                    + "AND "
		                    + "closeing_bal_date <= ? "
		                    + "ORDER BY "
		                    + "closeing_bal_date DESC "
		                    + "LIMIT 1";

		            preparedStatement = connection.prepareStatement(sql);

		            preparedStatement.setString(1, crusherId);
		            preparedStatement.setString(2, crusherCode);
		            preparedStatement.setString(3, yesterdayDateFormatted);


	        		resultSet = preparedStatement.executeQuery();
	        		if(resultSet.next())
	        		{
	        			yesterdayBallanceQty = resultSet.getFloat(1);
	        			
	        		}
	        		
	        		
	        		if(resultSet != null)
	        		{
	        			resultSet.close();
	        			resultSet = null;
	        		}
	        		if(preparedStatement!= null)
	        		{
	        			preparedStatement.close();
	        			preparedStatement = null;
	        		}
	        		
	        		
	        		
					sql = "SELECT "
							+ "entry_id,"
							+ "product_id,"
							+ "product_name,"
							+ "DATE_FORMAT(entry_date,'%d-%m-%Y'),"
							+ "entry_time,"
							+ "entry_type,"
							+ "quantity,"
							+ "entry_by,"
							+ "entry_details,"
							+ "entry_source "
							+ "FROM "
							+ "diesel_credit_debit_master "
							+ "WHERE "
							+ "(entry_date "
							+ "BETWEEN "
							+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "order by "
							+ "entry_date";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getFromDate());
					preparedStatement.setString(2, this.getToDate());
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					resultSet.last();
					
					int rowCount = resultSet.getRow();
					
					resultSet.beforeFirst();
					
					if(rowCount > 0)
					{
						float balance = this.getYesterdayBallanceQty() ;
						
						
						while(resultSet.next())
						{
							DieselStatementDAO dao = new DieselStatementDAO();
							dao.setEntryId(resultSet.getString(1));
							dao.setProductId(resultSet.getString(2));
							dao.setProductName(resultSet.getString(3));
							dao.setEntryDate(resultSet.getString(4));
							dao.setEntryType(resultSet.getString(6));
							dao.setQuantity(resultSet.getFloat(7));
							dao.setEntryBy(resultSet.getString(8));
							dao.setEntryDetails(resultSet.getString(9));
							String entrySource = resultSet.getString(10);
							
							
							if(resultSet.getString(6).equals("CREDIT"))
							{
								ttlCrAmt = ttlCrAmt + resultSet.getFloat(7);
								balance = balance + resultSet.getFloat(7);
							}
							if(resultSet.getString(6).equals("DEBIT"))
							{
								ttlDrAmt = ttlDrAmt + resultSet.getFloat(7);
								balance = balance - resultSet.getFloat(7);
							}
							
							balAmt = balance;
							
							dao.setBalance(balance);
							
							this.getDieselReportList().add(dao);
						}
						
						
						this.setTotalCreditAmount(ttlCrAmt);
						this.setTotalDebitAmount(ttlDrAmt );
						this.setBalanceAmount(balAmt );
						
						result = "success";
						
						
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.detailsNotFoundPlzTryAgain"));
					}
					
					
					
				}catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.accountDetailsNotFound"));
				} catch (Exception e) {
					//e.printStackTrace();
					
					result = "error";						
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.accountDetailsNotFound"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	result = "success";
	        }
        
        return result;
}

@Override
public void validate() {
	session=ServletActionContext.getRequest().getSession(false); 
	this.setAddSideBarJs("FALSE");
	
	
	
	
	if(!hasActionErrors())
	{
		if(this.getFromDate().equals("") && this.getToDate().equals(""))
		{
			addActionError(this.getText("Please Select Dates !"));
		}
	}
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}


public String getFromDate() {
	return fromDate;
}

public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}

public String getToDate() {
	return toDate;
}

public void setToDate(String toDate) {
	this.toDate = toDate;
}


public static long getSerialversionuid() {
	return serialVersionUID;
}


public Float getTotalCreditAmount() {
	return totalCreditAmount;
}

public void setTotalCreditAmount(Float totalCreditAmount) {
	this.totalCreditAmount = totalCreditAmount;
}

public Float getTotalDebitAmount() {
	return totalDebitAmount;
}

public void setTotalDebitAmount(Float totalDebitAmount) {
	this.totalDebitAmount = totalDebitAmount;
}

public Float getBalanceAmount() {
	return balanceAmount;
}

public void setBalanceAmount(Float balanceAmount) {
	this.balanceAmount = balanceAmount;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}


public Float getYesterdayBallanceQty() {
	return yesterdayBallanceQty;
}

public void setYesterdayBallanceQty(Float yesterdayBallanceQty) {
	this.yesterdayBallanceQty = yesterdayBallanceQty;
}

public List<DieselStatementDAO> getDieselReportList() {
	return dieselReportList;
}

public void setDieselReportList(List<DieselStatementDAO> dieselReportList) {
	this.dieselReportList = dieselReportList;
}




}
