package com.stonecrusher.report;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.DeliveryChallanInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class GetDCReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap; 
	private String fromDate;
	private String toDate;
	private ArrayList<DeliveryChallanInfoDAO> dcInfoList = new ArrayList<DeliveryChallanInfoDAO> ();
	private String addSideBarJs;
	private String customerName;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
	        	
	        	
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	    	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					
					if(this.getCustomerName().equalsIgnoreCase("ALL"))
					{
					
							sql = "SELECT "
									+ "challan_number,"
									+ "DATE_FORMAT(challan_date,'%d-%m-%Y'),"
									+ "customer_name,"
									+ "veihcle_reg_number,"
									+ "bill_created,"
									+ "bill_number "
									+ "FROM "
									+ "crusher_delivery_challan_master "
									+ "WHERE "
									+ "(challan_date BETWEEN "
									+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? "
									+ "ORDER BY challan_date";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, this.getFromDate());
							preparedStatement.setString(2, this.getToDate());
							preparedStatement.setString(3, crusherId);
							preparedStatement.setString(4, crusherCode);
					}
					else
					{
						sql = "SELECT "
								+ "challan_number,"
								+ "DATE_FORMAT(challan_date,'%d-%m-%Y'),"
								+ "customer_name,"
								+ "veihcle_reg_number,"
								+ "bill_created,"
								+ "bill_number "
								+ "FROM "
								+ "crusher_delivery_challan_master "
								+ "WHERE "
								+ "(challan_date BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "customer_id = ? "
								+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "ORDER BY challan_date";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, this.getFromDate());
						preparedStatement.setString(2, this.getToDate());
						preparedStatement.setString(3, this.getCustomerName().split("-")[0]);
						preparedStatement.setString(4, crusherId);
						preparedStatement.setString(5, crusherCode);
					}
					
					resultSet = preparedStatement.executeQuery();
					
					resultSet.last();
					int rowCount = resultSet.getRow();
					resultSet.beforeFirst();
					if(rowCount > 0)
					{
						while(resultSet.next())
						{
							DeliveryChallanInfoDAO challanInfoDAO = new DeliveryChallanInfoDAO();
							
							challanInfoDAO.setChallanNumber(resultSet.getString(1));
							challanInfoDAO.setChallanDate(resultSet.getString(2));
							challanInfoDAO.setCustomerName(resultSet.getString(3));
							challanInfoDAO.setVehicleRegNumber(resultSet.getString(4));
							challanInfoDAO.setIsBillCreated(resultSet.getBoolean(5));
							
							if(resultSet.getBoolean(5))
							{
								challanInfoDAO.setMessage("Bill Generated For This DC. Bill No : "+resultSet.getString(6));
								
							}
							
							this.getDcInfoList().add(challanInfoDAO);
										
						}
					}else
					{
						addActionError(this.getText("message.error.noDcFoundForDate"));
					}
					
					result = SUCCESS;
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		if(this.getFromDate() == null || this.getFromDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectFromDate"));
		}
		
		if(this.getToDate() == null || this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectToDate"));
		}
	}
	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public ArrayList<DeliveryChallanInfoDAO> getDcInfoList() {
		return dcInfoList;
	}


	public void setDcInfoList(ArrayList<DeliveryChallanInfoDAO> dcInfoList) {
		this.dcInfoList = dcInfoList;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



