package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerCreditReportDAO;
import com.stonecrusher.DAO.CustomerInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class GetCustomerCreditReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3363815906834114723L;
	private SessionMap<String,Object> sessionMap;
	private HttpSession session;
	private String minAmount;
	private String maxAmount;
	private String startDate;
	private String endDate;
	private List<CustomerCreditReportDAO> custCreditList = new ArrayList<CustomerCreditReportDAO>();	
	private float totolReportBillAmount = 0.0F;
	private float totalReportPaymentAmount = 0.0F;
	private float totalReportCreditAmount = 0.0F;
	
	private Float totalReportAfterDateBillAmt = 0.0f;
	private Float totalReportAfterDatePaymentAmt = 0.0F;
	private Float totalReportAfterDateBalAmt = 0.0F;

	private String downloadFileType;
	private String custIdStart;
	private String custIdEnd;
	private String addSideBarJs;
	private String fromDate;
	private String toDate;
	

	private ArrayList<String> downloadFileTypeList = new ArrayList<String>();
	
	private ArrayList<String> downloadFileLanguageList = new ArrayList<String>(); 
	private String downloadFileLanguage;
	
	public String execute(){
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	DecimalFormat df = new DecimalFormat("##.##");
	        	String actualStartDate = "";
	        
	        	
	        	if(!this.getFromDate().equals("") && !this.getToDate().equals(""))
	        	{
	        		
		        	this.setStartDate(this.getFromDate());
		        	this.setEndDate(this.getToDate());
		       	
		        	Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
		        	
		        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
		        	int year = cal.get(Calendar.YEAR);
		       
		        	
		        	actualStartDate = "01-04-"+(year-2);
		        	
		        	
	        	}else
	        	{
		        	Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
		        	
		        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
		        	int year = cal.get(Calendar.YEAR);
		       
		        	SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
		        	
		        	actualStartDate = "01-04-"+(year-2);
		        	
		        	this.setStartDate("01-04-"+(year-2));
		        	this.setEndDate(sdf.format(today));
	        	}
	        	
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		

	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    		try
	    		{
	    			 Map<String,CustomerInfoDAO> customerInfoMap = new LinkedHashMap<String,CustomerInfoDAO>();
	    		
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			sql = "SELECT "
	    					+ "customer_id,"
	    					+ "customer_name,"
	    					+ "mobile_number,"
	    					+ "billing_address,"
	    					+ "credit_limit "
	    					+ "FROM "
	    					+ "crusher_customer_master "
	    					+ "WHERE "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? "
	    					+ "ORDER BY customer_name asc";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			/*preparedStatement.setString(1, this.getCustIdStart());
	    			preparedStatement.setString(2, this.getCustIdEnd());*/
	    			
	    			preparedStatement.setString(1, crusherId);
	    			preparedStatement.setString(2, crusherCode);
	    			
	    			resultSet = preparedStatement.executeQuery();
	    			int count = 1;
	    		
	    		
	    			while(resultSet.next())
	    			{
	    				CustomerInfoDAO customerInfoDAO = new CustomerInfoDAO();
	    				
	    				customerInfoDAO.setCustomerId(resultSet.getString(1));
	    				customerInfoDAO.setCustName(resultSet.getString(2));
	    				customerInfoDAO.setMobileNumber(resultSet.getString(3));
	    				customerInfoDAO.setBillingaddress(resultSet.getString(4));
	    				customerInfoDAO.setCreditlimit(resultSet.getString(5));
	    				
	    				customerInfoMap.put(resultSet.getString(1),customerInfoDAO);	    				
	    			}
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    				resultSet = null;
	    			}
	    			
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    				preparedStatement = null;
	    			}
	    			
	    			Map<String,CustomerCreditReportDAO> custCreditReportMap = new LinkedHashMap<String,CustomerCreditReportDAO>() ;
	    			
	    			for(String custId: customerInfoMap.keySet())
	    			{
	    				float opeingBalFloat = 0.0F;
       					PreparedStatement getOpeningBalPSMT = null;
           				ResultSet getOpeningBalRs = null;
           				String getOpeningBalSQL = "SELECT "
           						+ "opening_balance,"
           						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
           						+ "updated_by "
           						+ "FROM "
           						+ "crusher_cust_close_open_bal_master "
           						+ "WHERE "
           						+ "customer_id = ? "
           						+ "AND "
           						+ "crusher_id = ? "
           						+ "AND "
           						+ "crusher_code = ?";
           				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
           				
           				getOpeningBalPSMT.setString(1, custId);
           				getOpeningBalPSMT.setString(2, crusherId);
           				getOpeningBalPSMT.setString(3, crusherCode);
           				
           				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
           				
           				if(getOpeningBalRs.next())
           				{
       					
           					opeingBalFloat = getOpeningBalRs.getFloat(1);
       					
           				}
           				
           			//	System.out.println(opeingBalFloat);
           				if(getOpeningBalRs != null)
           				{
           					getOpeningBalRs.close();
           					getOpeningBalRs = null;
           				}
           				if(getOpeningBalPSMT != null)
           				{
           					getOpeningBalPSMT.close();
           					getOpeningBalPSMT = null;
           				}
       					
       					
           				
	    				CustomerInfoDAO customerInfoDAO = customerInfoMap.get(custId);
	    				CustomerCreditReportDAO creditReportDAO = new CustomerCreditReportDAO();
	    				creditReportDAO.setCustometName(customerInfoDAO.getCustName());
	    				creditReportDAO.setCustomerMobile(customerInfoDAO.getMobileNumber());
	    				creditReportDAO.setCustomerAddress(customerInfoDAO.getBillingaddress());
	    				creditReportDAO.setOpeningBalance(opeingBalFloat);
	    				creditReportDAO.setSrNo(count);
	    				
	    				customerInfoDAO.setOpeningBalance(opeingBalFloat);
		    			
	    				
	    				count ++;
	    				
	    				float custTotalPaymentAmount = 0.0F;
	    				
	    				float custAfterDateTotalPayment = 0.0F;
	    				
	    				PreparedStatement getCustPaymentDetailsPSMT = null;
	    				ResultSet getCustPaymnetDetailsRS = null;
	    				
	    			
	    			
	    		 String getCustPaymentDetailsSQL = "SELECT "
    						+ "SUM(amount) "
	       					+ "FROM "
	       					+ "crusher_customer_payment_details_master "
	       					+ "WHERE "
	       					+ "customer_id = ? "
	       					+ "AND "
	       					+ "(payment_date "
	       					+ "BETWEEN "
	       					+ "STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
	       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
	       					+ "AND "
	       					+ "crusher_id = ? "
	       					+ "AND "
	       					+ "crusher_code = ? ";
		
			getCustPaymentDetailsPSMT = connection.prepareStatement(getCustPaymentDetailsSQL);
			
			getCustPaymentDetailsPSMT.setString(1, custId);
			getCustPaymentDetailsPSMT.setString(2, this.getStartDate());
			getCustPaymentDetailsPSMT.setString(3, this.getEndDate());
			getCustPaymentDetailsPSMT.setString(4, crusherId);
			getCustPaymentDetailsPSMT.setString(5, crusherCode);
			
			//System.out.println(getCustPaymentDetailsPSMT.toString());
			
			getCustPaymnetDetailsRS = getCustPaymentDetailsPSMT.executeQuery();
			
			if(getCustPaymnetDetailsRS.next())
			{
				if(getCustPaymnetDetailsRS.getString(1) != null)
				{
					custAfterDateTotalPayment = getCustPaymnetDetailsRS.getFloat(1);
				}
			}
	    			
			creditReportDAO.setTotalPaymentAfterDate(df.format(custAfterDateTotalPayment));
			custTotalPaymentAmount = custAfterDateTotalPayment;
			
			creditReportDAO.setTotalPaymentAmount(df.format(custTotalPaymentAmount));
			
			custCreditReportMap.put(custId, creditReportDAO);
	    			
	    			
			    			if(getCustPaymnetDetailsRS != null)
			    			{
			    				getCustPaymnetDetailsRS.close();
			    				getCustPaymnetDetailsRS = null;
			    			}
			    			
			    			if(getCustPaymentDetailsPSMT != null)
			    			{
			    				getCustPaymentDetailsPSMT.close();
			    				getCustPaymentDetailsPSMT = null;
			    			}
			    			
			    		//	System.out.println(creditReportDAO.getCustometName()+"::"+ creditReportDAO.getOpeningBalance());
	    			}
	    			
	    			for(String custId: custCreditReportMap.keySet())	    				
	    			{
	    				CustomerCreditReportDAO creditReportDAO = custCreditReportMap.get(custId);
	    				
	    				float custTotalPaymentAmount = Float.parseFloat(creditReportDAO.getTotalPaymentAmount());
			    				
			    				float billAmountAfterDate = 0.0F;
			    				
			    				float totalBillAmountAfterDate = 0.0F;
			    				
			    				float billAmountReceivedAfterDate = 0.0F;
			    				
			    				float totalAmountRecievedAfterDate = 0.0F;
			    				
			    				float billAmountBalanceAfterDate = 0.0F;
			    				
			    				float totalBalanceAmtAfterDate = 0.0F;
			    				
			       				float custTotalCreditAfterDate = 0.0F;
			       				
			       				float custTotalBillAfterDate = 0.0F;
			       				
			       				float custTotalBillAmtReceivedAfterDate = 0.0F;
			       				
			       				float custTotalCreditAmount = 0.0F;
			    				float custTotalBillAmount = 0.0F;
			    				float custTotalAmountReceived = 0.0F;
			       				
			       				PreparedStatement getBillAmountPSMT = null;
			       				ResultSet getBillAmountRS = null;
			       				 
			       				String	getBillAmountSQL=  "SELECT "	           					
			           					+ "bill_total_amount,"
			           					+ "bill_amount_received,"
			           					+ "bill_amount_return "
			           					+ "FROM "
			           					+ "crusher_bill_info_master "
			           					+ "WHERE "		           					
			           					+ "customer_id = ? "
			           					+ "AND "
			           					+ "(bill_date "
			           					+ "BETWEEN "
			           					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				       					+ "AND "
				       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				       					+ "AND "
				       					+ "crusher_id = ? "
				       					+ "AND "
				       					+ "crusher_code = ? ";
			       				
			       			
			       				
			       				getBillAmountPSMT = connection.prepareStatement(getBillAmountSQL);
			       				getBillAmountPSMT.setString(1, custId);
			       				getBillAmountPSMT.setString(2, this.getStartDate());
			       				getBillAmountPSMT.setString(3, this.getEndDate());
			       				getBillAmountPSMT.setString(4, crusherId);
			       				getBillAmountPSMT.setString(5, crusherCode);
			       				
			       				getBillAmountRS = getBillAmountPSMT.executeQuery();
			       				
			       				while(getBillAmountRS.next())
			       				{
			       					
			       					try
			       					{
			       						if(getBillAmountRS.getString(2) != null)
			       						{
			       						
			       							billAmountAfterDate = getBillAmountRS.getFloat(1);
			       							billAmountReceivedAfterDate = getBillAmountRS.getFloat(2);
			       							billAmountBalanceAfterDate = billAmountAfterDate - billAmountReceivedAfterDate;
			       							totalBillAmountAfterDate = totalBillAmountAfterDate + billAmountAfterDate;
				           					if(billAmountBalanceAfterDate > 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
					           					totalBalanceAmtAfterDate = totalBalanceAmtAfterDate+billAmountBalanceAfterDate;
					           					
					           				}
					           				else if(billAmountBalanceAfterDate == 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
						           								           				
					           				}
			       						}
			       						
				           			}catch(NumberFormatException nfe)
			       					{
			       						result = "error";
			       						addActionError(this.getText("message.error.errorWhileFormatting")
			       								+ this.getText("message.error.whileCalculatingEachBilldetailsForCustomer"));
			       						
			       					}
			       				}
			       			
			       				
			       				
			       				getBillAmountSQL=  "SELECT "	           					
			           					+ "bill_total_amount,"
			           					+ "bill_amount_received,"
			           					+ "amount_return "
			           					+ "FROM "
			           					+ "crusher_rmc_billinfo "
			           					+ "WHERE "		           					
			           					+ "customer_id = ? "
			           					+ "AND "
			           					+ "(bill_date "
			           					+ "BETWEEN "
			           					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				       					+ "AND "
				       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				       					+ "AND "
				       					+ "crusher_id = ? "
				       					+ "AND "
				       					+ "crusher_code = ? ";
			       				
			       				if(getBillAmountRS != null)
			       				{
			       					getBillAmountRS.close();
			       					getBillAmountRS = null;
			       				}
			       				if(getBillAmountPSMT != null)
			       				{
			       					getBillAmountPSMT.close();
			       					getBillAmountPSMT = null;
			       				}
			       				
			       				
			       				getBillAmountPSMT = connection.prepareStatement(getBillAmountSQL);
			       				getBillAmountPSMT.setString(1, custId);
			       				getBillAmountPSMT.setString(2, this.getStartDate());
			       				getBillAmountPSMT.setString(3, this.getEndDate());
			       				getBillAmountPSMT.setString(4, crusherId);
			       				getBillAmountPSMT.setString(5, crusherCode);
			       				
			       				getBillAmountRS = getBillAmountPSMT.executeQuery();
			       				
			       				while(getBillAmountRS.next())
			       				{
			       					
			       					try
			       					{
			       						if(getBillAmountRS.getString(2) != null)
			       						{
			       						
			       							billAmountAfterDate = getBillAmountRS.getFloat(1);
			       							billAmountReceivedAfterDate = getBillAmountRS.getFloat(2);
			       							billAmountBalanceAfterDate = billAmountAfterDate - billAmountReceivedAfterDate;
			       							totalBillAmountAfterDate = totalBillAmountAfterDate + billAmountAfterDate;
				           					if(billAmountBalanceAfterDate > 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
					           					totalBalanceAmtAfterDate = totalBalanceAmtAfterDate+billAmountBalanceAfterDate;
					           					
					           				}
					           				else if(billAmountBalanceAfterDate == 0)
					           				{
					           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
						           								           				
					           				}
			       						}
			       						
				           			}catch(NumberFormatException nfe)
			       					{
			       						result = "error";
			       						addActionError(this.getText("message.error.errorWhileFormatting")
			       								+ this.getText("message.error.whileCalculatingEachBilldetailsForCustomer"));
			       						
			       					}
			       				}
			       				
			       				
				       			creditReportDAO.setTotalBillAmountAfterDate(totalBillAmountAfterDate);
			       				creditReportDAO.setTotalPaymentAfterDate(""+(Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate()) + totalAmountRecievedAfterDate));
			       				
			       				creditReportDAO.setTotalBalAmountAfterDate(totalBillAmountAfterDate - (Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate())));
			       			
			       				
			       				
			       				
			       				creditReportDAO.setTotalBalAmount(totalBalanceAmtAfterDate);
			       				
			     				
			       				custTotalBillAmount =  totalBillAmountAfterDate;
			       				custTotalAmountReceived =  totalAmountRecievedAfterDate;
			       				
			       				custTotalPaymentAmount = Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate());
			       				custTotalCreditAmount = (custTotalBillAmount+creditReportDAO.getOpeningBalance()) - custTotalPaymentAmount;
			       				
			       				creditReportDAO.setTotalBillAmount(""+custTotalBillAmount);
			       				creditReportDAO.setTotalCreditAmount(custTotalCreditAmount);
			       				creditReportDAO.setTotalPaymentAmount(""+custTotalPaymentAmount);
			       				
			       				creditReportDAO.setSmsData(creditReportDAO.getCustomerMobile()
			       						+"-"+creditReportDAO.getTotalCreditAmount());
			       				

			       				if(getBillAmountRS != null)
			       				{
			       					getBillAmountRS.close();
			       					getBillAmountRS = null;
			       				}
			       				if(getBillAmountPSMT != null)
			       				{
			       					getBillAmountPSMT.close();
			       					getBillAmountPSMT = null;
			       				}
			       				
			       				if(!this.getMinAmount().equals("") && !this.getMaxAmount().equals(""))
			       				{
			       					float minAmt = Float.parseFloat(this.getMinAmount());
			       					float maxAmt = Float.parseFloat(this.getMaxAmount());
			       					
			       					if(custTotalCreditAmount >=minAmt && custTotalCreditAmount <=maxAmt)
			       					{
			       						custCreditList.add(creditReportDAO);
			       					}
			       					
			       				}
			       				else if(!this.getMinAmount().equals("") && this.getMaxAmount().equals(""))
			       				{
			       					float minAmt = Float.parseFloat(this.getMinAmount());
			       				
			       					if(custTotalCreditAmount >=minAmt)
			       					{
			       						custCreditList.add(creditReportDAO);
			       					}
			       				}
			       				else if(this.getMinAmount().equals("") && !this.getMaxAmount().equals(""))
			       				{
			       					float maxAmt = Float.parseFloat(this.getMaxAmount());
			       					
			       					if(custTotalCreditAmount <=maxAmt)
			       					{
			       						custCreditList.add(creditReportDAO);
			       					}
			       				}
			       				else if(custTotalCreditAmount>0)
			       				{
			       					custCreditList.add(creditReportDAO);
			       				}
			       				
			       				
			       				
			       				
			       				
			       			 Collections.sort(custCreditList);
			       			   
			       			
			       				
				    			
	    			}	
	    			
	    			boolean allOk = true;
	    			for(CustomerCreditReportDAO  dao : custCreditList)
       				{
       					
       				 
       				 try{
       					 
       				 
       				// System.out.println(totolReportBillAmount);
	       				totolReportBillAmount = totolReportBillAmount+Float.parseFloat(dao.getTotalBillAmount());
	       				totalReportPaymentAmount = totalReportPaymentAmount + Float.parseFloat(dao.getTotalPaymentAmount());
	       				totalReportCreditAmount = totalReportCreditAmount+dao.getTotalCreditAmount();
	       				
	       				totalReportAfterDateBillAmt = totalReportAfterDateBillAmt + dao.getTotalBillAmountAfterDate();
	       				totalReportAfterDatePaymentAmt = totalReportAfterDatePaymentAmt + Float.parseFloat(dao.getTotalPaymentAfterDate());
	       				totalReportAfterDateBalAmt = totalReportAfterDateBalAmt + dao.getTotalBalAmountAfterDate();
       				 }catch (Exception e) {
       					allOk = false;
       				 }
       				}
	    			
	    			this.setTotolReportBillAmount(totolReportBillAmount);
	    			this.setTotalReportPaymentAmount(totalReportPaymentAmount);
	    			this.setTotalReportCreditAmount(totalReportCreditAmount);
	    			
	    			this.setTotalReportAfterDateBillAmt(totalReportAfterDateBillAmt);
	    			this.setTotalReportAfterDatePaymentAmt(totalReportAfterDatePaymentAmt);
	    			this.setTotalReportAfterDateBalAmt(totalReportAfterDateBalAmt);
	    			
	    			if(allOk)
	    			{
	    				result = SUCCESS;
	    			}
	    			else
	    			{
	    				result = ERROR;
	    				addActionError(this.getText("message.error.somethingWentWrongComputongTotalAmount"));
	    			}
	    		
	
	    		}
	    		 catch (SQLException e) {
		    			e.printStackTrace();
		    			result = "error";
		    			
		    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
		    		} catch (IOException e) {
		    			result = "error";
		    			
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
		    		}
	    			finally {
		    			if(resultSet != null)
						{
							try {
								resultSet.close(); resultSet = null;
							} catch (SQLException e) {
								
							}
						}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close();preparedStatement=null;} catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close();connection=null;}catch (SQLException e) {}
		    			}
		    			
		    		}
	        	
	        }
	        return result;
	}


	@Override
	public void validate() {
		
		if(this.getMinAmount() != null && !this.getMinAmount().equals(""))
		{
			if(this.getMinAmount().length()<9)
			{
				try
				{
					float min = Float.parseFloat(this.getMinAmount());
					if(min<0)
					{
						addActionError("1."+this.getText("message.error.minimumAmountCannotBeLessThan0"));
					}
					
				}catch(NumberFormatException nfe)
				{
					addActionError("2."+this.getText("message.error.minimumAmountIsNotCorrect"));
					
				}
			}else
			{
				addActionError(this.getText("message.error.minimumAmountIsNotCorrect"));
			}
		}
		
		if(this.getMaxAmount() != null && !this.getMaxAmount().equals(""))
		{
			if(this.getMaxAmount().length()<9)
			{
			try
			{
				
				float max = Float.parseFloat(this.getMaxAmount());
				if(max<0)
				{
					addActionError(this.getText("message.error.maximumAmountCannotBeLessThan0"));
				}
				
			}catch(NumberFormatException nfe)
			{
				addActionError(this.getText("message.error.maximumAmountIsNotCorrect"));
				
			}
			}else
			{
				addActionError(this.getText("message.error.maximumAmountIsNotCorrect"));
			}
		}
		this.getDownloadFileTypeList().add("XLS");
    	this.getDownloadFileTypeList().add("PDF");
    	
       	this.getDownloadFileLanguageList().add("MARATHI");
    	this.getDownloadFileLanguageList().add("ENGLISH");
    	
		this.setAddSideBarJs("FALSE");
		
	}
	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getMinAmount() {
		return minAmount;
	}


	public void setMinAmount(String minAmount) {
		this.minAmount = minAmount;
	}


	public String getMaxAmount() {
		return maxAmount;
	}


	public void setMaxAmount(String maxAmount) {
		this.maxAmount = maxAmount;
	}


	public List<CustomerCreditReportDAO> getCustCreditList() {
		return custCreditList;
	}


	public void setCustCreditList(List<CustomerCreditReportDAO> custCreditList) {
		this.custCreditList = custCreditList;
	}


	public String getStartDate() {
		return startDate;
	}


	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}


	public String getEndDate() {
		return endDate;
	}


	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}


	public float getTotolReportBillAmount() {
		return totolReportBillAmount;
	}


	public void setTotolReportBillAmount(float totolReportBillAmount) {
		this.totolReportBillAmount = totolReportBillAmount;
	}


	public float getTotalReportPaymentAmount() {
		return totalReportPaymentAmount;
	}


	public void setTotalReportPaymentAmount(float totalReportPaymentAmount) {
		this.totalReportPaymentAmount = totalReportPaymentAmount;
	}


	public float getTotalReportCreditAmount() {
		return totalReportCreditAmount;
	}


	public void setTotalReportCreditAmount(float totalReportCreditAmount) {
		this.totalReportCreditAmount = totalReportCreditAmount;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public Float getTotalReportAfterDateBillAmt() {
		return totalReportAfterDateBillAmt;
	}


	public void setTotalReportAfterDateBillAmt(Float totalReportAfterDateBillAmt) {
		this.totalReportAfterDateBillAmt = totalReportAfterDateBillAmt;
	}


	public Float getTotalReportAfterDatePaymentAmt() {
		return totalReportAfterDatePaymentAmt;
	}


	public void setTotalReportAfterDatePaymentAmt(Float totalReportAfterDatePaymentAmt) {
		this.totalReportAfterDatePaymentAmt = totalReportAfterDatePaymentAmt;
	}


	public Float getTotalReportAfterDateBalAmt() {
		return totalReportAfterDateBalAmt;
	}


	public void setTotalReportAfterDateBalAmt(Float totalReportAfterDateBalAmt) {
		this.totalReportAfterDateBalAmt = totalReportAfterDateBalAmt;
	}


	public String getCustIdStart() {
		return custIdStart;
	}


	public void setCustIdStart(String custIdStart) {
		this.custIdStart = custIdStart;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public String getCustIdEnd() {
		return custIdEnd;
	}


	public void setCustIdEnd(String custIdEnd) {
		this.custIdEnd = custIdEnd;
	}


	public String getDownloadFileType() {
		return downloadFileType;
	}


	public void setDownloadFileType(String downloadFileType) {
		this.downloadFileType = downloadFileType;
	}


	public ArrayList<String> getDownloadFileTypeList() {
		return downloadFileTypeList;
	}


	public void setDownloadFileTypeList(ArrayList<String> downloadFileTypeList) {
		this.downloadFileTypeList = downloadFileTypeList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public ArrayList<String> getDownloadFileLanguageList() {
		return downloadFileLanguageList;
	}


	public void setDownloadFileLanguageList(ArrayList<String> downloadFileLanguageList) {
		this.downloadFileLanguageList = downloadFileLanguageList;
	}


	public String getDownloadFileLanguage() {
		return downloadFileLanguage;
	}


	public void setDownloadFileLanguage(String downloadFileLanguage) {
		this.downloadFileLanguage = downloadFileLanguage;
	}
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
}
