package com.stonecrusher.report;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ChequeInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class GetChequeReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 475698101190472546L;
	
	private HttpSession session;
	private String fromDate;
	private String toDate;
	private String bankName;
	private String branchName;
	private String chequeStatus;
	private String addSideBarJs;

	private SessionMap<String,Object> sessionMap;
	
	private List<ChequeInfoDAO> chequeInfoList = new ArrayList<ChequeInfoDAO>();
	
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeSatusList = new ArrayList<String>();
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	public String execute(){
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	        	try
	    		{
					connection = GetDBConnection.getDBConnection(db);
	    			
	    		if(this.getChequeStatus().equals("ALL"))
	    		{
	    			
	    			sql = "SELECT "
	    					+ "cheque_book_add_date,"
	    					+ "cheque_book_bank_name,"
	    					+ "cheque_book_branch_name,"
	    					+ "cheque_book_account_number,"
	    					+ "cheque_book_account_holder_name,"
	    					+ "cheque_number,"
	    					+ "DATE_FORMAT(cheuqe_pay_date,'%d-%M-%Y'),"
	    					+ "cheque_payee,"
	    					+ "cheque_amount,"
	    					+ "cheque_status,"
	    					+ "DATE_FORMAT(chaque_status_change_date,'%d-%M-%Y'),"
	    					+ "reason_for_cheque_given,"
	    					+ "status_changed_by "
	    					+ "FROM "
	    					+ "cheque_book_details_master "
	    					+ "WHERE "
	    					+ "cheque_book_bank_name = ? "
	    					+ "AND "
	    					+ "cheque_book_branch_name = ? "
	    					+ "AND "
	    					+ "(cheque_book_add_date "
	    					+ "BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
	    					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? ";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, this.getBankName());
	    			preparedStatement.setString(2, this.getBranchName());
	    			preparedStatement.setString(3, this.getFromDate());
	    			preparedStatement.setString(4, this.getToDate());
	    			preparedStatement.setString(5, crusherId);
	    			preparedStatement.setString(6, crusherCode);
	    			
	    			}
	    			else
	    			{
	    				sql = "SELECT "
		    					+ "DATE_FORMAT(cheque_book_add_date,'%d-%M-%Y'),"
		    					+ "cheque_book_bank_name,"
		    					+ "cheque_book_branch_name,"
		    					+ "cheque_book_account_number,"
		    					+ "cheque_book_account_holder_name,"
		    					+ "cheque_number,"
		    					+ "DATE_FORMAT(cheuqe_pay_date,'%d-%M-%Y'),"
		    					+ "cheque_payee,"
		    					+ "cheque_amount,"
		    					+ "cheque_status,"
		    					+ "DATE_FORMAT(chaque_status_change_date,'%d-%M-%Y'),"
		    					+ "reason_for_cheque_given,"
		    					+ "status_changed_by "
		    					+ "FROM "
		    					+ "cheque_book_details_master "
		    					+ "WHERE "
		    					+ "cheque_book_bank_name = ? "
		    					+ "AND "
		    					+ "cheque_book_branch_name = ? "
		    					+ "AND "
		    					+ "cheque_status = ? "
			    				+ "AND "
		    					+ "(cheque_book_add_date "
		    					+ "BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";

		    			preparedStatement = connection.prepareStatement(sql);
		    			
	    				preparedStatement.setString(1, this.getBankName());
		    			preparedStatement.setString(2, this.getBranchName());
		    			preparedStatement.setString(3, this.getChequeStatus());
		    			preparedStatement.setString(4, this.getFromDate());
		    			preparedStatement.setString(5, this.getToDate());
		    			preparedStatement.setString(6, crusherId);
		    			preparedStatement.setString(7, crusherCode);
		    			
	    			}
	    		
	    		
	    			resultSet = preparedStatement.executeQuery();
	    			resultSet.last();
	    			
	    			int rowCount = resultSet.getRow();
	    			
	    			resultSet.beforeFirst();
	    			
	    			if(rowCount > 0 )
	    			{
	    				while(resultSet.next())
	    				{
	    					ChequeInfoDAO dao = new ChequeInfoDAO();
	    					
	    					dao.setChequeBookAddDate(resultSet.getString(1));
	    					dao.setBankName(resultSet.getString(2));
	    					dao.setBranchName(resultSet.getString(3));
	    					dao.setAccountNumber(resultSet.getString(4));
	    					dao.setAccHolderName(resultSet.getString(5));
	    					dao.setChequeNumber(resultSet.getString(6));
	    					dao.setChequePayDate(resultSet.getString(7));
	    					dao.setChequePayee(resultSet.getString(8));
	    					dao.setAmount(resultSet.getString(9));
	    					dao.setStatus(resultSet.getString(10));
	    					dao.setStatusChangeDate(resultSet.getString(11));
	    					dao.setReason(resultSet.getString(12));
	    					dao.setStatusChangedBy(resultSet.getString(13));
	    					dao.setKey(URLEncoder.encode
	    							(EncryptionDecryption.encrypt
	    									(resultSet.getString(2)
	    									+"#"+resultSet.getString(3)
	    									+"#"+resultSet.getString(4)
	    									+"#"+resultSet.getString(6)),"UTF-8"));
	    					
	    					//KEY = BANK_NAME#BRANCH_NAME#ACC_NUMBER#CHEQUE_NUMBER
	    					
	    				
	    					this.getChequeInfoList().add(dao);
	    					
	    				}
	    				
	    				result = "success";
	    			}
	    			else
	    			{
	    				result = "error";
	    				addActionError(this.getText("message.error.recoredsNotFound"));
	    			}
	    			
	    		}
	    			
	    			catch (SQLException e) {
		    			
		    			result = "error";
		    			e.printStackTrace();
		    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
		    		} catch (IOException e) {
		    			result = "error";
		    			
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
		    		} finally {
		    			if(resultSet != null)
						{
							try {
								resultSet.close();
							} catch (SQLException e) {
								
							}
						}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close();} catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close();}catch (SQLException e) {}
		    			}
		    			
		    		}
	        	
	        }
	        
	        return result;
	}

	@Override
	public void validate() {
		session=ServletActionContext.getRequest().getSession(false); 
		
		Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
	 
		String sql = "";
		String db = (String) session.getAttribute("db");
		
    	try
		{
			connection = new GetDBConnection().getDBConnection(db);
			
			sql = "SELECT "
   					+ "cheque_book_bank_name "
   					+ "FROM "
   					+ "cheque_book_details_master "
   					+ "GROUP BY "
   					+ "cheque_book_bank_name";
   			
   			
   			preparedStatement = connection.prepareStatement(sql);
   			resultSet = preparedStatement.executeQuery();
   		
   			
   			while(resultSet.next())
   			{
   				bankList.add(resultSet.getString(1));
   			}
   			
   			chequeSatusList.add("ALL");
   			chequeSatusList.add("ACTIVE");
   			chequeSatusList.add("CANCELLED");
   			chequeSatusList.add("GIVEN");
   			chequeSatusList.add("PASSED");
   			chequeSatusList.add("BOUNCED");
   			chequeSatusList.add("STOPPED");
   			chequeSatusList.add("MISPLACED");
			
   			downloadTypeList.add("pdf");
   	    	downloadTypeList.add("xl");
   	    	
		}
			
			catch (SQLException e) {
    			
    			
    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
    		} catch (IOException e) {
    			
    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
    		} finally {
    			if(resultSet != null)
				{
					try {
						resultSet.close();
					} catch (SQLException e) {
						
					}
				}
    			if(preparedStatement != null)
    			{
    				try {preparedStatement.close();} catch (SQLException e) {}
    			}
    			if(connection != null)
    			{
    				
    				try {connection.close();}catch (SQLException e) {}
    			}
    			
    		}
    	
    	
    	if(this.getFromDate().equals("") && this.getToDate().equals(""))
    	{
    		addActionError(this.getText("message.error.plzSelectDatesAtWhichChequeBookIsAdded"));
    	}
    	
    	if(!hasActionErrors())
    	{
    		if(this.getBankName().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectBank"));
    		}
    	}
    	
    	if(!hasActionErrors())
    	{
    		if(this.getBranchName().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectBranch"));
    		}
    	}
    	
    	if(!hasActionErrors())
    	{
    		if(this.getChequeStatus().equals(""))
    		{
    			addActionError(this.getText("message.error.plzSelectChequeStatus"));
    		}
    	}
    	
    	this.setAddSideBarJs("FALSE");
    
	}

	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public String getBankName() {
		return bankName;
	}


	public void setBankName(String bankName) {
		this.bankName = bankName;
	}


	public String getBranchName() {
		return branchName;
	}


	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}


	public List<ChequeInfoDAO> getChequeInfoList() {
		return chequeInfoList;
	}


	public void setChequeInfoList(List<ChequeInfoDAO> chequeInfoList) {
		this.chequeInfoList = chequeInfoList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getChequeStatus() {
		return chequeStatus;
	}

	public void setChequeStatus(String chequeStatus) {
		this.chequeStatus = chequeStatus;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}

	public List<String> getChequeSatusList() {
		return chequeSatusList;
	}

	public void setChequeSatusList(List<String> chequeSatusList) {
		this.chequeSatusList = chequeSatusList;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
}

