package com.stonecrusher.report;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.BoulderInwardInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.opensymphony.xwork2.ActionSupport;

public class GetBoulderInwardReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2752394312202912406L;
	private SessionMap<String,Object> sessionMap;  
	private String fromDate;
	private String toDate;
	
	private List<BoulderInwardInfoDAO> boulderInwardList = new ArrayList<BoulderInwardInfoDAO>();
	
	private Float totalQuantity;
	
	private String vehicleId;
	private String boulderSupplierId;
	
	private String addSideBarJs;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
							
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				HashMap<String,String> inwardUnitList = GetListResource.GetBoulderInwardUnitList();
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					if(this.getVehicleId() == null)
					{
						this.setVehicleId("");
					}
					
					if(this.getBoulderSupplierId() == null)
					{
						this.setBoulderSupplierId("");
					}
					
					HashMap<String,String> boulderSuppList = GetListResource.getBoulderSupplierList(this.getSessionMap());
					
					if(this.getVehicleId().length() == 0 && this.getBoulderSupplierId().length() == 0)
					{
					
						sql = "SELECT "
								+ "indetails.entry_id,"
								+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
								+ "indetails.vehicle_id,"
								+ "indetails.vehicle_number,"
								+ "indetails.boulder_quantity,"
								+ "indetails.boulder_quantity_unit,"
								+ "indetails.inward_from,"
								+ "indetails.inward_to,"
								+ "indetails.entry_by,"
								+ "indetails.bill_generated_status,"
								+ "vemap.boulder_supplier_id "
								+ "FROM "
								+ "boulder_inward_details AS indetails "
								+ "INNER JOIN "
								+ "boulder_supplier_vehicle_mapping_master AS vemap "
								+ "ON "
								+ "indetails.vehicle_id = vemap.vehicle_id "
								+ "WHERE "
								+ "indetails.crusher_id = ? "
								+ "AND "
								+ "indetails.crusher_code = ? "
								+ "AND "
								+ "vemap.crusher_id = ? "
								+ "AND "
								+ "vemap.crusher_code = ? "
								+ "AND "
								+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						preparedStatement.setString(5, this.getFromDate());
						preparedStatement.setString(6, this.getToDate());
					}
					else if(this.getVehicleId().length() > 0 && this.getBoulderSupplierId().length() == 0)
					{

						String [] vehicleDetails = this.getVehicleId().split("-");
						
						sql = "SELECT "
								+ "indetails.entry_id,"
								+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
								+ "indetails.vehicle_id,"
								+ "indetails.vehicle_number,"
								+ "indetails.boulder_quantity,"
								+ "indetails.boulder_quantity_unit,"
								+ "indetails.inward_from,"
								+ "indetails.inward_to,"
								+ "indetails.entry_by,"
								+ "indetails.bill_generated_status,"
								+ "vemap.boulder_supplier_id "
								+ "FROM "
								+ "boulder_inward_details AS indetails "
								+ "INNER JOIN "
								+ "boulder_supplier_vehicle_mapping_master AS vemap "
								+ "ON "
								+ "indetails.vehicle_id = vemap.vehicle_id "
								+ "WHERE "
								+ "indetails.crusher_id = ? "
								+ "AND "
								+ "indetails.crusher_code = ? "
								+ "AND "
								+ "vemap.crusher_id = ? "
								+ "AND "
								+ "vemap.crusher_code = ? "
								+ "AND "
								+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "indetails.vehicle_id = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						preparedStatement.setString(5, this.getFromDate());
						preparedStatement.setString(6, this.getToDate());
						preparedStatement.setString(7, vehicleDetails[0]);
					}
					else if(this.getVehicleId().length() > 0 && this.getBoulderSupplierId().length() > 0)
					{

						String [] vehicleDetails = this.getVehicleId().split("-");
						String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
						
						sql = "SELECT "
								+ "indetails.entry_id,"
								+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
								+ "indetails.vehicle_id,"
								+ "indetails.vehicle_number,"
								+ "indetails.boulder_quantity,"
								+ "indetails.boulder_quantity_unit,"
								+ "indetails.inward_from,"
								+ "indetails.inward_to,"
								+ "indetails.entry_by,"
								+ "indetails.bill_generated_status,"
								+ "vemap.boulder_supplier_id "
								+ "FROM "
								+ "boulder_inward_details AS indetails "
								+ "INNER JOIN "
								+ "boulder_supplier_vehicle_mapping_master AS vemap "
								+ "ON "
								+ "indetails.vehicle_id = vemap.vehicle_id "
								+ "WHERE "
								+ "indetails.crusher_id = ? "
								+ "AND "
								+ "indetails.crusher_code = ? "
								+ "AND "
								+ "vemap.crusher_id = ? "
								+ "AND "
								+ "vemap.crusher_code = ? "
								+ "AND "
								+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "indetails.vehicle_id = ? "
								+ "AND "
								+ "vemap.boulder_supplier_id = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						preparedStatement.setString(5, this.getFromDate());
						preparedStatement.setString(6, this.getToDate());
						preparedStatement.setString(7, vehicleDetails[0]);
						preparedStatement.setString(8, boulderSuppDetails[0]);
					}
					
					else if(this.getVehicleId().length() == 0 && this.getBoulderSupplierId().length() > 0)
					{

						String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
						
						sql = "SELECT "
								+ "indetails.entry_id,"
								+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
								+ "indetails.vehicle_id,"
								+ "indetails.vehicle_number,"
								+ "indetails.boulder_quantity,"
								+ "indetails.boulder_quantity_unit,"
								+ "indetails.inward_from,"
								+ "indetails.inward_to,"
								+ "indetails.entry_by,"
								+ "indetails.bill_generated_status,"
								+ "vemap.boulder_supplier_id "
								+ "FROM "
								+ "boulder_inward_details AS indetails "
								+ "INNER JOIN "
								+ "boulder_supplier_vehicle_mapping_master AS vemap "
								+ "ON "
								+ "indetails.vehicle_id = vemap.vehicle_id "
								+ "WHERE "
								+ "indetails.crusher_id = ? "
								+ "AND "
								+ "indetails.crusher_code = ? "
								+ "AND "
								+ "vemap.crusher_id = ? "
								+ "AND "
								+ "vemap.crusher_code = ? "
								+ "AND "
								+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "vemap.boulder_supplier_id = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						preparedStatement.setString(5, this.getFromDate());
						preparedStatement.setString(6, this.getToDate());
						preparedStatement.setString(7, boulderSuppDetails[0]);
					}
					
					resultSet = preparedStatement.executeQuery();
					
					this.setTotalQuantity(0.0f);
					
					while(resultSet.next())
					{
						BoulderInwardInfoDAO dao = new BoulderInwardInfoDAO();
						
						dao.setEntryId(resultSet.getString(1));
						dao.setInwardDate(resultSet.getString(2));
						dao.setVehicleId(resultSet.getString(3));
						dao.setVehicleNumber(resultSet.getString(4));
						dao.setBoulderQuantity(resultSet.getFloat(5));
						dao.setBoulderInwardUnit(inwardUnitList.get(resultSet.getString(6)));
						dao.setFromPlace(resultSet.getString(7));
						dao.setToPlace(resultSet.getString(8));
						dao.setBillGeneratedStatus(resultSet.getString(10));
						dao.setBoulderSuppName(boulderSuppList.get(resultSet.getString(11)));
						
						this.setTotalQuantity(((this.getTotalQuantity() + resultSet.getFloat(5))*100.F) / 100.F);
						
						dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(3)));
						
						this.getBoulderInwardList().add(dao);
						
						
					}
					
					
					
					if(this.getBoulderInwardList().size() > 0)
					{
						result = SUCCESS;
					}
					else
					{
						result  = ERROR;
						addActionError("Details not found!");
					}
					
				}
				catch (SQLException e) {
					e.printStackTrace();
					result = ERROR;
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong 1!");
				}
				catch (Exception e) {
					e.printStackTrace();
						result = ERROR;
					
					addActionError(e.getMessage() +" || Something Went Wrong 2!");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		this.setAddSideBarJs("FALSE");
		
		if(this.getBoulderSupplierId() != null && this.getBoulderSupplierId().trim().length() > 0)
		{
			try
			{
				String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
				
				if(boulderSuppDetails.length < 2)
				{
					addActionError("Please provide boulder supplier details properly!");
				}
				
			}catch(Exception e)
			{
				addActionError("Please provide boulder supplier details properly!");
			}
		}
		
		
		if(this.getVehicleId() != null && this.getVehicleId().trim().length() > 0)
		{
			try
			{
				String [] vehicleDetails = this.getVehicleId().split("-");
				
				if(vehicleDetails.length < 2)
				{
					addActionError("Please provide vehicle details properly!");
				}
				
			}catch(Exception e)
			{
				addActionError("Please provide vehicle details properly!");
			}
		}
	}
	
	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public List<BoulderInwardInfoDAO> getBoulderInwardList() {
		return boulderInwardList;
	}



	public void setBoulderInwardList(List<BoulderInwardInfoDAO> boulderInwardList) {
		this.boulderInwardList = boulderInwardList;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public Float getTotalQuantity() {
		return totalQuantity;
	}



	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}



	public String getVehicleId() {
		return vehicleId;
	}



	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getBoulderSupplierId() {
		return boulderSupplierId;
	}

	public void setBoulderSupplierId(String boulderSupplierId) {
		this.boulderSupplierId = boulderSupplierId;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



