	package com.stonecrusher.report;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.DailyExpenseDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class DailyExpenseReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8591113875387565921L;

	private SessionMap<String,Object> sessionMap;
	private HttpSession session;
	private String fromDate;
	private String toDate;
	private List<DailyExpenseDAO> dailyExpenseList = new ArrayList<DailyExpenseDAO>();
	private Float totalExpenseAmount = 0.0F;
	private String addSideBarJs;
	private HashMap<String,String> accountHeadMapList = new HashMap<String,String>(); 
	private String accountHeadId;
	private Map<String,String> siteList = new LinkedHashMap<String,String>();
	private String siteCode;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	
	public String execute(){
		String result = "login";
		this.setSession(ServletActionContext.getRequest().getSession(false)); 
		 
	        if(this.getSession()==null || this.getSession().getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{

	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	       
	  
	    		
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) this.getSession().getAttribute("db");
	    		
	    		try
	    		{
	    		
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
					if(this.getAccountHeadId().equals("ALL")  && this.getSiteCode().equals("ALL"))
					{
		    			sql = "SELECT "
		    					+ "entry_id,"
		    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
		    					+ "expense_reason,"
		    					+ "expense_amount,"
		    					+ "type_of_payment,"
		    					+ "expense_details,"
		    					+ "expense_bill_image "
		    					+ "FROM "
		    					+ "crusher_daily_expenses "
		    					+ "WHERE "
		    					+ "(expense_date BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
		    					
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, crusherId);
		    			preparedStatement.setString(4, crusherCode);
		    			
		    			
					}else if(!this.getAccountHeadId().equals("ALL")  && this.getSiteCode().equals("ALL"))
					{
		    			sql = "SELECT "
		    					+ "entry_id,"
		    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
		    					+ "expense_reason,"
		    					+ "expense_amount,"
		    					+ "type_of_payment,"
		    					+ "expense_details,"
		    					+ "expense_bill_image "
		    					+ "FROM "
		    					+ "crusher_daily_expenses "
		    					+ "WHERE "
		    					+ "(expense_date BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "head_id = ? "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
		    			
		    					
		    					
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, this.getAccountHeadId());
		    			preparedStatement.setString(4, crusherId);
		    			preparedStatement.setString(5, crusherCode);
		    			
		    			
		    			
		    			
					}else if(this.getAccountHeadId().equals("ALL")  && !this.getSiteCode().equals("ALL"))
					{
		    			sql = "SELECT "
		    					+ "entry_id,"
		    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
		    					+ "expense_reason,"
		    					+ "expense_amount,"
		    					+ "type_of_payment,"
		    					+ "expense_details,"
		    					+ "expense_bill_image "
		    					+ "FROM "
		    					+ "crusher_daily_expenses "
		    					+ "WHERE "
		    					+ "(expense_date BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "site_code = ? "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
		    			
		    					
		    					
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getFromDate());
		    			preparedStatement.setString(2, this.getToDate());
		    			preparedStatement.setString(3, this.getSiteCode());
		    			preparedStatement.setString(4, crusherId);
		    			preparedStatement.setString(5, crusherCode);
		    			
		    			
		    			
					} else
					{
						sql = "SELECT "
		    					+ "entry_id,"
		    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
		    					+ "expense_reason,"
		    					+ "expense_amount,"
		    					+ "type_of_payment,"
		    					+ "expense_details,"
		    					+ "expense_bill_image "
		    					+ "FROM "
		    					+ "crusher_daily_expenses "
		    					+ "WHERE "
		    					+ "head_id = ? "
		    					+ "AND "
		    					+ "(expense_date BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
		    					+ "site_code = ? "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
						
						
						
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getAccountHeadId());
		    			preparedStatement.setString(2, this.getFromDate());
		    			preparedStatement.setString(3, this.getToDate());
		    			preparedStatement.setString(4, this.getSiteCode());
		    			preparedStatement.setString(5, crusherId);
		    			preparedStatement.setString(6, crusherCode);
		    			
					}
	    			
	    			resultSet = preparedStatement.executeQuery();
	    			resultSet.last();
	    			int resultCount = resultSet.getRow();
	    			resultSet.beforeFirst();
	    			
	    			if(resultCount > 0)
	    			{
	    				while(resultSet.next())
	    				{
	    					DailyExpenseDAO dailyExpenseDAO = new DailyExpenseDAO();
	    					dailyExpenseDAO.setId(resultSet.getString(1));
	    					dailyExpenseDAO.setExpenseDate(resultSet.getString(2));
	    					dailyExpenseDAO.setExpenseReason(resultSet.getString(3));
	    					dailyExpenseDAO.setAmount(resultSet.getString(4));
	    					dailyExpenseDAO.setTypeOfPayment(resultSet.getString(5));
	    					dailyExpenseDAO.setDescription(resultSet.getString(6));
	    					dailyExpenseDAO.setExpenseImage(resultSet.getBlob(7));
	    					dailyExpenseDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(4)));
	    					this.setTotalExpenseAmount(this.getTotalExpenseAmount()+Float.parseFloat(resultSet.getString(4)));
	    					
	    					dailyExpenseDAO.setExpenseId(EncryptionDecryption.encrypt(resultSet.getString(1)));
	    					dailyExpenseDAO.setExpenseSaved(true);
	    					
	    					dailyExpenseList.add(dailyExpenseDAO);
	    					
	    				}
	    				result = "success";
	    			}
	    			else
	    			{
	    				result = "success";
	    				addActionError(this.getText("message.error.recordsNotFoundForSpecificDates"));
	    			}
	    			
	    		}
	    		 catch (SQLException e) {
		    			e.printStackTrace();
		    			result = "error";
		    			
		    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
		    		} catch (IOException e) {
		    			result = "error";
		    			
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
		    		} finally {
		    			if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close(); connection = null;}catch (SQLException e) {}
		    			}
		    			
		    		}
	        	
	        }
	        
	        return result;
	}

	public HashMap<String, String> getAccountHeadMapList() {
		return accountHeadMapList;
	}

	public void setAccountHeadMapList(HashMap<String, String> accountHeadMapList) {
		this.accountHeadMapList = accountHeadMapList;
	}

	@Override
	public void validate() {
		this.setAddSideBarJs("FALSE");
		
		
		if(this.getFromDate().equals("") && this.getToDate().equals(""))
		{
			addActionError(this.getText("message.error.plzSelectDates"));
		}
		
		this.setAccountHeadMapList(GetListResource.getAccountHeadList());
		this.setSiteList(GetListResource.getSiteList());
		downloadTypeList.add("pdf");
    	downloadTypeList.add("xl");
    	
	}
	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public List<DailyExpenseDAO> getDailyExpenseList() {
		return dailyExpenseList;
	}

	public void setDailyExpenseList(List<DailyExpenseDAO> dailyExpenseList) {
		this.dailyExpenseList = dailyExpenseList;
	}

	public Float getTotalExpenseAmount() {
		return totalExpenseAmount;
	}

	public void setTotalExpenseAmount(Float totalExpenseAmount) {
		this.totalExpenseAmount = totalExpenseAmount;
	}

	public String getAccountHeadId() {
		return accountHeadId;
	}

	public void setAccountHeadId(String accountHeadId) {
		this.accountHeadId = accountHeadId;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getSiteList() {
		return siteList;
	}

	public void setSiteList(Map<String, String> siteList) {
		this.siteList = siteList;
	}

	public String getSiteCode() {
		return siteCode;
	}

	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
}
