package com.stonecrusher.render;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class RenderInsurancePDFFile extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4187343623745467847L;
	
	private HttpSession session;
	
	
	public void rederVehicleInsurance(){
		
		HttpServletResponse response = ServletActionContext.getResponse();
		HttpServletRequest request = ServletActionContext.getRequest();
		
		String vehicleId = request.getParameter("id");
		
		session=ServletActionContext.getRequest().getSession(false); 
		Connection connection = null;
   		PreparedStatement preparedStatement= null;	
   		ResultSet resultSet = null;
   		
   		String sql = "";
   		String db = (String) session.getAttribute("db");
   		String crusherId = (String) session.getAttribute("crusherId");
		String crusherCode = (String) session.getAttribute("crusherCode");
		

   		try
   		{
   		
   		if(db!=null)
   		{
   			connection = new GetDBConnection().getDBConnection(db);
   			
   			sql = "SELECT insurance_image_file from crusher_vehicle_details_master where vehicle_id = ? "
   					+ "AND "
					+ "crusher_id = ? "
					+ "AND "
					+ "crusher_code = ?";
   			
   			preparedStatement = connection.prepareStatement(sql);
   			preparedStatement.setString(1,vehicleId);
   			preparedStatement.setString(2, crusherId);
			preparedStatement.setString(3, crusherCode);
			
			
			resultSet = preparedStatement.executeQuery();
			if (resultSet.next()) {
			    Blob fileBlob = resultSet.getBlob("insurance_image_file");
			    byte[] data = fileBlob.getBytes(1, (int) fileBlob.length());

			   
			    String contentType = "application/octet-stream";
			    String fileExtension = ".bin";

			   
			    if (data.length >= 4) {
			        
			        if (data[0] == 0x25 && data[1] == 0x50 && data[2] == 0x44 && data[3] == 0x46) {
			            contentType = "application/pdf";
			            fileExtension = ".pdf";
			        }
			        
			        else if ((data[0] & 0xFF) == 0xFF && (data[1] & 0xFF) == 0xD8 && (data[2] & 0xFF) == 0xFF) {
			            contentType = "image/jpeg";
			            fileExtension = ".jpg";
			        }
			       
			        else if ((data[0] & 0xFF) == 0x89 && (data[1] & 0xFF) == 0x50 && (data[2] & 0xFF) == 0x4E && (data[3] & 0xFF) == 0x47) {
			            contentType = "image/png";
			            fileExtension = ".png";
			        }
			        
			    }

			    
			    response.setContentType(contentType);
			    response.setHeader("Content-Disposition", "attachment; filename=\"Insurance_File_" + vehicleId + fileExtension + "\"");
			    response.setContentLength(data.length);

			   
			    OutputStream out = response.getOutputStream();
			    out.write(data);
			    out.flush();
			    out.close();
			}

   		}
   		}catch (SQLException e) {
			addActionError(e.getErrorCode()+ "| Connection Error !!!");
			e.printStackTrace();
		}catch (IOException e) {
			addActionError(e.getMessage()+ "| Connection Error !!!");
			e.printStackTrace();
		}
		finally
		{
			if(resultSet != null)
			{
				try {
					resultSet.close();
				} catch (SQLException e) {
					
				}
			}
			if(preparedStatement != null)
			{
				try {
					
					preparedStatement.close();
				} catch (SQLException e) {
					
				}
			}
			if(connection != null)
			{
				try {
					
					connection.close();
				} catch (SQLException e) {
					
					//e.printStackTrace();
				}
			}
			
		}
		
		
	}
	

}