package com.stonecrusher.print;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;
import static org.vandeseer.easytable.settings.VerticalAlignment.BOTTOM;
import static org.vandeseer.easytable.settings.VerticalAlignment.MIDDLE;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.struts2.ServletActionContext;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetTaxPercentageByTaxId;
import com.stonecrusher.utils.NumberToWordsConverter;



public class PrintQuotation extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1414976236123269184L;
	/**
	 * 
	 */

	
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	
	
	
	
	private BillInformationDAO quotationInfoDAO = null;
	private List<BillProductInfoDAO> productInfoList = null;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private String quotationNumner;
	private String size;
	private String lang;
 
	private String nameOfBank;
	private String bankingName;
	private String nameOfBranch;
	private String accountNumber;
	private String ifscCode;
	
	
	private String billType;
	
	  private final static Color BLUE_DARK = new Color(76, 129, 190);
	    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
	    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

	    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
	    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
	    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
	    private static final float PADDING10 = 0.5F;
	    private static final float PADDING20 = 20f;
	    private static final float PADDING30 = 30f;
	    private static final float PADDING40 = 40f;
	    private static final float PADDING50 = 50f;
	
	
	public void printQuotationOnly() throws Exception {
		String vehicleNumber = "";
    	String tripFrom = "";
    	String tripTo = "";
    	String vehicleMake = "";
    	String driverName = "";
    	String driverMobileNumber = "";
    	String custNameMarathi = "";
    	String custAddMarathi = "";
    	String quotationTime = "";
		boolean isQuotationNumberFound = false;
		String custGSTNo = "";
		String custPinCodeNumber = "";
		//System.out.println("Bill Number : "+billNumber);
		String noOfTrips = "1";
		DecimalFormat df = new DecimalFormat("##.##");
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		String crushernameenglish = (String) this.getSessionMap().get("crushernameenglish");
	    		
	    		
	    		 
	    		this.setNameOfBank((String) this.getSessionMap().get("name_of_bank"));
	    		this.setBankingName((String) this.getSessionMap().get("banking_name"));
				this.setNameOfBranch((String) this.getSessionMap().get("name_of_branch"));
				this.setAccountNumber((String) this.getSessionMap().get("account_number"));
				this.setIfscCode((String) this.getSessionMap().get("ifsc_code"));
				
				
				String crushercustcarenumber = (String) this.getSessionMap().get("crushercustcarenumber");
				String crushergstnumber = (String) this.getSessionMap().get("crushergstnumber");

	    		
				String sql = "";
				String db = "crushererpsoft";
				String quotationDateTime = "";
				try
	        	{
	        		
					quotationInfoDAO = new BillInformationDAO();
					productInfoList = new ArrayList<BillProductInfoDAO>();
	        	      
	        
				connection = GetDBConnection.getDBConnection(db);
	        	
	        	sql = "select "
	        			+ "DATE_FORMAT(quotationdate,'%d-%M-%Y'),"
	        			+ "quotationtime,"
	        			+ "custid,"
	        			+ "customername,"
	        			+ "transportcharges,"
	        			+ "comments,"
	        			+ "quotationtotalamount,"
	        			+ "quotation_by "
	        			+ "FROM "
	        			+ "quotation_info "
	        			+ "WHERE "
	        			+ "quotationnumber = ? "
    					+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?";
	        	
	        	preparedStatement = connection.prepareStatement(sql);
	        	preparedStatement.setString(1, this.getQuotationNumner());
	        	preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				
	        	resultSet = preparedStatement.executeQuery();
	        	
	        	resultSet.last();
	        	int rowCount = resultSet.getRow();
	        	resultSet.beforeFirst();	        	
	        	
	        	if(rowCount>0)
	        	{
	        		
	        		isQuotationNumberFound = true;
	        	while(resultSet.next())
	        	{
	        		quotationInfoDAO.setBillDate(resultSet.getString(1));
	        		quotationDateTime = resultSet.getString(1)+" "+resultSet.getString(2);
	        		quotationTime = resultSet.getString(2);
	        		quotationInfoDAO.setBillNumber(getQuotationNumner());
	        		quotationInfoDAO.setCustId(resultSet.getString(3));
	        		quotationInfoDAO.setCustomerName(resultSet.getString(4)); 
	        		quotationInfoDAO.setTransportCharge(resultSet.getFloat(5));
	        		quotationInfoDAO.setComments(resultSet.getString(6));
	        		quotationInfoDAO.setTotalBillAmount(resultSet.getString(7));
	        		quotationInfoDAO.setBilledBy(resultSet.getString(8));
	        		
	        		
					/*
					 * float totalAmtPaid = Float.parseFloat(resultSet.getString(10)); float
					 * totalBillAmt = Float.parseFloat(resultSet.getString(9));
					 * 
					 * float balanceAmount = totalAmtPaid - totalBillAmt;
					 * 
					 * quotationInfoDAO.setTotalAmountBalance(""+balanceAmount) ;
					 */
	        		
	        		
	        	}
	        	
	        	

	        	if(resultSet != null)
	        	{
	        		resultSet.close();
	        		resultSet = null;
	        	}
	        	if(preparedStatement != null)
	        	{
	        		preparedStatement.close();
	        		preparedStatement = null;
	        	
	        	}
	        	
	        	
			        	
			        	sql = "SELECT "
			        			+ "customer_id,"
			        			+ "customer_name,"
			        			+ "cust_name_marathi,"
			        			+ "billing_address,"
			        			+ "billing_address_marathi,"
			        			+ "pincode_number,"
			        			+ "gst_number "
			        			+ "FROM "
			        			+ "crusher_customer_master "
			        			+ "WHERE "
			        			+ "customer_id = ? "
			        			+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
			        	
			        	preparedStatement = connection.prepareStatement(sql);
			        	preparedStatement.setString(1, quotationInfoDAO.getCustId());
			        	preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
			        	resultSet = preparedStatement.executeQuery();
			        	
			        	if(resultSet.next())
			        	{
			        		
			        		quotationInfoDAO.setCustomerAddress(resultSet.getString(4));
			        		custNameMarathi = resultSet.getString(3);
			        		custAddMarathi = resultSet.getString(5);
			        		custPinCodeNumber = resultSet.getString(6);
			        		custGSTNo = resultSet.getString(7);
			        	}
			        	else
			        	{
			        		quotationInfoDAO.setCustomerAddress("");
			        	}
			        	
			        	if(resultSet != null)
			        	{
			        		resultSet.close();
			        		resultSet = null;
			        	}
			        	if(preparedStatement != null)
			        	{
			        		preparedStatement.close();
			        		preparedStatement = null;
			        	
			        	}
			        	sql = "SELECT "
			        			+ "productname,"
			        			+ "productnamemarathi,"
			        			+ "salesunit,"
			        			+ "taxpercentage,"
			        			+ "salesrate,"
			        			+ "quanity,"
			        			+ "discountpercentage,"
			        			+ "discountrupees,"
			        			+ "productamount,"
			        			+ "productamtafterdiscount,"
			        			+ "grossamount,"
			        			+ "igst,"
			        			+ "cgst,"
			        			+ "sgst "
			        			+ "FROM "
			        			+ "product_quotation_info "
			        			+ "where quotationnumber = ? "
			        			+ "AND "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
			        	
			        	
			        	preparedStatement = connection.prepareStatement(sql);
			        	preparedStatement.setString(1, this.getQuotationNumner());
			        	preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
        				resultSet = preparedStatement.executeQuery();
			        	
			        	while(resultSet.next())
			        	{
			        		String getHSNCode = "SELECT hsn_sac_code FROM "
			        				+ "crusher_product_master WHERE product_name_eng = ? "
			        				+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
			        		
			        	 PreparedStatement getHSNCodePSMT = connection.prepareStatement(getHSNCode);
			        	 
			        	 getHSNCodePSMT.setString(1, resultSet.getString(1));
			        	 getHSNCodePSMT.setString(2, crusherId);
			        	 getHSNCodePSMT.setString(3, crusherCode);
	        				
			        	 ResultSet getHSNRs = getHSNCodePSMT.executeQuery();
			        	 String hsnCode = "";
			        	 if(getHSNRs.next())
			        	 {
			        		 hsnCode = getHSNRs.getString(1);
			        	 }
			        	 else
			        	 {
			        		 hsnCode = "NA";
			        	 }
			        	 
			        	 if(getHSNRs != null)
			        	 {
			        		 getHSNRs.close();
			        		 getHSNRs = null;
			        	 }
			        	 
			        	 if(getHSNCodePSMT != null)
			        	 {
			        		 getHSNCodePSMT.close();
			        		 getHSNCodePSMT = null;
			        	 }
			        	 
			        		BillProductInfoDAO billProductInfoDAO = new BillProductInfoDAO();
			        		billProductInfoDAO.setProductName(resultSet.getString(1));
			        		billProductInfoDAO.setProductNameMarathi(resultSet.getString(2));
			        		billProductInfoDAO.setSalesUnit(resultSet.getString(3));
			        		billProductInfoDAO.setTaxId(resultSet.getString(4));
			        		billProductInfoDAO.setTaxPercentage(""+GetTaxPercentageByTaxId.getTaxPercentageById(resultSet.getString(4), connection, this.getSessionMap()));
			        		billProductInfoDAO.setSalesRate(resultSet.getFloat(5));
			        		billProductInfoDAO.setQuantity(resultSet.getFloat(6));
			        		billProductInfoDAO.setDiscountPecentage(resultSet.getFloat(7));
			        		billProductInfoDAO.setDiscountRupees(resultSet.getFloat(8));
			        		billProductInfoDAO.setAmount(resultSet.getFloat(9));
			        		billProductInfoDAO.setAmountAfterDiscount(resultSet.getFloat(10));
			        		billProductInfoDAO.setGrossAmount(resultSet.getFloat(11));
			        		billProductInfoDAO.setIgst(resultSet.getFloat(12));
			        		billProductInfoDAO.setCgst(resultSet.getFloat(13));
			        		billProductInfoDAO.setSgst(resultSet.getFloat(14));
			        		billProductInfoDAO.setProductHSNCode(hsnCode);
			        		productInfoList.add(billProductInfoDAO);
			        		
			        				
			        	}
			        	
	        	}
	        	
				if(isQuotationNumberFound)
				{

						
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	int listSize = productInfoList.size();
		        	float paperHightSize = 0.0f;
		        	paperHightSize = (listSize*30)+320;
		        	

		        	for(BillProductInfoDAO infoDAO : productInfoList)
		        	{
		        		//System.out.print("Amount after discount : "+infoDAO.getProductTotalDiscount());
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + (infoDAO.getQuantity() * infoDAO.getDiscountRupees());
		        			        		
		        	}
		        	
		        	/*System.out.println("Total Amount : "+floatTotalAmount);
		        	System.out.println("Total Discount : "+floatTotalDiscount);
		        	System.out.println("Total amount Payble : "+floatTotalAmtAfterDiscount);*/
		        	
		        	String address = (String) this.getSessionMap().get("crusheronelineaddress");
			        
		        	String contactPersonName = "";
		        	String contactMobile = "";
		        	 float totalMaterialCost = 0.0F;
		        	
		        	response = ServletActionContext.getResponse();
		 			
		 			request = ServletActionContext.getRequest();
		 			
		 			String path = request.getSession().getServletContext().getRealPath("/images/");
		 			

					  PDImageXObject pdLeftLogoImage = null;
					  PDImageXObject pdRightLogoImage = null;
	                  PDImageXObject pdOwnerSignImage = null;
					  PDImageXObject pdCompanyStampImage = null;
						
					  
					
					if(this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A4") )
					{
						
						//System.out.println("Bill Type:"+billInfoDAO.getBillType());
						PDDocument document = new PDDocument(); 
						PDPage page = null;
						 page = new PDPage(PDRectangle.A4);
					
					
				         document.addPage(page);
				         
				         
				         if(this.getSessionMap().get("left_logo_image_array") != null)
						 {
							 byte[] leftLogoBytes = (byte[]) this.getSessionMap().get("left_logo_image_array");
							
							 if (leftLogoBytes != null) 
							 {
							     String leftLogoFilePath = path + "/left_logo_temp.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(leftLogoFilePath))
							     {
							         fos.write(leftLogoBytes); 
							     }					      
							
							     pdLeftLogoImage = PDImageXObject.createFromFile(leftLogoFilePath, document); 
							 }
						 }
						 
						 if(this.getSessionMap().get("right_logo_image_array") != null)
						 {
						  byte[] rightLogoBytes = (byte[]) this.getSessionMap().get("right_logo_image_array");
							 if (rightLogoBytes != null) {
							     String rightLogoFilePath = path + "/right_logo_temp.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(rightLogoFilePath)) {
							         fos.write(rightLogoBytes); 
							     }

							      
							
							     pdRightLogoImage = PDImageXObject.createFromFile(rightLogoFilePath, document); 
							 }
						 }
							 
							 
						 if(this.getSessionMap().get("owner_sign_image_array") != null)
						 {
							 byte[] signImageBytes = (byte[]) this.getSessionMap().get("owner_sign_image_array");
							 if (signImageBytes != null) {
							     String signImageFilePath = path + "/owner_sign_image.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(signImageFilePath)) {
							         fos.write(signImageBytes); 
							     }
		
							      
							
							     pdOwnerSignImage = PDImageXObject.createFromFile(signImageFilePath, document); 
							 }
						 }
						 
						 if(this.getSessionMap().get("company_stamp_image_array") != null)
						 {
							 byte[] stampImageBytes = (byte[]) this.getSessionMap().get("company_stamp_image_array");
							 if (stampImageBytes != null) {
							     String stampImageFilePath = path + "/company_stamp_image.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(stampImageFilePath)) {
							         fos.write(stampImageBytes); 
							     }
		
							      
							
							     pdCompanyStampImage = PDImageXObject.createFromFile(stampImageFilePath, document); 
							 }
						 
						 }
						 
						 
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
		 			
				         String imagePath=	request.getSession().getServletContext().getRealPath("/images/");
			        		
	     		
				        
				       	  
				         Table header;
				         Table billNumberTable;
				         Table customerDetails;				      
				         Table productDetails;
				         Table totalAmountDetails;
				         Table bankDetailsTable;
				         Table bottomInfo;
				         Table conditionInfo;
				         Table signature;
				         
				         
				         
				         
				          TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(520)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				       
				         
				          Row taxInvoice = Row.builder()
					                .add(TextCell.builder().text("QUOTATION").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(12)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(30)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row addressRow = Row.builder()
					                .add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row contactRow = Row.builder()
					                .add(TextCell.builder().text(contactPersonName+" - "+contactMobile).borderWidthBottom(1F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row gstRow = Row.builder()
					                .add(TextCell.builder().text("Customer Care no : "+crushercustcarenumber+"  GST NO :"+crushergstnumber).borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				         tableHeaderBuilder.addRow(taxInvoice);
				         tableHeaderBuilder.addRow(headerName);
				         tableHeaderBuilder.addRow(addressRow);
				         tableHeaderBuilder.addRow(contactRow);
				         tableHeaderBuilder.addRow(gstRow);
				         
				         header = tableHeaderBuilder.build();
				         
				         
				      
				         TableBuilder billNumberDate = Table.builder()
					                .addColumnsOfWidth(120,130,135,135)				                
					                .font(HELVETICA)
					                .borderWidth(1)
					                .borderColor(Color.BLACK);
				         
				         
				         Row billNumberDateRow1 = Row.builder()
					                .add(TextCell.builder().text("Quotation Number").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(quotationInfoDAO.getBillNumber()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Quotation Date").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(quotationInfoDAO.getBillDate()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         billNumberDate.addRow(billNumberDateRow1);
				         
				         billNumberTable =billNumberDate.build();
				         
				         TableBuilder tableCustDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(475)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         Row custDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Details Of Customer (Quotation To)").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         String custDetails [] = quotationInfoDAO.getCustomerName().split("-");
				         
				         Row custDetailsRow2 = Row.builder()
					                .add(TextCell.builder().text("Customer Name:  "+custDetails[1]).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow3 = Row.builder()
					                .add(TextCell.builder().text("Address: "+quotationInfoDAO.getCustomerAddress()).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow4 = Row.builder()
					                .add(TextCell.builder().text("Mobile:  "+custDetails[2]).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         tableCustDetailsBuilder.addRow(custDetailsRow1);
				         tableCustDetailsBuilder.addRow(custDetailsRow2);
				         tableCustDetailsBuilder.addRow(custDetailsRow3);
				         tableCustDetailsBuilder.addRow(custDetailsRow4);
				      
				         
				         customerDetails = tableCustDetailsBuilder.build();
				        
				   
				         TableBuilder tableproductDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(30,230,90,90,85)				                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK);
				         
				         Row productDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Description Of Goods").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Unit Price").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Total Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         tableproductDetailsBuilder.addRow(productDetailsRow1);
				            
				         int srNo = 1;
				         
				         float allUnitTotalAmount = 0.0F;
				        
				         for(int i=0;i<=5;i++)
				         {
				        	
				        	 
				        	 BillProductInfoDAO dao = null;
				        	 try
				        	 {
				        		 dao =productInfoList.get(i);
				        	 }
				        	 catch(Exception e)
				        	 {
				        		 dao = null;
				        	 }
				        			
				        	 if(dao != null)
				        	 {
				        		 
				        		 float basicPrice = 0.0F;
				        		 float taxableAmount = 0.0F;
				        		 float totalUnitAmount = 0.0F;
				        		 float unitCgst = 0.0F;
				        		 float unitSgst = 0.0F;
				        		 float taxPercentage = 0.0F;
				        		 float halfTax = 0.0F;
				        		 float qty = dao.getQuantity();
				        		 try
				        		 {
				        		 
				        		 basicPrice = dao.getSalesRate();
				        		/* unitCgst = Float.parseFloat(dao.getCgst());
				        		 unitSgst = Float.parseFloat(dao.getSgst());
				        		 taxPercentage = Float.parseFloat(dao.getTaxPercentage());*/
				        		 
				        		
				        		 taxableAmount = basicPrice*qty;
				        		 
				        		 totalMaterialCost = totalMaterialCost + taxableAmount;
				        		 
				        		 totalUnitAmount = basicPrice + unitCgst + unitSgst ;
				        		 
				        		 allUnitTotalAmount = allUnitTotalAmount+ totalUnitAmount;
				        		 
				        		 halfTax  = taxPercentage/2.0F;
				        		 
				        		 }catch(NumberFormatException e)
				        		 {
				        			 e.printStackTrace();
				        		 }
				        		 
				        		// int qty = Integer.parseInt(dao.getProductQuantity());
				        	
				       	
				        		 Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text(dao.getProductName().split("-")[1].toUpperCase()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getSalesRate())).horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getQuantity())).horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())					                
							                .add(TextCell.builder().text(""+df.format(taxableAmount)).horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F).lineSpacing(1F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(11)				              
							                .horizontalAlignment(CENTER)
							                .height(22F)					                
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
					         
					         srNo++;
				        	 }
				        	 
				        	 else
				        	 {

					        	  Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())						                
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(22F)	
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
						         
						         srNo++;
				        	 }
				         
				         }
				         
				         productDetails = tableproductDetailsBuilder.build();
				         
				         
				         
				       
				        
				        TableBuilder bankDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(100,160)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(LEFT)
				                .borderColor(Color.BLACK);
				        
				        
				        Row bankRow = Row.builder()
				                .add(TextCell.builder().text("Bank Details").colSpan(2).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow);  
				        
				        Row bankRow1 = Row.builder()
				                .add(TextCell.builder().text("Banking Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .add(TextCell.builder().text(""+this.getBankingName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow1);  
				        
				        
				        Row bankRow2 = Row.builder()
				                .add(TextCell.builder().text("Name Of Bank").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .add(TextCell.builder().text(""+this.getNameOfBank()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow2);  
				        
						        	
						        	 
				        Row bankRow3 = Row.builder()
				                .add(TextCell.builder().text("Branch").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .add(TextCell.builder().text(""+this.getNameOfBranch()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(9)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow3);  
					
					Row bankRow4 = Row.builder()
							                .add(TextCell.builder().text("IFSC Code").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text(""+this.getIfscCode()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)	
							                .build();
					bankDetailsBuilder.addRow(bankRow4);
					
					
					
					
					
		        	Row bankRow5 = Row.builder()
			                .add(TextCell.builder().text("Account Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			                .add(TextCell.builder().text(""+this.getAccountNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA)
			                .fontSize(9)				              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	bankDetailsBuilder.addRow(bankRow5);  
		        	
		        	bankDetailsTable = bankDetailsBuilder.build();
		        	
		        	 TableBuilder totalDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(150,100)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(RIGHT)
				                .borderColor(Color.BLACK);
				        
				        Row materialCostRow = Row.builder()
		                .add(TextCell.builder().text("Total Material Cost").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
		                .add(TextCell.builder().text(""+totalMaterialCost).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
		                .backgroundColor(Color.WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD)
		                .fontSize(9)				              
		                .horizontalAlignment(CENTER)
		                .height(27F)	
		                .build();
				        	totalDetailsBuilder.addRow(materialCostRow);  
				        	
				        	  Row transportCostRow = Row.builder()
				  	                .add(TextCell.builder().text("Transportation Charges").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				  	                .add(TextCell.builder().text(""+quotationInfoDAO.getTransportCharge()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
				  	                .backgroundColor(Color.WHITE)
				  	                .textColor(Color.BLACK)
				  	                .font(PDType1Font.HELVETICA_BOLD)
				  	                .fontSize(9)				              
				  	                .horizontalAlignment(CENTER)
				  	                .height(27F)	
				  	                .build();
				  			        	totalDetailsBuilder.addRow(transportCostRow);  
				         
				         Row totalDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Total Quotation Amount").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
					                .add(TextCell.builder().text(quotationInfoDAO.getTotalBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(27F)	
					                .build();
				         totalDetailsBuilder.addRow(totalDetailsRow1);        
				         
				        
				         
				        
				         
				         totalAmountDetails = totalDetailsBuilder.build();
				         
				       
				         
				         TableBuilder tableBottomInfoBuilder = Table.builder()
					                .addColumnsOfWidth(520)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK);
				         

				         Row bottomInfoRow2 = Row.builder()
					                .add(TextCell.builder().text(""
					                		+ "Declaration : We declare that this bill shows the "
					                		+ "actual price of the goods described, that all perticulers "
					                		+ "are true and correct. "
					                		).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F).verticalAlignment(BOTTOM).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				         
				         
				       
				         
				         
				         Float totalAmounttoConvert = Float.parseFloat(quotationInfoDAO.getTotalBillAmount());
				      
				         
				         DecimalFormat dfConvert = new DecimalFormat("##.##");
				   	String convertedAmount = NumberToWordsConverter.getConverted(dfConvert.format(totalAmounttoConvert));
				      
				       Row bottomInfoRow3 = Row.builder()
					                .add(TextCell.builder().text("Amount in words :"+convertedAmount).horizontalAlignment(LEFT).borderWidth(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				       
				       tableBottomInfoBuilder.addRow(bottomInfoRow3);
				       
				       if(quotationInfoDAO.getComments() == null || quotationInfoDAO.getComments().equals(""))
				       {
				    	   quotationInfoDAO.setComments("NA");
				       }
				       if(quotationInfoDAO.getComments().equals("NA"))
				         {
				         Row bottomInfoRowComments = Row.builder()
					                .add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(10)
					                .height(30F)
					                .horizontalAlignment(CENTER)					               	
					                .build();
				         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         
				         }
				         else
				         {
				        	 Row bottomInfoRowComments = Row.builder()
						                .add(TextCell.builder().text("Comments:"+quotationInfoDAO.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
						                .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA)
						                .fontSize(10)
						                .height(30F)
						                .horizontalAlignment(CENTER)					               	
						                .build();
					         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         }
				       tableBottomInfoBuilder.addRow(bottomInfoRow2);			        
				       bottomInfo = tableBottomInfoBuilder.build();
				       
				         
				       TableBuilder tableConditionInfoBuilder = Table.builder()
				                .addColumnsOfWidth(520)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK);
			         
				       Row bottomInfoRowCondition = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("Terms & Conditions : ")
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();

				       Row bottomInfoRowCondition2 = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("1. 5% GST amount will be added in final invoice. ")
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();

				       Row bottomInfoRowCondition3 = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("2. Rs. 700 per brass (royalty) will be added in final invoice.")
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();
				       
				       Row bottomInfoRowCondition4 = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("3. This quote is valid for 15 days from the date of quotation.".replace("\u00A0", " "))
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();
				       
				       
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition);
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition2);
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition3);
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition4);
		         
				       conditionInfo = tableConditionInfoBuilder.build();
				       
		       
				         
				         TableBuilder signatureBuiler = Table.builder()
					                .addColumnsOfWidth(260,260)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         
				         Row signRow1 = Row.builder()
					                .add(TextCell.builder().text("Receiver Signature").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
					                .add(TextCell.builder().text("For Propriter").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())					               
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				         signatureBuiler.addRow(signRow1);
				       
				         
				         signature = signatureBuiler.build(); 
			        
				         float startY = page.getMediaBox().getHeight() - PADDING20;
					        
					       
				         float yCordinate = page.getCropBox().getUpperRightY() - 72;
				     //    float startX = page.getCropBox().getLowerLeftX() + 10;
				         float endX = page.getCropBox().getUpperRightX() - 10;
				       
				    
				        
				        
				       TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(header)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				       
				        startY = startY - header.getHeight() - 10;
				      
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(billNumberTable)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        
				        startY = startY - billNumberTable.getHeight() - 10;
				      
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(customerDetails)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        startY = startY - customerDetails.getHeight() - 10;
					     
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(productDetails)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        
				        startY = startY - productDetails.getHeight() - 10;
					
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bankDetailsTable)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				       TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(totalAmountDetails)
		                .startX(295)
		                .startY(startY)
		                .build()
		                .draw();
				       
				       
				        startY = startY - bankDetailsTable.getHeight() - 10;
					
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(conditionInfo)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        startY = startY - conditionInfo.getHeight() - 10;
						
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bottomInfo)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
						
				        startY = startY - bottomInfo.getHeight() - 170;
						
				        
				        
				        
				        
				      TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(signature)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
			        	 
						
				      
				      if(pdLeftLogoImage != null)
				         {
				        	 contentStream.drawImage(pdLeftLogoImage, 20, 770, 65, 65);
					         
				         }
				      
				         if(pdRightLogoImage != null)
				         {
				        	 contentStream.drawImage(pdRightLogoImage, 470, 770, 65, 65);
				         }
				         
				         if(pdOwnerSignImage != null)
				         {
				        	 contentStream.drawImage(pdOwnerSignImage, 380, 40, 90, 30);
				         }
				         
				         if(pdCompanyStampImage != null)
				         {
				        	 contentStream.drawImage(pdCompanyStampImage, 260, 40, 67, 67);
				         }
				         
				         
				         
		
				      contentStream.close();
				        
				       // System.out.println(path);
								
				        
				        document.save(path+"/quotation.pdf");
				        document.close();
				        
				        

						response.setHeader("Content-disposition", "inline; filename=quotation.pdf");
						response.setContentType("application/pdf");
						@SuppressWarnings("resource")
						FileInputStream fileInputStream = new FileInputStream(path+"/quotation.pdf");
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();
			        
					}
					
					if(this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A5"))
					{

						PDDocument document = new PDDocument(); 
						PDPage page = null;
						 page = new PDPage(PDRectangle.A5);
					
					
				         document.addPage(page);
				         
				         if(this.getSessionMap().get("left_logo_image_array") != null)
						 {
							 byte[] leftLogoBytes = (byte[]) this.getSessionMap().get("left_logo_image_array");
							
							 if (leftLogoBytes != null) 
							 {
							     String leftLogoFilePath = path + "/left_logo_temp.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(leftLogoFilePath))
							     {
							         fos.write(leftLogoBytes); 
							     }					      
							
							     pdLeftLogoImage = PDImageXObject.createFromFile(leftLogoFilePath, document); 
							 }
						 }
						 
						 if(this.getSessionMap().get("right_logo_image_array") != null)
						 {
						  byte[] rightLogoBytes = (byte[]) this.getSessionMap().get("right_logo_image_array");
							 if (rightLogoBytes != null) {
							     String rightLogoFilePath = path + "/right_logo_temp.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(rightLogoFilePath)) {
							         fos.write(rightLogoBytes); 
							     }

							      
							
							     pdRightLogoImage = PDImageXObject.createFromFile(rightLogoFilePath, document); 
							 }
						 }
							 
							 
						 if(this.getSessionMap().get("owner_sign_image_array") != null)
						 {
							 byte[] signImageBytes = (byte[]) this.getSessionMap().get("owner_sign_image_array");
							 if (signImageBytes != null) {
							     String signImageFilePath = path + "/owner_sign_image.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(signImageFilePath)) {
							         fos.write(signImageBytes); 
							     }
		
							      
							
							     pdOwnerSignImage = PDImageXObject.createFromFile(signImageFilePath, document); 
							 }
						 }
						 
						 if(this.getSessionMap().get("company_stamp_image_array") != null)
						 {
							 byte[] stampImageBytes = (byte[]) this.getSessionMap().get("company_stamp_image_array");
							 if (stampImageBytes != null) {
							     String stampImageFilePath = path + "/company_stamp_image.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(stampImageFilePath)) {
							         fos.write(stampImageBytes); 
							     }
		
							      
							
							     pdCompanyStampImage = PDImageXObject.createFromFile(stampImageFilePath, document); 
							 }
						 
						 }
						 
						 
						 
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
		 			
				         String imagePath=	request.getSession().getServletContext().getRealPath("/images/");
			        		
	     		
				        // PDImageXObject pdImageNirmitiLogo = PDImageXObject.createFromFile(imagePath+"/nirmiti-logo.jpg", document);
					    
				       	  
				         Table header;
				         Table billNumberTable;
				         Table customerDetails;				      
				         Table productDetails;
				         Table totalAmountDetails;
				         Table bankDetailsTable;
				         Table bottomInfo;
				         Table conditionInfo;
				         Table signature;
				         
				         
				         
				         
				          TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				       
				          //System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
				          Row taxInvoice = Row.builder()
					                .add(TextCell.builder().text("QUOTATION").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(6)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(15)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				         // System.out.println("address : "+address);
				          Row addressRow = Row.builder()
					                .add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row contactRow = Row.builder()
					                .add(TextCell.builder().text(contactPersonName+" - "+contactMobile).borderWidthBottom(1F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row gstRow = Row.builder()
					                .add(TextCell.builder().text("Customer Care No : "+crushercustcarenumber+"  GST NO : "+crushergstnumber).borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				         tableHeaderBuilder.addRow(taxInvoice);
				         tableHeaderBuilder.addRow(headerName);
				         tableHeaderBuilder.addRow(addressRow);
				         tableHeaderBuilder.addRow(contactRow);
				       //  tableHeaderBuilder.addRow(gstRow);
				         
				         header = tableHeaderBuilder.build();
				         
				         
				      

					      
				         TableBuilder billNumberDate = Table.builder()
					                .addColumnsOfWidth(90,90,90,90)				                
					                .font(HELVETICA)
					                .borderWidth(1)
					                .borderColor(Color.BLACK);
				         
				         
				         Row billNumberDateRow1 = Row.builder()
					                .add(TextCell.builder().text("Quotation Number").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(quotationInfoDAO.getBillNumber()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Quotation Date").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())				               
					                .add(TextCell.builder().text(quotationInfoDAO.getBillDate()).horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         billNumberDate.addRow(billNumberDateRow1);
				         
				         billNumberTable =billNumberDate.build();
				         
				         TableBuilder tableCustDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         Row custDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Details Of Customer (Quotation To)").horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         String custDetails [] = quotationInfoDAO.getCustomerName().split("-");
				         
				         Row custDetailsRow2 = Row.builder()
					                .add(TextCell.builder().text("Customer Name:  "+custDetails[1]).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        // System.out.println(billInfoDAO.getCustomerAddress());
				         
				         Row custDetailsRow3 = Row.builder()
					                .add(TextCell.builder().text("Address: "+quotationInfoDAO.getCustomerAddress()).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         Row custDetailsRow4 = Row.builder()
					                .add(TextCell.builder().text("Mobile:  "+custDetails[2]).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())				                
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				        
				         tableCustDetailsBuilder.addRow(custDetailsRow1);
				         tableCustDetailsBuilder.addRow(custDetailsRow2);
				         tableCustDetailsBuilder.addRow(custDetailsRow3);
				         tableCustDetailsBuilder.addRow(custDetailsRow4);
				      
				         
				         customerDetails = tableCustDetailsBuilder.build();
				        
				   
				         TableBuilder tableproductDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(40,160,60,60,60)				                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK);
				         
				         Row productDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Description Of Goods").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Unit Price").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Total Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				         
				         tableproductDetailsBuilder.addRow(productDetailsRow1);
				            
				         int srNo = 1;
				         
				         float allUnitTotalAmount = 0.0F;
				        
				         for(int i=0;i<=5;i++)
				         {
				        	
				        	 
				        	 BillProductInfoDAO dao = null;
				        	 try
				        	 {
				        		 dao =productInfoList.get(i);
				        	 }
				        	 catch(Exception e)
				        	 {
				        		 dao = null;
				        	 }
				        			
				        	 if(dao != null)
				        	 {
				        		 
				        		 float basicPrice = 0.0F;
				        		 float taxableAmount = 0.0F;
				        		 float totalUnitAmount = 0.0F;
				        		 float unitCgst = 0.0F;
				        		 float unitSgst = 0.0F;
				        		 float taxPercentage = 0.0F;
				        		 float halfTax = 0.0F;
				        		 float qty = dao.getQuantity();
				        		 try
				        		 {
				        		 
				        		 basicPrice = dao.getSalesRate();
				        		/* unitCgst = Float.parseFloat(dao.getCgst());
				        		 unitSgst = Float.parseFloat(dao.getSgst());
				        		 taxPercentage = Float.parseFloat(dao.getTaxPercentage());*/
				        		 
				        		
				        		 taxableAmount = basicPrice*qty;
				        		 
				        		 totalMaterialCost = totalMaterialCost + taxableAmount;
				        		 
				        		 totalUnitAmount = basicPrice + unitCgst + unitSgst ;
				        		 
				        		 allUnitTotalAmount = allUnitTotalAmount+ totalUnitAmount;
				        		 
				        		 halfTax  = taxPercentage/2.0F;
				        		 
				        		 }catch(NumberFormatException e)
				        		 {
				        			 e.printStackTrace();
				        		 }
				        		 
				        		// int qty = Integer.parseInt(dao.getProductQuantity());
				        	
				        		// totalMaterialCost = totalMaterialCost + totalUnitAmount;
				       	
				        		 Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text(dao.getProductName().split("-")[1].toUpperCase()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getSalesRate())).horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())
							                .add(TextCell.builder().text(df.format(dao.getQuantity())).horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())					                
							                .add(TextCell.builder().text(""+df.format(taxableAmount)).horizontalAlignment(RIGHT).verticalAlignment(MIDDLE).borderWidth(0.5F).lineSpacing(1F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
					         
					         srNo++;
				        	 }
				        	 
				        	 else
				        	 {

					        	  Row productDetailsRow = Row.builder()
							                .add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())						                
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)	
							                .build();
						         tableproductDetailsBuilder.addRow(productDetailsRow);
						         
						         srNo++;
				        	 }
				         
				         }
				         
				         productDetails = tableproductDetailsBuilder.build();
				         
				         
				         
				       
				        
				        TableBuilder bankDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(70,130)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(LEFT)
				                .borderColor(Color.BLACK);
				        
				        
				        Row bankRow = Row.builder()
				                .add(TextCell.builder().text("Bank Details").colSpan(2).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				                
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow);  
				        
				        Row bankRow1 = Row.builder()
				                .add(TextCell.builder().text("Banking Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .add(TextCell.builder().text(""+this.getBankingName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow1);  
				        
				        Row bankRow2 = Row.builder()
				                .add(TextCell.builder().text("Name Of Bank").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .add(TextCell.builder().text(""+this.getNameOfBank()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow2);
				        
						        	
						        	 
				        Row bankRow3 = Row.builder()
				                .add(TextCell.builder().text("Branch").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				                .add(TextCell.builder().text(""+this.getNameOfBranch()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
				                .backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(15F)	
				                .build();
				        bankDetailsBuilder.addRow(bankRow3);  
					
					Row bankRow4 = Row.builder()
							                .add(TextCell.builder().text("IFSC Code").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text(""+this.getIfscCode()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(7)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)	
							                .build();
					bankDetailsBuilder.addRow(bankRow4);
					
					
					
					
					
		        	Row bankRow5 = Row.builder()
			                .add(TextCell.builder().text("Account Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
			                .add(TextCell.builder().text(""+this.getAccountNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
			                .backgroundColor(Color.WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA)
			                .fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .height(15F)	
			                .build();
		        	bankDetailsBuilder.addRow(bankRow5);  
		        	
		        	
		        	 
		        	 
		        	
		        	bankDetailsTable = bankDetailsBuilder.build();
		        	
		        	 TableBuilder totalDetailsBuilder = Table.builder()
				                .addColumnsOfWidth(110,60)				                
				                .font(HELVETICA)
				                .borderWidth(1)
				                .horizontalAlignment(RIGHT)
				                .borderColor(Color.BLACK);
				        
				        Row materialCostRow = Row.builder()
		                .add(TextCell.builder().text("Total Material Cost").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
		                .add(TextCell.builder().text(""+totalMaterialCost).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
		                .backgroundColor(Color.WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD)
		                .fontSize(8)				              
		                .horizontalAlignment(CENTER)
		                .height(25F)	
		                .build();
				        	totalDetailsBuilder.addRow(materialCostRow);  
				        	
				        	  Row transportCostRow = Row.builder()
				  	                .add(TextCell.builder().text("Transportation Charges").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
				  	                .add(TextCell.builder().text(""+quotationInfoDAO.getTransportCharge()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
				  	                .backgroundColor(Color.WHITE)
				  	                .textColor(Color.BLACK)
				  	                .font(PDType1Font.HELVETICA_BOLD)
				  	                .fontSize(8)				              
				  	                .horizontalAlignment(CENTER)
				  	                .height(25F)	
				  	                .build();
				  			        	totalDetailsBuilder.addRow(transportCostRow);  
				         
				         Row totalDetailsRow1 = Row.builder()
					                .add(TextCell.builder().text("Total Quotation Amount").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
					                .add(TextCell.builder().text(quotationInfoDAO.getTotalBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .height(25F)	
					                .build();
				         totalDetailsBuilder.addRow(totalDetailsRow1);        
				         
				        
				         
				         
				       
				         
				        
				         
				         totalAmountDetails = totalDetailsBuilder.build();
				         
				       
				         
				         TableBuilder tableBottomInfoBuilder = Table.builder()
					                .addColumnsOfWidth(380)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK);
				         

				         Row bottomInfoRow2 = Row.builder()
					                .add(TextCell.builder().text(""
					                		+ "Declaration : We declare that this bill shows the "
					                		+ "actual price of the goods described, that all perticulers "
					                		+ "are true and correct. "
					                		).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F).verticalAlignment(BOTTOM).lineSpacing(1F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .height(15F)	
					                .build();
				         
				         
				       
				         
				         
				         Float totalAmounttoConvert = Float.parseFloat(quotationInfoDAO.getTotalBillAmount());
				      
				         
				         DecimalFormat dfConvert = new DecimalFormat("##.##");
				         
						String convertedAmount = NumberToWordsConverter.getConverted(dfConvert.format(totalAmounttoConvert));
				
				       Row bottomInfoRow3 = Row.builder()
					                .add(TextCell.builder().text("Amount in words :"+convertedAmount).horizontalAlignment(LEFT).borderWidth(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(9)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				       
				       tableBottomInfoBuilder.addRow(bottomInfoRow3);
				       
				       if(quotationInfoDAO.getComments() == null || quotationInfoDAO.getComments().equals(""))
				       {
				    	   quotationInfoDAO.setComments("NA");
				       }
				       if(quotationInfoDAO.getComments().equals("NA"))
				         {
				         Row bottomInfoRowComments = Row.builder()
					                .add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA)
					                .fontSize(8)
					                .height(20F)
					                .horizontalAlignment(CENTER)					               	
					                .build();
				         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         
				         }
				         else
				         {
				        	 Row bottomInfoRowComments = Row.builder()
						                .add(TextCell.builder().text("Comments:"+quotationInfoDAO.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
						                .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA)
						                .fontSize(8)
						                .height(20F)
						                .horizontalAlignment(CENTER)					               	
						                .build();
					         tableBottomInfoBuilder.addRow(bottomInfoRowComments);
				         }
				       tableBottomInfoBuilder.addRow(bottomInfoRow2);			        
				       bottomInfo = tableBottomInfoBuilder.build();
				         
				       
				       TableBuilder tableConditionInfoBuilder = Table.builder()
				                .addColumnsOfWidth(380)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK);
			         
				       Row bottomInfoRowCondition = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("Terms & Conditions : ")
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();

				       Row bottomInfoRowCondition2 = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("1. 5% GST amount will be added in final invoice. ")
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();

				       Row bottomInfoRowCondition3 = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("2. Rs. 700 per brass (royalty) will be added in final invoice.")
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();
				       
				       Row bottomInfoRowCondition4 = Row.builder()
				    		    .add(TextCell.builder()
				    		        .text("3. This quote is valid for 15 days from the date of quotation.".replace("\u00A0", " "))
				    		        .horizontalAlignment(LEFT)
				    		        .borderWidth(0.5F)
				    		        .lineSpacing(0.5F)
				    		        .build())
				    		    .backgroundColor(Color.WHITE)
				    		    .textColor(Color.BLACK)
				    		    .font(PDType1Font.HELVETICA_BOLD) // Use bold font here
				    		    .fontSize(9)
				    		    .height(20F)
				    		    .horizontalAlignment(CENTER)
				    		    .build();
				       
				       
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition);
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition2);
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition3);
				       tableConditionInfoBuilder.addRow(bottomInfoRowCondition4);
		         
				       conditionInfo = tableConditionInfoBuilder.build();
				       
				         
				         TableBuilder signatureBuiler = Table.builder()
					                .addColumnsOfWidth(190,190)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				         
				         Row signRow1 = Row.builder()
					                .add(TextCell.builder().text("Receiver Signature").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
					                .add(TextCell.builder().text("For Propriter").verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())					               
					                .backgroundColor(Color.WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD)
					                .fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .height(20F)	
					                .build();
				         signatureBuiler.addRow(signRow1);
				       
				         
				         signature = signatureBuiler.build(); 
			        
				         float startY = page.getMediaBox().getHeight() - PADDING20;
					        
					       
				         float yCordinate = page.getCropBox().getUpperRightY() - 72;
				         float startX = page.getCropBox().getLowerLeftX() + 10;
				         float endX = page.getCropBox().getUpperRightX() - 10;
				       
				    
				        
				        
				       TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(header)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				       
				       startY = startY - header.getHeight() - 10;
				      
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(billNumberTable)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        startY = startY - billNumberTable.getHeight() - 10;
					     
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(customerDetails)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        startY = startY - customerDetails.getHeight() - 10;
					     
					     
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(productDetails)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        startY = startY - productDetails.getHeight() - 10;
						   
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bankDetailsTable)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(totalAmountDetails)
		                .startX(230)
		                .startY(startY)
		                .build()
		                .draw();
				       
				        startY = startY - bankDetailsTable.getHeight() - 10;
						
				        
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(conditionInfo)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				        startY = startY - conditionInfo.getHeight() - 10;
						
				        TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bottomInfo)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
				        
				       
				        startY = startY - conditionInfo.getHeight() - 8;
						
				        
				      TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(signature)
		                .startX(PADDING20)
		                .startY(startY)
		                .build()
		                .draw();
			        	 
						
				      
				      if(pdLeftLogoImage != null)
				         {
				        	 contentStream.drawImage(pdLeftLogoImage, 20, 535, 60, 55);
					         
				         }
				      
				         if(pdRightLogoImage != null)
				         {
				        	 contentStream.drawImage(pdRightLogoImage, 340, 535, 60, 55);
				         }
				         
				         if(pdOwnerSignImage != null)
				         {
				        	 contentStream.drawImage(pdOwnerSignImage, 280, 22, 70, 20);
				         }
				         
				         if(pdCompanyStampImage != null)
				         {
				        	 contentStream.drawImage(pdCompanyStampImage, 180, 12, 48, 48);
				         }
				         
				         
				         
				   //   contentStream.drawImage(pdImageNirmitiLogo, 30, 550, 100, 30);
				      contentStream.close();
				        
				       // System.out.println(path);
								
				        
				        document.save(path+"/quotation.pdf");
				        document.close();
				        
				        

						response.setHeader("Content-disposition", "inline; filename=quotation.pdf");
						response.setContentType("application/pdf");
						@SuppressWarnings("resource")
						FileInputStream fileInputStream = new FileInputStream(path+"/quotation.pdf");
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();
			        
					
					}
					
					
					}
	        	}
	        	catch (SQLException e) {
					e.printStackTrace();
				} catch (Exception e) {
					e.printStackTrace();
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
					
	        	}
				
		       
		   }

		public HttpSession getSession() {
			return session;
		}

		public void setSession(HttpSession session) {
			this.session = session;
		}

		public SessionMap<String, Object> getSessionMap() {
			return sessionMap;
		}

		public void setSessionMap(SessionMap<String, Object> sessionMap) {
			this.sessionMap = sessionMap;
		}

		public BillInformationDAO getBillInfoDAO() {
			return quotationInfoDAO;
		}

		public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
			this.quotationInfoDAO = billInfoDAO;
		}

		public List<BillProductInfoDAO> getProductInfoList() {
			return productInfoList;
		}

		public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
			this.productInfoList = productInfoList;
		}

		@Override  
		public void setSession(Map<String, Object> map) {  
		    sessionMap=(SessionMap<String, Object>)map;  
		}

		public HttpServletRequest getRequest() {
			return request;
		}

		public void setRequest(HttpServletRequest request) {
			this.request = request;
		}

		public HttpServletResponse getResponse() {
			return response;
		}

		public void setResponse(HttpServletResponse response) {
			this.response = response;
		}

		

		public BillInformationDAO getQuotationInfoDAO() {
			return quotationInfoDAO;
		}

		public void setQuotationInfoDAO(BillInformationDAO quotationInfoDAO) {
			this.quotationInfoDAO = quotationInfoDAO;
		}

		public String getQuotationNumner() {
			return quotationNumner;
		}

		public void setQuotationNumner(String quotationNumner) {
			this.quotationNumner = quotationNumner;
		}

		public String getSize() {
			return size;
		}

		public void setSize(String size) {
			this.size = size;
		}

		public String getLang() {
			return lang;
		}

		public void setLang(String lang) {
			this.lang = lang;
		}

		public String getBillType() {
			return billType;
		}

		public void setBillType(String billType) {
			this.billType = billType;
		}

		public String getBankingName() {
			return bankingName;
		}

		public void setBankingName(String bankingName) {
			this.bankingName = bankingName;
		}


		public String getNameOfBranch() {
			return nameOfBranch;
		}

		public void setNameOfBranch(String nameOfBranch) {
			this.nameOfBranch = nameOfBranch;
		}

		public String getAccountNumber() {
			return accountNumber;
		}

		public void setAccountNumber(String accountNumber) {
			this.accountNumber = accountNumber;
		}

		public String getIfscCode() {
			return ifscCode;
		}

		public void setIfscCode(String ifscCode) {
			this.ifscCode = ifscCode;
		}

		public String getNameOfBank() {
			return nameOfBank;
		}

		public void setNameOfBank(String nameOfBank) {
			this.nameOfBank = nameOfBank;
		}

		
		
		
		
		
		

	}
