package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class ViewRMCBillJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7713193858695407144L;
	private String chalanNumber;
	private HttpSession session;
	private String billDateTime;
	private String operator;
	private String paymentType;
	private String customerName;
	private String billType;
	
	private Float transportCharge;
	private String comments;
    private Float pumpAmount;
	private Float labourAmount;

	
	private String billNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private List<BillProductInfoDAO> productInfoList = new ArrayList<BillProductInfoDAO>();
	private String defaultValue;
	

	private List<String> paymentTypeList2 = new ArrayList<String>();
	private String modeOfPayment;
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();

	
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private Float amountPaid;
	private String returnAmount;
	
	private String removeVaules="false";
	
	private BillInformationDAO billInfoDAO = null;
	
	private SessionMap<String,Object> sessionMap;
	
	private String viewBill;
	
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private boolean billSaved;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	 private String discountType;
		
		private Map<String,String> discountTypeList = new HashMap<String,String>();

		
		 private Float tenmm;
		   private Float twentymm;
		   private Float crushsand;
		   private Float silicasand;
		   private Float water;
		   private Float addmixture;
		   private Float cementOPC;
		   private Float cementPPC;
		   private String addSideBarJs;
			
		   
		   
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
	        	
	        	try
	        	{
	    			taxList = GetListResource.GetTaxList();
	    			
	    		} catch (IOException e) {
	    			
	    		}
	        	this.setViewBill("true");
	        	
	        	unitList = GetListResource.GetUnitList();
	        	billTypeList = GetListResource.GetBillTypeList();
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	 discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
				
	        	if(productInfoList == null)
	        	{
	        		productInfoList = new ArrayList<BillProductInfoDAO>();
	        	}
	        	
	        	if(billInfoDAO==null)
	        	{
	        		billInfoDAO = new BillInformationDAO();        		      		
	        		
	        	}
	        	
	        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	
	        	this.setRateTyprDefaultValue("INCLUDINGGST");
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    		
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			sql = "SELECT "
	       					+ "DATE_FORMAT(bill_date, '%d-%m-%Y'),"
	       					+ "payment_type,"
	       					+ "bill_type,"
	       					+ "customer_name,"
	       					+ "transport_charges,"
	       					+ "comments, "
	       					+ "chalan_number,"
	       					+ "bill_amount_received,"
	       					+ "amount_return,"
	       					+ "discount_type,"
	       					+ "pumpAmount,"
	       					+ "labourAmount "
	       					+ "FROM "
	       					+ "crusher_rmc_billinfo "
	       					+ "WHERE "
	       					+ "bill_number = '"+this.getBillNumber()+"' "
	       					+ "AND "
	       					+ "bill_type = ? "
	       					+ "AND "
   							+ "crusher_id = ? "
   							+ "AND "
   							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, this.getBillType());
	       			preparedStatement.setString(2, crusherId);
	       			preparedStatement.setString(3, crusherCode);
	       			
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			if(rowCount>0)
	       			{
	       				result = "success";
	       				if(resultSet.next())
	       				{
	       					this.setBillDateTime(resultSet.getString(1));
	       					this.setPaymentType(resultSet.getString(2));
	       					this.setDefaultValue(resultSet.getString(2));
	       					
	       					this.setBillType(resultSet.getString(3));
	       					
	       					this.setCustomerName(resultSet.getString(4));
	       					this.setTransportCharge(resultSet.getFloat(5));
	       					this.setComments(resultSet.getString(6));
	       					this.setChalanNumber(resultSet.getString(7));
	       					this.setAmountPaid(resultSet.getFloat(8));
	       					this.setReturnAmount(resultSet.getString(9));
	       					this.setDiscountType(resultSet.getString(10));
	       					this.setPumpAmount(resultSet.getFloat(11));
	       					this.setLabourAmount(resultSet.getFloat(12));
	       					
	       					billInfoDAO.setBillDate(resultSet.getString(1));
	       					billInfoDAO.setTransportCharge(resultSet.getFloat(5));
	       					billInfoDAO.setPumpAmount(resultSet.getFloat(11));
	       					billInfoDAO.setLabourAmount(resultSet.getFloat(12));
	       					billInfoDAO.setBillNumber(getBillNumber());	        	
	       	        		billInfoDAO.setPaymentType(getPaymentType());
	       	        		billInfoDAO.setBillType(getBillType());
	       	        		billInfoDAO.setCustomerName(getCustomerName());        		
	       		        	billInfoDAO.setBillSaved(true);
	       		        	this.setBillSaved(true);
	       		        	billInfoDAO.setBillInformationInserted(true);
	       		        	billInfoDAO.setChalanNumber(resultSet.getString(7));
	       		        	if(resultSet != null)
	       		        	{
	       		        		resultSet.close();
	       		        		resultSet = null;
	       		        	}
	       					if(preparedStatement != null)
	       					{
	       						preparedStatement.close();
	       						preparedStatement = null;
	       					}
	       					
	       					sql = "select "
	       							+ "product_name,"
	       							+ "sales_unit,"
	       							+ "tax_percentage,"
	       							+ "sales_rate,"
	       							+ "quanity,"
	       							+ "discount_percentage,"
	       							+ "discount_rupees,"
	       							+ "product_amount,"
	       							+ "product_amt_after_discount,"
	       							+ "gross_amount,"
	       							+ "igst,"
	       							+ "cgst,"
	       							+ "sgst,"
	       							+ "product_name_marathi "
	       							+ "from "
	       							+ "crusher_rmc_productbillinfo "
	       							+ "where "
	       							+ "bill_number = '"+getBillNumber()+"' "
	       							+ "AND "
	       							+ "bill_type = ? "
	       							+ "AND "
	       							+ "crusher_id = ? "
	       							+ "AND "
	       							+ "crusher_code = ? ";
	       					
	       					
	       					
	       					preparedStatement = connection.prepareStatement(sql);
	       					preparedStatement.setString(1, this.getBillType()); 
	       					preparedStatement.setString(2, crusherId);
	    	       			preparedStatement.setString(3, crusherCode);
	    	       			
	       					resultSet = preparedStatement.executeQuery();
	       					
	       					while(resultSet.next())
	       					{
	       						BillProductInfoDAO  billProductInfoDAO = new BillProductInfoDAO();
	       						
	       						billProductInfoDAO.setProductName(resultSet.getString(1));
	       						billProductInfoDAO.setSalesUnit(resultSet.getString(2));
	       						billProductInfoDAO.setTaxId(resultSet.getString(3));
	       						billProductInfoDAO.setSalesRate(resultSet.getFloat(4));
	       						billProductInfoDAO.setQuantity(resultSet.getFloat(5));
	       						billProductInfoDAO.setDiscountPecentage(resultSet.getFloat(6));
	       						billProductInfoDAO.setDiscountRupees(resultSet.getFloat(7));
	       						billProductInfoDAO.setAmount(resultSet.getFloat(8));
	       						billProductInfoDAO.setAmountAfterDiscount(resultSet.getFloat(9));
	       						billProductInfoDAO.setGrossAmount(resultSet.getFloat(10));
	       						billProductInfoDAO.setIgst(resultSet.getFloat(11));
	       						billProductInfoDAO.setCgst(resultSet.getFloat(12));
	       						billProductInfoDAO.setSgst(resultSet.getFloat(13));
	       						billProductInfoDAO.setProductNameMarathi(resultSet.getString(14));
	       						
	       						String taxDetails = GetListResource.getTaxDetailsByTaxId(resultSet.getString(3));
	       						String taxPercentage = "";
	       						try
	       						{
	       							taxPercentage = taxDetails.split(":")[1];
	       						}
	       						catch(Exception e)
	       						{
	       							taxPercentage = "0";
	       						}
	       						billProductInfoDAO.setTaxPercentage(taxPercentage);
	       						
	       			        	float totalProductDiscount = Float.parseFloat(resultSet.getString(8)) - Float.parseFloat(resultSet.getString(9));
	       						
	       			        	billProductInfoDAO.setProductTotalDiscount(totalProductDiscount);
	       			        	
	       			        	
	       			        	
	       			        	sql = "SELECT "
		    	       					+ "10mm,"
		    	       					+ "20mm,"
		    	       					+ "crushsand,"
		    	       					+ "silicasand,"
		    	       					+ "water,"
		    	       					+ "addmixture,"
		    	       					+ "cementopc,"
		    	       					+ "cementppc "
		    	       					+ "FROM "
		    	       					+ "rmc_bill_ingredients_used_details_master "
		    	       					+ "WHERE "
		    	       					+ "rmc_bill_number = ? "
		    	       					+ "AND "
		    	       					+ "crusher_id = ? "
		    	       					+ "AND "
		    	       					+ "crusher_code = ? "
		    	       					+ "AND "
		    	       					+ "bill_type = ?";
		    	       			
		       			     	PreparedStatement getRMCUsedIngPSMT = connection.prepareStatement(sql);
		    	       			
		       			     getRMCUsedIngPSMT.setString(1, this.getBillNumber());
		       			     getRMCUsedIngPSMT.setString(2, crusherId);
		       			     getRMCUsedIngPSMT.setString(3, crusherCode);
		       			     getRMCUsedIngPSMT.setString(4, this.getBillType());
		    	       			
		    	       		 ResultSet	getRMCUsedIngrRS = getRMCUsedIngPSMT.executeQuery();
		    	       		
		    	       			if(getRMCUsedIngrRS.next())
		    	       			{
		    	       				
		    	       				this.setTenmm(getRMCUsedIngrRS.getFloat(1));
		    	       				this.setTwentymm(getRMCUsedIngrRS.getFloat(2));
		    	       				this.setCrushsand(getRMCUsedIngrRS.getFloat(3));
		    	       				this.setSilicasand(getRMCUsedIngrRS.getFloat(4));
		    	       				this.setWater(getRMCUsedIngrRS.getFloat(5));
		    	       				this.setAddmixture(getRMCUsedIngrRS.getFloat(6));
		    	       				this.setCementOPC(getRMCUsedIngrRS.getFloat(7));
		    	       				this.setCementPPC(getRMCUsedIngrRS.getFloat(8));
		    	       				
		    	       				billProductInfoDAO.setTenmm(getRMCUsedIngrRS.getFloat(1));
		    	       				billProductInfoDAO.setTwentymm(getRMCUsedIngrRS.getFloat(2));
		    	       				billProductInfoDAO.setCrushsand(getRMCUsedIngrRS.getFloat(3));
		    	       				billProductInfoDAO.setWashsand(getRMCUsedIngrRS.getFloat(4));
		    	       				billProductInfoDAO.setWater(getRMCUsedIngrRS.getFloat(5));
		    	       				billProductInfoDAO.setAddmixture(getRMCUsedIngrRS.getFloat(6));
		    	       				billProductInfoDAO.setCementOPC(getRMCUsedIngrRS.getFloat(7));
		    	       				billProductInfoDAO.setCementPPC(getRMCUsedIngrRS.getFloat(8));
		    	       				
		    	       			}
		    	       			
	       						this.getProductInfoList().add(billProductInfoDAO);
	       					}
	       					
	       					
	       				}
	       				
	       				
	       				
	       				
	       			}
	       			
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement  = null;
	       			}
	       			
	       			sql = "SELECT "
	       					+ "trip_vehicle_id,"
	       					+ "vehicle_km_start,"
	       					+ "vehicle_km_end,"
	       					+ "trip_total_km,"
	       					+ "trip_from,"
	       					+ "trip_to,"
	       					+ "total_trips "
	       					+ "FROM "
	       					+ "crusher_rmc_vehicle_trip_master "
	       					+ "WHERE "
	       					+ "bill_number = ? "
	       					+ "AND "
	       					+ "bill_type = ? "
	       					+ "AND "
   							+ "crusher_id = ? "
   							+ "AND "
   							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, billInfoDAO.getBillNumber());
	       			preparedStatement.setString(2, this.getBillInfoDAO().getBillType());
	       			preparedStatement.setString(3, crusherId);
	       			preparedStatement.setString(4, crusherCode);
	       			
	       			resultSet = preparedStatement.executeQuery();
	       			if(resultSet.next())
	       			{
	       				HashMap<String,String> vehicleDetailsMap = new HashMap<String,String>();
	       				vehicleDetailsMap = GetVehicleDetailsById.getVehicleDetailsById(resultSet.getString(1), this.getSessionMap(), connection);
	       				
	       				this.setVehicleId(resultSet.getString(1)+"-"+vehicleDetailsMap.get("VEHICLEMAKE")+"-"+vehicleDetailsMap.get("REGISTRATIONNUMBER"));
	       				this.setKmStart(resultSet.getFloat(2));
	       				this.setKmEnd(resultSet.getFloat(3));
	       				this.setTotalKm(resultSet.getFloat(4));
	       				this.setTripFrom(resultSet.getString(5));
	       				this.setTripTo(resultSet.getString(6));
	       				this.setTotalTrips(resultSet.getInt(7));
	       				
	       				this.getBillInfoDAO().setVehicleId(this.getVehicleId());
	       				this.getBillInfoDAO().setKmStart(this.getKmStart());
	       				this.getBillInfoDAO().setKmEnd(this.getKmEnd());
	       				this.getBillInfoDAO().setTotalKm(this.getTotalKm());
	       				this.getBillInfoDAO().setTripFrom(this.getTripFrom());
	       				this.getBillInfoDAO().setTripTo(this.getTripTo());
	       				this.getBillInfoDAO().setTotalTrips(this.getTotalTrips());
	       				
	       			}
	       			
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement  = null;
	       			}
	       			
	       			
	       			
	       			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
	       					+ "crusher_id = ? "
   							+ "AND "
   							+ "crusher_code = ? ";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
	       			preparedStatement.setString(2, crusherCode);
	       			
	       			resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    			
	       			float transportCharge = 0.0F;
		        	if(!billInfoDAO.getTransportCharge().equals("")){
		        		
		        		try
		        		{
		        			transportCharge = billInfoDAO.getTransportCharge();
		        		}catch(NumberFormatException nfe)
		        		{
		        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
		        		}
		        	}
		        	
	       			
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        	}
		        	
		        	
		        
		        
		        	if(!hasActionErrors())
		        	{
		        		this.setTotalAmount(""+(floatTotalAmount+this.getTransportCharge()+ this.getPumpAmount() + this.getLabourAmount()));	        	
		        		this.setTotalDiscount(""+floatTotalDiscount);
		        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getTransportCharge()+ this.getPumpAmount() + this.getLabourAmount()));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	else
		        	{
		        		this.setTotalAmount(""+(floatTotalAmount+this.getTransportCharge()+ this.getPumpAmount() + this.getLabourAmount()));	        	
		        		this.setTotalDiscount(""+floatTotalDiscount);
		        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getTransportCharge()+ this.getPumpAmount() + this.getLabourAmount()));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	
		        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
		    		
		        	this.setPaymentTypeList2(GetTypeOfPaymentList.getPaymentTypeList());
		        	
	       			this.getSessionMap().put("RMCBillInformation", billInfoDAO);
	       			this.getSessionMap().put("RMCProductList", productInfoList);
	       			
	       		} catch (SQLException e) {
	   				e.printStackTrace();
	   				addActionError(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.errorWhileFindingBillInformation"));
				
				} catch (Exception e) {
					e.printStackTrace();
					addActionError(e.getMessage()+"|| "+this.getText("message.error.errorWhileFindingBillInformation"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    						resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close(); connection = null;} catch (SQLException e) {}
	   				}
	   				
	   			}
	        	
	        }
	       // System.out.println("Size:"+this.getProductInfoList().size());
	        return result;
	}




	public HttpSession getSession() {
		return session;
	}




	public void setSession(HttpSession session) {
		this.session = session;
	}




	public String getBillDateTime() {
		return billDateTime;
	}




	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}




	public String getOperator() {
		return operator;
	}




	public void setOperator(String operator) {
		this.operator = operator;
	}




	public String getPaymentType() {
		return paymentType;
	}




	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}




	public String getCustomerName() {
		return customerName;
	}




	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	



	public String getComments() {
		return comments;
	}




	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getBillNumber() {
		return billNumber;
	}




	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}




	public Map<String, String> getTaxList() {
		return taxList;
	}




	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}




	public Map<String, String> getUnitList() {
		return unitList;
	}




	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}




	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}




	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}




	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}




	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}




	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}




	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}




	public String getDefaultValue() {
		return defaultValue;
	}




	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}




	public String getTotalAmount() {
		return totalAmount;
	}




	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}




	public String getTotalDiscount() {
		return totalDiscount;
	}




	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}




	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}




	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}




	public String getRemoveVaules() {
		return removeVaules;
	}




	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}




	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}




	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}




	public String getBillType() {
		return billType;
	}




	public void setBillType(String billType) {
		this.billType = billType;
	}




	public String getViewBill() {
		return viewBill;
	}




	public void setViewBill(String viewBill) {
		this.viewBill = viewBill;
	}




	public String getChalanNumber() {
		return chalanNumber;
	}




	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}




	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public Float getAmountPaid() {
		return amountPaid;
	}




	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}




	public String getReturnAmount() {
		return returnAmount;
	}




	public void setReturnAmount(String returnAmount) {
		this.returnAmount = returnAmount;
	}




	public String getTripDate() {
		return tripDate;
	}




	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}




	public String getVehicleId() {
		return vehicleId;
	}




	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}




	public String getMaterialName() {
		return materialName;
	}




	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}




	public Float getMaterialVolume() {
		return materialVolume;
	}




	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}




	public Float getKmStart() {
		return kmStart;
	}




	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}




	public Float getKmEnd() {
		return kmEnd;
	}




	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}




	public Float getTotalKm() {
		return totalKm;
	}




	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}




	public String getTripFrom() {
		return tripFrom;
	}




	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}




	public String getTripTo() {
		return tripTo;
	}




	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}




	public Integer getTotalTrips() {
		return totalTrips;
	}




	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}




	public Map<String, String> getVehicleList() {
		return vehicleList;
	}




	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}




	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}




	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}




	public String getModeOfPayment() {
		return modeOfPayment;
	}




	public void setModeOfPayment(String modeOfPayment) {
		this.modeOfPayment = modeOfPayment;
	}




	public String getAccountId() {
		return accountId;
	}




	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}




	public Map<String, String> getAccountList() {
		return accountList;
	}




	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}




	public boolean isBillSaved() {
		return billSaved;
	}




	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}




	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}




	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}




	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}




	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}




	public String getRateType() {
		return rateType;
	}




	public void setRateType(String rateType) {
		this.rateType = rateType;
	}




	public String getDiscountType() {
		return discountType;
	}




	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}




	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}




	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}




	public Float getTenmm() {
		return tenmm;
	}




	public void setTenmm(Float tenmm) {
		this.tenmm = tenmm;
	}




	public Float getTwentymm() {
		return twentymm;
	}




	public void setTwentymm(Float twentymm) {
		this.twentymm = twentymm;
	}




	public Float getCrushsand() {
		return crushsand;
	}




	public void setCrushsand(Float crushsand) {
		this.crushsand = crushsand;
	}




	public Float getSilicasand() {
		return silicasand;
	}




	public void setSilicasand(Float silicasand) {
		this.silicasand = silicasand;
	}




	public Float getWater() {
		return water;
	}




	public void setWater(Float water) {
		this.water = water;
	}




	public Float getAddmixture() {
		return addmixture;
	}




	public void setAddmixture(Float addmixture) {
		this.addmixture = addmixture;
	}




	public Float getCementOPC() {
		return cementOPC;
	}




	public void setCementOPC(Float cementOPC) {
		this.cementOPC = cementOPC;
	}




	public Float getCementPPC() {
		return cementPPC;
	}




	public void setCementPPC(Float cementPPC) {
		this.cementPPC = cementPPC;
	}




	public String getAddSideBarJs() {
		return addSideBarJs;
	}




	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}




	public Float getPumpAmount() {
		return pumpAmount;
	}




	public void setPumpAmount(Float pumpAmount) {
		this.pumpAmount = pumpAmount;
	}




	public Float getLabourAmount() {
		return labourAmount;
	}




	public void setLabourAmount(Float labourAmount) {
		this.labourAmount = labourAmount;
	}




	public Float getTransportCharge() {
		return transportCharge;
	}




	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}




	
	
	
	
}
