package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class ViewLabourAccountDetailsJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1137449839377712427L;
	
	private HttpSession session;
	private String key;
	private String laborId;
	private String laborName;
	private String laborMobile;
	private String fromDate;
	private String toDate;
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setToDate(dateFormat.format(d));
	        	this.setFromDate("01-04-2022");
	        
	        	this.setAddSideBarJs("FALSE");
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
					
					connection = GetDBConnection.getDBConnection(db);
					
					String laborId = EncryptionDecryption.decrypt(this.getKey());
					
					sql = "SELECT "
							+ "employee_name,"
							+ "employee_mobile_number "
							+ "FROM "
							+ "crusher_employee_master "
							+ "WHERE "
							+ "employee_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setLaborName(resultSet.getString(1));
						this.setLaborMobile(resultSet.getString(2));
						
						result = SUCCESS;
					}
					else
					{
						addActionError(this.getText("message.error.detailsNotFoundUrlTemperedPlzTryAgain"));
						result = ERROR;
					}
				
				}catch (SQLException e) {
	       			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	    		} catch (IOException e) {
	    			
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        	
	        	
	        	
	        }
	        return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	
	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getLaborMobile() {
		return laborMobile;
	}

	public void setLaborMobile(String laborMobile) {
		this.laborMobile = laborMobile;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	
	

}

