package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class ViewCustAccountDetailsJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1137449839377712427L;
	
	private HttpSession session;
	private String key;
	private String custName;
	private String custMobile;
	private String fromDate;
	private String toDate;
	private String addSideBarJs;
	private String type;
	private List<String> downloadTypeList = new ArrayList<String>();
	
	private List<String> typeList = new ArrayList<String>();
	private LinkedHashMap<String,String> crusherAccountList = new LinkedHashMap<String,String>();
	private String crusherAccount;
	
	private SessionMap<String,Object> sessionMap;

	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setToDate(dateFormat.format(d));
	        	this.setFromDate("01-04-2024");
	        	String custId = EncryptionDecryption.decrypt(getKey());	        	
	        	setKey(EncryptionDecryption.encrypt(custId));
	        	//System.out.println("Cust ID:"+custId);

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		
	    		
	       		typeList.add("Type 1");
	       		typeList.add("Type 2");
	       		
	       		downloadTypeList.add("pdf");
	        	downloadTypeList.add("xl");
	        	
	        	
	        	
	       		this.setAddSideBarJs("FALSE");
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			sql = "SELECT "
	       					+ "customer_name,"
	       					+ "mobile_number,"
	       					+ "gst_number "
	       					+ "FROM "
	       					+ "crusher_customer_master "
	       					+ "WHERE "
	       					+ "customer_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, custId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
	       			
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			crusherAccountList.put("ALL", "ALL");
	       	    	crusherAccountList.put("CRUSHER", "CRUSHER");
	       	    	crusherAccountList.put("RMC", "RMC");
	       	    	this.setCrusherAccount("ALL");
		        
	       			
		        	
	       			
	       			if(rowCount>0)
	       			{
	       				result = SUCCESS;
		       			while(resultSet.next())
		       			{
		       				
		       				setCustName(resultSet.getString(1));
		       				setCustMobile(resultSet.getString(2));					
		       				
		       				
		       			}
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.detailsNotFound"));
	       			}
	       		}catch (SQLException e) {
	       			e.printStackTrace();
	       			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
	    		} catch (IOException e) {
	    			
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        	
	        	
	        	
	        }
	        return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCustName() {
		return custName;
	}

	public void setCustName(String custName) {
		this.custName = custName;
	}

	public String getCustMobile() {
		return custMobile;
	}

	public void setCustMobile(String custMobile) {
		this.custMobile = custMobile;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public List<String> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public LinkedHashMap<String, String> getCrusherAccountList() {
		return crusherAccountList;
	}

	public void setCrusherAccountList(LinkedHashMap<String, String> crusherAccountList) {
		this.crusherAccountList = crusherAccountList;
	}

	public String getCrusherAccount() {
		return crusherAccount;
	}

	public void setCrusherAccount(String crusherAccount) {
		this.crusherAccount = crusherAccount;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	

}
