package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class ViewBoulderSuppAccountDetailsJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1098053268941291070L;
	
	private HttpSession session;
	private String key;
	private String boulderSupplierName;
	private String boulderSupplierMobile;
	private String boulderSupplierAddress;
	private Map<String,String> boulderSuppSearchOptionList = new HashMap<String,String>();
	private String boulderSuppSearchOption;
	private String defaultValue;
	private String fromDate;
	private String toDate;
	private String addSideBarJs;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	    		this.setAddSideBarJs("FALSE");

	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setToDate(dateFormat.format(d));
	        	this.setFromDate("01-04-2024");
	        	
	        	this.getBoulderSuppSearchOptionList().put("BYNAME", "BY NAME");
	        	this.getBoulderSuppSearchOptionList().put("BYMOBILE", "BY MOBILE");
	        	this.getBoulderSuppSearchOptionList().put("BYADDRESS","BY ADDRESS");
				this.setBoulderSupplierName("BYNAME");
				setDefaultValue("BYNAME");
				
	        	String supplierId = EncryptionDecryption.decrypt(getKey());	        	
	        	setKey(EncryptionDecryption.encrypt(supplierId));
	        
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			sql = "SELECT "
	       					+ "boulder_supplier_id,"
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_mobile_number,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_id =  ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			
	       			if(rowCount>0)
	       			{
	       				while(resultSet.next())
		       			{
	       					this.setBoulderSupplierName(resultSet.getString(2));
	       					this.setBoulderSupplierMobile(resultSet.getString(3));
	       					this.setBoulderSupplierAddress(resultSet.getString(4));
		       			}
	       				result = "success";
	       			}
	       		}catch (SQLException e) {
	       			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.supplierDetailsNotFound"));
	    		} catch (IOException e) {
	    			
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" ||"+this.getText("message.error.supplierDetailsNotFound"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        	
	        	
	        	
	        }
	        return result;
}

	public String getBoulderSupplierName() {
		return boulderSupplierName;
	}

	public void setBoulderSupplierName(String boulderSupplierName) {
		this.boulderSupplierName = boulderSupplierName;
	}

	public String getBoulderSupplierMobile() {
		return boulderSupplierMobile;
	}

	public void setBoulderSupplierMobile(String boulderSupplierMobile) {
		this.boulderSupplierMobile = boulderSupplierMobile;
	}

	public String getBoulderSupplierAddress() {
		return boulderSupplierAddress;
	}

	public void setBoulderSupplierAddress(String boulderSupplierAddress) {
		this.boulderSupplierAddress = boulderSupplierAddress;
	}

	public Map<String, String> getBoulderSuppSearchOptionList() {
		return boulderSuppSearchOptionList;
	}

	public void setBoulderSuppSearchOptionList(Map<String, String> boulderSuppSearchOptionList) {
		this.boulderSuppSearchOptionList = boulderSuppSearchOptionList;
	}

	public String getBoulderSuppSearchOption() {
		return boulderSuppSearchOption;
	}

	public void setBoulderSuppSearchOption(String boulderSuppSearchOption) {
		this.boulderSuppSearchOption = boulderSuppSearchOption;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	

}
