package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateVehicleTripEntryJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1826724344164398983L;
	
	private HttpSession session;
	private String key;
	
	private String tripDate;
	private String vehicleId;
	private String customerName;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	/*
	 * private Float dieselQuantity; private Float dieselAmount; private Float
	 * transportationCharges; private String tripDateHidden; private Float
	 * maintenanceAmount; private String maintenanceDescription;
	 */

	private Map<String,String> vehicleList = new HashMap<String,String>();
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String billNo;
	private Float transportationCharges;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	String tripId  = "";
	        	try {
					
	        		tripId = EncryptionDecryption.decrypt(URLDecoder.decode(this.getKey(),"UTF-8"));
				} catch (UnsupportedEncodingException e1) {
					addActionError(this.getText("message.error.errorWhiledecryptionTheKey")+e1.getMessage());
				}
	        	
	        	if(!hasActionErrors())
	        	{
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			connection = GetDBConnection.getDBConnection(db);
	       			
	       			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    			}
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    			}
	    			
	    			if(!this.getBillNo().equals("0"))
	    			{
	    				
	    				sql = "SELECT "
		    					+ "trip_entry_id,"
		    					+ "DATE_FORMAT(trip_date,'%d-%m-%Y'),"
		    					+ "vehicle_id,"
		    					+ "customer_id,"
		    					+ "customer_name,"
		    					+ "product_name,"
		    					+ "product_quantity,"
		    					+ "vehicle_km_start,"
		    					+ "vehicle_km_end,"
		    					+ "trip_total_km,"
		    					+ "trip_start_from,"
		    					+ "trip_end_to,"
		    					+ "total_trip_count,"
		    					+ "trip_driver_name,"
		    					+ "trip_driver_mobile_number,"
		    					+ "bill_type,"
		    					+ "trip_total_km,"
		    					+ "transportation_charges "
		    					+ "FROM "
		    					+ "crusher_vehicle_trip_master "
		    					+ "WHERE "
		    					+ "trip_entry_id = ? "
		    					+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
		       			
		       			preparedStatement = connection.prepareStatement(sql);
		       			preparedStatement.setString(1, tripId);
		       			preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
		       			resultSet = preparedStatement.executeQuery();
		       			
		       			if(resultSet.next())
		       			{
		       				this.setTripDate(resultSet.getString(2));
		       				this.setVehicleId(resultSet.getString(3));
		       				this.setCustomerName(resultSet.getString(4)+"-"+resultSet.getString(5));
		       				this.setMaterialName(resultSet.getString(6));
		       				this.setMaterialVolume(resultSet.getFloat(7));
		       				this.setKmStart(resultSet.getFloat(8));
		       				this.setKmEnd(resultSet.getFloat(9));
		       				this.setTotalKm(resultSet.getFloat(10));
		       				this.setTripFrom(resultSet.getString(11));
		       				this.setTripTo(resultSet.getString(12));
		       				this.setTotalTrips(resultSet.getInt(13));
							this.setTransportationCharges(resultSet.getFloat(18));
		       				
		       				
		       				
		       				result = "success";
		       			}
		       			else
		       			{
		       				result = "error";
		       				addActionError(this.getText("message.error.tripEntryDetailsNotFound"));
		       			}
		       			
		       			
		       			
	    				
	    			}else {
	       			sql = "SELECT "
	    					+ "trip_entry_id,"
	    					+ "DATE_FORMAT(trip_date,'%d-%m-%Y'),"
	    					+ "vehicle_id,"
	    					+ "customer_id,"
	    					+ "customer_name,"
	    					+ "product_name,"
	    					+ "product_quantity,"
	    					+ "vehicle_km_start,"
	    					+ "vehicle_km_end,"
	    					+ "trip_total_km,"
	    					+ "trip_start_from,"
	    					+ "trip_end_to,"
	    					+ "total_trip_count,"
	    					+ "transportation_charges "
	    					+ "FROM "
	    					+ "crusher_vehicle_trip_other_master "
	    					+ "WHERE "
	    					+ "trip_entry_id = ? "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, tripId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				this.setTripDate(resultSet.getString(2));
	       				this.setVehicleId(resultSet.getString(3));
	       				this.setCustomerName(resultSet.getString(4)+"-"+resultSet.getString(5));
	       				this.setMaterialName(resultSet.getString(6));
	       				this.setMaterialVolume(resultSet.getFloat(7));
	       				this.setKmStart(resultSet.getFloat(8));
	       				this.setKmEnd(resultSet.getFloat(9));
	       				this.setTotalKm(resultSet.getFloat(10));
	       				this.setTripFrom(resultSet.getString(11));
	       				this.setTripTo(resultSet.getString(12));
	       				this.setTotalTrips(resultSet.getInt(13));
	       				this.setTransportationCharges(resultSet.getFloat(14));
	       				
	       				
	       				
	       				
	       				result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.tripEntryDetailsNotFound"));
	       			}
	       			
	    			}
	       			
	       		}
	       		catch (SQLException e) 
	       		{
	        		result = "error";
	        		addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
	       		} 
	       		
	       		catch (IOException e) {
					
					result = "error";
					addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
					{
						try 
						{
							resultSet.close();
						
						}catch (SQLException e) {
							
						}
					}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close();} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close();} catch (SQLException e) {}
	   				}
	   				
	   			}
	        	}else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.urlTempered"));
	        	}
		        	
		        
		        }
		
		        return result;
	}
		public HttpSession getSession() {
			return session;
		}
		public void setSession(HttpSession session) {
			this.session = session;
		}
		public String getKey() {
			return key;
		}
		public void setKey(String key) {
			this.key = key;
		}
		public String getTripDate() {
			return tripDate;
		}
		public void setTripDate(String tripDate) {
			this.tripDate = tripDate;
		}
		public String getVehicleId() {
			return vehicleId;
		}
		public void setVehicleId(String vehicleId) {
			this.vehicleId = vehicleId;
		}
		public String getCustomerName() {
			return customerName;
		}
		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}
		public String getMaterialName() {
			return materialName;
		}
		public void setMaterialName(String materialName) {
			this.materialName = materialName;
		}
		public Float getMaterialVolume() {
			return materialVolume;
		}
		public void setMaterialVolume(Float materialVolume) {
			this.materialVolume = materialVolume;
		}
		public Float getKmStart() {
			return kmStart;
		}
		public void setKmStart(Float kmStart) {
			this.kmStart = kmStart;
		}
		public Float getKmEnd() {
			return kmEnd;
		}
		public void setKmEnd(Float kmEnd) {
			this.kmEnd = kmEnd;
		}
		public Float getTotalKm() {
			return totalKm;
		}
		public void setTotalKm(Float totalKm) {
			this.totalKm = totalKm;
		}
		public String getTripFrom() {
			return tripFrom;
		}
		public void setTripFrom(String tripFrom) {
			this.tripFrom = tripFrom;
		}
		public String getTripTo() {
			return tripTo;
		}
		public void setTripTo(String tripTo) {
			this.tripTo = tripTo;
		}
		public Integer getTotalTrips() {
			return totalTrips;
		}
		public void setTotalTrips(Integer totalTrips) {
			this.totalTrips = totalTrips;
		}

		/*
		 * public Float getDieselQuantity() { return dieselQuantity; } public void
		 * setDieselQuantity(Float dieselQuantity) { this.dieselQuantity =
		 * dieselQuantity; } public Float getDieselAmount() { return dieselAmount; }
		 * public void setDieselAmount(Float dieselAmount) { this.dieselAmount =
		 * dieselAmount; } public Float getTransportationCharges() { return
		 * transportationCharges; } public void setTransportationCharges(Float
		 * transportationCharges) { this.transportationCharges = transportationCharges;
		 * }
		 */
		public static long getSerialversionuid() {
			return serialVersionUID;
		}
		
		public Map<String, String> getCustomerSearchOptionList() {
			return customerSearchOptionList;
		}
		public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
			this.customerSearchOptionList = customerSearchOptionList;
		}
		public String getCustomerSearchOption() {
			return customerSearchOption;
		}
		public void setCustomerSearchOption(String customerSearchOption) {
			this.customerSearchOption = customerSearchOption;
		}
		public String getDefaultValue() {
			return defaultValue;
		}
		public void setDefaultValue(String defaultValue) {
			this.defaultValue = defaultValue;
		}
		public Map<String, String> getVehicleList() {
			return vehicleList;
		}
		public void setVehicleList(Map<String, String> vehicleList) {
			this.vehicleList = vehicleList;
		}

		/*
		 * public String getTripDateHidden() { return tripDateHidden; } public void
		 * setTripDateHidden(String tripDateHidden) { this.tripDateHidden =
		 * tripDateHidden; } public String getMaintenanceDescription() { return
		 * maintenanceDescription; } public void setMaintenanceDescription(String
		 * maintenanceDescription) { this.maintenanceDescription =
		 * maintenanceDescription; } public Float getMaintenanceAmount() { return
		 * maintenanceAmount; } public void setMaintenanceAmount(Float
		 * maintenanceAmount) { this.maintenanceAmount = maintenanceAmount; }
		 */
		public String getBillNo() {
			return billNo;
		}
		public void setBillNo(String billNo) {
			this.billNo = billNo;
		}
		public float getTransportationCharges() {
			return transportationCharges;
		}
		public void setTransportationCharges(float transportationCharges) {
			this.transportationCharges = transportationCharges;
		}
		
		
		

}
