package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateSalaryDetailsJsp extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3149263533240331042L;
	private String key;
	private HttpSession session;
	private String typeOfSalaryPayment;
	private Float salaryAmount;
	private String laborId;
	private String laborName;
	private String typeOfOpeningBal;
	private Float balanceAmount;
	private List<String> typeOfBalanceAmountList = new ArrayList<String>();
	private HashMap<String,String> typeOfSalaryPaymentList = new LinkedHashMap<String,String>();
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	
	    		this.getTypeOfSalaryPaymentList().put("MONTHLY", "MONTHLY");
	        	this.getTypeOfSalaryPaymentList().put("PERHOURBASIS", "PER HOUR BASIS");
	        	this.getTypeOfSalaryPaymentList().put("DAILY", "DAILY");
	        	this.getTypeOfSalaryPaymentList().put("WORKBASIS", "WORK BASIS");
	        	this.getTypeOfSalaryPaymentList().put("WEEKLY", "WEEKLY");
	        	
	        	
	        	this.getTypeOfBalanceAmountList().add("ADVANCE");
	        	this.getTypeOfBalanceAmountList().add("PENDING");
	        	
	        	String laborId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
				
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "employee_name,"
							+ "employee_salary_type,"
							+ "employee_salary_amount,"
							+ "opening_bal_type,"
							+ "opening_balance_amount "
							+ "FROM "
							+ "crusher_employee_salary_details "
							+ "WHERE "
							+ "employee_id = ?"
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setLaborName(resultSet.getString(1));
						this.setTypeOfSalaryPayment(resultSet.getString(2));
						this.setSalaryAmount(resultSet.getFloat(3));
						
						this.setTypeOfOpeningBal(resultSet.getString(4));
						this.setBalanceAmount(resultSet.getFloat(5));
						result = SUCCESS;
						
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotFoundPlzTryAgain"));
								
					}
					
				}catch (SQLException e) {
					//e.printStackTrace();
					result = ERROR;				
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.laborSalaryDetailsNotFound"));
				
				} catch (IOException e) {
					//e.printStackTrace();
					result = ERROR;			
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.laborSalaryDetailsNotFound"));
				
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
        		
					
	        }
	        
	        return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getTypeOfSalaryPayment() {
		return typeOfSalaryPayment;
	}

	public void setTypeOfSalaryPayment(String typeOfSalaryPayment) {
		this.typeOfSalaryPayment = typeOfSalaryPayment;
	}

	public Float getSalaryAmount() {
		return salaryAmount;
	}

	public void setSalaryAmount(Float salaryAmount) {
		this.salaryAmount = salaryAmount;
	}

	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getTypeOfOpeningBal() {
		return typeOfOpeningBal;
	}

	public void setTypeOfOpeningBal(String typeOfOpeningBal) {
		this.typeOfOpeningBal = typeOfOpeningBal;
	}

	public Float getBalanceAmount() {
		return balanceAmount;
	}

	public void setBalanceAmount(Float balanceAmount) {
		this.balanceAmount = balanceAmount;
	}

	
	public List<String> getTypeOfBalanceAmountList() {
		return typeOfBalanceAmountList;
	}

	public void setTypeOfBalanceAmountList(List<String> typeOfBalanceAmountList) {
		this.typeOfBalanceAmountList = typeOfBalanceAmountList;
	}

	public HashMap<String, String> getTypeOfSalaryPaymentList() {
		return typeOfSalaryPaymentList;
	}

	public void setTypeOfSalaryPaymentList(HashMap<String, String> typeOfSalaryPaymentList) {
		this.typeOfSalaryPaymentList = typeOfSalaryPaymentList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	
}
