package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class UpdatePaymentEntryJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3149263533240331042L;
	private SessionMap<String,Object> sessionMap;  
	private String key;
	private String laborPaymentDate;
	private String laborId;
	private String laborName;
	private String laborMobile;
	private Float laborOutstandingAmount;
	private Float amount;
	private String typeOfPayment;
	private String accountId;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private String details;
	private HttpSession session;
	private String addSideBarJs;
	
	private String fromDate;
	private String toDate;
	private String secKey;
	
	private String paymentId;
	
	public String execute() throws IOException, ParseException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	        	
	        	this.setAddSideBarJs("FALSE");
	    		
	    		session=ServletActionContext.getRequest().getSession(false);
	        	paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));     
	        	
	        	
	        	String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
    			String entryId = keyDetails[0];
    			String laborId = keyDetails[1];
    		
    			this.setPaymentId(entryId);
	        	
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
				
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "payment_date,"
							+ "employee_id,"
							+ "employee_name,"
							+ "payment_amount,"
							+ "payment_type,"
							+ "amount_debit_account_id,"
							+ "payment_details "
							+ "FROM "
							+ "crusher_employee_payment_details "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "employee_id = ?"
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, laborId);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						String paymentDate = resultSet.getString(1); 

						this.setLaborName(resultSet.getString(3));
						this.setAmount(resultSet.getFloat(4));
						this.setTypeOfPayment(resultSet.getString(5));
						this.setAccountId(resultSet.getString(6));
						this.setDetails(resultSet.getString(7));
						
						SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
					    SimpleDateFormat outputFormat = new SimpleDateFormat("dd-MM-yyyy");
					    String formattedDate = outputFormat.format(inputFormat.parse(paymentDate));
					    this.setLaborPaymentDate(formattedDate);
						
					      
						
						result = SUCCESS;
						
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotAddedPlzTryAgain"));
								
					}
					
				}catch (SQLException e) {
					//e.printStackTrace();
					result = ERROR;				
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.laborPaymentDetailsNotFound"));
				
				} catch (IOException e) {
					//e.printStackTrace();
					result = ERROR;			
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.laborPaymentDetailsNotFound"));
				
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
        		
					
	        }
	        
	        return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	
	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getLaborPaymentDate() {
		return laborPaymentDate;
	}

	public void setLaborPaymentDate(String laborPaymentDate) {
		this.laborPaymentDate = laborPaymentDate;
	}

	public String getLaborMobile() {
		return laborMobile;
	}

	public void setLaborMobile(String laborMobile) {
		this.laborMobile = laborMobile;
	}

	public Float getLaborOutstandingAmount() {
		return laborOutstandingAmount;
	}

	public void setLaborOutstandingAmount(Float laborOutstandingAmount) {
		this.laborOutstandingAmount = laborOutstandingAmount;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public String getTypeOfPayment() {
		return typeOfPayment;
	}

	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public String getChequePayDate() {
		return chequePayDate;
	}

	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}

	public String getChequePayee() {
		return chequePayee;
	}

	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}

	public String getChequeNumber() {
		return chequeNumber;
	}

	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}

	public List<String> getChequeList() {
		return chequeList;
	}

	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getSecKey() {
		return secKey;
	}

	public void setSecKey(String secKey) {
		this.secKey = secKey;
	}

	public String getPaymentId() {
		return paymentId;
	}

	public void setPaymentId(String paymentId) {
		this.paymentId = paymentId;
	}
	
	
	
}
