package com.stonecrusher.jspRedirect;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.opensymphony.xwork2.ActionSupport;

public class UpdateExpenseEntryJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	
	private String key;
	private String fromDate;
	private String toDate;
	private String accountHeadId;
	private String accountHeadCode;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountHeadList = new HashMap<String,String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	
	private String expenseReason;
	private Float amount;
	private String typeOfPayment;
	private String accountId;
	private String description;
	
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	private String addSideBarJs;
	private Map<String,String> siteList = new LinkedHashMap<String,String>();
	private String siteCode;
	private String expenseDate;
	
	private String expenseId;
	private boolean expenseSaved;
	
	
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	this.setAccountHeadCode(this.getAccountHeadId());
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					paymentTypeList.add("CASH");
		        	paymentTypeList.add("UPI");
		        	paymentTypeList.add("RTGS");
		        	paymentTypeList.add("NEFT");
		        	paymentTypeList.add("CHEQUE");
		        
		        	
						this.setAccountHeadList(GetListResource.getAccountHeadList());
						this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));       
						this.setSiteList(GetListResource.getSiteList());
				        
		        
		       	
		        	this.setAddSideBarJs("FALSE");
					
					connection = GetDBConnection.getDBConnection(db);
					
					
					String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					
					String entryId = keyDetails[0];
					String entryDate = keyDetails[1];
					
					sql = "SELECT "
							+ "entry_id,"
							+ "head_id,"
							+ "head_name,"
							+ "expense_date,"
							+ "expense_time,"
							+ "expense_amount,"
							+ "type_of_payment,"
							+ "account_id,"
							+ "expense_details,"
							+ "expense_reason,"
							+ "site_code "
							+ "FROM "
							+ "crusher_daily_expenses "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setExpenseDate(entryDate);
						this.setExpenseReason("");
			        	this.setAmount(resultSet.getFloat(6));
			        	this.setTypeOfPayment(resultSet.getString(7));
			        	this.setAccountId(resultSet.getString(8));
			        	this.setChequePayDate("");
			        	this.setChequePayee("");
			        	this.setBranchName("");
			        	this.setBranchName("");
			        	this.setChequeNumber("");
			        	this.setDescription(resultSet.getString(9));
			        	this.setExpenseReason(resultSet.getString(10));
			        	this.setAccountHeadId(resultSet.getString(2));
			        	this.setSiteCode(resultSet.getString(11));
			        	this.setAccountHeadCode(resultSet.getString(2));
			        	
			        	this.setExpenseId(EncryptionDecryption.encrypt(resultSet.getString(1)));
			        	this.setExpenseSaved(true);
			        	
			        	result = SUCCESS;
					}
					else
					{
						addActionError(this.getText("message.error.detailsNotFoundPlzTryAgain"));
						
						result = ERROR;
					}
					
					
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	
	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getAccountHeadId() {
		return accountHeadId;
	}



	public void setAccountHeadId(String accountHeadId) {
		this.accountHeadId = accountHeadId;
	}



	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}



	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}



	public List<String> getBankList() {
		return bankList;
	}



	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}



	public List<String> getBranchList() {
		return branchList;
	}



	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}



	public List<String> getChequeList() {
		return chequeList;
	}



	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}



	public Map<String, String> getAccountHeadList() {
		return accountHeadList;
	}



	public void setAccountHeadList(Map<String, String> accountHeadList) {
		this.accountHeadList = accountHeadList;
	}



	public Map<String, String> getAccountList() {
		return accountList;
	}



	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}



	public String getExpenseReason() {
		return expenseReason;
	}



	public void setExpenseReason(String expenseReason) {
		this.expenseReason = expenseReason;
	}



	public Float getAmount() {
		return amount;
	}



	public void setAmount(Float amount) {
		this.amount = amount;
	}



	public String getTypeOfPayment() {
		return typeOfPayment;
	}



	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}



	public String getAccountId() {
		return accountId;
	}



	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}



	public String getDescription() {
		return description;
	}



	public void setDescription(String description) {
		this.description = description;
	}



	public String getChequePayDate() {
		return chequePayDate;
	}



	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}



	public String getChequePayee() {
		return chequePayee;
	}



	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}



	public String getBankName() {
		return bankName;
	}



	public void setBankName(String bankName) {
		this.bankName = bankName;
	}



	public String getBranchName() {
		return branchName;
	}



	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}



	public String getChequeNumber() {
		return chequeNumber;
	}



	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public String getExpenseDate() {
		return expenseDate;
	}



	public void setExpenseDate(String expenseDate) {
		this.expenseDate = expenseDate;
	}



	public String getAccountHeadCode() {
		return accountHeadCode;
	}



	public void setAccountHeadCode(String accountHeadCode) {
		this.accountHeadCode = accountHeadCode;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public Map<String, String> getSiteList() {
		return siteList;
	}



	public void setSiteList(Map<String, String> siteList) {
		this.siteList = siteList;
	}



	public String getSiteCode() {
		return siteCode;
	}



	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}



	public String getExpenseId() {
		return expenseId;
	}



	public void setExpenseId(String expenseId) {
		this.expenseId = expenseId;
	}



	public boolean isExpenseSaved() {
		return expenseSaved;
	}



	public void setExpenseSaved(boolean expenseSaved) {
		this.expenseSaved = expenseSaved;
	}
	

}



