package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;

public class UpdateCustPaymentEntryJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1117494103464746961L;

	
	private HttpSession session;
	private String key;
	private String paymentDate;
	private String custName;
	private String totalAmount;
	private String paymentDetails;
	private String outstandingAmount;
	private String outStandingAmtWithoutPayment;
	private boolean sendSMS;
	
	private Float custOpeningBalnce = 0.0F;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private SessionMap<String,Object> sessionMap;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String paymentId;
	private String fromDate;
	private String toDate;
	private String custMobile;
     private String accountId1;
     private String accountId2;
    
	private String typeOfPayment1;
	private String typeOfPayment2;
	
	private String amount1;
	private String amount2;
	
	private boolean paymentSaved;
	private String addSideBarJs;
	
	
	
	@SuppressWarnings("static-access")
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
				
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	    		this.setPaymentTypeList(GetTypeOfPaymentList.getPaymentTypeList());
	        	
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try 
	       		{
	       			this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap())); 
					
	       			connection = new GetDBConnection().getDBConnection(db);
	       			
	       			sql = "SELECT "
	       					+ "customer_id,"
	       					+ "customer_name,"
	       					+ "DATE_FORMAT(payment_date,'%d-%m-%Y'),"
	       					+ "amount,"
	       					+ "payemnt_details,"
	       					+ "amount_debit_account1_id,"
	       					+ "payment_type1,"
	       					+ "account1_amount,"
	       					+ "amount_debit_account2_id,"
	       					+ "payment_type2,"
	       					+ "account2_amount "
	       					+ "FROM "
	       					+ "crusher_customer_payment_details_master "
	       					+ "WHERE "
	       					+ "payement_entry_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, this.getPaymentId());
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			if(rowCount > 0)
	       			{
	       				
	       				if(resultSet.next())
	       				{
	       					this.setCustName(resultSet.getString(1)+"-"+resultSet.getString(2));
	       					this.setPaymentDate(resultSet.getString(3));
	       					this.setTotalAmount(resultSet.getString(4));
	       					this.setPaymentDetails(resultSet.getString(5));	 
	       					this.setAccountId1(resultSet.getString(6));
	       					this.setTypeOfPayment1(resultSet.getString(7));
	       					this.setAmount1(resultSet.getString(8));
	       					this.setAccountId2(resultSet.getString(9));
	       					this.setTypeOfPayment2(resultSet.getString(10));
	       					this.setAmount2(resultSet.getString(11));
	       					
	       					String custId = resultSet.getString(1);
	       					
	       					
	    	       			PreparedStatement getOpeningBalPSMT = null;
	           				ResultSet getOpeningBalRs = null;
	           				String getOpeningBalSQL = "SELECT "
	           						+ "opening_balance,"
	           						+ "DATE_FORMAT(opening_balance_date,'%d-%M-%Y'),"
	           						+ "updated_by "
	           						+ "FROM "
	           						+ "crusher_cust_close_open_bal_master "
	           						+ "WHERE "
	           						+ "customer_id = ? "
	           						+ "AND "
	        						+ "crusher_id = ? "
	    							+ "AND "
	    							+ "crusher_code = ?";
	           				
	           				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
	           				
	           				getOpeningBalPSMT.setString(1, custId);
	           				getOpeningBalPSMT.setString(2, crusherId);
	           				getOpeningBalPSMT.setString(3, crusherCode);
	        				
	           				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
	           				
	           				if(getOpeningBalRs.next())
	           				{
	           					this.setCustOpeningBalnce(getOpeningBalRs.getFloat(1));
	           					this.setOpeingBalanceUpdateDate(getOpeningBalRs.getString(2));
	           					this.setOpeingBalancUpdatedBy(getOpeningBalRs.getString(3));
	           				}
	           				else
	           				{
	           					this.setCustOpeningBalnce(0.0F);
	           				}
	           				if(getOpeningBalRs != null)
	           				{
	           					getOpeningBalRs.close();
	           					getOpeningBalRs = null;
	           				}
	           				if(getOpeningBalPSMT != null)
	           				{
	           					getOpeningBalPSMT.close();
	           					getOpeningBalPSMT = null;
	           				}
	       					
	           				float floatTotalAmt = 0.0F;
		       				float floatAmtReceived = 0.0F;
		       				float floatBalanceAmt = 0.0F;
		       				float totalBalanceAmt = 0.0F;
		       				float totalPaymentDone = 0.0F;
		       				
		       				if(resultSet != null)
		       				{
		       					resultSet.close();
		       					resultSet = null;
		       				}
		       				
		       				if(preparedStatement != null)
		       				{
		       					preparedStatement.close();
		       					preparedStatement = null;
		       				}
		       				
		       				sql = "SELECT "	           					
		           					+ "bill_total_amount,"
		           					+ "bill_amount_received,"
		           					+ "bill_amount_return "
		           					+ "FROM "
		           					+ "crusher_bill_info_master "
		           					+ "WHERE "		           					
		           					+ "customer_id = '"+custId+"' "
		           					+ "AND "
	        						+ "crusher_id = ? "
	    							+ "AND "
	    							+ "crusher_code = ?";
		           					/*+ "AND "
		           					+ "bill_amount_received != 'null'";
		           				*/
		       				
		       				preparedStatement = connection.prepareStatement(sql);
		       				preparedStatement.setString(1, crusherId);
	        				preparedStatement.setString(2, crusherCode);
	        				
		       				ResultSet resultSetBillInfo = preparedStatement.executeQuery();
		       				
		       				while(resultSetBillInfo.next())
		       				{
		       					try
		       					{
			       					floatTotalAmt = Float.parseFloat(resultSetBillInfo.getString(1));
			           				floatAmtReceived = Float.parseFloat(resultSetBillInfo.getString(2));
			           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
			           				
			           				
			           				if(floatBalanceAmt > 0)
			           				{
			           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
			           				}
			           				
		       					}catch(NumberFormatException nfe)
		       					{
		       						result = "error";
		       						addActionError(this.getText("message.error.errorWhileFormattingWhileCalculatingBalanceAmount")+nfe.getMessage());
		       					}
		       				}
		       				if(resultSetBillInfo != null)
		       				{
		       					resultSetBillInfo.close();
		       				}
		       				if(preparedStatement != null)
		       				{
		       					preparedStatement.close();
		       				}
		       				
		       				sql = "select "
		       						+ "sum(amount) "
		       						+ "from "
		       						+ "crusher_customer_payment_details_master "
		       						+ "where "
		       						+ "customer_id = '"+custId+"' "
		       						+ "AND "
	        						+ "crusher_id = ? "
	    							+ "AND "
	    							+ "crusher_code = ?";
		       			
		       				preparedStatement = connection.prepareStatement(sql);
		       				preparedStatement.setString(1, crusherId);
	        				preparedStatement.setString(2, crusherCode);
	        				
		       				ResultSet resultSetTotalPayment = preparedStatement.executeQuery();
		       				
		       				resultSetTotalPayment.last();
		       				int rowCount2 = resultSetTotalPayment.getRow();
		       				resultSetTotalPayment.beforeFirst();
		       				
		       				if(rowCount2>0)
		       				{
		       				
			       				while(resultSetTotalPayment.next())
			       				{
			       					try
			       					{
			       						if(resultSetTotalPayment.getString(1) != null)
			       						{		       						
			       							totalPaymentDone = Float.parseFloat(resultSetTotalPayment.getString(1));
			       						}
			       					}
			       					catch(NumberFormatException nfe)
			       					{
			       						result = "error";
			       						addActionError(this.getText("message.error.errorWhileFormattingWhileCalculatingTotalPaymentAmount")+nfe.getMessage());
			       					}
			       				}
			       						
			       				
			       				totalBalanceAmt = (totalBalanceAmt+this.getCustOpeningBalnce()) - totalPaymentDone;
		       				}
		       				setOutstandingAmount(""+totalBalanceAmt);
		       				setOutStandingAmtWithoutPayment(""+(totalBalanceAmt+Float.parseFloat(this.getTotalAmount())));
		       				if(resultSetTotalPayment != null)
		       				{
		       					resultSetTotalPayment.close();
		       				}
	       					
	       					
	       					
	       					
	       				}
	       				
	       				this.setPaymentSaved(true);
	       				result = "success";
	       				
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.urlTemperedInformationNotFound"));
	       			}
	       			
	       			
	       		}
	       		catch (SQLException e) {
		       		result = "error";				
		       		addActionError(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
	       	 	} catch (IOException e) {
				
				result = "error";
				addActionError(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
			finally
			{
				if(resultSet != null)
				{
					try {
						resultSet.close();
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					try {connection.close();} catch (SQLException e) {}
				}
				
			}
		
	        	
	        
	        }
	
	        return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getPaymentDate() {
		return paymentDate;
	}

	public void setPaymentDate(String paymentDate) {
		this.paymentDate = paymentDate;
	}

	public String getCustName() {
		return custName;
	}

	public void setCustName(String custName) {
		this.custName = custName;
	}


	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getPaymentDetails() {
		return paymentDetails;
	}

	public void setPaymentDetails(String paymentDetails) {
		this.paymentDetails = paymentDetails;
	}

	public String getOutstandingAmount() {
		return outstandingAmount;
	}

	public void setOutstandingAmount(String outstandingAmount) {
		this.outstandingAmount = outstandingAmount;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public Float getCustOpeningBalnce() {
		return custOpeningBalnce;
	}

	public void setCustOpeningBalnce(Float custOpeningBalnce) {
		this.custOpeningBalnce = custOpeningBalnce;
	}

	public String getOpeingBalancUpdatedBy() {
		return opeingBalancUpdatedBy;
	}

	public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
		this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
	}

	public String getOpeingBalanceUpdateDate() {
		return opeingBalanceUpdateDate;
	}

	public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
		this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
	}

	public String getOutStandingAmtWithoutPayment() {
		return outStandingAmtWithoutPayment;
	}

	public void setOutStandingAmtWithoutPayment(String outStandingAmtWithoutPayment) {
		this.outStandingAmtWithoutPayment = outStandingAmtWithoutPayment;
	}

	public String getPaymentId() {
		return paymentId;
	}

	public void setPaymentId(String paymentId) {
		this.paymentId = paymentId;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getCustMobile() {
		return custMobile;
	}

	public void setCustMobile(String custMobile) {
		this.custMobile = custMobile;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	public String getAccountId1() {
		return accountId1;
	}

	public void setAccountId1(String accountId1) {
		this.accountId1 = accountId1;
	}

	public String getAccountId2() {
		return accountId2;
	}

	public void setAccountId2(String accountId2) {
		this.accountId2 = accountId2;
	}

	public String getTypeOfPayment1() {
		return typeOfPayment1;
	}

	public void setTypeOfPayment1(String typeOfPayment1) {
		this.typeOfPayment1 = typeOfPayment1;
	}

	public String getTypeOfPayment2() {
		return typeOfPayment2;
	}

	public void setTypeOfPayment2(String typeOfPayment2) {
		this.typeOfPayment2 = typeOfPayment2;
	}

	public boolean isPaymentSaved() {
		return paymentSaved;
	}

	public void setPaymentSaved(boolean paymentSaved) {
		this.paymentSaved = paymentSaved;
	}

	public String getAmount1() {
		return amount1;
	}

	public void setAmount1(String amount1) {
		this.amount1 = amount1;
	}

	public String getAmount2() {
		return amount2;
	}

	public void setAmount2(String amount2) {
		this.amount2 = amount2;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	
	

}
