package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateCustOpeningBalanceJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3641379554154019539L;
	
	private String key;
	private String custName;
	private HttpSession session;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	String custId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			sql = "SELECT "	       					
	       					+ "DATE_FORMAT(add_date,'%d-%M-%y'),"
	       					+ "customer_name,"
	       					+ "mobile_number,"
	       					+ "gst_number,"
	       					+ "pan_number,"
	       					+ "tin_number,"
	       					+ "billing_address,"
	       					+ "DATE_FORMAT(birth_date,'%d-%m-%y'),"
	       					+ "credit_limit "
	       					+ "FROM "
	       					+ "crusher_customer_master "
	       					+ "where "
	       					+ "customer_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, custId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			if(rowCount>0)
	       			{
		       			if(resultSet.next())
		       			{
		       				this.setCustName(custId+"-"+resultSet.getString(2));
		       			
		       			}
		       			
		       			this.setAddSideBarJs("FALSE");
		       			result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.detailsOfSpecifiedCustomerNotFound"));
	       			}
	       		
	        	}	 catch (SQLException e) {
	        		result = "error";
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		
	        	
	        
	        }
	
	        return result;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}


public Map<String, String> getCustomerSearchOptionList() {
	return customerSearchOptionList;
}

public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
	this.customerSearchOptionList = customerSearchOptionList;
}

public String getCustomerSearchOption() {
	return customerSearchOption;
}

public void setCustomerSearchOption(String customerSearchOption) {
	this.customerSearchOption = customerSearchOption;
}

public String getDefaultValue() {
	return defaultValue;
}

public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}

public String getCustName() {
	return custName;
}

public void setCustName(String custName) {
	this.custName = custName;
}


}
