package com.stonecrusher.jspRedirect;


import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class UpdateCompanySettingsJsp extends ActionSupport implements SessionAware, ServletResponseAware, ServletRequestAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 6586976079336065363L;

	private SessionMap<String,Object> sessionMap;  
	
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	private String addSideBarJs;
	private String customerCareNumber;
	private String GSTNumber;
	private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();
	private Map<String,String> CompanyDetailsDisplayList = new HashMap<String,String>();
	private String companyDetailsDisplay;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		      
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    		  
		    	  }
		      }
		      this.setAddSideBarJs("FALSE");
		      
		      
		      discountTypeList.put("", "Select Discount Type");
		      discountTypeList.put("By Quantity", "By Quantity");
		      discountTypeList.put("By Percentage", "By Percentage");
		      discountTypeList.put("By Direct Amount", "By Direct Amount");
				this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
				
				
				CompanyDetailsDisplayList.put("", "Select");
				CompanyDetailsDisplayList.put("YES", "YES");
				CompanyDetailsDisplayList.put("NO", "NO");
			      this.setCompanyDetailsDisplay((String) this.getSessionMap().get("companyDetailsDisplayInThermalBillPrint"));
					
					
					
		      String crusherId = (String) this.getSessionMap().get("crusherId");
				String crusherCode = (String) this.getSessionMap().get("crusherCode");

	    	  	
	    		Connection connection = null;
				
					
				
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					  
					PreparedStatement getQRFilePSMT = null;
					  ResultSet getQRFileRS = null;

					  
					  String getQRFileSQL = "SELECT "
					  		+ "customer_care_number,"
					  		+ "crusher_gst_number,"
					  		+ "left_logo_file,"
					  		+ "right_logo_file,"
					  		+ "owner_sign_image_file,"
					  		+ "comany_stamp_image_file "
					  		+ "FROM "
					  		+ "crusher_info_master "
					  		+ "WHERE "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ?";

					  getQRFilePSMT = connection.prepareStatement(getQRFileSQL);
					  getQRFilePSMT.setString(1, crusherId);
					  getQRFilePSMT.setString(2, crusherCode);
					  
					  getQRFileRS = getQRFilePSMT.executeQuery();
					  
					  if(getQRFileRS.next())
					  {
						  this.setCustomerCareNumber(getQRFileRS.getString("customer_care_number")); 
						   this.setGSTNumber(getQRFileRS.getString("crusher_gst_number"));
						   
						    Blob leftLogo = getQRFileRS.getBlob("left_logo_file");
						    Blob rightLogo = getQRFileRS.getBlob("right_logo_file");
						    Blob ownerSignImage = getQRFileRS.getBlob("owner_sign_image_file");
						    Blob companyStampImage = getQRFileRS.getBlob("comany_stamp_image_file");

						    
							  InputStream leftLogoIS = null;
						      InputStream rightLogoIS = null;
						      InputStream ownerSignImageIS = null;
						      InputStream companyStampImageIS = null;
						     

						      
						      
						    if(leftLogo != null)
							  {
								  
								  leftLogoIS = leftLogo.getBinaryStream();
								  byte[] leftLogoBytes = IOUtils.toByteArray(leftLogoIS);
									 
								  this.getSessionMap().put("left_logo_image_array",leftLogoBytes); 
									
								  
									
								  if(leftLogoIS != null)
								  {
									  leftLogoIS.close();
									  leftLogoIS = null;
								  }
							  }


						    if(rightLogo != null)
							  {
								  
								 
								  
								  rightLogoIS = rightLogo.getBinaryStream();
								  byte[] rightLogoBytes = IOUtils.toByteArray(rightLogoIS);
								  this.getSessionMap().put("right_logo_image_array",rightLogoBytes); 
								  
								  if(rightLogoIS != null)
								  {
									  rightLogoIS.close();
									  rightLogoIS = null;
								  }
								  
							  }

						    
						    if(ownerSignImage != null)
							  {
								  
								 
								  
								  ownerSignImageIS = ownerSignImage.getBinaryStream();
								  byte[] ownerSignImageBytes = IOUtils.toByteArray(ownerSignImageIS);
								  this.getSessionMap().put("owner_sign_image_array",ownerSignImageBytes); 
								  
								  if(ownerSignImageIS != null)
								  {
									  ownerSignImageIS.close();
									  ownerSignImageIS = null;
								  }
								  
							  }
						    
						    
						    if(companyStampImage != null)
							  {
								  
								 
								  
								  companyStampImageIS = companyStampImage.getBinaryStream();
								  byte[] companyStampImageBytes = IOUtils.toByteArray(companyStampImageIS);
								  this.getSessionMap().put("company_stamp_image_array",companyStampImageBytes); 
								  
								  if(companyStampImageIS != null)
								  {
									  companyStampImageIS.close();
									  companyStampImageIS = null;
								  }
								  
							  }
						    

						  
						    
						    this.getSessionMap().put("crushercustcarenumber", this.getCustomerCareNumber());
						    this.getSessionMap().put("crushergstnumber", this.getGSTNumber());
						    
						    
						   
						    
						    if(getQRFileRS != null)
							  {
								  getQRFileRS.close();
								  getQRFileRS = null;
							  }
							  
							 
							  
							  
						    if(requestFromAndroid)
							{
								result = "android-success";
								
							}else
							{
								result = "success";
							}
							
							
					  }
					  
						
					
					else
					{
						addActionError(this.getText("message.error.detailsNotFound"));
						
						result = ERROR;
					}
					
				}
				catch (SQLException e) {
					e.printStackTrace();
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					e.printStackTrace();
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					  
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
				
	        	
	        }
	        
	        return result;
	}
	
	




	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	@Override
	public void setServletRequest(HttpServletRequest arg0) {
		// TODO Auto-generated method stub
		this.request = arg0;
	}


	@Override
	public void setServletResponse(HttpServletResponse arg0) {
		// TODO Auto-generated method stub
		this.response = arg0;
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}






	public String getAddSideBarJs() {
		return addSideBarJs;
	}






	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}






	public String getCustomerCareNumber() {
		return customerCareNumber;
	}






	public void setCustomerCareNumber(String customerCareNumber) {
		this.customerCareNumber = customerCareNumber;
	}






	public String getGSTNumber() {
		return GSTNumber;
	}






	public void setGSTNumber(String gSTNumber) {
		GSTNumber = gSTNumber;
	}






	public String getDiscountType() {
		return discountType;
	}






	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}






	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}






	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}






	public Map<String, String> getCompanyDetailsDisplayList() {
		return CompanyDetailsDisplayList;
	}






	public void setCompanyDetailsDisplayList(Map<String, String> companyDetailsDisplayList) {
		CompanyDetailsDisplayList = companyDetailsDisplayList;
	}






	public String getCompanyDetailsDisplay() {
		return companyDetailsDisplay;
	}






	public void setCompanyDetailsDisplay(String companyDetailsDisplay) {
		this.companyDetailsDisplay = companyDetailsDisplay;
	}





















	

}



