package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateChequeStatusJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -95427605502498203L;
	
	
	private HttpSession session;
	private String key;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	private String chequeBookAddDate;
	private String bankName;
	private String branchName;
	private String accountNumber;	
	private String accHolderName;
	private String chequeNumber;
	private String chequePayDate;
	private String chequePayee;
	private String amount;
	private String status;
	private String statusChangeDate;
	private String statusChangedBy;
	private String reason;
	private String chequeStatus;
	
	private List<String> chequeSatusList = new ArrayList<String>();
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	    		
	    		
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			connection = new GetDBConnection().getDBConnection(db);
	       			
	       			
	       			String []  keyDetails = new String [5];
	       			
	       			//KEY = BANK_NAME#BRANCH_NAME#ACC_NUMBER#CHEQUE_NUMBER
	       			String bankName = "";
	       			String branchName = "";
	       			String accNumber = "";
	       			String chequeNumber = "";
	       			
	       			try
	       			{
	       			
	       				keyDetails = EncryptionDecryption.decrypt(URLDecoder.decode(this.getKey(),"UTF-8")).split("#");
	       				
	       				bankName = keyDetails[0];
	       				branchName = keyDetails[1];
	       				accNumber = keyDetails[2];
	       				chequeNumber = keyDetails[3];
	       				
	       			}catch(Exception e)
	       			{
	       				result = "error";
	       				addActionError("Error while parsing key!");
	       			}
	       			
	       			if(!hasActionErrors())
	       			{
	       				sql = "SELECT "
		    					+ "DATE_FORMAT(cheque_book_add_date,'%d-%M-%Y'),"
		    					+ "cheque_book_bank_name,"
		    					+ "cheque_book_branch_name,"
		    					+ "cheque_book_account_number,"
		    					+ "cheque_book_account_holder_name,"
		    					+ "cheque_number,"
		    					+ "DATE_FORMAT(cheuqe_pay_date,'%d-%M-%Y'),"
		    					+ "cheque_payee,"
		    					+ "cheque_amount,"
		    					+ "cheque_status,"
		    					+ "DATE_FORMAT(chaque_status_change_date,'%d-%M-%Y'),"
		    					+ "reason_for_cheque_given,"
		    					+ "status_changed_by "
		    					+ "FROM "
		    					+ "cheque_book_details_master "
		    					+ "WHERE "
		    					+ "cheque_book_bank_name = ? "
		    					+ "AND "
		    					+ "cheque_book_branch_name = ? "
		    					+ "AND "
		    					+ "cheque_book_account_number = ? "
		    					+ "AND "
		    					+ "cheque_number = ? "
		    					+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, bankName);
	       				preparedStatement.setString(2, branchName);
	       				preparedStatement.setString(3, accNumber);
	       				preparedStatement.setString(4, chequeNumber);
	       				preparedStatement.setString(5, crusherId);
        				preparedStatement.setString(6, crusherCode);
        				
	       				
	       				resultSet = preparedStatement.executeQuery();
	       				
	       				if(resultSet.next())
	       				{
	       					this.setChequeBookAddDate(resultSet.getString(1));
	    					this.setBankName(resultSet.getString(2));
	    					this.setBranchName(resultSet.getString(3));
	    					this.setAccountNumber(resultSet.getString(4));
	    					this.setAccHolderName(resultSet.getString(5));
	    					this.setChequeNumber(resultSet.getString(6));
	    					this.setChequePayDate(resultSet.getString(7));
	    					this.setChequePayee(resultSet.getString(8));
	    					this.setAmount(resultSet.getString(9));
	    					this.setStatus(resultSet.getString(10));
	    					this.setStatusChangeDate(resultSet.getString(11));
	    					this.setReason(resultSet.getString(12));
	    					this.setStatusChangedBy(resultSet.getString(13));
	    					this.setChequeStatus(resultSet.getString(10));
	    					
	    	       			chequeSatusList.add("ALL");
	    	       			chequeSatusList.add("ACTIVE");
	    	       			chequeSatusList.add("CANCELLED");
	    	       			chequeSatusList.add("GIVEN");
	    	       			chequeSatusList.add("PASSED");
	    	       			chequeSatusList.add("BOUNCED");
	    	       			chequeSatusList.add("STOPPED");
	    	       			chequeSatusList.add("MISPLACED");
	    	       			
	    					result = "success";
	       				}
	       				else
	       				{
	       					result = "error";
	       					addActionError(this.getText("message.error.recordsNotFound"));
	       				}
	       				
	       				
	       			}
	       			else
	       			{
	       				result = "error";
	       			}
	       			
	       		}catch (SQLException e) 
	       		{
	        		result = "error";
	        		addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
	       		} 
	       		
	       		catch (IOException e) {
					
					result = "error";
					addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
					{
						try 
						{
							resultSet.close();
						
						}catch (SQLException e) {
							
						}
					}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close();} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close();} catch (SQLException e) {}
	   				}
	   				
	   			}
	        }
	        return result;
	   }

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getChequeBookAddDate() {
		return chequeBookAddDate;
	}

	public void setChequeBookAddDate(String chequeBookAddDate) {
		this.chequeBookAddDate = chequeBookAddDate;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}

	public String getAccountNumber() {
		return accountNumber;
	}

	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}

	public String getAccHolderName() {
		return accHolderName;
	}

	public void setAccHolderName(String accHolderName) {
		this.accHolderName = accHolderName;
	}

	public String getChequeNumber() {
		return chequeNumber;
	}

	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}

	public String getChequePayDate() {
		return chequePayDate;
	}

	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}

	public String getChequePayee() {
		return chequePayee;
	}

	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatusChangeDate() {
		return statusChangeDate;
	}

	public void setStatusChangeDate(String statusChangeDate) {
		this.statusChangeDate = statusChangeDate;
	}

	public String getStatusChangedBy() {
		return statusChangedBy;
	}

	public void setStatusChangedBy(String statusChangedBy) {
		this.statusChangedBy = statusChangedBy;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public List<String> getChequeSatusList() {
		return chequeSatusList;
	}

	public void setChequeSatusList(List<String> chequeSatusList) {
		this.chequeSatusList = chequeSatusList;
	}

	public String getChequeStatus() {
		return chequeStatus;
	}

	public void setChequeStatus(String chequeStatus) {
		this.chequeStatus = chequeStatus;
	}

	
}
