package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateBoulderSupplierOpeningBalanceJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -9169573822450830699L;
	
	private String key;
	private String boulderSupplierName;	
	private String address;
	private HttpSession session;
	private Map<String,String> boulderSuppSearchOptionList = new HashMap<String,String>();
	private String boulderSuppSearchOption;
	private String defaultValue;
	
	private String addSideBarJs;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		


	        	this.setAddSideBarJs("FALSE");
	        	this.getBoulderSuppSearchOptionList().put("BYNAME", "BY NAME");
	        	this.getBoulderSuppSearchOptionList().put("BYMOBILE", "BY MOBILE");
	        	this.getBoulderSuppSearchOptionList().put("BYADDRESS","BY ADDRESS");
				setDefaultValue("BYNAME");
				this.setBoulderSupplierName("BYNAME");
	        	
	        	String supplierId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			sql = "SELECT "
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				this.setBoulderSupplierName(resultSet.getString(1));
	       				this.setAddress(resultSet.getString(2));
	       				this.setKey(EncryptionDecryption.encrypt(supplierId));
	       				result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.detailsNotFound"));
	       				
	       			}
	       			
	       		} catch (SQLException e) {
	        		result = "error";
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		
	        	
	        
	        }

        return result;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}


public String getBoulderSupplierName() {
	return boulderSupplierName;
}

public void setBoulderSupplierName(String boulderSupplierName) {
	this.boulderSupplierName = boulderSupplierName;
}

public Map<String, String> getBoulderSuppSearchOptionList() {
	return boulderSuppSearchOptionList;
}

public void setBoulderSuppSearchOptionList(Map<String, String> boulderSuppSearchOptionList) {
	this.boulderSuppSearchOptionList = boulderSuppSearchOptionList;
}

public String getBoulderSuppSearchOption() {
	return boulderSuppSearchOption;
}

public void setBoulderSuppSearchOption(String boulderSuppSearchOption) {
	this.boulderSuppSearchOption = boulderSuppSearchOption;
}

public String getAddress() {
	return address;
}

public void setAddress(String address) {
	this.address = address;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}


public String getDefaultValue() {
	return defaultValue;
}

public void setDefaultValue(String defaultValue) {
	this.defaultValue = defaultValue;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}



}
