package com.stonecrusher.jspRedirect;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.resource.GetListResource;

public class MaintenanceReportJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private SessionMap<String,Object> sessionMap;  
	private String fromDate;
	private String toDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private String addSideBarJs;
	private List<String> downloadTypeList = new ArrayList<String>();
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setFromDate(dateFormat.format(d));
	        	this.setToDate(dateFormat.format(d));
	        	
	        	downloadTypeList.add("pdf");
	        	downloadTypeList.add("xl");
	        	this.setAddSideBarJs("FALSE");
	    		this.setVehicleList(GetListResource.getVehicleList(true, this.getSessionMap()));
	    		
	        	
	        	result = SUCCESS;
	        }
	        return result;
	}
	
	
	public Map<String, String> getVehicleList() {
		return vehicleList;
	}


	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	
	

}



