package com.stonecrusher.jspRedirect;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.BoulderInwardInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.opensymphony.xwork2.ActionSupport;

public class GenerateBoulderInwardBillType1Jsp extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -2702523296200018044L;
	private SessionMap<String,Object> sessionMap;  
	
	private String fromDate;
	private String toDate;
	private String boulderSupplierId;
	private String vehicleId;
	private List<BoulderInwardInfoDAO> boulderInwardList = new ArrayList<BoulderInwardInfoDAO>();
	
	
	private int totalTrips;
	private String boulderSuppName;
	private Float mtonQuantity = 0.0f;
	private Float brassQuantity = 0.0f;
	
	private Float mtonRate;
	private Float brassRate;
	
	private Float mtonQtyAmount;
	private Float brassQtyAmount;
	
	private Float totalBillAmount;
	
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
							
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				
				String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
				
				this.setBoulderSuppName(boulderSuppDetails[1]);
				
				HashMap<String,String> inwardUnitList = GetListResource.GetBoulderInwardUnitList();
				HashMap<String,String> boulderSuppList = GetListResource.getBoulderSupplierList(this.getSessionMap());
				
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					 if(this.getVehicleId().length() == 0 && this.getBoulderSupplierId().length() > 0)
						{

						
							
							sql = "SELECT "
									+ "indetails.entry_id,"
									+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
									+ "indetails.vehicle_id,"
									+ "indetails.vehicle_number,"
									+ "indetails.boulder_quantity,"
									+ "indetails.boulder_quantity_unit,"
									+ "indetails.inward_from,"
									+ "indetails.inward_to,"
									+ "indetails.entry_by,"
									+ "indetails.bill_generated_status,"
									+ "vemap.boulder_supplier_id "
									+ "FROM "
									+ "boulder_inward_details AS indetails "
									+ "INNER JOIN "
									+ "boulder_supplier_vehicle_mapping_master AS vemap "
									+ "ON "
									+ "indetails.vehicle_id = vemap.vehicle_id "
									+ "WHERE "
									+ "indetails.crusher_id = ? "
									+ "AND "
									+ "indetails.crusher_code = ? "
									+ "AND "
									+ "vemap.crusher_id = ? "
									+ "AND "
									+ "vemap.crusher_code = ? "
									+ "AND "
									+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
									+ "AND "
									+ "vemap.boulder_supplier_id = ? "
									+ "AND "
									+ "indetails.inward_from = 'QUARRY' ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crusherId);
							preparedStatement.setString(2, crusherCode);
							preparedStatement.setString(3, crusherId);
							preparedStatement.setString(4, crusherCode);
							preparedStatement.setString(5, this.getFromDate());
							preparedStatement.setString(6, this.getToDate());
							preparedStatement.setString(7, boulderSuppDetails[0]);
						}
						
						resultSet = preparedStatement.executeQuery();
						
						
						int totalTripsLocal = 0;
						
						while(resultSet.next())
						{
							
							if(resultSet.getString(6).equals("BRASS"))
							{
								this.setBrassQuantity(this.getBrassQuantity() + resultSet.getFloat(5));
							}
							if(resultSet.getString(6).equals("MTON"))
							{
								this.setMtonQuantity(this.getMtonQuantity() + resultSet.getFloat(5));
							}
							
							totalTripsLocal++;
						}
						
						this.setTotalTrips(totalTripsLocal);
						
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						
						if(preparedStatement != null)
						{
							preparedStatement.close();
							preparedStatement = null;
						}
						

						sql = "SELECT "
								+ "boulder_brass_rate,"
								+ "boulder_mton_rate "
								+ "FROM "
								+ "crusher_boulder_supplier_master "
								+ "WHERE "
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? "
								+ "AND "
								+ "boulder_supplier_id = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						preparedStatement.setString(3, boulderSuppDetails[0]);
						
						resultSet = preparedStatement.executeQuery();
						
						if(resultSet.next())
						{
							this.setBrassRate(resultSet.getFloat(1));
							this.setMtonRate(resultSet.getFloat(2));
						}
						
						
						this.setBrassQuantity(Math.round(this.getBrassQuantity() * 100.0F) / 100.0F);
						this.setMtonQuantity(Math.round(this.getMtonQuantity() * 100.0F) / 100.0F);
						
						this.setBrassQtyAmount(this.getBrassRate() * this.getBrassQuantity());
						this.setMtonQtyAmount(this.getMtonRate() * this.getMtonQuantity());
						
						this.setTotalBillAmount(this.getBrassQtyAmount() + this.getMtonQtyAmount());
						
						result = SUCCESS;
						
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		if(this.getVehicleId().length() > 0)
		{
			addActionError("Bill cannot be generated for perticuler vehicle!");
		}
		
		
		if(this.getBoulderSupplierId().length() == 0)
		{
			addActionError("Please provide boulder supplier name!");
		}
	}
	
	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public String getBoulderSupplierId() {
		return boulderSupplierId;
	}



	public void setBoulderSupplierId(String boulderSupplierId) {
		this.boulderSupplierId = boulderSupplierId;
	}



	public String getVehicleId() {
		return vehicleId;
	}



	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public List<BoulderInwardInfoDAO> getBoulderInwardList() {
		return boulderInwardList;
	}

	public void setBoulderInwardList(List<BoulderInwardInfoDAO> boulderInwardList) {
		this.boulderInwardList = boulderInwardList;
	}

	
	
	public int getTotalTrips() {
		return totalTrips;
	}

	public void setTotalTrips(int totalTrips) {
		this.totalTrips = totalTrips;
	}

	public String getBoulderSuppName() {
		return boulderSuppName;
	}

	public void setBoulderSuppName(String boulderSuppName) {
		this.boulderSuppName = boulderSuppName;
	}

	public Float getMtonQuantity() {
		return mtonQuantity;
	}

	public void setMtonQuantity(Float mtonQuantity) {
		this.mtonQuantity = mtonQuantity;
	}

	public Float getBrassQuantity() {
		return brassQuantity;
	}

	public void setBrassQuantity(Float brassQuantity) {
		this.brassQuantity = brassQuantity;
	}

	public Float getMtonRate() {
		return mtonRate;
	}

	public void setMtonRate(Float mtonRate) {
		this.mtonRate = mtonRate;
	}

	public Float getBrassRate() {
		return brassRate;
	}

	public void setBrassRate(Float brassRate) {
		this.brassRate = brassRate;
	}

	public Float getMtonQtyAmount() {
		return mtonQtyAmount;
	}

	public void setMtonQtyAmount(Float mtonQtyAmount) {
		this.mtonQtyAmount = mtonQtyAmount;
	}

	public Float getBrassQtyAmount() {
		return brassQtyAmount;
	}

	public void setBrassQtyAmount(Float brassQtyAmount) {
		this.brassQtyAmount = brassQtyAmount;
	}

	public Float getTotalBillAmount() {
		return totalBillAmount;
	}

	public void setTotalBillAmount(Float totalBillAmount) {
		this.totalBillAmount = totalBillAmount;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



