package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class EditProductJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3030419045969989995L;
	

	private HttpSession session;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();

	private String productAddDate;
	private String productName;
	private String puchaseRate;
	private String productNameMarathi ;
	
	private String salesRate;
	private String supplier;
	private String taxPercentage;
	private String Alias;
	private String saleUnit;
	private String purchaseUnit;
	private String lowStockCount;
	private String hsnCode;
	private String convertQuantity;
	private String pName;
	private String id;
	@Override
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else
	        {
	        	try {
					taxList = GetListResource.GetTaxList();
				
				} catch (IOException e) {
					
				}
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	unitList = GetListResource.GetUnitList();
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);					
					
					sql = "SELECT "
							+ "add_date,"
							+ "product_name_eng,"
							+ "product_name_mar,"
							+ "product_alias,"
							+ "low_stock_count,"
							+ "purchase_rate,"
							+ "customer_sales_price,"
							+ "dealer_sales_price,"
							+ "retailer_sales_price,"
							+ "tax_id,"
							+ "purchase_unit,"
							+ "sales_unit,"
							+ "hsn_sac_code,"
							+ "stock_conversion_ratio "
							+ "FROM "
							+ "crusher_product_master "
							+ "WHERE "
							+ "product_id = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getId());					
					preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
    				
    				resultSet = preparedStatement.executeQuery();
					
					resultSet.last();
					
					int rowCount = resultSet.getRow();
					
					resultSet.beforeFirst();
					
					if(rowCount>0)
					{
						result = "success";
						
						if(resultSet.next())
						{
							this.setProductAddDate(resultSet.getString(1));
							this.setProductName(resultSet.getString(2));
							this.setProductNameMarathi(resultSet.getString(3));
							this.setAlias(resultSet.getString(4));
							this.setLowStockCount(resultSet.getString(5));
							this.setPuchaseRate(resultSet.getString(6));
							this.setSalesRate(resultSet.getString(7));
							this.setTaxPercentage(resultSet.getString(10));
							this.setPurchaseUnit(resultSet.getString(11));
							this.setSaleUnit(resultSet.getString(12));
							this.setHsnCode(resultSet.getString(13));
							this.setConvertQuantity(resultSet.getString(14));
							
							
						}
					}
					else
					{
						result = "error";
						
						addActionError(this.getText("message.error.urlTemperedProductWithNameNotFound"));
					}
					
				} catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() );
				} catch (IOException e) {
					result = "error";
					
					addActionError(e.getMessage()+" || "+e.getCause());
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
		
		return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getProductAddDate() {
		return productAddDate;
	}

	public void setProductAddDate(String productAddDate) {
		this.productAddDate = productAddDate;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getPuchaseRate() {
		return puchaseRate;
	}

	public void setPuchaseRate(String puchaseRate) {
		this.puchaseRate = puchaseRate;
	}

	public String getProductNameMarathi() {
		return productNameMarathi;
	}

	public void setProductNameMarathi(String productNameMarathi) {
		this.productNameMarathi = productNameMarathi;
	}

	public String getSalesRate() {
		return salesRate;
	}

	public void setSalesRate(String salesRate) {
		this.salesRate = salesRate;
	}

	public String getSupplier() {
		return supplier;
	}

	public void setSupplier(String supplier) {
		this.supplier = supplier;
	}

	public String getTaxPercentage() {
		return taxPercentage;
	}

	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}

	public String getAlias() {
		return Alias;
	}

	public void setAlias(String alias) {
		Alias = alias;
	}

	public String getSaleUnit() {
		return saleUnit;
	}

	public void setSaleUnit(String saleUnit) {
		this.saleUnit = saleUnit;
	}

	public String getPurchaseUnit() {
		return purchaseUnit;
	}

	public void setPurchaseUnit(String purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}

	public String getLowStockCount() {
		return lowStockCount;
	}

	public void setLowStockCount(String lowStockCount) {
		this.lowStockCount = lowStockCount;
	}

	public String getHsnCode() {
		return hsnCode;
	}

	public void setHsnCode(String hsnCode) {
		this.hsnCode = hsnCode;
	}

	public String getConvertQuantity() {
		return convertQuantity;
	}

	public void setConvertQuantity(String convertQuantity) {
		this.convertQuantity = convertQuantity;
	}

	public String getpName() {
		return pName;
	}

	public void setpName(String pName) {
		this.pName = pName;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}


	
	
	
				

}
