package com.stonecrusher.jspRedirect;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;

public class CutomerCreditReportJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4452079905704723458L;
	
	private HttpSession session;
	private String startDate;
	private String endDate;
	private String addSideBarJs;
	private ArrayList<String> downloadFileTypeList = new ArrayList<String>();
	private ArrayList<String> downloadFileLanguageList = new ArrayList<String>(); 
	private String downloadFileLanguage;
	private String downloadFileType;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
	        	int year = cal.get(Calendar.YEAR);
	        	
	        	this.setDownloadFileType("PDF");
	        	
	        	this.getDownloadFileTypeList().add("XLS");
	        	this.getDownloadFileTypeList().add("PDF");
	        	
	        	this.getDownloadFileLanguageList().add("MARATHI");
	        	this.getDownloadFileLanguageList().add("ENGLISH");
	        	
	        	this.setDownloadFileLanguage("ENGLISH");
	        	
	        	this.setStartDate("01-04-"+(year));
	        	this.setEndDate(dateFormat.format(d));
	        	
	        	this.setAddSideBarJs("FALSE");
	        	result = "success";
	        }
	        
	        return  result ;
}
	
	
	public String getStartDate() {
		return startDate;
	}


	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}


	public String getEndDate() {
		return endDate;
	}


	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public ArrayList<String> getDownloadFileLanguageList() {
		return downloadFileLanguageList;
	}


	public void setDownloadFileLanguageList(ArrayList<String> downloadFileLanguageList) {
		this.downloadFileLanguageList = downloadFileLanguageList;
	}
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public String getDownloadFileType() {
		return downloadFileType;
	}


	public void setDownloadFileType(String downloadFileType) {
		this.downloadFileType = downloadFileType;
	}


	public ArrayList<String> getDownloadFileTypeList() {
		return downloadFileTypeList;
	}


	public String getDownloadFileLanguage() {
		return downloadFileLanguage;
	}


	public void setDownloadFileLanguage(String downloadFileLanguage) {
		this.downloadFileLanguage = downloadFileLanguage;
	}


	public void setDownloadFileTypeList(ArrayList<String> downloadFileTypeList) {
		this.downloadFileTypeList = downloadFileTypeList;
	}


	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}

}
