package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class ChequeReportJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6559379219859806614L;
	

	private HttpSession session;
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeSatusList = new ArrayList<String>();
	private String addSideBarJs;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private List<String> downloadTypeList = new ArrayList<String>();
	
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
				
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			
	    			connection = new GetDBConnection().getDBConnection(db);
	    			sql = "SELECT "
	       					+ "cheque_book_bank_name "
	       					+ "FROM "
	       					+ "cheque_book_details_master "
	       					+ "WHERE "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "GROUP BY "
	       					+ "cheque_book_bank_name";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
	       		
	       			
	       			while(resultSet.next())
	       			{
	       				bankList.add(resultSet.getString(1));
	       			}
	       			
	       			chequeSatusList.add("ALL");
	       			chequeSatusList.add("ACTIVE");
	       			chequeSatusList.add("CANCELLED");
	       			chequeSatusList.add("GIVEN");
	       			chequeSatusList.add("PASSED");
	       			chequeSatusList.add("BOUNCED");
	       			chequeSatusList.add("STOPPED");
	       			chequeSatusList.add("MISPLACED");
	       			
	       			downloadTypeList.add("pdf");
		        	downloadTypeList.add("xl");
		        	
	       			this.setAddSideBarJs("FALSE");
	       			result = "success";
	       			
	    		}catch (SQLException e) {
	    			
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
	    		} catch (IOException e) {
	    			result = "error";
	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close();} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close();}catch (SQLException e) {}
	    			}
	    			
	    		}
        	
        	
        	
        	
        }
        
        return result;
}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}


	public List<String> getChequeSatusList() {
		return chequeSatusList;
	}

	public void setChequeSatusList(List<String> chequeSatusList) {
		this.chequeSatusList = chequeSatusList;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	
}
